/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AllWiseCatalogEntry
implements CatalogEntry,
Extinction {
    public static final String CATALOG_NAME = "AllWISE";
    private String sourceId;
    private double ra;
    private double dec;
    private double W1mag;
    private double W1_err;
    private double W2mag;
    private double W2_err;
    private double W3mag;
    private double W3_err;
    private double W4mag;
    private double W4_err;
    private double W1_snr;
    private double W2_snr;
    private double W3_snr;
    private double W4_snr;
    private double pmra;
    private double pmra_err;
    private double pmdec;
    private double pmdec_err;
    private String cc_flags;
    private int ext_flg;
    private String var_flg;
    private String ph_qual;
    private double Jmag;
    private double J_err;
    private double Hmag;
    private double H_err;
    private double Kmag;
    private double K_err;
    private double ra_pm;
    private double dec_pm;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public AllWiseCatalogEntry() {
    }

    public AllWiseCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        if (MiscUtils.isVizierTAP()) {
            this.sourceId = values[columns.get(CATALOG_NAME)];
            this.ra = NumericFunctions.toDouble(values[columns.get("RAJ2000")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("DEJ2000")]);
            this.W1mag = NumericFunctions.toDouble(values[columns.get("W1mag")]);
            this.W1_err = NumericFunctions.toDouble(values[columns.get("e_W1mag")]);
            this.W2mag = NumericFunctions.toDouble(values[columns.get("W2mag")]);
            this.W2_err = NumericFunctions.toDouble(values[columns.get("e_W2mag")]);
            this.W3mag = NumericFunctions.toDouble(values[columns.get("W3mag")]);
            this.W3_err = NumericFunctions.toDouble(values[columns.get("e_W3mag")]);
            this.W4mag = NumericFunctions.toDouble(values[columns.get("W4mag")]);
            this.W4_err = NumericFunctions.toDouble(values[columns.get("e_W4mag")]);
            this.W1_snr = NumericFunctions.toDouble(values[columns.get("snr1")]);
            this.W2_snr = NumericFunctions.toDouble(values[columns.get("snr2")]);
            this.W3_snr = NumericFunctions.toDouble(values[columns.get("snr3")]);
            this.W4_snr = NumericFunctions.toDouble(values[columns.get("snr4")]);
            this.ra_pm = NumericFunctions.toDouble(values[columns.get("RA_pm")]);
            this.dec_pm = NumericFunctions.toDouble(values[columns.get("DE_pm")]);
            this.pmra = NumericFunctions.toDouble(values[columns.get("pmRA")]);
            this.pmra_err = NumericFunctions.toDouble(values[columns.get("e_pmRA")]);
            this.pmdec = NumericFunctions.toDouble(values[columns.get("pmDE")]);
            this.pmdec_err = NumericFunctions.toDouble(values[columns.get("e_pmDE")]);
            this.cc_flags = values[columns.get("ccf")];
            this.ext_flg = NumericFunctions.toInteger(values[columns.get("ex")]);
            this.var_flg = values[columns.get("var")];
            this.ph_qual = values[columns.get("qph")];
            this.Jmag = NumericFunctions.toDouble(values[columns.get("Jmag")]);
            this.J_err = NumericFunctions.toDouble(values[columns.get("e_Jmag")]);
            this.Hmag = NumericFunctions.toDouble(values[columns.get("Hmag")]);
            this.H_err = NumericFunctions.toDouble(values[columns.get("e_Hmag")]);
            this.Kmag = NumericFunctions.toDouble(values[columns.get("Kmag")]);
            this.K_err = NumericFunctions.toDouble(values[columns.get("e_Kmag")]);
        } else {
            MiscUtils.replaceNanValuesByZero(values);
            this.sourceId = values[columns.get("designation")];
            this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
            this.W1mag = NumericFunctions.toDouble(values[columns.get("w1mpro")]);
            this.W1_err = NumericFunctions.toDouble(values[columns.get("w1sigmpro")]);
            this.W2mag = NumericFunctions.toDouble(values[columns.get("w2mpro")]);
            this.W2_err = NumericFunctions.toDouble(values[columns.get("w2sigmpro")]);
            this.W3mag = NumericFunctions.toDouble(values[columns.get("w3mpro")]);
            this.W3_err = NumericFunctions.toDouble(values[columns.get("w3sigmpro")]);
            this.W4mag = NumericFunctions.toDouble(values[columns.get("w4mpro")]);
            this.W4_err = NumericFunctions.toDouble(values[columns.get("w4sigmpro")]);
            this.W1_snr = NumericFunctions.toDouble(values[columns.get("w1snr")]);
            this.W2_snr = NumericFunctions.toDouble(values[columns.get("w2snr")]);
            this.W3_snr = NumericFunctions.toDouble(values[columns.get("w3snr")]);
            this.W4_snr = NumericFunctions.toDouble(values[columns.get("w4snr")]);
            this.ra_pm = NumericFunctions.toDouble(values[columns.get("ra_pm")]);
            this.dec_pm = NumericFunctions.toDouble(values[columns.get("dec_pm")]);
            this.pmra = NumericFunctions.toDouble(values[columns.get("pmra")]);
            this.pmra_err = NumericFunctions.toDouble(values[columns.get("sigpmra")]);
            this.pmdec = NumericFunctions.toDouble(values[columns.get("pmdec")]);
            this.pmdec_err = NumericFunctions.toDouble(values[columns.get("sigpmdec")]);
            this.cc_flags = values[columns.get("cc_flags")];
            this.ext_flg = NumericFunctions.toInteger(values[columns.get("ext_flg")]);
            this.var_flg = values[columns.get("var_flg")];
            this.ph_qual = values[columns.get("ph_qual")];
            this.Jmag = NumericFunctions.toDouble(values[columns.get("j_m_2mass")]);
            this.J_err = NumericFunctions.toDouble(values[columns.get("j_msig_2mass")]);
            this.Hmag = NumericFunctions.toDouble(values[columns.get("h_m_2mass")]);
            this.H_err = NumericFunctions.toDouble(values[columns.get("h_msig_2mass")]);
            this.Kmag = NumericFunctions.toDouble(values[columns.get("k_m_2mass")]);
            this.K_err = NumericFunctions.toDouble(values[columns.get("k_msig_2mass")]);
        }
    }

    @Override
    public CatalogEntry copy() {
        return new AllWiseCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", this.sourceId, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 (mag)", NumericFunctions.roundTo3DecNZ(this.W1mag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("W1 err", NumericFunctions.roundTo3DecNZ(this.W1_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W2 (mag)", NumericFunctions.roundTo3DecNZ(this.W2mag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("W2 err", NumericFunctions.roundTo3DecNZ(this.W2_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W3 (mag)", NumericFunctions.roundTo3DecNZ(this.W3mag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("W3 err", NumericFunctions.roundTo3DecNZ(this.W3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W4 (mag)", NumericFunctions.roundTo3DecNZ(this.W4mag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("W4 err", NumericFunctions.roundTo3DecNZ(this.W4_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 snr", NumericFunctions.roundTo1DecNZ(this.W1_snr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W2 snr", NumericFunctions.roundTo1DecNZ(this.W2_snr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W3 snr", NumericFunctions.roundTo1DecNZ(this.W3_snr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W4 snr", NumericFunctions.roundTo1DecNZ(this.W4_snr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo0DecNZ(this.pmra), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra err", NumericFunctions.roundTo0DecNZ(this.pmra_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo0DecNZ(this.pmdec), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmdec err", NumericFunctions.roundTo0DecNZ(this.pmdec_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("cc flags", this.cc_flags, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), AllWiseCatalogEntry.createToolTip_cc_flags()));
        this.catalogElements.add(new CatalogElement("ext. flag", String.valueOf(this.ext_flg), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), AllWiseCatalogEntry.createToolTip_ext_flg()));
        this.catalogElements.add(new CatalogElement("var. flag", this.var_flg, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), AllWiseCatalogEntry.createToolTip_var_flg()));
        this.catalogElements.add(new CatalogElement("ph. qual.", this.ph_qual, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), AllWiseCatalogEntry.createToolTip_ph_qual()));
        this.catalogElements.add(new CatalogElement("J (mag)", NumericFunctions.roundTo3DecNZ(this.Jmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J err", NumericFunctions.roundTo3DecNZ(this.J_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H (mag)", NumericFunctions.roundTo3DecNZ(this.Hmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H err", NumericFunctions.roundTo3DecNZ(this.H_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("K (mag)", NumericFunctions.roundTo3DecNZ(this.Kmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("K err", NumericFunctions.roundTo3DecNZ(this.K_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1-W2", NumericFunctions.roundTo3DecNZ(this.getW1_W2()), Alignment.RIGHT, Comparators.getDoubleComparator(), true, true));
        this.catalogElements.add(new CatalogElement("W2-W3", NumericFunctions.roundTo3DecNZ(this.getW2_W3()), Alignment.RIGHT, Comparators.getDoubleComparator(), true, true));
        this.catalogElements.add(new CatalogElement("J-W2", NumericFunctions.roundTo3DecNZ(this.getJ_W2()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("J-H", NumericFunctions.roundTo3DecNZ(this.getJ_H()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("H-K", NumericFunctions.roundTo3DecNZ(this.getH_K()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("J-K", NumericFunctions.roundTo3DecNZ(this.getJ_K()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public static String createToolTip_cc_flags() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Contamination and confusion flags (cc flags):</b>").append("<br/>");
        toolTip.append("D,d - Diffraction spike. Source may be a spurious detection of (D) or contaminated by (d) a diffraction spike from a nearby bright star on the same image, or").append("<br/>");
        toolTip.append("P,p - Persistence. Source may be a spurious detection of (P) or contaminated by (p) a short-term latent image left by a bright source, or").append("<br/>");
        toolTip.append("H,h - Halo. Source may be a spurious detection of (H) or contaminated by (h) the scattered light halo surrounding a nearby bright source, or").append("<br/>");
        toolTip.append("O,o (letter \"o\") - Optical ghost. Source may be a spurious detection of (O) or contaminated by (o) an optical ghost image caused by a nearby bright source, or").append("<br/>");
        toolTip.append("0 (number zero) - Source is unaffected by known artifacts. ");
        return toolTip.toString();
    }

    public static String createToolTip_ext_flg() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Extended source flag (ext. flag):</b>").append("<br/>");
        toolTip.append("0 - The source shape is consistent with a point-source and the source is not associated with or superimposed on a 2MASS XSC source.").append("<br/>");
        toolTip.append("1 - The profile-fit photometry goodness-of-fit, w?rchi2, is &gt; 3.0 in one or more bands.").append("<br/>");
        toolTip.append("2 - The source falls within the extrapolated isophotal footprint of a 2MASS XSC source.").append("<br/>");
        toolTip.append("3 - The profile-fit photometry goodness-of-fit, w?rchi2, is &gt; 3.0 in one or more bands, and The source falls within the extrapolated isophotal footprint of a 2MASS XSC source.").append("<br/>");
        toolTip.append("4 - The source position falls within 5\" of a 2MASS XSC source.").append("<br/>");
        toolTip.append("5 - The profile-fit photometry goodness-of-fit, w?rchi2, is &gt; 3.0 in one or more bands, and the source position falls within 5\" of a 2MASS XSC source.");
        return toolTip.toString();
    }

    public static String createToolTip_var_flg() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Variability flag (var. flag):</b>").append("<br/>");
        toolTip.append("A value of \"n\" in a band indicates insufficient or inadequate data to make a determination of possible variability.").append("<br/>");
        toolTip.append("Values of \"0\" through \"9\" indicate increasing probabilities of variation.").append("<br/>");
        toolTip.append("Values of \"0\" through \"5\" are most likely not variables.").append("<br/>");
        toolTip.append("Values of \"6\" and \"7\" are likely flux variables, but are the most susceptible to false-positive variability.").append("<br/>");
        toolTip.append("Values greater than \"7\" have the highest probability of being true flux variables in a band.");
        return toolTip.toString();
    }

    public static String createToolTip_ph_qual() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Photometric quality flag (ph. qual.):</b>").append("<br/>");
        toolTip.append("A - Source is detected in this band with a flux signal-to-noise ratio w?snr &gt; 10.").append("<br/>");
        toolTip.append("B - Source is detected in this band with a flux signal-to-noise ratio 3 &lt; w?snr &lt; 10.").append("<br/>");
        toolTip.append("C - Source is detected in this band with a flux signal-to-noise ratio 2 &lt; w?snr &lt; 3.").append("<br/>");
        toolTip.append("U - Upper limit on magnitude. Source measurement has w?snr &lt; 2. The profile-fit magnitude w?mpro is a 95% confidence upper limit.").append("<br/>");
        toolTip.append("X - A profile-fit measurement was not possible at this location in this band. The value of w?mpro and w?sigmpro will be \"null\" in this band.").append("<br/>");
        toolTip.append("Z - A profile-fit source flux measurement was made at this location, but the flux uncertainty could not be measured.");
        return toolTip.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + Objects.hashCode(this.sourceId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllWiseCatalogEntry other = (AllWiseCatalogEntry)obj;
        return Objects.equals(this.sourceId, other.sourceId);
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new AllWiseCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return Color.GREEN.darker();
    }

    @Override
    public String getCatalogQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return ServiceHelper.createVizieRUrl(this.ra, this.dec, this.searchRadius / 3600.0, "II/328/allwise", "RAJ2000", "DEJ2000");
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltCatalogQuery());
    }

    private String createAltCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT designation,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       w1mpro,");
        MiscUtils.addRow(query, "       w1sigmpro,");
        MiscUtils.addRow(query, "       w2mpro,");
        MiscUtils.addRow(query, "       w2sigmpro,");
        MiscUtils.addRow(query, "       w3mpro,");
        MiscUtils.addRow(query, "       w3sigmpro,");
        MiscUtils.addRow(query, "       w4mpro,");
        MiscUtils.addRow(query, "       w4sigmpro,");
        MiscUtils.addRow(query, "       w1snr,");
        MiscUtils.addRow(query, "       w2snr,");
        MiscUtils.addRow(query, "       w3snr,");
        MiscUtils.addRow(query, "       w4snr,");
        MiscUtils.addRow(query, "       ra_pm,");
        MiscUtils.addRow(query, "       dec_pm,");
        MiscUtils.addRow(query, "       pmra,");
        MiscUtils.addRow(query, "       sigpmra,");
        MiscUtils.addRow(query, "       pmdec,");
        MiscUtils.addRow(query, "       sigpmdec,");
        MiscUtils.addRow(query, "       cc_flags,");
        MiscUtils.addRow(query, "       ext_flg,");
        MiscUtils.addRow(query, "       var_flg,");
        MiscUtils.addRow(query, "       ph_qual,");
        MiscUtils.addRow(query, "       j_m_2mass,");
        MiscUtils.addRow(query, "       j_msig_2mass,");
        MiscUtils.addRow(query, "       h_m_2mass,");
        MiscUtils.addRow(query, "       h_msig_2mass,");
        MiscUtils.addRow(query, "       k_m_2mass,");
        MiscUtils.addRow(query, "       k_msig_2mass");
        MiscUtils.addRow(query, "FROM   allwise.source");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo3Dec(this.W1mag) + "," + NumericFunctions.roundTo3Dec(this.W1_err) + "," + NumericFunctions.roundTo3Dec(this.W2mag) + "," + NumericFunctions.roundTo3Dec(this.W2_err) + "," + NumericFunctions.roundTo3Dec(this.W3mag) + "," + NumericFunctions.roundTo3Dec(this.W3_err) + "," + NumericFunctions.roundTo3Dec(this.W4mag) + "," + NumericFunctions.roundTo3Dec(this.W4_err) + "," + NumericFunctions.roundTo1Dec(this.W1_snr) + "," + NumericFunctions.roundTo1Dec(this.W2_snr) + "," + NumericFunctions.roundTo1Dec(this.W3_snr) + "," + NumericFunctions.roundTo1Dec(this.W4_snr) + "," + NumericFunctions.roundTo0Dec(this.pmra) + "," + NumericFunctions.roundTo0Dec(this.pmra_err) + "," + NumericFunctions.roundTo0Dec(this.pmdec) + "," + NumericFunctions.roundTo0Dec(this.pmdec_err) + "," + this.cc_flags + "," + this.ext_flg + "," + this.var_flg + "," + this.ph_qual + "," + NumericFunctions.roundTo3Dec(this.Jmag) + "," + NumericFunctions.roundTo3Dec(this.J_err) + "," + NumericFunctions.roundTo3Dec(this.Hmag) + "," + NumericFunctions.roundTo3Dec(this.H_err) + "," + NumericFunctions.roundTo3Dec(this.Kmag) + "," + NumericFunctions.roundTo3Dec(this.K_err) + "," + NumericFunctions.roundTo3Dec(this.getW1_W2()) + "," + NumericFunctions.roundTo3Dec(this.getW2_W3()) + "," + NumericFunctions.roundTo3Dec(this.getJ_W2()) + "," + NumericFunctions.roundTo3Dec(this.getJ_H()) + "," + NumericFunctions.roundTo3Dec(this.getH_K()) + "," + NumericFunctions.roundTo3Dec(this.getJ_K());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,W1 (mag),W1 err,W2 (mag),W2 err,W3 (mag),W3 err,W4 (mag),W4 err,W1 snr,W2 snr,W3 snr,W4 snr,pmra (mas/yr),pmra err,pmdec (mas/yr),pmdec err,cc flags,ext. flag,var. flag,ph. qual.,J (mag),J err,H (mag),H err,K (mag),K err,W1-W2,W2-W3,J-W2,J-H,H-K,J-K";
        return columnTitles.split(",", -1);
    }

    @Override
    public void applyExtinctionCorrection(Map<String, Double> extinctionsByBand) {
        if (this.W1mag != 0.0) {
            this.W1mag -= extinctionsByBand.get("WISE-1").doubleValue();
        }
        if (this.W2mag != 0.0) {
            this.W2mag -= extinctionsByBand.get("WISE-2").doubleValue();
        }
        if (this.Jmag != 0.0) {
            this.Jmag -= extinctionsByBand.get("2MASS J").doubleValue();
        }
        if (this.Hmag != 0.0) {
            this.Hmag -= extinctionsByBand.get("2MASS H").doubleValue();
        }
        if (this.Kmag != 0.0) {
            this.Kmag -= extinctionsByBand.get("2MASS Ks").doubleValue();
        }
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        if (this.W1_err != 0.0) {
            bands.put(Band.W1, new NumberPair(this.W1mag, this.W1_err));
        }
        if (this.W2_err != 0.0) {
            bands.put(Band.W2, new NumberPair(this.W2mag, this.W2_err));
        }
        if (this.W3_err != 0.0) {
            bands.put(Band.W3, new NumberPair(this.W3mag, this.W3_err));
        }
        if (this.J_err != 0.0) {
            bands.put(Band.J, new NumberPair(this.Jmag, this.J_err));
        }
        if (this.H_err != 0.0) {
            bands.put(Band.H, new NumberPair(this.Hmag, this.H_err));
        }
        if (this.K_err != 0.0) {
            bands.put(Band.K, new NumberPair(this.Kmag, this.K_err));
        }
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.W1_W2, this.getW1_W2());
        colors.put(astro.tool.box.enumeration.Color.W1_W3, this.getW1_W3());
        colors.put(astro.tool.box.enumeration.Color.W1_W4, this.getW1_W4());
        colors.put(astro.tool.box.enumeration.Color.J_H, this.getJ_H());
        colors.put(astro.tool.box.enumeration.Color.H_K, this.getH_K());
        colors.put(astro.tool.box.enumeration.Color.J_K, this.getJ_K());
        colors.put(astro.tool.box.enumeration.Color.K_W1, this.getK_W1());
        colors.put(astro.tool.box.enumeration.Color.e_W1_W2, this.getW1_W2() - this.getW1_W2_err());
        colors.put(astro.tool.box.enumeration.Color.e_W1_W3, this.getW1_W3() - this.getW1_W3_err());
        colors.put(astro.tool.box.enumeration.Color.e_W1_W4, this.getW1_W4() - this.getW1_W4_err());
        colors.put(astro.tool.box.enumeration.Color.e_J_H, this.getJ_H() - this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.e_H_K, this.getH_K() - this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.e_J_K, this.getJ_K() - this.getJ_K_err());
        colors.put(astro.tool.box.enumeration.Color.e_K_W1, this.getK_W1() - this.getK_W1_err());
        colors.put(astro.tool.box.enumeration.Color.E_W1_W2, this.getW1_W2() + this.getW1_W2_err());
        colors.put(astro.tool.box.enumeration.Color.E_W1_W3, this.getW1_W3() + this.getW1_W3_err());
        colors.put(astro.tool.box.enumeration.Color.E_W1_W4, this.getW1_W4() + this.getW1_W4_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_H, this.getJ_H() + this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.E_H_K, this.getH_K() + this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_K, this.getJ_K() + this.getJ_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_K_W1, this.getK_W1() + this.getK_W1_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.W1mag != 0.0) {
            mags.append("W1=").append(NumericFunctions.roundTo3DecNZ(this.W1mag)).append(" ");
        }
        if (this.W2mag != 0.0) {
            mags.append("W2=").append(NumericFunctions.roundTo3DecNZ(this.W2mag)).append(" ");
        }
        if (this.W3mag != 0.0) {
            mags.append("W3=").append(NumericFunctions.roundTo3DecNZ(this.W3mag)).append(" ");
        }
        if (this.W4mag != 0.0) {
            mags.append("W4=").append(NumericFunctions.roundTo3DecNZ(this.W4mag)).append(" ");
        }
        if (this.Jmag != 0.0) {
            mags.append("J=").append(NumericFunctions.roundTo3DecNZ(this.Jmag)).append(" ");
        }
        if (this.Hmag != 0.0) {
            mags.append("H=").append(NumericFunctions.roundTo3DecNZ(this.Hmag)).append(" ");
        }
        if (this.Kmag != 0.0) {
            mags.append("K=").append(NumericFunctions.roundTo3DecNZ(this.Kmag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.W1mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.W1mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.W1_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.W2mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.W2mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.W2_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.W3mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.W3mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.W3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.W4mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.W4mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.W4_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return 0.0;
    }

    @Override
    public double getPmdec() {
        return 0.0;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return 0.0;
    }

    public double getRa_pm() {
        return this.ra_pm;
    }

    public double getDec_pm() {
        return this.dec_pm;
    }

    public String getCc_flags() {
        return this.cc_flags;
    }

    public double getW1_W2() {
        if (this.W1mag == 0.0 || this.W2mag == 0.0 || this.getW1_W2_err() == 0.0) {
            return 0.0;
        }
        return this.W1mag - this.W2mag;
    }

    public double getW1_W3() {
        if (this.W1mag == 0.0 || this.W3mag == 0.0 || this.getW1_W3_err() == 0.0) {
            return 0.0;
        }
        return this.W1mag - this.W3mag;
    }

    public double getW1_W4() {
        if (this.W1mag == 0.0 || this.W4mag == 0.0 || this.getW1_W4_err() == 0.0) {
            return 0.0;
        }
        return this.W1mag - this.W4mag;
    }

    public double getW2_W3() {
        if (this.W2mag == 0.0 || this.W3mag == 0.0 || this.getW2_W3_err() == 0.0) {
            return 0.0;
        }
        return this.W2mag - this.W3mag;
    }

    public double getW3_W4() {
        if (this.W3mag == 0.0 || this.W4mag == 0.0 || this.getW3_W4_err() == 0.0) {
            return 0.0;
        }
        return this.W3mag - this.W4mag;
    }

    public double getJ_H() {
        if (this.Jmag == 0.0 || this.Hmag == 0.0 || this.getJ_H_err() == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.Hmag;
    }

    public double getH_K() {
        if (this.Hmag == 0.0 || this.Kmag == 0.0 || this.getH_K_err() == 0.0) {
            return 0.0;
        }
        return this.Hmag - this.Kmag;
    }

    public double getJ_K() {
        if (this.Jmag == 0.0 || this.Kmag == 0.0 || this.getJ_K_err() == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.Kmag;
    }

    public double getK_W1() {
        if (this.Kmag == 0.0 || this.W1mag == 0.0 || this.getK_W1_err() == 0.0) {
            return 0.0;
        }
        return this.Kmag - this.W1mag;
    }

    public double getJ_W2() {
        if (this.Jmag == 0.0 || this.W2mag == 0.0 || this.getJ_W2_err() == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.W2mag;
    }

    public double getW1_W2_err() {
        if (this.W1_err == 0.0 || this.W2_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W1_err, this.W2_err);
    }

    public double getW1_W3_err() {
        if (this.W1_err == 0.0 || this.W3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W1_err, this.W3_err);
    }

    public double getW1_W4_err() {
        if (this.W1_err == 0.0 || this.W4_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W1_err, this.W4_err);
    }

    public double getW2_W3_err() {
        if (this.W2_err == 0.0 || this.W3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W2_err, this.W3_err);
    }

    public double getW3_W4_err() {
        if (this.W3_err == 0.0 || this.W4_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W3_err, this.W4_err);
    }

    public double getJ_H_err() {
        if (this.J_err == 0.0 || this.H_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.J_err, this.H_err);
    }

    public double getH_K_err() {
        if (this.H_err == 0.0 || this.K_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.H_err, this.K_err);
    }

    public double getJ_K_err() {
        if (this.J_err == 0.0 || this.K_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.J_err, this.K_err);
    }

    public double getK_W1_err() {
        if (this.K_err == 0.0 || this.W1_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.K_err, this.W1_err);
    }

    public double getJ_W2_err() {
        if (this.J_err == 0.0 || this.W2_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.J_err, this.W2_err);
    }

    public double getW1mag() {
        return this.W1mag;
    }

    public double getW2mag() {
        return this.W2mag;
    }

    public double getW3mag() {
        return this.W3mag;
    }

    public double getW4mag() {
        return this.W4mag;
    }

    public double getJmag() {
        return this.Jmag;
    }

    public double getHmag() {
        return this.Hmag;
    }

    public double getKmag() {
        return this.Kmag;
    }

    public double getW1_err() {
        return this.W1_err;
    }

    public double getW2_err() {
        return this.W2_err;
    }

    public double getW3_err() {
        return this.W3_err;
    }

    public double getW4_err() {
        return this.W4_err;
    }

    public double getJ_err() {
        return this.J_err;
    }

    public double getH_err() {
        return this.H_err;
    }

    public double getK_err() {
        return this.K_err;
    }
}

