/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.Artifact;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.catalog.ProperMotionCatalog;
import astro.tool.box.catalog.ProperMotionQuery;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CatWiseCatalogEntry
implements CatalogEntry,
ProperMotionQuery,
ProperMotionCatalog,
Artifact,
Extinction {
    public static final String CATALOG_NAME = "CatWISE2020";
    private String sourceId;
    private double ra;
    private double dec;
    private double W1mag;
    private double W1_err;
    private double W2mag;
    private double W2_err;
    private double W1_snr;
    private double W2_snr;
    private double pmra;
    private double pmra_err;
    private double pmdec;
    private double pmdec_err;
    private double par_pm;
    private double par_pmsig;
    private double par_stat;
    private double par_sigma;
    private String cc_flags;
    private String ab_flags;
    private double meanObsMJD;
    private double ra_pm;
    private double dec_pm;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private double tpm;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public CatWiseCatalogEntry() {
    }

    public CatWiseCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        if (MiscUtils.isVizierTAP()) {
            this.sourceId = values[columns.get("Name")];
            this.ra = NumericFunctions.toDouble(values[columns.get("RA_ICRS")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("DE_ICRS")]);
            this.W1mag = NumericFunctions.toDouble(values[columns.get("W1mproPM")]);
            this.W1_err = NumericFunctions.toDouble(values[columns.get("e_W1mproPM")]);
            this.W2mag = NumericFunctions.toDouble(values[columns.get("W2mproPM")]);
            this.W2_err = NumericFunctions.toDouble(values[columns.get("e_W2mproPM")]);
            this.W1_snr = NumericFunctions.toDouble(values[columns.get("snrW1pm")]);
            this.W2_snr = NumericFunctions.toDouble(values[columns.get("snrW2pm")]);
            this.meanObsMJD = NumericFunctions.toDouble(values[columns.get("MJD")]);
            this.ra_pm = NumericFunctions.toDouble(values[columns.get("RAPMdeg")]);
            this.dec_pm = NumericFunctions.toDouble(values[columns.get("DEPMdeg")]);
            this.pmra = NumericFunctions.toDouble(values[columns.get("pmRA")]) * 1000.0;
            this.pmdec = NumericFunctions.toDouble(values[columns.get("pmDE")]) * 1000.0;
            this.pmra_err = NumericFunctions.toDouble(values[columns.get("e_pmRA")]) * 1000.0;
            this.pmdec_err = NumericFunctions.toDouble(values[columns.get("e_pmDE")]) * 1000.0;
            this.par_pm = NumericFunctions.toDouble(values[columns.get("plx1")]) * 1000.0;
            this.par_pmsig = NumericFunctions.toDouble(values[columns.get("e_plx1")]) * 1000.0;
            this.par_stat = NumericFunctions.toDouble(values[columns.get("plx2")]) * 1000.0;
            this.par_sigma = NumericFunctions.toDouble(values[columns.get("e_plx2")]) * 1000.0;
            this.cc_flags = values[columns.get("ccf")];
            this.ab_flags = values[columns.get("abf")];
        } else {
            MiscUtils.replaceNanValuesByZero(values);
            this.sourceId = values[columns.get("source_name")];
            this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
            this.W1mag = NumericFunctions.toDouble(values[columns.get("w1mpro_pm")]);
            this.W1_err = NumericFunctions.toDouble(values[columns.get("w1sigmpro_pm")]);
            this.W2mag = NumericFunctions.toDouble(values[columns.get("w2mpro_pm")]);
            this.W2_err = NumericFunctions.toDouble(values[columns.get("w2sigmpro_pm")]);
            this.W1_snr = NumericFunctions.toDouble(values[columns.get("w1snr_pm")]);
            this.W2_snr = NumericFunctions.toDouble(values[columns.get("w2snr_pm")]);
            this.meanObsMJD = NumericFunctions.toDouble(values[columns.get("meanobsmjd")]);
            this.ra_pm = NumericFunctions.toDouble(values[columns.get("ra_pm")]);
            this.dec_pm = NumericFunctions.toDouble(values[columns.get("dec_pm")]);
            this.pmra = NumericFunctions.toDouble(values[columns.get("pmra")]) * 1000.0;
            this.pmdec = NumericFunctions.toDouble(values[columns.get("pmdec")]) * 1000.0;
            this.pmra_err = NumericFunctions.toDouble(values[columns.get("sigpmra")]) * 1000.0;
            this.pmdec_err = NumericFunctions.toDouble(values[columns.get("sigpmdec")]) * 1000.0;
            this.par_pm = NumericFunctions.toDouble(values[columns.get("par_pm")]) * 1000.0;
            this.par_pmsig = NumericFunctions.toDouble(values[columns.get("par_pmsig")]) * 1000.0;
            this.par_stat = NumericFunctions.toDouble(values[columns.get("par_stat")]) * 1000.0;
            this.par_sigma = NumericFunctions.toDouble(values[columns.get("par_sigma")]) * 1000.0;
            this.cc_flags = values[columns.get("cc_flags")];
            this.ab_flags = values[columns.get("ab_flags")];
        }
    }

    @Override
    public CatalogEntry copy() {
        return new CatWiseCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", this.sourceId, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 (mag)", NumericFunctions.roundTo3DecNZ(this.W1mag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("W1 err", NumericFunctions.roundTo3DecNZ(this.W1_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W2 (mag)", NumericFunctions.roundTo3DecNZ(this.W2mag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("W2 err", NumericFunctions.roundTo3DecNZ(this.W2_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 snr", NumericFunctions.roundTo1DecNZ(this.W1_snr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W2 snr", NumericFunctions.roundTo1DecNZ(this.W2_snr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo2DecNZ(this.pmra), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmra err", NumericFunctions.roundTo2DecNZ(this.pmra_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmra, this.pmra_err)));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo2DecNZ(this.pmdec), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmdec err", NumericFunctions.roundTo2DecNZ(this.pmdec_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmdec, this.pmdec_err)));
        this.catalogElements.add(new CatalogElement("plx PM desc-asc (mas)", NumericFunctions.roundTo1DecNZ(this.par_pm), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("plx PM desc-asc err", NumericFunctions.roundTo1DecNZ(this.par_pmsig), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("plx stat. sol. (mas)", NumericFunctions.roundTo1DecNZ(this.par_stat), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("plx stat. sol. err", NumericFunctions.roundTo1DecNZ(this.par_sigma), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("cc flags", this.cc_flags, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), AllWiseCatalogEntry.createToolTip_cc_flags()));
        this.catalogElements.add(new CatalogElement("ab flags", this.ab_flags, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("tpm (mas/yr)", NumericFunctions.roundTo3DecNZ(this.getTotalProperMotion()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("W1-W2", NumericFunctions.roundTo3DecNZ(this.getW1_W2()), Alignment.RIGHT, Comparators.getDoubleComparator(), true, true));
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.sourceId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CatWiseCatalogEntry other = (CatWiseCatalogEntry)obj;
        return Objects.equals(this.sourceId, other.sourceId);
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new CatWiseCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return Color.MAGENTA;
    }

    @Override
    public String getCatalogQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return "http://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createCatalogQuery());
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltCatalogQuery());
    }

    @Override
    public String getMotionQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return "http://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createProperMotionQuery());
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltProperMotionQuery());
    }

    private String createCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT Name,");
        MiscUtils.addRow(query, "       RA_ICRS,");
        MiscUtils.addRow(query, "       DE_ICRS,");
        MiscUtils.addRow(query, "       W1mproPM,");
        MiscUtils.addRow(query, "       e_W1mproPM,");
        MiscUtils.addRow(query, "       W2mproPM,");
        MiscUtils.addRow(query, "       e_W2mproPM,");
        MiscUtils.addRow(query, "       snrW1pm,");
        MiscUtils.addRow(query, "       snrW2pm,");
        MiscUtils.addRow(query, "       MJD,");
        MiscUtils.addRow(query, "       RAPMdeg,");
        MiscUtils.addRow(query, "       DEPMdeg,");
        MiscUtils.addRow(query, "       pmRA,");
        MiscUtils.addRow(query, "       pmDE,");
        MiscUtils.addRow(query, "       e_pmRA,");
        MiscUtils.addRow(query, "       e_pmDE,");
        MiscUtils.addRow(query, "       plx1,");
        MiscUtils.addRow(query, "       e_plx1,");
        MiscUtils.addRow(query, "       plx2,");
        MiscUtils.addRow(query, "       e_plx2,");
        MiscUtils.addRow(query, "       ccf,");
        MiscUtils.addRow(query, "       abf");
        MiscUtils.addRow(query, "FROM   \"II/365/catwise\"");
        MiscUtils.addRow(query, "WHERE  1=CONTAINS(POINT('ICRS', RA_ICRS, DE_ICRS), CIRCLE('ICRS', " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + "))");
        return query.toString();
    }

    private String createProperMotionQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, this.createCatalogQuery());
        MiscUtils.addRow(query, "AND    SQRT(pmRA * pmRA + pmDE * pmDE) >= " + this.tpm / 1000.0);
        return query.toString();
    }

    private String createAltCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT source_name,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       w1mpro_pm,");
        MiscUtils.addRow(query, "       w1sigmpro_pm,");
        MiscUtils.addRow(query, "       w2mpro_pm,");
        MiscUtils.addRow(query, "       w2sigmpro_pm,");
        MiscUtils.addRow(query, "       w1snr_pm,");
        MiscUtils.addRow(query, "       w2snr_pm,");
        MiscUtils.addRow(query, "       meanobsmjd,");
        MiscUtils.addRow(query, "       ra_pm,");
        MiscUtils.addRow(query, "       dec_pm,");
        MiscUtils.addRow(query, "       pmra,");
        MiscUtils.addRow(query, "       pmdec,");
        MiscUtils.addRow(query, "       sigpmra,");
        MiscUtils.addRow(query, "       sigpmdec,");
        MiscUtils.addRow(query, "       par_pm,");
        MiscUtils.addRow(query, "       par_pmsig,");
        MiscUtils.addRow(query, "       par_stat,");
        MiscUtils.addRow(query, "       par_sigma,");
        MiscUtils.addRow(query, "       cc_flags,");
        MiscUtils.addRow(query, "       ab_flags");
        MiscUtils.addRow(query, "FROM   catwise2020.main");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    private String createAltProperMotionQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, this.createAltCatalogQuery());
        MiscUtils.addRow(query, "AND    pmra <> 'NaN' AND pmdec <> 'NaN'");
        MiscUtils.addRow(query, "AND    SQRT(pmra * pmra + pmdec * pmdec) >= " + this.tpm / 1000.0);
        return query.toString();
    }

    @Override
    public void setTpm(double tpm) {
        this.tpm = tpm;
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo3Dec(this.W1mag) + "," + NumericFunctions.roundTo3Dec(this.W1_err) + "," + NumericFunctions.roundTo3Dec(this.W2mag) + "," + NumericFunctions.roundTo3Dec(this.W2_err) + "," + NumericFunctions.roundTo1Dec(this.W1_snr) + "," + NumericFunctions.roundTo1Dec(this.W2_snr) + "," + NumericFunctions.roundTo2Dec(this.pmra) + "," + NumericFunctions.roundTo2Dec(this.pmra_err) + "," + NumericFunctions.roundTo2Dec(this.pmdec) + "," + NumericFunctions.roundTo2Dec(this.pmdec_err) + "," + NumericFunctions.roundTo1Dec(this.par_pm) + "," + NumericFunctions.roundTo1Dec(this.par_pmsig) + "," + NumericFunctions.roundTo1Dec(this.par_stat) + "," + NumericFunctions.roundTo1Dec(this.par_sigma) + "," + this.cc_flags + "," + this.ab_flags + "," + NumericFunctions.roundTo3Dec(this.getTotalProperMotion()) + "," + NumericFunctions.roundTo3Dec(this.getW1_W2());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,W1 (mag),W1 err,W2 (mag),W2 err,W1 snr,W2 snr,pmra,pmra err,pmdec,pmdec err,plx PM desc-asc (mas),plx PM desc-asc err,plx stat. sol. (mas),plx stat. sol. err,cc flags,ab flags,tpm (mas/yr),W1-W2";
        return columnTitles.split(",", -1);
    }

    @Override
    public void applyExtinctionCorrection(Map<String, Double> extinctionsByBand) {
        if (this.W1mag != 0.0) {
            this.W1mag -= extinctionsByBand.get("WISE-1").doubleValue();
        }
        if (this.W2mag != 0.0) {
            this.W2mag -= extinctionsByBand.get("WISE-2").doubleValue();
        }
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.W1, new NumberPair(this.W1mag, this.W1_err));
        bands.put(Band.W2, new NumberPair(this.W2mag, this.W2_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.W1_W2, this.getW1_W2());
        colors.put(astro.tool.box.enumeration.Color.e_W1_W2, this.getW1_W2() - this.getW1_W2_err());
        colors.put(astro.tool.box.enumeration.Color.E_W1_W2, this.getW1_W2() + this.getW1_W2_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.W1mag != 0.0) {
            mags.append("W1=").append(NumericFunctions.roundTo3DecNZ(this.W1mag)).append(" ");
        }
        if (this.W2mag != 0.0) {
            mags.append("W2=").append(NumericFunctions.roundTo3DecNZ(this.W2mag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.W1mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.W1mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.W1_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.W2mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.W2mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.W2_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getPmraErr() {
        return this.pmra_err;
    }

    @Override
    public double getPmdecErr() {
        return this.pmdec_err;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getMeanObsMJD() {
        return this.meanObsMJD;
    }

    public double getRa_pm() {
        return this.ra_pm;
    }

    public double getDec_pm() {
        return this.dec_pm;
    }

    @Override
    public String getCc_flags() {
        return this.cc_flags;
    }

    @Override
    public String getAb_flags() {
        return this.ab_flags;
    }

    public double getW1_W2() {
        if (this.W1mag == 0.0 || this.W2mag == 0.0) {
            return 0.0;
        }
        return this.W1mag - this.W2mag;
    }

    public double getW1_W2_err() {
        if (this.W1_err == 0.0 || this.W2_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W1_err, this.W2_err);
    }

    public double getW1mag() {
        return this.W1mag;
    }

    public double getW2mag() {
        return this.W2mag;
    }

    public double getW1_err() {
        return this.W1_err;
    }

    public double getW2_err() {
        return this.W2_err;
    }
}

