/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Band;
import astro.tool.box.util.Constants;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public interface CatalogEntry {
    default public String getEntryData() {
        StringBuilder entryData = new StringBuilder(this.getCatalogName()).append(":");
        List<CatalogElement> catalogElements = this.getCatalogElements();
        for (int i = 1; i < catalogElements.size(); ++i) {
            CatalogElement catalogElement = catalogElements.get(i);
            entryData.append(Constants.LINE_SEP).append(catalogElement.getName()).append(" = ").append(catalogElement.getValue());
        }
        return entryData.toString();
    }

    public CatalogEntry copy();

    public CatalogEntry getInstance(Map<String, Integer> var1, String[] var2);

    public void loadCatalogElements();

    public String getCatalogName();

    public Color getCatalogColor();

    public String getCatalogQueryUrl();

    public String[] getColumnValues();

    public String[] getColumnTitles();

    public Map<Band, NumberPair> getBands();

    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean var1);

    public String getMagnitudes();

    default public String getPhotometry() {
        return null;
    }

    public String getSourceId();

    public double getRa();

    public void setRa(double var1);

    public double getDec();

    public void setDec(double var1);

    public double getSearchRadius();

    public void setSearchRadius(double var1);

    public double getTargetRa();

    public void setTargetRa(double var1);

    public double getTargetDec();

    public void setTargetDec(double var1);

    public double getPixelRa();

    public void setPixelRa(double var1);

    public double getPixelDec();

    public void setPixelDec(double var1);

    public String getSpt();

    public void setSpt(String var1);

    public List<CatalogElement> getCatalogElements();

    public double getPlx();

    public double getPmra();

    public double getPmdec();

    public double getTargetDistance();

    public double getParallacticDistance();

    public double getTotalProperMotion();
}

