/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.container.StringPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DesCatalogEntry
implements CatalogEntry {
    public static final String CATALOG_NAME = "DES DR2";
    private String sourceId;
    private double ra;
    private double dec;
    private double g_ext;
    private double r_ext;
    private double i_ext;
    private double z_ext;
    private double y_ext;
    private int g_caut;
    private int r_caut;
    private int i_caut;
    private int z_caut;
    private int y_caut;
    private double g_mag;
    private double g_err;
    private double r_mag;
    private double r_err;
    private double i_mag;
    private double i_err;
    private double z_mag;
    private double z_err;
    private double y_mag;
    private double y_err;
    private double glon;
    private double glat;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;
    private static final Map<Integer, String> CAUTIONARY_FLAGS = new HashMap<Integer, String>();

    public DesCatalogEntry() {
    }

    public DesCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        if (MiscUtils.isVizierTAP()) {
            this.sourceId = values[columns.get("CoadID")];
            this.ra = NumericFunctions.toDouble(values[columns.get("RA_ICRS")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("DE_ICRS")]);
            this.g_ext = NumericFunctions.toDouble(values[columns.get("S/Gg")]);
            this.r_ext = NumericFunctions.toDouble(values[columns.get("S/Gr")]);
            this.i_ext = NumericFunctions.toDouble(values[columns.get("S/Gi")]);
            this.z_ext = NumericFunctions.toDouble(values[columns.get("S/Gz")]);
            this.y_ext = NumericFunctions.toDouble(values[columns.get("S/GY")]);
            this.g_caut = NumericFunctions.toInteger(values[columns.get("gFlag")]);
            this.r_caut = NumericFunctions.toInteger(values[columns.get("rFlag")]);
            this.i_caut = NumericFunctions.toInteger(values[columns.get("iFlag")]);
            this.z_caut = NumericFunctions.toInteger(values[columns.get("zFlag")]);
            this.y_caut = NumericFunctions.toInteger(values[columns.get("yFlag")]);
            this.g_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("gmag")]));
            this.g_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("e_gmag")]));
            this.r_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("rmag")]));
            this.r_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("e_rmag")]));
            this.i_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("imag")]));
            this.i_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("e_imag")]));
            this.z_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("zmag")]));
            this.z_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("e_zmag")]));
            this.y_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("Ymag")]));
            this.y_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("e_Ymag")]));
            this.glon = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("GLON")]));
            this.glat = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("GLAT")]));
        } else {
            MiscUtils.replaceNanValuesByZero(values);
            this.sourceId = values[columns.get("coadd_object_id")];
            this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
            this.g_ext = NumericFunctions.toDouble(values[columns.get("class_star_g")]);
            this.r_ext = NumericFunctions.toDouble(values[columns.get("class_star_r")]);
            this.i_ext = NumericFunctions.toDouble(values[columns.get("class_star_y")]);
            this.z_ext = NumericFunctions.toDouble(values[columns.get("class_star_z")]);
            this.y_ext = NumericFunctions.toDouble(values[columns.get("class_star_y")]);
            this.g_caut = NumericFunctions.toInteger(values[columns.get("flags_g")]);
            this.r_caut = NumericFunctions.toInteger(values[columns.get("flags_r")]);
            this.i_caut = NumericFunctions.toInteger(values[columns.get("flags_i")]);
            this.z_caut = NumericFunctions.toInteger(values[columns.get("flags_z")]);
            this.y_caut = NumericFunctions.toInteger(values[columns.get("flags_y")]);
            this.g_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("mag_auto_g")]));
            this.g_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("magerr_auto_g")]));
            this.r_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("mag_auto_r")]));
            this.r_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("magerr_auto_r")]));
            this.i_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("mag_auto_i")]));
            this.i_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("magerr_auto_i")]));
            this.z_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("mag_auto_z")]));
            this.z_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("magerr_auto_z")]));
            this.y_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("mag_auto_y")]));
            this.y_err = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("magerr_auto_y")]));
            this.glon = NumericFunctions.toDouble(values[columns.get("galactic_l")]);
            this.glat = NumericFunctions.toDouble(values[columns.get("galactic_b")]);
        }
    }

    private double fixMagVal(double mag) {
        return mag > 98.0 ? 0.0 : mag;
    }

    @Override
    public CatalogEntry copy() {
        return new DesCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g Galaxy-Star (0-1)", NumericFunctions.roundTo2DecNZ(this.g_ext), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r Galaxy-Star (0-1)", NumericFunctions.roundTo2DecNZ(this.r_ext), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i Galaxy-Star (0-1)", NumericFunctions.roundTo2DecNZ(this.i_ext), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z Galaxy-Star (0-1)", NumericFunctions.roundTo2DecNZ(this.z_ext), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Y Galaxy-Star (0-1)", NumericFunctions.roundTo2DecNZ(this.y_ext), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g cautionary flag", String.valueOf(this.g_caut), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), this.createToolTipCautionaryFlag(this.g_caut)));
        this.catalogElements.add(new CatalogElement("r cautionary flag", String.valueOf(this.r_caut), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), this.createToolTipCautionaryFlag(this.r_caut)));
        this.catalogElements.add(new CatalogElement("i cautionary flag", String.valueOf(this.i_caut), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), this.createToolTipCautionaryFlag(this.i_caut)));
        this.catalogElements.add(new CatalogElement("z cautionary flag", String.valueOf(this.z_caut), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), this.createToolTipCautionaryFlag(this.z_caut)));
        this.catalogElements.add(new CatalogElement("Y cautionary flag", String.valueOf(this.y_caut), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), this.createToolTipCautionaryFlag(this.y_caut)));
        this.catalogElements.add(new CatalogElement("g (mag)", NumericFunctions.roundTo3DecNZ(this.g_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g err", NumericFunctions.roundTo3DecNZ(this.g_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r (mag)", NumericFunctions.roundTo3DecNZ(this.r_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r err", NumericFunctions.roundTo3DecNZ(this.r_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i (mag)", NumericFunctions.roundTo3DecNZ(this.i_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i err", NumericFunctions.roundTo3DecNZ(this.i_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z (mag)", NumericFunctions.roundTo3DecNZ(this.z_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z err", NumericFunctions.roundTo3DecNZ(this.z_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Y (mag)", NumericFunctions.roundTo3DecNZ(this.y_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Y err", NumericFunctions.roundTo3DecNZ(this.y_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g-r", NumericFunctions.roundTo3DecNZ(this.get_g_r()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("r-i", NumericFunctions.roundTo3DecNZ(this.get_r_i()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("i-z", NumericFunctions.roundTo3DecNZ(this.get_i_z()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("z-Y", NumericFunctions.roundTo3DecNZ(this.get_z_y()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public String createToolTipCautionaryFlag(Integer cautionaryFlag) {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Cautionary flag details:</b>");
        List<StringPair> flagLabels = PhotometricFunctions.getFlagLabels(cautionaryFlag, CAUTIONARY_FLAGS);
        if (flagLabels.isEmpty()) {
            toolTip.append("<br/>").append("No warnings.");
        } else {
            flagLabels.forEach(flag -> toolTip.append("<br/>").append(flag.getS1()).append(" = ").append(flag.getS2()));
        }
        return toolTip.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this.sourceId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DesCatalogEntry other = (DesCatalogEntry)obj;
        return Objects.equals(this.sourceId, other.sourceId);
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new DesCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.SAND.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return ServiceHelper.createVizieRUrl(this.ra, this.dec, this.searchRadius / 3600.0, "II/371/des_dr2", "RA_ICRS", "DE_ICRS");
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltCatalogQuery());
    }

    private String createAltCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT coadd_object_id,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       class_star_g,");
        MiscUtils.addRow(query, "       class_star_r,");
        MiscUtils.addRow(query, "       class_star_y,");
        MiscUtils.addRow(query, "       class_star_z,");
        MiscUtils.addRow(query, "       class_star_y,");
        MiscUtils.addRow(query, "       flags_g,");
        MiscUtils.addRow(query, "       flags_r,");
        MiscUtils.addRow(query, "       flags_i,");
        MiscUtils.addRow(query, "       flags_z,");
        MiscUtils.addRow(query, "       flags_y,");
        MiscUtils.addRow(query, "       mag_auto_g,");
        MiscUtils.addRow(query, "       magerr_auto_g,");
        MiscUtils.addRow(query, "       mag_auto_r,");
        MiscUtils.addRow(query, "       magerr_auto_r,");
        MiscUtils.addRow(query, "       mag_auto_i,");
        MiscUtils.addRow(query, "       magerr_auto_i,");
        MiscUtils.addRow(query, "       mag_auto_z,");
        MiscUtils.addRow(query, "       magerr_auto_z,");
        MiscUtils.addRow(query, "       mag_auto_y,");
        MiscUtils.addRow(query, "       magerr_auto_y,");
        MiscUtils.addRow(query, "       galactic_l,");
        MiscUtils.addRow(query, "       galactic_b");
        MiscUtils.addRow(query, "FROM   des_dr2.main");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo2Dec(this.g_ext) + "," + NumericFunctions.roundTo2Dec(this.r_ext) + "," + NumericFunctions.roundTo2Dec(this.i_ext) + "," + NumericFunctions.roundTo2Dec(this.z_ext) + "," + NumericFunctions.roundTo2Dec(this.y_ext) + "," + this.g_caut + "," + this.r_caut + "," + this.i_caut + "," + this.z_caut + "," + this.y_caut + "," + NumericFunctions.roundTo3Dec(this.g_mag) + "," + NumericFunctions.roundTo3Dec(this.g_err) + "," + NumericFunctions.roundTo3Dec(this.r_mag) + "," + NumericFunctions.roundTo3Dec(this.r_err) + "," + NumericFunctions.roundTo3Dec(this.i_mag) + "," + NumericFunctions.roundTo3Dec(this.i_err) + "," + NumericFunctions.roundTo3Dec(this.z_mag) + "," + NumericFunctions.roundTo3Dec(this.z_err) + "," + NumericFunctions.roundTo3Dec(this.y_mag) + "," + NumericFunctions.roundTo3Dec(this.y_err) + "," + NumericFunctions.roundTo3Dec(this.get_g_r()) + "," + NumericFunctions.roundTo3Dec(this.get_r_i()) + "," + NumericFunctions.roundTo3Dec(this.get_i_z()) + "," + NumericFunctions.roundTo3Dec(this.get_z_y());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,g Galaxy-Star (0-1),r Galaxy-Star (0-1),i Galaxy-Star (0-1),z Galaxy-Star (0-1),Y Galaxy-Star (0-1),g cautionary flag,r cautionary flag,i cautionary flag,z cautionary flag,Y cautionary flag,u (mag),u err,g (mag),g err,r (mag),r err,i (mag),i err,z (mag),z err,Y (mag),Y err,u-g,g-r,r-i,i-z,z-Y";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.g, new NumberPair(this.g_mag, this.g_err));
        bands.put(Band.r, new NumberPair(this.r_mag, this.r_err));
        bands.put(Band.i, new NumberPair(this.i_mag, this.i_err));
        bands.put(Band.z, new NumberPair(this.z_mag, this.z_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.g_r_DES, this.get_g_r());
        colors.put(astro.tool.box.enumeration.Color.r_i_DES, this.get_r_i());
        colors.put(astro.tool.box.enumeration.Color.i_z_DES, this.get_i_z());
        colors.put(astro.tool.box.enumeration.Color.z_Y_DES, this.get_z_y());
        colors.put(astro.tool.box.enumeration.Color.e_g_r_DES, this.get_g_r() - this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.e_r_i_DES, this.get_r_i() - this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.e_i_z_DES, this.get_i_z() - this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.e_z_Y_DES, this.get_z_y() - this.get_z_y_err());
        colors.put(astro.tool.box.enumeration.Color.E_g_r_DES, this.get_g_r() + this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.E_r_i_DES, this.get_r_i() + this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.E_i_z_DES, this.get_i_z() + this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.E_z_Y_DES, this.get_z_y() + this.get_z_y_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.g_mag != 0.0) {
            mags.append("g=").append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(" ");
        }
        if (this.r_mag != 0.0) {
            mags.append("r=").append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(" ");
        }
        if (this.i_mag != 0.0) {
            mags.append("i=").append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(" ");
        }
        if (this.z_mag != 0.0) {
            mags.append("z=").append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(" ");
        }
        if (this.y_mag != 0.0) {
            mags.append("y=").append(NumericFunctions.roundTo3DecNZ(this.y_mag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.g_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.g_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.r_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.r_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.i_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.i_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.z_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.z_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.y_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.y_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.y_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return 0.0;
    }

    @Override
    public double getPmdec() {
        return 0.0;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return 0.0;
    }

    public double getGlon() {
        return this.glon;
    }

    public double getGlat() {
        return this.glat;
    }

    public double get_g_r() {
        if (this.g_mag == 0.0 || this.r_mag == 0.0) {
            return 0.0;
        }
        return this.g_mag - this.r_mag;
    }

    public double get_r_i() {
        if (this.r_mag == 0.0 || this.i_mag == 0.0) {
            return 0.0;
        }
        return this.r_mag - this.i_mag;
    }

    public double get_i_z() {
        if (this.i_mag == 0.0 || this.z_mag == 0.0) {
            return 0.0;
        }
        return this.i_mag - this.z_mag;
    }

    public double get_z_y() {
        if (this.z_mag == 0.0 || this.y_mag == 0.0) {
            return 0.0;
        }
        return this.z_mag - this.y_mag;
    }

    public double get_g_r_err() {
        if (this.g_err == 0.0 || this.r_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.g_err, this.r_err);
    }

    public double get_r_i_err() {
        if (this.r_err == 0.0 || this.i_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.r_err, this.i_err);
    }

    public double get_i_z_err() {
        if (this.i_err == 0.0 || this.z_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.i_err, this.z_err);
    }

    public double get_z_y_err() {
        if (this.z_err == 0.0 || this.y_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.z_err, this.y_err);
    }

    public double get_g_mag() {
        return this.g_mag;
    }

    public double get_r_mag() {
        return this.r_mag;
    }

    public double get_i_mag() {
        return this.i_mag;
    }

    public double get_z_mag() {
        return this.z_mag;
    }

    public double get_y_mag() {
        return this.y_mag;
    }

    public double get_g_err() {
        return this.g_err;
    }

    public double get_r_err() {
        return this.r_err;
    }

    public double get_i_err() {
        return this.i_err;
    }

    public double get_z_err() {
        return this.z_err;
    }

    public double get_y_err() {
        return this.y_err;
    }

    public int get_g_caut() {
        return this.g_caut;
    }

    public int get_r_caut() {
        return this.r_caut;
    }

    public int get_i_caut() {
        return this.i_caut;
    }

    public int get_z_caut() {
        return this.z_caut;
    }

    public int get_y_caut() {
        return this.y_caut;
    }

    static {
        CAUTIONARY_FLAGS.put(1, "The object has neighbors, bright and close enough to significantly bias the photometry, or bad pixels (more than 10% of the integrated area affected).");
        CAUTIONARY_FLAGS.put(2, "The object was originally blended with another one.");
        CAUTIONARY_FLAGS.put(4, "At least one pixel of the object is saturated (or very close to).");
        CAUTIONARY_FLAGS.put(8, "The object is truncated (too close to an image boundary).");
        CAUTIONARY_FLAGS.put(16, "Object's aperture data are incomplete or corrupted.");
        CAUTIONARY_FLAGS.put(32, "Object's isophotal data are incomplete or corrupted.");
        CAUTIONARY_FLAGS.put(64, "A memory overflow occurred during deblending.");
        CAUTIONARY_FLAGS.put(128, "A memory overflow occurred during extraction.");
    }
}

