/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.GaiaCmd;
import astro.tool.box.catalog.ProperMotionCatalog;
import astro.tool.box.catalog.ProperMotionQuery;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GaiaDR2CatalogEntry
implements CatalogEntry,
ProperMotionQuery,
ProperMotionCatalog,
WhiteDwarf,
GaiaCmd {
    public static final String CATALOG_NAME = "Gaia DR2";
    private long sourceId;
    private double ra;
    private double dec;
    private double plx;
    private double plx_err;
    private double pmra;
    private double pmra_err;
    private double pmdec;
    private double pmdec_err;
    private double Gmag;
    private double G_err;
    private double BPmag;
    private double BP_err;
    private double RPmag;
    private double RP_err;
    private double BP_RP;
    private double BP_G;
    private double G_RP;
    private double radvel;
    private double radvel_err;
    private double teff;
    private double radsun;
    private double lumsun;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private double tpm;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public GaiaDR2CatalogEntry() {
    }

    public GaiaDR2CatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        if (MiscUtils.isVizierTAP()) {
            this.sourceId = NumericFunctions.toLong(values[columns.get("source_id")]);
            this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
            this.plx = NumericFunctions.toDouble(values[columns.get("parallax")]);
            this.plx_err = NumericFunctions.toDouble(values[columns.get("parallax_error")]);
            this.pmra = NumericFunctions.toDouble(values[columns.get("pmra")]);
            this.pmra_err = NumericFunctions.toDouble(values[columns.get("pmra_error")]);
            this.pmdec = NumericFunctions.toDouble(values[columns.get("pmdec")]);
            this.pmdec_err = NumericFunctions.toDouble(values[columns.get("pmdec_error")]);
            this.Gmag = NumericFunctions.toDouble(values[columns.get("phot_g_mean_mag")]);
            this.BPmag = NumericFunctions.toDouble(values[columns.get("phot_bp_mean_mag")]);
            this.RPmag = NumericFunctions.toDouble(values[columns.get("phot_rp_mean_mag")]);
            this.G_err = NumericFunctions.toDouble(values[columns.get("phot_g_mean_mag_error")]);
            this.BP_err = NumericFunctions.toDouble(values[columns.get("phot_bp_mean_mag_error")]);
            this.RP_err = NumericFunctions.toDouble(values[columns.get("phot_rp_mean_mag_error")]);
            this.BP_RP = NumericFunctions.toDouble(values[columns.get("bp_rp")]);
            this.BP_G = NumericFunctions.toDouble(values[columns.get("bp_g")]);
            this.G_RP = NumericFunctions.toDouble(values[columns.get("g_rp")]);
            this.radvel = NumericFunctions.toDouble(values[columns.get("radial_velocity")]);
            this.radvel_err = NumericFunctions.toDouble(values[columns.get("radial_velocity_error")]);
            this.teff = NumericFunctions.toDouble(values[columns.get("teff_val")]);
            this.radsun = NumericFunctions.toDouble(values[columns.get("radius_val")]);
            this.lumsun = NumericFunctions.toDouble(values[columns.get("lum_val")]);
        } else {
            MiscUtils.replaceNanValuesByZero(values);
            this.sourceId = NumericFunctions.toLong(values[columns.get("source_id")]);
            this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
            this.plx = NumericFunctions.toDouble(values[columns.get("parallax")]);
            this.plx_err = NumericFunctions.toDouble(values[columns.get("parallax_error")]);
            this.pmra = NumericFunctions.toDouble(values[columns.get("pmra")]);
            this.pmra_err = NumericFunctions.toDouble(values[columns.get("pmra_error")]);
            this.pmdec = NumericFunctions.toDouble(values[columns.get("pmdec")]);
            this.pmdec_err = NumericFunctions.toDouble(values[columns.get("pmdec_error")]);
            this.Gmag = NumericFunctions.toDouble(values[columns.get("phot_g_mean_mag")]);
            this.BPmag = NumericFunctions.toDouble(values[columns.get("phot_bp_mean_mag")]);
            this.RPmag = NumericFunctions.toDouble(values[columns.get("phot_rp_mean_mag")]);
            this.BP_RP = NumericFunctions.toDouble(values[columns.get("bp_rp")]);
            this.BP_G = NumericFunctions.toDouble(values[columns.get("bp_g")]);
            this.G_RP = NumericFunctions.toDouble(values[columns.get("g_rp")]);
            this.radvel = NumericFunctions.toDouble(values[columns.get("radial_velocity")]);
            this.radvel_err = NumericFunctions.toDouble(values[columns.get("radial_velocity_error")]);
            this.teff = NumericFunctions.toDouble(values[columns.get("teff_val")]);
            this.radsun = NumericFunctions.toDouble(values[columns.get("radius_val")]);
            this.lumsun = NumericFunctions.toDouble(values[columns.get("lum_val")]);
        }
    }

    @Override
    public CatalogEntry copy() {
        return new GaiaDR2CatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("plx (mas)", NumericFunctions.roundTo4DecNZ(this.plx), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("plx err", NumericFunctions.roundTo4DecNZ(this.plx_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmra), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmra err", NumericFunctions.roundTo3DecNZ(this.pmra_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmra, this.pmra_err)));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmdec), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmdec err", NumericFunctions.roundTo3DecNZ(this.pmdec_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmdec, this.pmdec_err)));
        this.catalogElements.add(new CatalogElement("G (mag)", NumericFunctions.roundTo3DecNZ(this.Gmag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("G err", NumericFunctions.roundTo3DecNZ(this.G_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP (mag)", NumericFunctions.roundTo3DecNZ(this.BPmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP err", NumericFunctions.roundTo3DecNZ(this.BP_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("RP (mag)", NumericFunctions.roundTo3DecNZ(this.RPmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("RP err", NumericFunctions.roundTo3DecNZ(this.RP_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP-RP", NumericFunctions.roundTo3DecNZ(this.BP_RP), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP-G", NumericFunctions.roundTo3DecNZ(this.BP_G), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("G-RP", NumericFunctions.roundTo3DecNZ(this.G_RP), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("rad vel (km/s)", NumericFunctions.roundTo3DecNZ(this.radvel), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("rad vel err", NumericFunctions.roundTo3DecNZ(this.radvel_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("teff (K)", NumericFunctions.roundTo2DecNZ(this.teff), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("radius (Rsun)", NumericFunctions.roundTo2DecNZ(this.radsun), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("luminosity (Lsun)", NumericFunctions.roundTo3DecNZ(this.lumsun), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dist (1/plx)", NumericFunctions.roundTo3DecNZ(this.getParallacticDistance()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("Absolute G (mag)", NumericFunctions.roundTo3DecNZ(this.getAbsoluteGmag()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tpm (mas/yr)", NumericFunctions.roundTo3DecNZ(this.getTotalProperMotion()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tang vel (km/s)", NumericFunctions.roundTo3DecNZ(this.getTangentialVelocity()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tot vel (km/s)", NumericFunctions.roundTo3DecNZ(this.getTotalVelocity()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (int)(this.sourceId ^ this.sourceId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GaiaDR2CatalogEntry other = (GaiaDR2CatalogEntry)obj;
        return this.sourceId == other.sourceId;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new GaiaDR2CatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return Color.CYAN.darker();
    }

    @Override
    public String getCatalogQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return "http://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createCatalogQuery());
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltCatalogQuery());
    }

    @Override
    public String getMotionQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return "http://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createProperMotionQuery());
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltProperMotionQuery());
    }

    private String createCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT source_id,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       parallax,");
        MiscUtils.addRow(query, "       parallax_error,");
        MiscUtils.addRow(query, "       pmra,");
        MiscUtils.addRow(query, "       pmra_error,");
        MiscUtils.addRow(query, "       pmdec,");
        MiscUtils.addRow(query, "       pmdec_error,");
        MiscUtils.addRow(query, "       phot_g_mean_mag,");
        MiscUtils.addRow(query, "       phot_bp_mean_mag,");
        MiscUtils.addRow(query, "       phot_rp_mean_mag,");
        MiscUtils.addRow(query, "       phot_g_mean_mag_error,");
        MiscUtils.addRow(query, "       phot_bp_mean_mag_error,");
        MiscUtils.addRow(query, "       phot_rp_mean_mag_error,");
        MiscUtils.addRow(query, "       bp_rp,");
        MiscUtils.addRow(query, "       bp_g,");
        MiscUtils.addRow(query, "       g_rp,");
        MiscUtils.addRow(query, "       radial_velocity,");
        MiscUtils.addRow(query, "       radial_velocity_error,");
        MiscUtils.addRow(query, "       teff_val,");
        MiscUtils.addRow(query, "       radius_val,");
        MiscUtils.addRow(query, "       lum_val");
        MiscUtils.addRow(query, "FROM   \"I/345/gaia2\"");
        MiscUtils.addRow(query, "WHERE  1=CONTAINS(POINT('ICRS', ra, dec), CIRCLE('ICRS', " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + "))");
        return query.toString();
    }

    private String createProperMotionQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, this.createCatalogQuery());
        MiscUtils.addRow(query, "AND    SQRT(pmra * pmra + pmdec * pmdec) >= " + this.tpm);
        return query.toString();
    }

    private String createAltCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT source_id,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       parallax,");
        MiscUtils.addRow(query, "       parallax_error,");
        MiscUtils.addRow(query, "       pmra,");
        MiscUtils.addRow(query, "       pmra_error,");
        MiscUtils.addRow(query, "       pmdec,");
        MiscUtils.addRow(query, "       pmdec_error,");
        MiscUtils.addRow(query, "       phot_g_mean_mag,");
        MiscUtils.addRow(query, "       phot_bp_mean_mag,");
        MiscUtils.addRow(query, "       phot_rp_mean_mag,");
        MiscUtils.addRow(query, "       bp_rp,");
        MiscUtils.addRow(query, "       bp_g,");
        MiscUtils.addRow(query, "       g_rp,");
        MiscUtils.addRow(query, "       radial_velocity,");
        MiscUtils.addRow(query, "       radial_velocity_error,");
        MiscUtils.addRow(query, "       teff_val,");
        MiscUtils.addRow(query, "       radius_val,");
        MiscUtils.addRow(query, "       lum_val");
        MiscUtils.addRow(query, "FROM   gaia_dr2.gaia_source");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    private String createAltProperMotionQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, this.createAltCatalogQuery());
        MiscUtils.addRow(query, "AND    pmra <> 'NaN' AND pmdec <> 'NaN'");
        MiscUtils.addRow(query, "AND    SQRT(pmra * pmra + pmdec * pmdec) >= " + this.tpm);
        return query.toString();
    }

    @Override
    public void setTpm(double tpm) {
        this.tpm = tpm;
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo4Dec(this.plx) + "," + NumericFunctions.roundTo4Dec(this.plx_err) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmra_err) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + NumericFunctions.roundTo3Dec(this.pmdec_err) + "," + NumericFunctions.roundTo3Dec(this.Gmag) + "," + NumericFunctions.roundTo3Dec(this.G_err) + "," + NumericFunctions.roundTo3Dec(this.BPmag) + "," + NumericFunctions.roundTo3Dec(this.BP_err) + "," + NumericFunctions.roundTo3Dec(this.RPmag) + "," + NumericFunctions.roundTo3Dec(this.RP_err) + "," + NumericFunctions.roundTo3Dec(this.BP_RP) + "," + NumericFunctions.roundTo3Dec(this.BP_G) + "," + NumericFunctions.roundTo3Dec(this.G_RP) + "," + NumericFunctions.roundTo3Dec(this.radvel) + "," + NumericFunctions.roundTo3Dec(this.radvel_err) + "," + NumericFunctions.roundTo2Dec(this.teff) + "," + NumericFunctions.roundTo2Dec(this.radsun) + "," + NumericFunctions.roundTo3Dec(this.lumsun) + "," + NumericFunctions.roundTo3Dec(this.getParallacticDistance()) + "," + NumericFunctions.roundTo3Dec(this.getAbsoluteGmag()) + "," + NumericFunctions.roundTo3Dec(this.getTotalProperMotion()) + "," + NumericFunctions.roundTo3Dec(this.getTangentialVelocity()) + "," + NumericFunctions.roundTo3Dec(this.getTotalVelocity());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,plx (mas),plx err,pmra (mas/yr),pmra err,pmdec (mas/yr),pmdec err,G (mag),G err,BP (mag),BP err,RP (mag),RP err,BP-RP,BP-G,G-RP,rad vel (km/s),rad vel err,teff (K),radius (Rsun),luminosity (Lsun),dist (1/plx),Absolute G (mag),tpm (mas/yr),tang vel (km/s),tot vel (km/s)";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.G, new NumberPair(this.Gmag, this.G_err));
        bands.put(Band.BP, new NumberPair(this.BPmag, this.BP_err));
        bands.put(Band.RP, new NumberPair(this.RPmag, this.RP_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.M_G, this.getAbsoluteGmag());
        colors.put(astro.tool.box.enumeration.Color.M_BP, this.getAbsoluteBPmag());
        colors.put(astro.tool.box.enumeration.Color.M_RP, this.getAbsoluteRPmag());
        colors.put(astro.tool.box.enumeration.Color.G_RP, this.G_RP);
        colors.put(astro.tool.box.enumeration.Color.BP_RP, this.BP_RP);
        colors.put(astro.tool.box.enumeration.Color.BP_G, this.BP_G);
        colors.put(astro.tool.box.enumeration.Color.e_M_G, this.getAbsoluteGmag() - this.getAbsoluteGmagError());
        colors.put(astro.tool.box.enumeration.Color.e_M_BP, this.getAbsoluteBPmag() - this.getAbsoluteBPmagError());
        colors.put(astro.tool.box.enumeration.Color.e_M_RP, this.getAbsoluteRPmag() - this.getAbsoluteRPmagError());
        colors.put(astro.tool.box.enumeration.Color.e_G_RP, this.G_RP - this.getG_RP_err());
        colors.put(astro.tool.box.enumeration.Color.e_BP_RP, this.BP_RP - this.getBP_RP_err());
        colors.put(astro.tool.box.enumeration.Color.e_BP_G, this.BP_G - this.getBP_G_err());
        colors.put(astro.tool.box.enumeration.Color.E_M_G, this.getAbsoluteGmag() + this.getAbsoluteGmagError());
        colors.put(astro.tool.box.enumeration.Color.E_M_BP, this.getAbsoluteBPmag() + this.getAbsoluteBPmagError());
        colors.put(astro.tool.box.enumeration.Color.E_M_RP, this.getAbsoluteRPmag() + this.getAbsoluteRPmagError());
        colors.put(astro.tool.box.enumeration.Color.E_G_RP, this.G_RP + this.getG_RP_err());
        colors.put(astro.tool.box.enumeration.Color.E_BP_RP, this.BP_RP + this.getBP_RP_err());
        colors.put(astro.tool.box.enumeration.Color.E_BP_G, this.BP_G + this.getBP_G_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.Gmag != 0.0) {
            mags.append("G=").append(NumericFunctions.roundTo3DecNZ(this.Gmag)).append(" ");
        }
        if (this.BPmag != 0.0) {
            mags.append("BP=").append(NumericFunctions.roundTo3DecNZ(this.BPmag)).append(" ");
        }
        if (this.RPmag != 0.0) {
            mags.append("RP=").append(NumericFunctions.roundTo3DecNZ(this.RPmag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.Gmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.Gmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.G_err)).append(",");
        } else {
            mags.append(",");
        }
        if (this.BPmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.BPmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.BP_err)).append(",");
        } else {
            mags.append(",");
        }
        if (this.RPmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.RPmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.RP_err)).append(",");
        } else {
            mags.append(",");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return this.plx;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getPmraErr() {
        return this.pmra_err;
    }

    @Override
    public double getPmdecErr() {
        return this.pmdec_err;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return AstrometricFunctions.calculateParallacticDistance(this.plx);
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getTangentialVelocity() {
        return AstrometricFunctions.calculateTangentialVelocityFromParallax(this.pmra, this.pmdec, this.plx);
    }

    public double getTotalVelocity() {
        return AstrometricFunctions.calculateTotalVelocity(this.radvel, this.getTangentialVelocity());
    }

    public double getAbsoluteRPmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.RPmag, this.plx);
    }

    public double getAbsoluteBPmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.BPmag, this.plx);
    }

    public double getAbsoluteGmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.Gmag, this.G_err, this.plx, this.plx_err);
    }

    public double getAbsoluteRPmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.RPmag, this.RP_err, this.plx, this.plx_err);
    }

    public double getAbsoluteBPmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.BPmag, this.BP_err, this.plx, this.plx_err);
    }

    @Override
    public double getAbsoluteGmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.Gmag, this.plx);
    }

    @Override
    public double getBP_RP() {
        return this.BP_RP;
    }

    @Override
    public double getG_RP() {
        return this.G_RP;
    }

    public double getBP_RP_err() {
        if (this.BP_err == 0.0 || this.RP_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.BP_err, this.RP_err);
    }

    public double getG_RP_err() {
        if (this.G_err == 0.0 || this.RP_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.G_err, this.RP_err);
    }

    public double getBP_G_err() {
        if (this.BP_err == 0.0 || this.G_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.BP_err, this.G_err);
    }

    public double getGmag() {
        return this.Gmag;
    }

    public double getBPmag() {
        return this.BPmag;
    }

    public double getRPmag() {
        return this.RPmag;
    }

    public double getG_err() {
        return this.G_err;
    }

    public double getBP_err() {
        return this.BP_err;
    }

    public double getRP_err() {
        return this.RP_err;
    }
}

