/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.GaiaCmd;
import astro.tool.box.catalog.ProperMotionCatalog;
import astro.tool.box.catalog.ProperMotionQuery;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GaiaDR3CatalogEntry
implements CatalogEntry,
ProperMotionQuery,
ProperMotionCatalog,
WhiteDwarf,
GaiaCmd {
    public static final String CATALOG_NAME = "Gaia DR3";
    private long sourceId;
    private double ra;
    private double dec;
    private double plx;
    private double plx_err;
    private double pmra;
    private double pmra_err;
    private double pmdec;
    private double pmdec_err;
    private double Gmag;
    private double G_err;
    private double BPmag;
    private double BP_err;
    private double RPmag;
    private double RP_err;
    private double BP_RP;
    private double BP_G;
    private double G_RP;
    private double ruwe;
    private double radvel;
    private double radvel_err;
    private double teff_gspphot;
    private double teff_gspphot_lower;
    private double teff_gspphot_upper;
    private double logg_gspphot;
    private double logg_gspphot_lower;
    private double logg_gspphot_upper;
    private double mh_gspphot;
    private double mh_gspphot_lower;
    private double mh_gspphot_upper;
    private double distance_gspphot;
    private double distance_gspphot_lower;
    private double distance_gspphot_upper;
    private String phot_variable_flag;
    private double classprob_dsc_combmod_quasar;
    private double classprob_dsc_combmod_galaxy;
    private double classprob_dsc_combmod_star;
    private double ag_gspphot;
    private double ebpminrp_gspphot;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private double tpm;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public GaiaDR3CatalogEntry() {
    }

    public GaiaDR3CatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        if (MiscUtils.isVizierTAP()) {
            this.sourceId = NumericFunctions.toLong(values[columns.get("Source")]);
            this.ra = NumericFunctions.toDouble(values[columns.get("RA_ICRS")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("DE_ICRS")]);
            this.plx = NumericFunctions.toDouble(values[columns.get("Plx")]);
            this.plx_err = NumericFunctions.toDouble(values[columns.get("e_Plx")]);
            this.pmra = NumericFunctions.toDouble(values[columns.get("pmRA")]);
            this.pmra_err = NumericFunctions.toDouble(values[columns.get("e_pmRA")]);
            this.pmdec = NumericFunctions.toDouble(values[columns.get("pmDE")]);
            this.pmdec_err = NumericFunctions.toDouble(values[columns.get("e_pmDE")]);
            this.Gmag = NumericFunctions.toDouble(values[columns.get("Gmag")]);
            this.G_err = NumericFunctions.toDouble(values[columns.get("e_Gmag")]);
            this.BPmag = NumericFunctions.toDouble(values[columns.get("BPmag")]);
            this.BP_err = NumericFunctions.toDouble(values[columns.get("e_BPmag")]);
            this.RPmag = NumericFunctions.toDouble(values[columns.get("RPmag")]);
            this.RP_err = NumericFunctions.toDouble(values[columns.get("e_RPmag")]);
            this.BP_RP = NumericFunctions.toDouble(values[columns.get("BP-RP")]);
            this.BP_G = NumericFunctions.toDouble(values[columns.get("BP-G")]);
            this.G_RP = NumericFunctions.toDouble(values[columns.get("G-RP")]);
            this.ruwe = NumericFunctions.toDouble(values[columns.get("RUWE")]);
            this.radvel = NumericFunctions.toDouble(values[columns.get("RV")]);
            this.radvel_err = NumericFunctions.toDouble(values[columns.get("e_RV")]);
            this.teff_gspphot = NumericFunctions.toDouble(values[columns.get("Teff")]);
            this.teff_gspphot_lower = NumericFunctions.toDouble(values[columns.get("b_Teff")]);
            this.teff_gspphot_upper = NumericFunctions.toDouble(values[columns.get("B_Teff")]);
            this.logg_gspphot = NumericFunctions.toDouble(values[columns.get("logg")]);
            this.logg_gspphot_lower = NumericFunctions.toDouble(values[columns.get("b_logg")]);
            this.logg_gspphot_upper = NumericFunctions.toDouble(values[columns.get("B_logg")]);
            this.mh_gspphot = NumericFunctions.toDouble(values[columns.get("[Fe/H]")]);
            this.mh_gspphot_lower = NumericFunctions.toDouble(values[columns.get("b_[Fe/H]")]);
            this.mh_gspphot_upper = NumericFunctions.toDouble(values[columns.get("B_[Fe/H]")]);
            this.distance_gspphot = NumericFunctions.toDouble(values[columns.get("Dist")]);
            this.distance_gspphot_lower = NumericFunctions.toDouble(values[columns.get("b_Dist")]);
            this.distance_gspphot_upper = NumericFunctions.toDouble(values[columns.get("B_Dist")]);
            this.phot_variable_flag = values[columns.get("VarFlag")];
            this.classprob_dsc_combmod_quasar = NumericFunctions.toDouble(values[columns.get("PQSO")]);
            this.classprob_dsc_combmod_galaxy = NumericFunctions.toDouble(values[columns.get("PGal")]);
            this.classprob_dsc_combmod_star = NumericFunctions.toDouble(values[columns.get("PSS")]);
            this.ag_gspphot = NumericFunctions.toDouble(values[columns.get("AG")]);
            this.ebpminrp_gspphot = NumericFunctions.toDouble(values[columns.get("E(BP-RP)")]);
        } else {
            this.sourceId = NumericFunctions.toLong(values[columns.get("source_id")]);
            this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
            this.plx = NumericFunctions.toDouble(values[columns.get("parallax")]);
            this.plx_err = NumericFunctions.toDouble(values[columns.get("parallax_error")]);
            this.pmra = NumericFunctions.toDouble(values[columns.get("pmra")]);
            this.pmra_err = NumericFunctions.toDouble(values[columns.get("pmra_error")]);
            this.pmdec = NumericFunctions.toDouble(values[columns.get("pmdec")]);
            this.pmdec_err = NumericFunctions.toDouble(values[columns.get("pmdec_error")]);
            this.Gmag = NumericFunctions.toDouble(values[columns.get("phot_g_mean_mag")]);
            this.BPmag = NumericFunctions.toDouble(values[columns.get("phot_bp_mean_mag")]);
            this.RPmag = NumericFunctions.toDouble(values[columns.get("phot_rp_mean_mag")]);
            this.BP_RP = NumericFunctions.toDouble(values[columns.get("bp_rp")]);
            this.BP_G = NumericFunctions.toDouble(values[columns.get("bp_g")]);
            this.G_RP = NumericFunctions.toDouble(values[columns.get("g_rp")]);
            this.ruwe = NumericFunctions.toDouble(values[columns.get("ruwe")]);
            this.radvel = NumericFunctions.toDouble(values[columns.get("radial_velocity")]);
            this.radvel_err = NumericFunctions.toDouble(values[columns.get("radial_velocity_error")]);
            this.teff_gspphot = NumericFunctions.toDouble(values[columns.get("teff_gspphot")]);
            this.teff_gspphot_lower = NumericFunctions.toDouble(values[columns.get("teff_gspphot_lower")]);
            this.teff_gspphot_upper = NumericFunctions.toDouble(values[columns.get("teff_gspphot_upper")]);
            this.logg_gspphot = NumericFunctions.toDouble(values[columns.get("logg_gspphot")]);
            this.logg_gspphot_lower = NumericFunctions.toDouble(values[columns.get("logg_gspphot_lower")]);
            this.logg_gspphot_upper = NumericFunctions.toDouble(values[columns.get("logg_gspphot_upper")]);
            this.mh_gspphot = NumericFunctions.toDouble(values[columns.get("mh_gspphot")]);
            this.mh_gspphot_lower = NumericFunctions.toDouble(values[columns.get("mh_gspphot_lower")]);
            this.mh_gspphot_upper = NumericFunctions.toDouble(values[columns.get("mh_gspphot_upper")]);
            this.distance_gspphot = NumericFunctions.toDouble(values[columns.get("distance_gspphot")]);
            this.distance_gspphot_lower = NumericFunctions.toDouble(values[columns.get("distance_gspphot_lower")]);
            this.distance_gspphot_upper = NumericFunctions.toDouble(values[columns.get("distance_gspphot_upper")]);
            this.phot_variable_flag = values[columns.get("phot_variable_flag")];
            this.classprob_dsc_combmod_quasar = NumericFunctions.toDouble(values[columns.get("classprob_dsc_combmod_quasar")]);
            this.classprob_dsc_combmod_galaxy = NumericFunctions.toDouble(values[columns.get("classprob_dsc_combmod_galaxy")]);
            this.classprob_dsc_combmod_star = NumericFunctions.toDouble(values[columns.get("classprob_dsc_combmod_star")]);
            this.ag_gspphot = NumericFunctions.toDouble(values[columns.get("ag_gspphot")]);
            this.ebpminrp_gspphot = NumericFunctions.toDouble(values[columns.get("ebpminrp_gspphot")]);
        }
    }

    @Override
    public CatalogEntry copy() {
        return new GaiaDR3CatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("plx (mas)", NumericFunctions.roundTo4DecNZ(this.plx), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("plx err", NumericFunctions.roundTo4DecNZ(this.plx_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmra), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmra err", NumericFunctions.roundTo3DecNZ(this.pmra_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmra, this.pmra_err)));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmdec), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmdec err", NumericFunctions.roundTo3DecNZ(this.pmdec_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmdec, this.pmdec_err)));
        this.catalogElements.add(new CatalogElement("G (mag)", NumericFunctions.roundTo3DecNZ(this.Gmag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("G err", NumericFunctions.roundTo3DecNZ(this.G_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP (mag)", NumericFunctions.roundTo3DecNZ(this.BPmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP err", NumericFunctions.roundTo3DecNZ(this.BP_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("RP (mag)", NumericFunctions.roundTo3DecNZ(this.RPmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("RP err", NumericFunctions.roundTo3DecNZ(this.RP_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP-RP", NumericFunctions.roundTo3DecNZ(this.BP_RP), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP-G", NumericFunctions.roundTo3DecNZ(this.BP_G), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("G-RP", NumericFunctions.roundTo3DecNZ(this.G_RP), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("RUWE", NumericFunctions.roundTo3DecNZ(this.ruwe), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), false));
        this.catalogElements.add(new CatalogElement("rad vel (km/s)", NumericFunctions.roundTo3DecNZ(this.radvel), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("rad vel err", NumericFunctions.roundTo3DecNZ(this.radvel_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("teff (K)", NumericFunctions.roundTo3DecNZ(this.teff_gspphot), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("lower teff (K)", NumericFunctions.roundTo3DecNZ(this.teff_gspphot_lower), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("upper teff (K)", NumericFunctions.roundTo3DecNZ(this.teff_gspphot_upper), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("log g", NumericFunctions.roundTo3DecNZ(this.logg_gspphot), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("lower log g", NumericFunctions.roundTo3DecNZ(this.logg_gspphot_lower), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("upper log g", NumericFunctions.roundTo3DecNZ(this.logg_gspphot_upper), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Fe/H (dex)", NumericFunctions.roundTo3DecNZ(this.mh_gspphot), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("lower Fe/H (dex)", NumericFunctions.roundTo3DecNZ(this.mh_gspphot_lower), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("upper Fe/H (dex)", NumericFunctions.roundTo3DecNZ(this.mh_gspphot_upper), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dist (pc)", NumericFunctions.roundTo3DecNZ(this.distance_gspphot), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("lower dist (pc)", NumericFunctions.roundTo3DecNZ(this.distance_gspphot_lower), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("upper dist (pc)", NumericFunctions.roundTo3DecNZ(this.distance_gspphot_upper), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("var. flag", this.phot_variable_flag, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("quasar prob.", NumericFunctions.roundTo3DecNZ(this.classprob_dsc_combmod_quasar), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("galaxy prob.", NumericFunctions.roundTo3DecNZ(this.classprob_dsc_combmod_galaxy), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("star prob.", NumericFunctions.roundTo3DecNZ(this.classprob_dsc_combmod_star), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("extinct. in G band", NumericFunctions.roundTo3DecNZ(this.ag_gspphot), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("reddening E(BP-RP)", NumericFunctions.roundTo3DecNZ(this.ebpminrp_gspphot), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dist (1/plx)", NumericFunctions.roundTo3DecNZ(this.getParallacticDistance()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("Absolute G (mag)", NumericFunctions.roundTo3DecNZ(this.getAbsoluteGmag()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tpm (mas/yr)", NumericFunctions.roundTo3DecNZ(this.getTotalProperMotion()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tang vel (km/s)", NumericFunctions.roundTo3DecNZ(this.getTangentialVelocity()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tot vel (km/s)", NumericFunctions.roundTo3DecNZ(this.getTotalVelocity()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(this.sourceId ^ this.sourceId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GaiaDR3CatalogEntry other = (GaiaDR3CatalogEntry)obj;
        return this.sourceId == other.sourceId;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new GaiaDR3CatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return Color.CYAN.darker();
    }

    @Override
    public String getCatalogQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return "http://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createCatalogQuery());
        }
        return "https://gea.esac.esa.int/tap-server/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltCatalogQuery());
    }

    @Override
    public String getMotionQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return "http://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createProperMotionQuery());
        }
        return "https://gea.esac.esa.int/tap-server/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltProperMotionQuery());
    }

    private String createCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT Source,");
        MiscUtils.addRow(query, "       RA_ICRS,");
        MiscUtils.addRow(query, "       DE_ICRS,");
        MiscUtils.addRow(query, "       Plx,");
        MiscUtils.addRow(query, "       e_Plx,");
        MiscUtils.addRow(query, "       pmRA,");
        MiscUtils.addRow(query, "       e_pmRA,");
        MiscUtils.addRow(query, "       pmDE,");
        MiscUtils.addRow(query, "       e_pmDE,");
        MiscUtils.addRow(query, "       Gmag,");
        MiscUtils.addRow(query, "       e_Gmag,");
        MiscUtils.addRow(query, "       BPmag,");
        MiscUtils.addRow(query, "       e_BPmag,");
        MiscUtils.addRow(query, "       RPmag,");
        MiscUtils.addRow(query, "       e_RPmag,");
        MiscUtils.addRow(query, "       \"BP-RP\",");
        MiscUtils.addRow(query, "       \"BP-G\",");
        MiscUtils.addRow(query, "       \"G-RP\",");
        MiscUtils.addRow(query, "       RUWE,");
        MiscUtils.addRow(query, "       RV,");
        MiscUtils.addRow(query, "       e_RV,");
        MiscUtils.addRow(query, "       Teff,");
        MiscUtils.addRow(query, "       \"b_Teff\",");
        MiscUtils.addRow(query, "       \"B_Teff\",");
        MiscUtils.addRow(query, "       logg,");
        MiscUtils.addRow(query, "       \"b_logg\",");
        MiscUtils.addRow(query, "       \"B_logg\",");
        MiscUtils.addRow(query, "       \"[Fe/H]\",");
        MiscUtils.addRow(query, "       \"b_[Fe/H]\",");
        MiscUtils.addRow(query, "       \"B_[Fe/H]\",");
        MiscUtils.addRow(query, "       Dist,");
        MiscUtils.addRow(query, "       \"b_Dist\",");
        MiscUtils.addRow(query, "       \"B_Dist\",");
        MiscUtils.addRow(query, "       VarFlag,");
        MiscUtils.addRow(query, "       PQSO,");
        MiscUtils.addRow(query, "       PGal,");
        MiscUtils.addRow(query, "       PSS,");
        MiscUtils.addRow(query, "       AG,");
        MiscUtils.addRow(query, "       \"E(BP-RP)\"");
        MiscUtils.addRow(query, "FROM   \"I/355/gaiadr3\"");
        MiscUtils.addRow(query, "WHERE  1=CONTAINS(POINT('ICRS', RA_ICRS, DE_ICRS), CIRCLE('ICRS', " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + "))");
        return query.toString();
    }

    private String createProperMotionQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, this.createCatalogQuery());
        MiscUtils.addRow(query, "AND    SQRT(pmRA * pmRA + pmDE * pmDE) >= " + this.tpm);
        return query.toString();
    }

    private String createAltCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT source_id,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       parallax,");
        MiscUtils.addRow(query, "       parallax_error,");
        MiscUtils.addRow(query, "       pmra,");
        MiscUtils.addRow(query, "       pmra_error,");
        MiscUtils.addRow(query, "       pmdec,");
        MiscUtils.addRow(query, "       pmdec_error,");
        MiscUtils.addRow(query, "       phot_g_mean_mag,");
        MiscUtils.addRow(query, "       phot_bp_mean_mag,");
        MiscUtils.addRow(query, "       phot_rp_mean_mag,");
        MiscUtils.addRow(query, "       bp_rp,");
        MiscUtils.addRow(query, "       bp_g,");
        MiscUtils.addRow(query, "       g_rp,");
        MiscUtils.addRow(query, "       ruwe,");
        MiscUtils.addRow(query, "       radial_velocity,");
        MiscUtils.addRow(query, "       radial_velocity_error,");
        MiscUtils.addRow(query, "       teff_gspphot,");
        MiscUtils.addRow(query, "       teff_gspphot_lower,");
        MiscUtils.addRow(query, "       teff_gspphot_upper,");
        MiscUtils.addRow(query, "       logg_gspphot,");
        MiscUtils.addRow(query, "       logg_gspphot_lower,");
        MiscUtils.addRow(query, "       logg_gspphot_upper,");
        MiscUtils.addRow(query, "       mh_gspphot,");
        MiscUtils.addRow(query, "       mh_gspphot_lower,");
        MiscUtils.addRow(query, "       mh_gspphot_upper,");
        MiscUtils.addRow(query, "       distance_gspphot,");
        MiscUtils.addRow(query, "       distance_gspphot_lower,");
        MiscUtils.addRow(query, "       distance_gspphot_upper,");
        MiscUtils.addRow(query, "       phot_variable_flag,");
        MiscUtils.addRow(query, "       classprob_dsc_combmod_quasar,");
        MiscUtils.addRow(query, "       classprob_dsc_combmod_galaxy,");
        MiscUtils.addRow(query, "       classprob_dsc_combmod_star,");
        MiscUtils.addRow(query, "       ag_gspphot,");
        MiscUtils.addRow(query, "       ebpminrp_gspphot");
        MiscUtils.addRow(query, "FROM   gaiadr3.gaia_source");
        MiscUtils.addRow(query, "WHERE  1=CONTAINS(POINT('ICRS', ra, dec), CIRCLE('ICRS', " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + "))");
        return query.toString();
    }

    private String createAltProperMotionQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, this.createAltCatalogQuery());
        MiscUtils.addRow(query, "AND    SQRT(pmra * pmra + pmdec * pmdec) >= " + this.tpm);
        return query.toString();
    }

    @Override
    public void setTpm(double tpm) {
        this.tpm = tpm;
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo4Dec(this.plx) + "," + NumericFunctions.roundTo4Dec(this.plx_err) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmra_err) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + NumericFunctions.roundTo3Dec(this.pmdec_err) + "," + NumericFunctions.roundTo3Dec(this.Gmag) + "," + NumericFunctions.roundTo3Dec(this.G_err) + "," + NumericFunctions.roundTo3Dec(this.BPmag) + "," + NumericFunctions.roundTo3Dec(this.BP_err) + "," + NumericFunctions.roundTo3Dec(this.RPmag) + "," + NumericFunctions.roundTo3Dec(this.RP_err) + "," + NumericFunctions.roundTo3Dec(this.BP_RP) + "," + NumericFunctions.roundTo3Dec(this.BP_G) + "," + NumericFunctions.roundTo3Dec(this.G_RP) + "," + NumericFunctions.roundTo3Dec(this.ruwe) + "," + NumericFunctions.roundTo3Dec(this.radvel) + "," + NumericFunctions.roundTo3Dec(this.radvel_err) + "," + NumericFunctions.roundTo3Dec(this.teff_gspphot) + "," + NumericFunctions.roundTo3Dec(this.teff_gspphot_lower) + "," + NumericFunctions.roundTo3Dec(this.teff_gspphot_upper) + "," + NumericFunctions.roundTo3Dec(this.logg_gspphot) + "," + NumericFunctions.roundTo3Dec(this.logg_gspphot_lower) + "," + NumericFunctions.roundTo3Dec(this.logg_gspphot_upper) + "," + NumericFunctions.roundTo3Dec(this.mh_gspphot) + "," + NumericFunctions.roundTo3Dec(this.mh_gspphot_lower) + "," + NumericFunctions.roundTo3Dec(this.mh_gspphot_upper) + "," + NumericFunctions.roundTo3Dec(this.distance_gspphot) + "," + NumericFunctions.roundTo3Dec(this.distance_gspphot_lower) + "," + NumericFunctions.roundTo3Dec(this.distance_gspphot_upper) + "," + this.phot_variable_flag + "," + NumericFunctions.roundTo3Dec(this.classprob_dsc_combmod_quasar) + "," + NumericFunctions.roundTo3Dec(this.classprob_dsc_combmod_galaxy) + "," + NumericFunctions.roundTo3Dec(this.classprob_dsc_combmod_star) + "," + NumericFunctions.roundTo3Dec(this.ag_gspphot) + "," + NumericFunctions.roundTo3Dec(this.ebpminrp_gspphot) + "," + NumericFunctions.roundTo3Dec(this.getParallacticDistance()) + "," + NumericFunctions.roundTo3Dec(this.getAbsoluteGmag()) + "," + NumericFunctions.roundTo3Dec(this.getTotalProperMotion()) + "," + NumericFunctions.roundTo3Dec(this.getTangentialVelocity()) + "," + NumericFunctions.roundTo3Dec(this.getTotalVelocity());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,plx (mas),plx err,pmra (mas/yr),pmra err,pmdec (mas/yr),pmdec err,G (mag),G err,BP (mag),BP err,RP (mag),RP err,BP-RP,BP-G,G-RP,RUWE,rad vel (km/s),rad vel err,teff (K),lower teff (K),upper teff (K),log g,lower log g,upper log g,Fe/H (dex),lower Fe/H (dex),upper Fe/H (dex),dist (pc),lower dist (pc),upper dist (pc),var. flag,quasar prob.,galaxy prob.,star prob.,extinct. in G band,reddening E(BP-RP),dist (1/plx),Absolute G (mag),tpm (mas/yr),tang vel (km/s),tot vel (km/s)";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.G, new NumberPair(this.Gmag, this.G_err));
        bands.put(Band.BP, new NumberPair(this.BPmag, this.BP_err));
        bands.put(Band.RP, new NumberPair(this.RPmag, this.RP_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.M_G, this.getAbsoluteGmag());
        colors.put(astro.tool.box.enumeration.Color.M_BP, this.getAbsoluteBPmag());
        colors.put(astro.tool.box.enumeration.Color.M_RP, this.getAbsoluteRPmag());
        colors.put(astro.tool.box.enumeration.Color.G_RP, this.G_RP);
        colors.put(astro.tool.box.enumeration.Color.BP_RP, this.BP_RP);
        colors.put(astro.tool.box.enumeration.Color.BP_G, this.BP_G);
        colors.put(astro.tool.box.enumeration.Color.e_M_G, this.getAbsoluteGmag() - this.getAbsoluteGmagError());
        colors.put(astro.tool.box.enumeration.Color.e_M_BP, this.getAbsoluteBPmag() - this.getAbsoluteBPmagError());
        colors.put(astro.tool.box.enumeration.Color.e_M_RP, this.getAbsoluteRPmag() - this.getAbsoluteRPmagError());
        colors.put(astro.tool.box.enumeration.Color.e_G_RP, this.G_RP - this.getG_RP_err());
        colors.put(astro.tool.box.enumeration.Color.e_BP_RP, this.BP_RP - this.getBP_RP_err());
        colors.put(astro.tool.box.enumeration.Color.e_BP_G, this.BP_G - this.getBP_G_err());
        colors.put(astro.tool.box.enumeration.Color.E_M_G, this.getAbsoluteGmag() + this.getAbsoluteGmagError());
        colors.put(astro.tool.box.enumeration.Color.E_M_BP, this.getAbsoluteBPmag() + this.getAbsoluteBPmagError());
        colors.put(astro.tool.box.enumeration.Color.E_M_RP, this.getAbsoluteRPmag() + this.getAbsoluteRPmagError());
        colors.put(astro.tool.box.enumeration.Color.E_G_RP, this.G_RP + this.getG_RP_err());
        colors.put(astro.tool.box.enumeration.Color.E_BP_RP, this.BP_RP + this.getBP_RP_err());
        colors.put(astro.tool.box.enumeration.Color.E_BP_G, this.BP_G + this.getBP_G_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.Gmag != 0.0) {
            mags.append("G=").append(NumericFunctions.roundTo3DecNZ(this.Gmag)).append(" ");
        }
        if (this.BPmag != 0.0) {
            mags.append("BP=").append(NumericFunctions.roundTo3DecNZ(this.BPmag)).append(" ");
        }
        if (this.RPmag != 0.0) {
            mags.append("RP=").append(NumericFunctions.roundTo3DecNZ(this.RPmag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.Gmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.Gmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.G_err)).append(",");
        } else {
            mags.append(",");
        }
        if (this.BPmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.BPmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.BP_err)).append(",");
        } else {
            mags.append(",");
        }
        if (this.RPmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.RPmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.RP_err)).append(",");
        } else {
            mags.append(",");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return this.plx;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return AstrometricFunctions.calculateParallacticDistance(this.plx);
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getPlxErr() {
        return this.plx_err;
    }

    @Override
    public double getPmraErr() {
        return this.pmra_err;
    }

    @Override
    public double getPmdecErr() {
        return this.pmdec_err;
    }

    public double getRadvel() {
        return this.radvel;
    }

    public double getRadvelErr() {
        return this.radvel_err;
    }

    public double getRuwe() {
        return this.ruwe;
    }

    public double getTangentialVelocity() {
        return AstrometricFunctions.calculateTangentialVelocityFromParallax(this.pmra, this.pmdec, this.plx);
    }

    public double getTotalVelocity() {
        return AstrometricFunctions.calculateTotalVelocity(this.radvel, this.getTangentialVelocity());
    }

    public double getAbsoluteRPmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.RPmag, this.plx);
    }

    public double getAbsoluteBPmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.BPmag, this.plx);
    }

    public double getAbsoluteGmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.Gmag, this.G_err, this.plx, this.plx_err);
    }

    public double getAbsoluteRPmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.RPmag, this.RP_err, this.plx, this.plx_err);
    }

    public double getAbsoluteBPmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.BPmag, this.BP_err, this.plx, this.plx_err);
    }

    @Override
    public double getAbsoluteGmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.Gmag, this.plx);
    }

    @Override
    public double getBP_RP() {
        return this.BP_RP;
    }

    @Override
    public double getG_RP() {
        return this.G_RP;
    }

    public double getBP_RP_err() {
        if (this.BP_err == 0.0 || this.RP_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.BP_err, this.RP_err);
    }

    public double getG_RP_err() {
        if (this.G_err == 0.0 || this.RP_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.G_err, this.RP_err);
    }

    public double getBP_G_err() {
        if (this.BP_err == 0.0 || this.G_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.BP_err, this.G_err);
    }

    public double getGmag() {
        return this.Gmag;
    }

    public double getBPmag() {
        return this.BPmag;
    }

    public double getRPmag() {
        return this.RPmag;
    }

    public double getG_err() {
        return this.G_err;
    }

    public double getBP_err() {
        return this.BP_err;
    }

    public double getRP_err() {
        return this.RP_err;
    }
}

