/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.ABOffset;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GaiaWDCatalogEntry
implements CatalogEntry,
Extinction {
    public static final String CATALOG_NAME = "Gaia EDR3 WD";
    private long sourceId;
    private String wdId;
    private double ra;
    private double dec;
    private double plx;
    private double pmra;
    private double pmdec;
    private double Gmag;
    private double BPmag;
    private double RPmag;
    private String sdssId;
    private double u_mag;
    private double g_mag;
    private double r_mag;
    private double i_mag;
    private double z_mag;
    private double pwd;
    private double teffH;
    private double loggH;
    private double massH;
    private double teffHe;
    private double loggHe;
    private double massHe;
    private double teffH_err;
    private double loggH_err;
    private double massH_err;
    private double teffHe_err;
    private double loggHe_err;
    private double massHe_err;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private boolean toVega;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public GaiaWDCatalogEntry() {
    }

    public GaiaWDCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        this.sourceId = NumericFunctions.toLong(values[columns.get("GaiaEDR3")]);
        this.wdId = values[columns.get("WDJname")];
        this.ra = NumericFunctions.toDouble(values[columns.get("RA_ICRS")]);
        this.dec = NumericFunctions.toDouble(values[columns.get("DE_ICRS")]);
        this.plx = NumericFunctions.toDouble(values[columns.get("Plx")]);
        this.pmra = NumericFunctions.toDouble(values[columns.get("pmRA")]);
        this.pmdec = NumericFunctions.toDouble(values[columns.get("pmDE")]);
        this.Gmag = NumericFunctions.toDouble(values[columns.get("Gmag")]);
        this.BPmag = NumericFunctions.toDouble(values[columns.get("BPmag")]);
        this.RPmag = NumericFunctions.toDouble(values[columns.get("RPmag")]);
        this.sdssId = values[columns.get("SDSS12")];
        this.u_mag = NumericFunctions.toDouble(values[columns.get("umag")]);
        this.g_mag = NumericFunctions.toDouble(values[columns.get("gmag")]);
        this.r_mag = NumericFunctions.toDouble(values[columns.get("rmag")]);
        this.i_mag = NumericFunctions.toDouble(values[columns.get("imag")]);
        this.z_mag = NumericFunctions.toDouble(values[columns.get("zmag")]);
        this.pwd = NumericFunctions.toDouble(values[columns.get("Pwd")]);
        this.teffH = NumericFunctions.toDouble(values[columns.get("TeffH")]);
        this.loggH = NumericFunctions.toDouble(values[columns.get("loggH")]);
        this.massH = NumericFunctions.toDouble(values[columns.get("MassH")]);
        this.teffHe = NumericFunctions.toDouble(values[columns.get("TeffHe")]);
        this.loggHe = NumericFunctions.toDouble(values[columns.get("loggHe")]);
        this.massHe = NumericFunctions.toDouble(values[columns.get("MassHe")]);
        this.teffH_err = NumericFunctions.toDouble(values[columns.get("e_TeffH")]);
        this.loggH_err = NumericFunctions.toDouble(values[columns.get("e_loggH")]);
        this.massH_err = NumericFunctions.toDouble(values[columns.get("e_MassH")]);
        this.teffHe_err = NumericFunctions.toDouble(values[columns.get("e_TeffHe")]);
        this.loggHe_err = NumericFunctions.toDouble(values[columns.get("e_loggHe")]);
        this.massHe_err = NumericFunctions.toDouble(values[columns.get("e_MassHe")]);
    }

    @Override
    public CatalogEntry copy() {
        return new GaiaWDCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("WD id", this.wdId, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("plx (mas)", NumericFunctions.roundTo4DecNZ(this.plx), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmra), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmdec), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("G (mag)", NumericFunctions.roundTo3DecNZ(this.Gmag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("BP (mag)", NumericFunctions.roundTo3DecNZ(this.BPmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("RP (mag)", NumericFunctions.roundTo3DecNZ(this.RPmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u (mag)", NumericFunctions.roundTo3DecNZ(this.u_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g (mag)", NumericFunctions.roundTo3DecNZ(this.g_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r (mag)", NumericFunctions.roundTo3DecNZ(this.r_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i (mag)", NumericFunctions.roundTo3DecNZ(this.i_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z (mag)", NumericFunctions.roundTo3DecNZ(this.z_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("teff H (K)", NumericFunctions.roundTo3DecNZ(this.teffH), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("teff H err", NumericFunctions.roundTo3DecNZ(this.teffH_err), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("teff He (K)", NumericFunctions.roundTo3DecNZ(this.teffHe), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("teff He err", NumericFunctions.roundTo3DecNZ(this.teffHe_err), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("logg H", NumericFunctions.roundTo3DecNZ(this.loggH), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("logg H err", NumericFunctions.roundTo3DecNZ(this.loggH_err), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("logg He", NumericFunctions.roundTo3DecNZ(this.loggHe), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("logg He err", NumericFunctions.roundTo3DecNZ(this.loggHe_err), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("mass H (Msun)", NumericFunctions.roundTo3DecNZ(this.massH), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("mass H err", NumericFunctions.roundTo3DecNZ(this.massH_err), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("mass He (Msun)", NumericFunctions.roundTo3DecNZ(this.massHe), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("mass He err", NumericFunctions.roundTo3DecNZ(this.massHe_err), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("SDSS id", this.sdssId, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("probability of being a WD", NumericFunctions.roundTo3DecNZ(this.pwd), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dist (1/plx)", NumericFunctions.roundTo3DecNZ(this.getParallacticDistance()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tpm (mas/yr)", NumericFunctions.roundTo3DecNZ(this.getTotalProperMotion()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("Absolute G (mag)", NumericFunctions.roundTo3DecNZ(this.getAbsoluteGmag()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("G-RP", NumericFunctions.roundTo3DecNZ(this.getG_RP()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("BP-RP", NumericFunctions.roundTo3DecNZ(this.getBP_RP()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("u-g", NumericFunctions.roundTo3DecNZ(this.get_u_g()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("g-r", NumericFunctions.roundTo3DecNZ(this.get_g_r()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("r-i", NumericFunctions.roundTo3DecNZ(this.get_r_i()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("i-z", NumericFunctions.roundTo3DecNZ(this.get_i_z()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (int)(this.sourceId ^ this.sourceId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GaiaWDCatalogEntry other = (GaiaWDCatalogEntry)obj;
        return this.sourceId == other.sourceId;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new GaiaWDCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.PURPLE.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        return ServiceHelper.createVizieRUrl(this.ra, this.dec, this.searchRadius / 3600.0, "J/MNRAS/508/3877/maincat", "RA_ICRS", "DE_ICRS");
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + this.wdId + "," + NumericFunctions.roundTo4Dec(this.plx) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + NumericFunctions.roundTo3Dec(this.Gmag) + "," + NumericFunctions.roundTo3Dec(this.BPmag) + "," + NumericFunctions.roundTo3Dec(this.RPmag) + "," + NumericFunctions.roundTo3Dec(this.u_mag) + "," + NumericFunctions.roundTo3Dec(this.g_mag) + "," + NumericFunctions.roundTo3Dec(this.r_mag) + "," + NumericFunctions.roundTo3Dec(this.i_mag) + "," + NumericFunctions.roundTo3Dec(this.z_mag) + "," + NumericFunctions.roundTo3Dec(this.teffH) + "," + NumericFunctions.roundTo3Dec(this.teffH_err) + "," + NumericFunctions.roundTo3Dec(this.teffHe) + "," + NumericFunctions.roundTo3Dec(this.teffHe_err) + "," + NumericFunctions.roundTo3Dec(this.loggH) + "," + NumericFunctions.roundTo3Dec(this.loggH_err) + "," + NumericFunctions.roundTo3Dec(this.loggHe) + "," + NumericFunctions.roundTo3Dec(this.loggHe_err) + "," + NumericFunctions.roundTo3Dec(this.massH) + "," + NumericFunctions.roundTo3Dec(this.massH_err) + "," + NumericFunctions.roundTo3Dec(this.massHe) + "," + NumericFunctions.roundTo3Dec(this.massHe_err) + "," + this.sdssId + "," + NumericFunctions.roundTo3Dec(this.pwd) + "," + NumericFunctions.roundTo3Dec(this.getParallacticDistance()) + "," + NumericFunctions.roundTo3Dec(this.getTotalProperMotion()) + "," + NumericFunctions.roundTo3Dec(this.getAbsoluteGmag()) + "," + NumericFunctions.roundTo3Dec(this.getG_RP()) + "," + NumericFunctions.roundTo3Dec(this.getBP_RP()) + "," + NumericFunctions.roundTo3Dec(this.get_u_g()) + "," + NumericFunctions.roundTo3Dec(this.get_g_r()) + "," + NumericFunctions.roundTo3Dec(this.get_r_i()) + "," + NumericFunctions.roundTo3Dec(this.get_i_z());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,WD id,plx (mas),pmra (mas/yr),pmdec (mas/yr),G (mag),BP (mag),RP (mag),u (mag),g (mag),r (mag),i (mag),z (mag),teff H (K),teff H err,teff He (K),teff He err,logg H,logg H err,logg He,logg He err,mass H (Msun),mass H err,mass He (Msun),mass He err,SDSS id,probability of being a WD,dist (1/plx),tpm (mas/yr),Absolute G (mag),G-RP,BP-RP,u-g,g-r,r-i,i-z";
        return columnTitles.split(",", -1);
    }

    @Override
    public void applyExtinctionCorrection(Map<String, Double> extinctionsByBand) {
        if (this.u_mag != 0.0) {
            this.u_mag -= extinctionsByBand.get("SDSS u").doubleValue();
        }
        if (this.g_mag != 0.0) {
            this.g_mag -= extinctionsByBand.get("SDSS g").doubleValue();
        }
        if (this.r_mag != 0.0) {
            this.r_mag -= extinctionsByBand.get("SDSS r").doubleValue();
        }
        if (this.i_mag != 0.0) {
            this.i_mag -= extinctionsByBand.get("SDSS i").doubleValue();
        }
        if (this.z_mag != 0.0) {
            this.z_mag -= extinctionsByBand.get("SDSS z").doubleValue();
        }
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.G, new NumberPair(this.Gmag, 0.0));
        bands.put(Band.BP, new NumberPair(this.BPmag, 0.0));
        bands.put(Band.RP, new NumberPair(this.RPmag, 0.0));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        this.toVega = toVega;
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.M_G, this.getAbsoluteGmag());
        colors.put(astro.tool.box.enumeration.Color.M_RP, this.getAbsoluteRPmag());
        colors.put(astro.tool.box.enumeration.Color.M_BP, this.getAbsoluteBPmag());
        colors.put(astro.tool.box.enumeration.Color.G_RP, this.getG_RP());
        colors.put(astro.tool.box.enumeration.Color.BP_RP, this.getBP_RP());
        colors.put(astro.tool.box.enumeration.Color.BP_G, this.getBP_G());
        colors.put(astro.tool.box.enumeration.Color.u_g, this.get_u_g());
        colors.put(astro.tool.box.enumeration.Color.g_r, this.get_g_r());
        colors.put(astro.tool.box.enumeration.Color.r_i, this.get_r_i());
        colors.put(astro.tool.box.enumeration.Color.i_z, this.get_i_z());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.Gmag != 0.0) {
            mags.append("G=").append(NumericFunctions.roundTo3DecNZ(this.Gmag)).append(" ");
        }
        if (this.BPmag != 0.0) {
            mags.append("BP=").append(NumericFunctions.roundTo3DecNZ(this.BPmag)).append(" ");
        }
        if (this.RPmag != 0.0) {
            mags.append("RP=").append(NumericFunctions.roundTo3DecNZ(this.RPmag)).append(" ");
        }
        if (this.u_mag != 0.0) {
            mags.append("u=").append(NumericFunctions.roundTo3DecNZ(this.u_mag)).append(" ");
        }
        if (this.g_mag != 0.0) {
            mags.append("g=").append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(" ");
        }
        if (this.r_mag != 0.0) {
            mags.append("r=").append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(" ");
        }
        if (this.i_mag != 0.0) {
            mags.append("i=").append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(" ");
        }
        if (this.z_mag != 0.0) {
            mags.append("z=").append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return this.plx;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return AstrometricFunctions.calculateParallacticDistance(this.plx);
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getAbsoluteRPmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.RPmag, this.plx);
    }

    public double getAbsoluteBPmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.BPmag, this.plx);
    }

    public double getAbsoluteGmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.Gmag, this.plx);
    }

    public double getG_RP() {
        if (this.Gmag == 0.0 || this.RPmag == 0.0) {
            return 0.0;
        }
        return this.Gmag - this.RPmag;
    }

    public double getBP_RP() {
        if (this.BPmag == 0.0 || this.RPmag == 0.0) {
            return 0.0;
        }
        return this.BPmag - this.RPmag;
    }

    public double getBP_G() {
        if (this.BPmag == 0.0 || this.Gmag == 0.0) {
            return 0.0;
        }
        return this.BPmag - this.Gmag;
    }

    public double get_u_g() {
        if (this.u_mag == 0.0 || this.g_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.u_mag - ABOffset.u.val - (this.g_mag - ABOffset.g.val);
        }
        return this.u_mag - this.g_mag;
    }

    public double get_g_r() {
        if (this.g_mag == 0.0 || this.r_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.g_mag - ABOffset.g.val - (this.r_mag - ABOffset.r.val);
        }
        return this.g_mag - this.r_mag;
    }

    public double get_r_i() {
        if (this.r_mag == 0.0 || this.i_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.r_mag - ABOffset.r.val - (this.i_mag - ABOffset.i.val);
        }
        return this.r_mag - this.i_mag;
    }

    public double get_i_z() {
        if (this.i_mag == 0.0 || this.z_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.i_mag - ABOffset.i.val - (this.z_mag - ABOffset.z.val);
        }
        return this.i_mag - this.z_mag;
    }

    public double getPwd() {
        return this.pwd;
    }

    public double getTeffH() {
        return this.teffH;
    }

    public double getLoggH() {
        return this.loggH;
    }

    public double getMassH() {
        return this.massH;
    }

    public double getTeffHe() {
        return this.teffHe;
    }

    public double getLoggHe() {
        return this.loggHe;
    }

    public double getMassHe() {
        return this.massHe;
    }

    public double getTeffH_err() {
        return this.teffH_err;
    }

    public double getLoggH_err() {
        return this.loggH_err;
    }

    public double getMassH_err() {
        return this.massH_err;
    }

    public double getTeffHe_err() {
        return this.teffHe_err;
    }

    public double getLoggHe_err() {
        return this.loggHe_err;
    }

    public double getMassHe_err() {
        return this.massHe_err;
    }
}

