/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.GenericCatalogEntry;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.util.Comparators;
import java.awt.Color;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MocaCatalogEntry
extends GenericCatalogEntry {
    public static final String CATALOG_NAME = "MOCA DB";
    private String sourceId;
    private double searchRadius;

    public MocaCatalogEntry() {
    }

    public MocaCatalogEntry(String[] titles, String[] values) {
        super(titles, values);
    }

    public List<CatalogEntry> findCatalogEntries() {
        String url = "jdbc:mysql://104.248.106.21:3306/mocadb";
        String username = "public";
        String password = "z@nUg_2h7_%?31y88";
        double ra = this.getRa();
        double dec = this.getDec();
        double radius = this.getSearchRadius() / 3600.0;
        String query = "SELECT * FROM summary_all_objects o LEFT JOIN moca_associations a ON o.moca_aid = a.moca_aid LEFT JOIN moca_membership_types m ON o.moca_mtid = m.moca_mtid WHERE ACOS(SIN(RADIANS(`dec`)) * SIN(RADIANS(%f)) + COS(RADIANS(`dec`)) * COS(RADIANS(%f)) * COS(RADIANS(ra - %f))) * 180 / PI() <= %f".formatted(dec, dec, ra, radius);
        ArrayList<CatalogEntry> catalogEntries = new ArrayList<CatalogEntry>();
        try (Connection connection = DriverManager.getConnection(url, username, password);
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                columnNames.add(metaData.getColumnName(i));
            }
            while (resultSet.next()) {
                ArrayList<String> columnValues = new ArrayList<String>();
                for (String columnName : columnNames) {
                    columnValues.add(resultSet.getString(columnName));
                }
                MocaCatalogEntry catalogEntry = new MocaCatalogEntry((String[])columnNames.toArray(String[]::new), (String[])columnValues.toArray(String[]::new));
                catalogEntry.setRa(resultSet.getDouble("ra"));
                catalogEntry.setDec(resultSet.getDouble("dec"));
                catalogEntry.setSourceId(resultSet.getString("moca_oid"));
                catalogEntries.add(catalogEntry);
            }
        }
        catch (SQLException e) {
            ToolboxHelper.writeErrorLog(e);
            ToolboxHelper.showWarnDialog(null, "%s is currently inaccessible!".formatted("MOCA database"));
        }
        return catalogEntries;
    }

    @Override
    public void loadCatalogElements() {
        super.loadCatalogElements();
        this.getCatalogElements().add(0, new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
    }

    @Override
    public String[] getColumnValues() {
        List columnValues = this.getCatalogElements().stream().map(CatalogElement::getValue).collect(Collectors.toList());
        return (String[])columnValues.toArray(String[]::new);
    }

    @Override
    public String[] getColumnTitles() {
        List columnNames = this.getCatalogElements().stream().map(CatalogElement::getName).collect(Collectors.toList());
        return (String[])columnNames.toArray(String[]::new);
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.getTargetRa(), this.getTargetDec()), new NumberPair(this.getRa(), this.getDec()), 3600.0);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.DARK_ORANGE.val;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }
}

