/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.ProperMotionCatalog;
import astro.tool.box.catalog.ProperMotionQuery;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.Constants;
import astro.tool.box.util.MiscUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NoirlabCatalogEntry
implements CatalogEntry,
ProperMotionQuery,
ProperMotionCatalog {
    public static final String CATALOG_NAME = "NSC DR2";
    private String sourceId;
    private double ra;
    private double ra_err;
    private double dec;
    private double dec_err;
    private double type;
    private double pmra;
    private double pmra_err;
    private double pmdec;
    private double pmdec_err;
    private LocalDateTime mean_mjd;
    private int ndet;
    private double delta_mjd;
    private double u_mag;
    private double u_err;
    private double g_mag;
    private double g_err;
    private double r_mag;
    private double r_err;
    private double i_mag;
    private double i_err;
    private double z_mag;
    private double z_err;
    private double y_mag;
    private double y_err;
    private double vr_mag;
    private double vr_err;
    private double glon;
    private double glat;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private double tpm;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public NoirlabCatalogEntry() {
    }

    public NoirlabCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        this.sourceId = values[columns.get("id")];
        this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
        this.ra_err = NumericFunctions.toDouble(values[columns.get("raerr")]);
        this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
        this.dec_err = NumericFunctions.toDouble(values[columns.get("decerr")]);
        this.pmra = NumericFunctions.toDouble(this.fixPmVal(values[columns.get("pmra")]));
        this.pmra_err = NumericFunctions.toDouble(this.fixPmVal(values[columns.get("pmraerr")]));
        this.pmdec = NumericFunctions.toDouble(this.fixPmVal(values[columns.get("pmdec")]));
        this.pmdec_err = NumericFunctions.toDouble(this.fixPmVal(values[columns.get("pmdecerr")]));
        this.type = NumericFunctions.toDouble(values[columns.get("class_star")]);
        this.mean_mjd = AstrometricFunctions.convertMJDToDateTime(new BigDecimal(values[columns.get("mjd")]));
        this.ndet = NumericFunctions.toInteger(values[columns.get("ndet")]);
        this.delta_mjd = NumericFunctions.toDouble(values[columns.get("deltamjd")]);
        this.u_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("umag")]));
        this.u_err = this.fixMagErr(NumericFunctions.toDouble(values[columns.get("uerr")]));
        this.g_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("gmag")]));
        this.g_err = this.fixMagErr(NumericFunctions.toDouble(values[columns.get("gerr")]));
        this.r_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("rmag")]));
        this.r_err = this.fixMagErr(NumericFunctions.toDouble(values[columns.get("rerr")]));
        this.i_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("imag")]));
        this.i_err = this.fixMagErr(NumericFunctions.toDouble(values[columns.get("ierr")]));
        this.z_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("zmag")]));
        this.z_err = this.fixMagErr(NumericFunctions.toDouble(values[columns.get("zerr")]));
        this.y_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("ymag")]));
        this.y_err = this.fixMagErr(NumericFunctions.toDouble(values[columns.get("yerr")]));
        this.vr_mag = this.fixMagVal(NumericFunctions.toDouble(values[columns.get("vrmag")]));
        this.vr_err = this.fixMagErr(NumericFunctions.toDouble(values[columns.get("vrerr")]));
        this.glon = NumericFunctions.toDouble(values[columns.get("glon")]);
        this.glat = NumericFunctions.toDouble(values[columns.get("glat")]);
    }

    private String fixPmVal(String pm) {
        return "NaN".equals(pm) ? "0" : pm;
    }

    private double fixMagVal(double mag) {
        return mag > 99.9 ? 0.0 : mag;
    }

    private double fixMagErr(double err) {
        return err > 9.9 ? 0.0 : err;
    }

    @Override
    public CatalogEntry copy() {
        return new NoirlabCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("ra err (arcsec)", NumericFunctions.roundTo7DecNZ(this.ra_err), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec err (arcsec)", NumericFunctions.roundTo7DecNZ(this.dec_err), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmra), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra err", NumericFunctions.roundTo3DecNZ(this.pmra_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmra, this.pmra_err)));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmdec), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmdec err", NumericFunctions.roundTo3DecNZ(this.pmdec_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmdec, this.pmdec_err)));
        this.catalogElements.add(new CatalogElement("Galaxy-Star (0-1)", NumericFunctions.roundTo2DecNZ(this.type), Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("mean mjd", this.mean_mjd.format(Constants.DATE_TIME_FORMATTER), Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("detections", String.valueOf(this.ndet), Alignment.RIGHT, Comparators.getIntegerComparator()));
        this.catalogElements.add(new CatalogElement("delta mjd", NumericFunctions.roundTo3DecNZ(this.delta_mjd), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u (mag)", NumericFunctions.roundTo3DecNZ(this.u_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u err", NumericFunctions.roundTo3DecNZ(this.u_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g (mag)", NumericFunctions.roundTo3DecNZ(this.g_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g err", NumericFunctions.roundTo3DecNZ(this.g_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r (mag)", NumericFunctions.roundTo3DecNZ(this.r_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r err", NumericFunctions.roundTo3DecNZ(this.r_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i (mag)", NumericFunctions.roundTo3DecNZ(this.i_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i err", NumericFunctions.roundTo3DecNZ(this.i_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z (mag)", NumericFunctions.roundTo3DecNZ(this.z_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z err", NumericFunctions.roundTo3DecNZ(this.z_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Y (mag)", NumericFunctions.roundTo3DecNZ(this.y_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Y err", NumericFunctions.roundTo3DecNZ(this.y_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("VR (mag)", NumericFunctions.roundTo3DecNZ(this.vr_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("VR err", NumericFunctions.roundTo3DecNZ(this.vr_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u-g", NumericFunctions.roundTo3DecNZ(this.get_u_g()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("g-r", NumericFunctions.roundTo3DecNZ(this.get_g_r()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("r-i", NumericFunctions.roundTo3DecNZ(this.get_r_i()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("i-z", NumericFunctions.roundTo3DecNZ(this.get_i_z()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("z-Y", NumericFunctions.roundTo3DecNZ(this.get_z_y()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tpm (mas/yr)", NumericFunctions.roundTo3DecNZ(this.getTotalProperMotion()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this.sourceId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NoirlabCatalogEntry other = (NoirlabCatalogEntry)obj;
        return Objects.equals(this.sourceId, other.sourceId);
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new NoirlabCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.NAVY.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createCatalogQuery());
    }

    @Override
    public String getMotionQueryUrl() {
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createProperMotionQuery());
    }

    private String createCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT id,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       raerr,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       decerr,");
        MiscUtils.addRow(query, "       pmra,");
        MiscUtils.addRow(query, "       pmraerr,");
        MiscUtils.addRow(query, "       pmdec,");
        MiscUtils.addRow(query, "       pmdecerr,");
        MiscUtils.addRow(query, "       class_star,");
        MiscUtils.addRow(query, "       mjd,");
        MiscUtils.addRow(query, "       ndet,");
        MiscUtils.addRow(query, "       deltamjd,");
        MiscUtils.addRow(query, "       umag,");
        MiscUtils.addRow(query, "       uerr,");
        MiscUtils.addRow(query, "       gmag,");
        MiscUtils.addRow(query, "       gerr,");
        MiscUtils.addRow(query, "       rmag,");
        MiscUtils.addRow(query, "       rerr,");
        MiscUtils.addRow(query, "       imag,");
        MiscUtils.addRow(query, "       ierr,");
        MiscUtils.addRow(query, "       zmag,");
        MiscUtils.addRow(query, "       zerr,");
        MiscUtils.addRow(query, "       ymag,");
        MiscUtils.addRow(query, "       yerr,");
        MiscUtils.addRow(query, "       vrmag,");
        MiscUtils.addRow(query, "       vrerr,");
        MiscUtils.addRow(query, "       glat,");
        MiscUtils.addRow(query, "       glon");
        MiscUtils.addRow(query, "FROM   nsc_dr2.object");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    private String createProperMotionQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, this.createCatalogQuery());
        MiscUtils.addRow(query, "AND    class_star > 0.5");
        MiscUtils.addRow(query, "AND    ndet > 2");
        MiscUtils.addRow(query, "AND    deltamjd > 180");
        MiscUtils.addRow(query, "AND    SQRT(pmra * pmra + pmdec * pmdec) >= " + this.tpm);
        return query.toString();
    }

    @Override
    public void setTpm(double tpm) {
        this.tpm = tpm;
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.ra_err) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo7Dec(this.dec_err) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmra_err) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + NumericFunctions.roundTo3Dec(this.pmdec_err) + "," + NumericFunctions.roundTo2DecNZ(this.type) + "," + this.mean_mjd.format(Constants.DATE_TIME_FORMATTER) + "," + this.ndet + "," + NumericFunctions.roundTo3Dec(this.delta_mjd) + "," + NumericFunctions.roundTo3Dec(this.u_mag) + "," + NumericFunctions.roundTo3Dec(this.u_err) + "," + NumericFunctions.roundTo3Dec(this.g_mag) + "," + NumericFunctions.roundTo3Dec(this.g_err) + "," + NumericFunctions.roundTo3Dec(this.r_mag) + "," + NumericFunctions.roundTo3Dec(this.r_err) + "," + NumericFunctions.roundTo3Dec(this.i_mag) + "," + NumericFunctions.roundTo3Dec(this.i_err) + "," + NumericFunctions.roundTo3Dec(this.z_mag) + "," + NumericFunctions.roundTo3Dec(this.z_err) + "," + NumericFunctions.roundTo3Dec(this.y_mag) + "," + NumericFunctions.roundTo3Dec(this.y_err) + "," + NumericFunctions.roundTo3Dec(this.vr_mag) + "," + NumericFunctions.roundTo3Dec(this.vr_err) + "," + NumericFunctions.roundTo3Dec(this.get_u_g()) + "," + NumericFunctions.roundTo3Dec(this.get_g_r()) + "," + NumericFunctions.roundTo3Dec(this.get_r_i()) + "," + NumericFunctions.roundTo3Dec(this.get_i_z()) + "," + NumericFunctions.roundTo3Dec(this.get_z_y()) + "," + NumericFunctions.roundTo3Dec(this.getTotalProperMotion());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,ra err (arcsec),dec,dec err (arcsec),pmra (mas/yr),pmra err,pmdec (mas/yr),pmdec err,Galaxy-Star (0-1),mean mjd,detections,delta mjd,u (mag),u err,g (mag),g err,r (mag),r err,i (mag),i err,z (mag),z err,Y (mag),Y err,VR (mag),VR err,u-g,g-r,r-i,i-z,z-Y,tpm (mas/yr)";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.g, new NumberPair(this.g_mag, this.g_err));
        bands.put(Band.r, new NumberPair(this.r_mag, this.r_err));
        bands.put(Band.i, new NumberPair(this.i_mag, this.i_err));
        bands.put(Band.z, new NumberPair(this.z_mag, this.z_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.g_r_NSC, this.get_g_r());
        colors.put(astro.tool.box.enumeration.Color.r_i_NSC, this.get_r_i());
        colors.put(astro.tool.box.enumeration.Color.i_z_NSC, this.get_i_z());
        colors.put(astro.tool.box.enumeration.Color.z_Y_NSC, this.get_z_y());
        colors.put(astro.tool.box.enumeration.Color.e_g_r_NSC, this.get_g_r() - this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.e_r_i_NSC, this.get_r_i() - this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.e_i_z_NSC, this.get_i_z() - this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.e_z_Y_NSC, this.get_z_y() - this.get_z_y_err());
        colors.put(astro.tool.box.enumeration.Color.E_g_r_NSC, this.get_g_r() + this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.E_r_i_NSC, this.get_r_i() + this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.E_i_z_NSC, this.get_i_z() + this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.E_z_Y_NSC, this.get_z_y() + this.get_z_y_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.u_mag != 0.0) {
            mags.append("u=").append(NumericFunctions.roundTo3DecNZ(this.u_mag)).append(" ");
        }
        if (this.g_mag != 0.0) {
            mags.append("g=").append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(" ");
        }
        if (this.r_mag != 0.0) {
            mags.append("r=").append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(" ");
        }
        if (this.i_mag != 0.0) {
            mags.append("i=").append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(" ");
        }
        if (this.z_mag != 0.0) {
            mags.append("z=").append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(" ");
        }
        if (this.y_mag != 0.0) {
            mags.append("y=").append(NumericFunctions.roundTo3DecNZ(this.y_mag)).append(" ");
        }
        if (this.vr_mag != 0.0) {
            mags.append("vr=").append(NumericFunctions.roundTo3DecNZ(this.vr_mag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.u_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.u_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.u_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.g_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.g_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.r_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.r_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.i_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.i_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.z_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.z_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.y_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.y_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.y_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getPmraErr() {
        return this.pmra_err;
    }

    @Override
    public double getPmdecErr() {
        return this.pmdec_err;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getMeanEpoch() {
        return AstrometricFunctions.convertDateToYear(this.mean_mjd);
    }

    public int getNdet() {
        return this.ndet;
    }

    public double getDelta_mjd() {
        return this.delta_mjd;
    }

    public double getGlon() {
        return this.glon;
    }

    public double getGlat() {
        return this.glat;
    }

    public double get_u_g() {
        if (this.u_mag == 0.0 || this.g_mag == 0.0) {
            return 0.0;
        }
        return this.u_mag - this.g_mag;
    }

    public double get_g_r() {
        if (this.g_mag == 0.0 || this.r_mag == 0.0) {
            return 0.0;
        }
        return this.g_mag - this.r_mag;
    }

    public double get_r_i() {
        if (this.r_mag == 0.0 || this.i_mag == 0.0) {
            return 0.0;
        }
        return this.r_mag - this.i_mag;
    }

    public double get_i_z() {
        if (this.i_mag == 0.0 || this.z_mag == 0.0) {
            return 0.0;
        }
        return this.i_mag - this.z_mag;
    }

    public double get_z_y() {
        if (this.z_mag == 0.0 || this.y_mag == 0.0) {
            return 0.0;
        }
        return this.z_mag - this.y_mag;
    }

    public double get_u_g_err() {
        if (this.u_err == 0.0 || this.g_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.u_err, this.g_err);
    }

    public double get_g_r_err() {
        if (this.g_err == 0.0 || this.r_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.g_err, this.r_err);
    }

    public double get_r_i_err() {
        if (this.r_err == 0.0 || this.i_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.r_err, this.i_err);
    }

    public double get_i_z_err() {
        if (this.i_err == 0.0 || this.z_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.i_err, this.z_err);
    }

    public double get_z_y_err() {
        if (this.z_err == 0.0 || this.y_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.z_err, this.y_err);
    }

    public double get_g_mag() {
        return this.g_mag;
    }

    public double get_r_mag() {
        return this.r_mag;
    }

    public double get_i_mag() {
        return this.i_mag;
    }

    public double get_z_mag() {
        return this.z_mag;
    }

    public double get_y_mag() {
        return this.y_mag;
    }

    public double get_g_err() {
        return this.g_err;
    }

    public double get_r_err() {
        return this.r_err;
    }

    public double get_i_err() {
        return this.i_err;
    }

    public double get_z_err() {
        return this.z_err;
    }

    public double get_y_err() {
        return this.y_err;
    }
}

