/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.Constants;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PanStarrsCatalogEntry
implements CatalogEntry {
    public static final String CATALOG_NAME = "Pan-STARRS";
    private long objID;
    private String objName;
    private int qualityFlag;
    private double raMean;
    private double decMean;
    private double raMeanErr;
    private double decMeanErr;
    private LocalDateTime epochMean;
    private int nDetections;
    private double gMeanPSFMag;
    private double gMeanPSFMagErr;
    private double rMeanPSFMag;
    private double rMeanPSFMagErr;
    private double iMeanPSFMag;
    private double iMeanPSFMagErr;
    private double zMeanPSFMag;
    private double zMeanPSFMagErr;
    private double yMeanPSFMag;
    private double yMeanPSFMagErr;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;
    private static final Map<Integer, String> QUALITY_FLAGS = new HashMap<Integer, String>();

    public PanStarrsCatalogEntry() {
    }

    public PanStarrsCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals("-999.0")) continue;
            values[i] = "0";
        }
        this.objName = values[columns.get("objName")];
        this.objID = NumericFunctions.toLong(values[columns.get("objID")]);
        this.qualityFlag = NumericFunctions.toInteger(values[columns.get("qualityFlag")]);
        this.raMean = NumericFunctions.toDouble(values[columns.get("raMean")]);
        this.decMean = NumericFunctions.toDouble(values[columns.get("decMean")]);
        this.raMeanErr = NumericFunctions.toDouble(values[columns.get("raMeanErr")]);
        this.decMeanErr = NumericFunctions.toDouble(values[columns.get("decMeanErr")]);
        this.epochMean = AstrometricFunctions.convertMJDToDateTime(new BigDecimal(values[columns.get("epochMean")]));
        this.nDetections = NumericFunctions.toInteger(values[columns.get("nDetections")]);
        this.gMeanPSFMag = NumericFunctions.toDouble(values[columns.get("gMeanPSFMag")]);
        this.gMeanPSFMagErr = NumericFunctions.toDouble(values[columns.get("gMeanPSFMagErr")]);
        this.rMeanPSFMag = NumericFunctions.toDouble(values[columns.get("rMeanPSFMag")]);
        this.rMeanPSFMagErr = NumericFunctions.toDouble(values[columns.get("rMeanPSFMagErr")]);
        this.iMeanPSFMag = NumericFunctions.toDouble(values[columns.get("iMeanPSFMag")]);
        this.iMeanPSFMagErr = NumericFunctions.toDouble(values[columns.get("iMeanPSFMagErr")]);
        this.zMeanPSFMag = NumericFunctions.toDouble(values[columns.get("zMeanPSFMag")]);
        this.zMeanPSFMagErr = NumericFunctions.toDouble(values[columns.get("zMeanPSFMagErr")]);
        this.yMeanPSFMag = NumericFunctions.toDouble(values[columns.get("yMeanPSFMag")]);
        this.yMeanPSFMagErr = NumericFunctions.toDouble(values[columns.get("yMeanPSFMagErr")]);
    }

    @Override
    public CatalogEntry copy() {
        return new PanStarrsCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.objID), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("object name", this.objName, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("quality flag sum", String.valueOf(this.qualityFlag), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), this.createToolTipQualityFlag()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.raMean), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("ra err (arcsec)", NumericFunctions.roundTo4DecNZ(this.raMeanErr), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.decMean), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec err (arcsec)", NumericFunctions.roundTo4DecNZ(this.decMeanErr), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("mean observ. time", this.epochMean.format(Constants.DATE_TIME_FORMATTER), Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("detections", String.valueOf(this.nDetections), Alignment.RIGHT, Comparators.getIntegerComparator()));
        this.catalogElements.add(new CatalogElement("g (mag)", NumericFunctions.roundTo3DecNZ(this.gMeanPSFMag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g err", NumericFunctions.roundTo3DecNZ(this.gMeanPSFMagErr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r (mag)", NumericFunctions.roundTo3DecNZ(this.rMeanPSFMag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r err", NumericFunctions.roundTo3DecNZ(this.rMeanPSFMagErr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i (mag)", NumericFunctions.roundTo3DecNZ(this.iMeanPSFMag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i err", NumericFunctions.roundTo3DecNZ(this.iMeanPSFMagErr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z (mag)", NumericFunctions.roundTo3DecNZ(this.zMeanPSFMag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z err", NumericFunctions.roundTo3DecNZ(this.zMeanPSFMagErr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("y (mag)", NumericFunctions.roundTo3DecNZ(this.yMeanPSFMag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("y err", NumericFunctions.roundTo3DecNZ(this.yMeanPSFMagErr), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g-r", NumericFunctions.roundTo3DecNZ(this.get_g_r()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("r-i", NumericFunctions.roundTo3DecNZ(this.get_r_i()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("i-z", NumericFunctions.roundTo3DecNZ(this.get_i_z()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("z-y", NumericFunctions.roundTo3DecNZ(this.get_z_y()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public String createToolTipQualityFlag() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Quality flag details:</b>");
        PhotometricFunctions.getFlagLabels(this.qualityFlag, QUALITY_FLAGS).forEach(flag -> toolTip.append("<br/>").append(flag.getS1()).append(" = ").append(flag.getS2()));
        return toolTip.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(this.objID ^ this.objID >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PanStarrsCatalogEntry other = (PanStarrsCatalogEntry)obj;
        return this.objID == other.objID;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new PanStarrsCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.BROWN.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        return ServiceHelper.createPanStarrsUrl(this.raMean, this.decMean, this.searchRadius / 3600.0);
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.objID + "," + this.objName + "," + this.qualityFlag + "," + NumericFunctions.roundTo7Dec(this.raMean) + "," + NumericFunctions.roundTo4Dec(this.raMeanErr) + "," + NumericFunctions.roundTo7Dec(this.decMean) + "," + NumericFunctions.roundTo4Dec(this.decMeanErr) + "," + this.epochMean.format(Constants.DATE_TIME_FORMATTER) + "," + this.nDetections + "," + NumericFunctions.roundTo3Dec(this.gMeanPSFMag) + "," + NumericFunctions.roundTo3Dec(this.gMeanPSFMagErr) + "," + NumericFunctions.roundTo3Dec(this.rMeanPSFMag) + "," + NumericFunctions.roundTo3Dec(this.rMeanPSFMagErr) + "," + NumericFunctions.roundTo3Dec(this.iMeanPSFMag) + "," + NumericFunctions.roundTo3Dec(this.iMeanPSFMagErr) + "," + NumericFunctions.roundTo3Dec(this.zMeanPSFMag) + "," + NumericFunctions.roundTo3Dec(this.zMeanPSFMagErr) + "," + NumericFunctions.roundTo3Dec(this.yMeanPSFMag) + "," + NumericFunctions.roundTo3Dec(this.yMeanPSFMagErr) + "," + NumericFunctions.roundTo3Dec(this.get_g_r()) + "," + NumericFunctions.roundTo3Dec(this.get_r_i()) + "," + NumericFunctions.roundTo3Dec(this.get_i_z()) + "," + NumericFunctions.roundTo3Dec(this.get_z_y());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,object name,quality flag,ra,ra err (arcsec),dec,dec err (arcsec),mean observ. time,detections,g (mag),g err,r (mag),r err,i (mag),i err,z (mag),z err,y (mag),y err,g-r,r-i,i-z,z-y";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.g, new NumberPair(this.gMeanPSFMag, this.gMeanPSFMagErr));
        bands.put(Band.r, new NumberPair(this.rMeanPSFMag, this.rMeanPSFMagErr));
        bands.put(Band.i, new NumberPair(this.iMeanPSFMag, this.iMeanPSFMagErr));
        bands.put(Band.z, new NumberPair(this.zMeanPSFMag, this.zMeanPSFMagErr));
        bands.put(Band.y, new NumberPair(this.yMeanPSFMag, this.yMeanPSFMagErr));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.g_r_PS1, this.get_g_r());
        colors.put(astro.tool.box.enumeration.Color.r_i_PS1, this.get_r_i());
        colors.put(astro.tool.box.enumeration.Color.i_z_PS1, this.get_i_z());
        colors.put(astro.tool.box.enumeration.Color.i_y_PS1, this.get_i_y());
        colors.put(astro.tool.box.enumeration.Color.z_y_PS1, this.get_z_y());
        colors.put(astro.tool.box.enumeration.Color.e_g_r_PS1, this.get_g_r() - this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.e_r_i_PS1, this.get_r_i() - this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.e_i_z_PS1, this.get_i_z() - this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.e_i_y_PS1, this.get_i_y() - this.get_i_y_err());
        colors.put(astro.tool.box.enumeration.Color.e_z_y_PS1, this.get_z_y() - this.get_z_y_err());
        colors.put(astro.tool.box.enumeration.Color.E_g_r_PS1, this.get_g_r() + this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.E_r_i_PS1, this.get_r_i() + this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.E_i_z_PS1, this.get_i_z() + this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.E_i_y_PS1, this.get_i_y() + this.get_i_y_err());
        colors.put(astro.tool.box.enumeration.Color.E_z_y_PS1, this.get_z_y() + this.get_z_y_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.gMeanPSFMag != 0.0) {
            mags.append("g=").append(NumericFunctions.roundTo3DecNZ(this.gMeanPSFMag)).append(" ");
        }
        if (this.rMeanPSFMag != 0.0) {
            mags.append("r=").append(NumericFunctions.roundTo3DecNZ(this.rMeanPSFMag)).append(" ");
        }
        if (this.iMeanPSFMag != 0.0) {
            mags.append("i=").append(NumericFunctions.roundTo3DecNZ(this.iMeanPSFMag)).append(" ");
        }
        if (this.zMeanPSFMag != 0.0) {
            mags.append("z=").append(NumericFunctions.roundTo3DecNZ(this.zMeanPSFMag)).append(" ");
        }
        if (this.yMeanPSFMag != 0.0) {
            mags.append("y=").append(NumericFunctions.roundTo3DecNZ(this.yMeanPSFMag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.gMeanPSFMag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.gMeanPSFMag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.gMeanPSFMagErr)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.rMeanPSFMag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.rMeanPSFMag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.rMeanPSFMagErr)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.iMeanPSFMag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.iMeanPSFMag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.iMeanPSFMagErr)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.zMeanPSFMag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.zMeanPSFMag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.zMeanPSFMagErr)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.yMeanPSFMag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.yMeanPSFMag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.yMeanPSFMagErr)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.objID);
    }

    @Override
    public double getRa() {
        return this.raMean;
    }

    @Override
    public void setRa(double ra) {
        this.raMean = ra;
    }

    @Override
    public double getDec() {
        return this.decMean;
    }

    @Override
    public void setDec(double dec) {
        this.decMean = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return 0.0;
    }

    @Override
    public double getPmdec() {
        return 0.0;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.raMean, this.decMean), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return 0.0;
    }

    public LocalDateTime getObsDate() {
        return this.epochMean;
    }

    public double get_g_r() {
        if (this.gMeanPSFMag == 0.0 || this.rMeanPSFMag == 0.0) {
            return 0.0;
        }
        return this.gMeanPSFMag - this.rMeanPSFMag;
    }

    public double get_r_i() {
        if (this.rMeanPSFMag == 0.0 || this.iMeanPSFMag == 0.0) {
            return 0.0;
        }
        return this.rMeanPSFMag - this.iMeanPSFMag;
    }

    public double get_i_z() {
        if (this.iMeanPSFMag == 0.0 || this.zMeanPSFMag == 0.0) {
            return 0.0;
        }
        return this.iMeanPSFMag - this.zMeanPSFMag;
    }

    public double get_i_y() {
        if (this.iMeanPSFMag == 0.0 || this.yMeanPSFMag == 0.0) {
            return 0.0;
        }
        return this.iMeanPSFMag - this.yMeanPSFMag;
    }

    public double get_z_y() {
        if (this.zMeanPSFMag == 0.0 || this.yMeanPSFMag == 0.0) {
            return 0.0;
        }
        return this.zMeanPSFMag - this.yMeanPSFMag;
    }

    public double get_g_r_err() {
        if (this.gMeanPSFMagErr == 0.0 || this.rMeanPSFMagErr == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.gMeanPSFMagErr, this.rMeanPSFMagErr);
    }

    public double get_r_i_err() {
        if (this.rMeanPSFMagErr == 0.0 || this.iMeanPSFMagErr == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.rMeanPSFMagErr, this.iMeanPSFMagErr);
    }

    public double get_i_z_err() {
        if (this.iMeanPSFMagErr == 0.0 || this.zMeanPSFMagErr == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.iMeanPSFMag, this.zMeanPSFMag);
    }

    public double get_i_y_err() {
        if (this.iMeanPSFMagErr == 0.0 || this.yMeanPSFMagErr == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.iMeanPSFMagErr, this.yMeanPSFMagErr);
    }

    public double get_z_y_err() {
        if (this.zMeanPSFMagErr == 0.0 || this.yMeanPSFMagErr == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.zMeanPSFMagErr, this.yMeanPSFMagErr);
    }

    public double get_g_mag() {
        return this.gMeanPSFMag;
    }

    public double get_r_mag() {
        return this.rMeanPSFMag;
    }

    public double get_i_mag() {
        return this.iMeanPSFMag;
    }

    public double get_z_mag() {
        return this.zMeanPSFMag;
    }

    public double get_y_mag() {
        return this.yMeanPSFMag;
    }

    public double get_g_err() {
        return this.gMeanPSFMagErr;
    }

    public double get_r_err() {
        return this.rMeanPSFMagErr;
    }

    public double get_i_err() {
        return this.iMeanPSFMagErr;
    }

    public double get_z_err() {
        return this.zMeanPSFMagErr;
    }

    public double get_y_err() {
        return this.yMeanPSFMagErr;
    }

    static {
        QUALITY_FLAGS.put(1, "extended in Pan-STARRS data");
        QUALITY_FLAGS.put(2, "extended in external data (2MASS)");
        QUALITY_FLAGS.put(4, "good-quality measurement in Pan-STARRS data");
        QUALITY_FLAGS.put(8, "good-quality measurement in external data (2MASS)");
        QUALITY_FLAGS.put(16, "good-quality object in the stack");
        QUALITY_FLAGS.put(32, "the primary stack measurements are the best");
        QUALITY_FLAGS.put(64, "suspect object in the stack (no more than 1 good measurement)");
        QUALITY_FLAGS.put(128, "poor-quality stack object (no more than 1 good or suspect measurement)");
    }
}

