/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.ABOffset;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.Constants;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SdssCatalogEntry
implements CatalogEntry,
Extinction {
    public static final String CATALOG_NAME = "SDSS DR17";
    private long objID;
    private double ra;
    private double dec;
    private double raErr;
    private double decErr;
    private int type;
    private int clean;
    private LocalDateTime mjd;
    private BigInteger specObjID;
    private double u_mag;
    private double u_err;
    private double g_mag;
    private double g_err;
    private double r_mag;
    private double r_err;
    private double i_mag;
    private double i_err;
    private double z_mag;
    private double z_err;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private boolean toVega;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;
    private static final Map<Integer, String> OBJECT_TYPES = new HashMap<Integer, String>();

    public SdssCatalogEntry() {
    }

    public SdssCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        this.objID = NumericFunctions.toLong(values[columns.get("objid")]);
        this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
        this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
        this.raErr = NumericFunctions.toDouble(values[columns.get("raErr")]);
        this.decErr = NumericFunctions.toDouble(values[columns.get("decErr")]);
        this.type = NumericFunctions.toInteger(values[columns.get("type")]);
        this.clean = NumericFunctions.toInteger(values[columns.get("clean")]);
        this.mjd = AstrometricFunctions.convertMJDToDateTime(new BigDecimal(values[columns.get("mjd")]));
        this.specObjID = new BigInteger(values[columns.get("specObjID")]);
        this.u_mag = NumericFunctions.toDouble(values[columns.get("u")]);
        this.u_err = NumericFunctions.toDouble(values[columns.get("Err_u")]);
        this.g_mag = NumericFunctions.toDouble(values[columns.get("g")]);
        this.g_err = NumericFunctions.toDouble(values[columns.get("Err_g")]);
        this.r_mag = NumericFunctions.toDouble(values[columns.get("r")]);
        this.r_err = NumericFunctions.toDouble(values[columns.get("Err_r")]);
        this.i_mag = NumericFunctions.toDouble(values[columns.get("i")]);
        this.i_err = NumericFunctions.toDouble(values[columns.get("Err_i")]);
        this.z_mag = NumericFunctions.toDouble(values[columns.get("z")]);
        this.z_err = NumericFunctions.toDouble(values[columns.get("Err_z")]);
    }

    @Override
    public CatalogEntry copy() {
        return new SdssCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.objID), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("ra err (arcsec)", NumericFunctions.roundTo7DecNZ(this.raErr), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec err (arcsec)", NumericFunctions.roundTo7DecNZ(this.decErr), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("object type", OBJECT_TYPES.get(this.type), Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("photometry flag", this.getSdssPhotometryFlag(this.clean), Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("observation date", this.mjd.format(Constants.DATE_FORMATTER), Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("spectrum pointer", String.valueOf(this.specObjID), Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("u (mag)", NumericFunctions.roundTo3DecNZ(this.u_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u err", NumericFunctions.roundTo3DecNZ(this.u_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g (mag)", NumericFunctions.roundTo3DecNZ(this.g_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g err", NumericFunctions.roundTo3DecNZ(this.g_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r (mag)", NumericFunctions.roundTo3DecNZ(this.r_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r err", NumericFunctions.roundTo3DecNZ(this.r_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i (mag)", NumericFunctions.roundTo3DecNZ(this.i_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i err", NumericFunctions.roundTo3DecNZ(this.i_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z (mag)", NumericFunctions.roundTo3DecNZ(this.z_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z err", NumericFunctions.roundTo3DecNZ(this.z_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u-g", NumericFunctions.roundTo3DecNZ(this.get_u_g()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("g-r", NumericFunctions.roundTo3DecNZ(this.get_g_r()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("r-i", NumericFunctions.roundTo3DecNZ(this.get_r_i()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("i-z", NumericFunctions.roundTo3DecNZ(this.get_i_z()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (int)(this.objID ^ this.objID >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SdssCatalogEntry other = (SdssCatalogEntry)obj;
        return this.objID == other.objID;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new SdssCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.STEEL.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        return ServiceHelper.createSdssUrl(this.ra, this.dec, this.searchRadius / 60.0);
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.objID + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.raErr) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo7Dec(this.decErr) + "," + OBJECT_TYPES.get(this.type) + "," + this.getSdssPhotometryFlag(this.clean) + "," + this.mjd.format(Constants.DATE_FORMATTER) + "," + String.valueOf(this.specObjID) + "," + NumericFunctions.roundTo3Dec(this.u_mag) + "," + NumericFunctions.roundTo3Dec(this.u_err) + "," + NumericFunctions.roundTo3Dec(this.g_mag) + "," + NumericFunctions.roundTo3Dec(this.g_err) + "," + NumericFunctions.roundTo3Dec(this.r_mag) + "," + NumericFunctions.roundTo3Dec(this.r_err) + "," + NumericFunctions.roundTo3Dec(this.i_mag) + "," + NumericFunctions.roundTo3Dec(this.i_err) + "," + NumericFunctions.roundTo3Dec(this.z_mag) + "," + NumericFunctions.roundTo3Dec(this.z_err) + "," + NumericFunctions.roundTo3Dec(this.get_u_g()) + "," + NumericFunctions.roundTo3Dec(this.get_g_r()) + "," + NumericFunctions.roundTo3Dec(this.get_r_i()) + "," + NumericFunctions.roundTo3Dec(this.get_i_z());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,ra err (arcsec),dec,dec err (arcsec),object type,photometry flag,observation date,spectrum pointer,u (mag),u err,g (mag),g err,r (mag),r err,i (mag),i err,z (mag),z err,u-g,g-r,r-i,i-z";
        return columnTitles.split(",", -1);
    }

    @Override
    public void applyExtinctionCorrection(Map<String, Double> extinctionsByBand) {
        if (this.u_mag != 0.0) {
            this.u_mag -= extinctionsByBand.get("SDSS u").doubleValue();
        }
        if (this.g_mag != 0.0) {
            this.g_mag -= extinctionsByBand.get("SDSS g").doubleValue();
        }
        if (this.r_mag != 0.0) {
            this.r_mag -= extinctionsByBand.get("SDSS r").doubleValue();
        }
        if (this.i_mag != 0.0) {
            this.i_mag -= extinctionsByBand.get("SDSS i").doubleValue();
        }
        if (this.z_mag != 0.0) {
            this.z_mag -= extinctionsByBand.get("SDSS z").doubleValue();
        }
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.g, new NumberPair(this.g_mag, this.g_err));
        bands.put(Band.r, new NumberPair(this.r_mag, this.r_err));
        bands.put(Band.i, new NumberPair(this.i_mag, this.i_err));
        bands.put(Band.z, new NumberPair(this.z_mag, this.z_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        this.toVega = toVega;
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.u_g, this.get_u_g());
        colors.put(astro.tool.box.enumeration.Color.g_r, this.get_g_r());
        colors.put(astro.tool.box.enumeration.Color.r_i, this.get_r_i());
        colors.put(astro.tool.box.enumeration.Color.i_z, this.get_i_z());
        colors.put(astro.tool.box.enumeration.Color.e_u_g, this.get_u_g() - this.get_u_g_err());
        colors.put(astro.tool.box.enumeration.Color.e_g_r, this.get_g_r() - this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.e_r_i, this.get_r_i() - this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.e_i_z, this.get_i_z() - this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.E_u_g, this.get_u_g() + this.get_u_g_err());
        colors.put(astro.tool.box.enumeration.Color.E_g_r, this.get_g_r() + this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.E_r_i, this.get_r_i() + this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.E_i_z, this.get_i_z() + this.get_i_z_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.u_mag != 0.0) {
            mags.append("u=").append(NumericFunctions.roundTo3DecNZ(this.u_mag)).append(" ");
        }
        if (this.g_mag != 0.0) {
            mags.append("g=").append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(" ");
        }
        if (this.r_mag != 0.0) {
            mags.append("r=").append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(" ");
        }
        if (this.i_mag != 0.0) {
            mags.append("i=").append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(" ");
        }
        if (this.z_mag != 0.0) {
            mags.append("z=").append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.u_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.u_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.u_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.g_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.g_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.r_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.r_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.i_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.i_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.z_mag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.z_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.objID);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return 0.0;
    }

    @Override
    public double getPmdec() {
        return 0.0;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return 0.0;
    }

    public String getSdssPhotometryFlag(int flag) {
        return flag == 1 ? "clean" : "unclean";
    }

    public LocalDateTime getObsDate() {
        return this.mjd;
    }

    public BigInteger getSpecObjID() {
        return this.specObjID;
    }

    public double get_u_g() {
        if (this.u_mag == 0.0 || this.g_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.u_mag - ABOffset.u.val - (this.g_mag - ABOffset.g.val);
        }
        return this.u_mag - this.g_mag;
    }

    public double get_g_r() {
        if (this.g_mag == 0.0 || this.r_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.g_mag - ABOffset.g.val - (this.r_mag - ABOffset.r.val);
        }
        return this.g_mag - this.r_mag;
    }

    public double get_r_i() {
        if (this.r_mag == 0.0 || this.i_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.r_mag - ABOffset.r.val - (this.i_mag - ABOffset.i.val);
        }
        return this.r_mag - this.i_mag;
    }

    public double get_i_z() {
        if (this.i_mag == 0.0 || this.z_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.i_mag - ABOffset.i.val - (this.z_mag - ABOffset.z.val);
        }
        return this.i_mag - this.z_mag;
    }

    public double get_u_g_err() {
        if (this.u_err == 0.0 || this.g_err == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return AstrometricFunctions.calculateAdditionError(this.u_err - ABOffset.u.val, this.g_err - ABOffset.g.val);
        }
        return AstrometricFunctions.calculateAdditionError(this.u_err, this.g_err);
    }

    public double get_g_r_err() {
        if (this.g_err == 0.0 || this.r_err == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return AstrometricFunctions.calculateAdditionError(this.g_err - ABOffset.g.val, this.r_err - ABOffset.r.val);
        }
        return AstrometricFunctions.calculateAdditionError(this.g_err, this.r_err);
    }

    public double get_r_i_err() {
        if (this.r_err == 0.0 || this.i_err == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return AstrometricFunctions.calculateAdditionError(this.r_err - ABOffset.r.val, this.i_err - ABOffset.i.val);
        }
        return AstrometricFunctions.calculateAdditionError(this.r_err, this.i_err);
    }

    public double get_i_z_err() {
        if (this.i_err == 0.0 || this.z_err == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return AstrometricFunctions.calculateAdditionError(this.i_err - ABOffset.i.val, this.z_err - ABOffset.z.val);
        }
        return AstrometricFunctions.calculateAdditionError(this.i_err, this.z_err);
    }

    static {
        OBJECT_TYPES.put(0, "Unknown:");
        OBJECT_TYPES.put(1, "Cosmic-ray track");
        OBJECT_TYPES.put(2, "Defect");
        OBJECT_TYPES.put(3, "Galaxy");
        OBJECT_TYPES.put(4, "Ghost");
        OBJECT_TYPES.put(5, "Known object");
        OBJECT_TYPES.put(6, "Star");
        OBJECT_TYPES.put(7, "Satellite/Asteroid/Meteor trail");
        OBJECT_TYPES.put(8, "No objects in area");
        OBJECT_TYPES.put(9, "Not a type");
    }
}

