/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.ABOffset;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimbadCatalogEntry
implements CatalogEntry,
Extinction {
    public static final String CATALOG_NAME = "SIMBAD";
    private String sourceId;
    private String objectType;
    private String spectralType;
    private double ra;
    private double dec;
    private double plx;
    private double plx_err;
    private double pmra;
    private double pmdec;
    private double radvel;
    private double redshift;
    private String rvtype;
    private double Umag;
    private double Bmag;
    private double Vmag;
    private double Rmag;
    private double Imag;
    private double Gmag;
    private double Jmag;
    private double Hmag;
    private double Kmag;
    private double u_mag;
    private double g_mag;
    private double r_mag;
    private double i_mag;
    private double z_mag;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private boolean toVega;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public SimbadCatalogEntry() {
    }

    public SimbadCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        this.sourceId = values[columns.get("main_id")];
        this.objectType = values[columns.get("otype_longname")];
        this.spectralType = values[columns.get("sp_type")];
        this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
        this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
        this.plx = NumericFunctions.toDouble(values[columns.get("plx_value")]);
        this.plx_err = NumericFunctions.toDouble(values[columns.get("plx_err")]);
        this.pmra = NumericFunctions.toDouble(values[columns.get("pmra")]);
        this.pmdec = NumericFunctions.toDouble(values[columns.get("pmdec")]);
        this.radvel = NumericFunctions.toDouble(values[columns.get("rvz_radvel")]);
        this.redshift = NumericFunctions.toDouble(values[columns.get("rvz_redshift")]);
        this.rvtype = values[columns.get("rvz_type")];
        this.Umag = NumericFunctions.toDouble(values[columns.get("U")]);
        this.Bmag = NumericFunctions.toDouble(values[columns.get("B")]);
        this.Vmag = NumericFunctions.toDouble(values[columns.get("V")]);
        this.Rmag = NumericFunctions.toDouble(values[columns.get("R")]);
        this.Imag = NumericFunctions.toDouble(values[columns.get("I")]);
        this.Gmag = NumericFunctions.toDouble(values[columns.get("G")]);
        this.Jmag = NumericFunctions.toDouble(values[columns.get("J")]);
        this.Hmag = NumericFunctions.toDouble(values[columns.get("H")]);
        this.Kmag = NumericFunctions.toDouble(values[columns.get("K")]);
        this.u_mag = NumericFunctions.toDouble(values[columns.get("u_")]);
        this.g_mag = NumericFunctions.toDouble(values[columns.get("g_")]);
        this.r_mag = NumericFunctions.toDouble(values[columns.get("r_")]);
        this.i_mag = NumericFunctions.toDouble(values[columns.get("i_")]);
        this.z_mag = NumericFunctions.toDouble(values[columns.get("z_")]);
    }

    @Override
    public CatalogEntry copy() {
        return new SimbadCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", this.sourceId, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("object type", this.objectType, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("spectral type", this.spectralType, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("plx (mas)", NumericFunctions.roundTo4DecNZ(this.plx), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("plx err", NumericFunctions.roundTo4DecNZ(this.plx_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmra), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmdec), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("rad vel (km/s)", NumericFunctions.roundTo1DecNZ(this.radvel), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("redshift", NumericFunctions.roundTo6DecNZ(this.redshift), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("rv type", this.rvtype, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("U (mag)", NumericFunctions.roundTo3DecNZ(this.Umag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("B (mag)", NumericFunctions.roundTo3DecNZ(this.Bmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("V (mag)", NumericFunctions.roundTo3DecNZ(this.Vmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("R (mag)", NumericFunctions.roundTo3DecNZ(this.Rmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("I (mag)", NumericFunctions.roundTo3DecNZ(this.Imag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("G (mag)", NumericFunctions.roundTo3DecNZ(this.Gmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J (mag)", NumericFunctions.roundTo3DecNZ(this.Jmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H (mag)", NumericFunctions.roundTo3DecNZ(this.Hmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("K (mag)", NumericFunctions.roundTo3DecNZ(this.Kmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u (mag)", NumericFunctions.roundTo3DecNZ(this.u_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g (mag)", NumericFunctions.roundTo3DecNZ(this.g_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r (mag)", NumericFunctions.roundTo3DecNZ(this.r_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i (mag)", NumericFunctions.roundTo3DecNZ(this.i_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z (mag)", NumericFunctions.roundTo3DecNZ(this.z_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("B-V", NumericFunctions.roundTo3DecNZ(this.getB_V()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("U-B", NumericFunctions.roundTo3DecNZ(this.getU_B()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("V-R", NumericFunctions.roundTo3DecNZ(this.getV_R()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("V-I", NumericFunctions.roundTo3DecNZ(this.getV_I()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("J-H", NumericFunctions.roundTo3DecNZ(this.getJ_H()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("H-K", NumericFunctions.roundTo3DecNZ(this.getH_K()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("J-K", NumericFunctions.roundTo3DecNZ(this.getJ_K()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("u-g", NumericFunctions.roundTo3DecNZ(this.get_u_g()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("g-r", NumericFunctions.roundTo3DecNZ(this.get_g_r()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("r-i", NumericFunctions.roundTo3DecNZ(this.get_r_i()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("i-z", NumericFunctions.roundTo3DecNZ(this.get_i_z()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this.sourceId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimbadCatalogEntry other = (SimbadCatalogEntry)obj;
        return Objects.equals(this.sourceId, other.sourceId);
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new SimbadCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return Color.RED;
    }

    @Override
    public String getCatalogQueryUrl() {
        return ServiceHelper.createSimbadUrl(this.ra, this.dec, this.searchRadius / 3600.0);
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + this.objectType + "," + this.spectralType + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo4Dec(this.plx) + "," + NumericFunctions.roundTo4Dec(this.plx_err) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + NumericFunctions.roundTo1Dec(this.radvel) + "," + NumericFunctions.roundTo6Dec(this.redshift) + "," + this.rvtype + "," + NumericFunctions.roundTo3Dec(this.Umag) + "," + NumericFunctions.roundTo3Dec(this.Bmag) + "," + NumericFunctions.roundTo3Dec(this.Vmag) + "," + NumericFunctions.roundTo3Dec(this.Rmag) + "," + NumericFunctions.roundTo3Dec(this.Imag) + "," + NumericFunctions.roundTo3Dec(this.Gmag) + "," + NumericFunctions.roundTo3Dec(this.Jmag) + "," + NumericFunctions.roundTo3Dec(this.Hmag) + "," + NumericFunctions.roundTo3Dec(this.Kmag) + "," + NumericFunctions.roundTo3Dec(this.u_mag) + "," + NumericFunctions.roundTo3Dec(this.g_mag) + "," + NumericFunctions.roundTo3Dec(this.r_mag) + "," + NumericFunctions.roundTo3Dec(this.i_mag) + "," + NumericFunctions.roundTo3Dec(this.z_mag) + "," + NumericFunctions.roundTo3Dec(this.getB_V()) + "," + NumericFunctions.roundTo3Dec(this.getU_B()) + "," + NumericFunctions.roundTo3Dec(this.getV_R()) + "," + NumericFunctions.roundTo3Dec(this.getV_I()) + "," + NumericFunctions.roundTo3Dec(this.getJ_H()) + "," + NumericFunctions.roundTo3Dec(this.getH_K()) + "," + NumericFunctions.roundTo3Dec(this.getJ_K()) + "," + NumericFunctions.roundTo3Dec(this.get_u_g()) + "," + NumericFunctions.roundTo3Dec(this.get_g_r()) + "," + NumericFunctions.roundTo3Dec(this.get_r_i()) + "," + NumericFunctions.roundTo3Dec(this.get_i_z());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,object type,spectral type,ra,dec,plx (mas),plx err,pmra (mas/yr),pmdec (mas/yr),rad vel (km/s),redshift,rv type,U (mag),B (mag),V (mag),R (mag),I (mag),G (mag),J (mag),H (mag),K (mag),u (mag),g (mag),r (mag),i (mag),z (mag),B-V,U-B,V-R,V-I,J-H,H-K,J-K,u-g,g-r,r-i,i-z";
        return columnTitles.split(",", -1);
    }

    @Override
    public void applyExtinctionCorrection(Map<String, Double> extinctionsByBand) {
        if (this.u_mag != 0.0) {
            this.u_mag -= extinctionsByBand.get("SDSS u").doubleValue();
        }
        if (this.g_mag != 0.0) {
            this.g_mag -= extinctionsByBand.get("SDSS g").doubleValue();
        }
        if (this.r_mag != 0.0) {
            this.r_mag -= extinctionsByBand.get("SDSS r").doubleValue();
        }
        if (this.i_mag != 0.0) {
            this.i_mag -= extinctionsByBand.get("SDSS i").doubleValue();
        }
        if (this.z_mag != 0.0) {
            this.z_mag -= extinctionsByBand.get("SDSS z").doubleValue();
        }
        if (this.Jmag != 0.0) {
            this.Jmag -= extinctionsByBand.get("2MASS J").doubleValue();
        }
        if (this.Hmag != 0.0) {
            this.Hmag -= extinctionsByBand.get("2MASS H").doubleValue();
        }
        if (this.Kmag != 0.0) {
            this.Kmag -= extinctionsByBand.get("2MASS Ks").doubleValue();
        }
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.J, new NumberPair(this.Jmag, 0.0));
        bands.put(Band.H, new NumberPair(this.Hmag, 0.0));
        bands.put(Band.K, new NumberPair(this.Kmag, 0.0));
        bands.put(Band.G, new NumberPair(this.Gmag, 0.0));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        this.toVega = toVega;
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.J_H, this.getJ_H());
        colors.put(astro.tool.box.enumeration.Color.J_K, this.getJ_K());
        colors.put(astro.tool.box.enumeration.Color.H_K, this.getH_K());
        colors.put(astro.tool.box.enumeration.Color.u_g, this.get_u_g());
        colors.put(astro.tool.box.enumeration.Color.g_r, this.get_g_r());
        colors.put(astro.tool.box.enumeration.Color.r_i, this.get_r_i());
        colors.put(astro.tool.box.enumeration.Color.i_z, this.get_i_z());
        colors.put(astro.tool.box.enumeration.Color.M_G, this.getAbsoluteGmag());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.Umag != 0.0) {
            mags.append("U=").append(NumericFunctions.roundTo3DecNZ(this.Umag)).append(" ");
        }
        if (this.Bmag != 0.0) {
            mags.append("B=").append(NumericFunctions.roundTo3DecNZ(this.Bmag)).append(" ");
        }
        if (this.Vmag != 0.0) {
            mags.append("V=").append(NumericFunctions.roundTo3DecNZ(this.Vmag)).append(" ");
        }
        if (this.Rmag != 0.0) {
            mags.append("R=").append(NumericFunctions.roundTo3DecNZ(this.Rmag)).append(" ");
        }
        if (this.Imag != 0.0) {
            mags.append("I=").append(NumericFunctions.roundTo3DecNZ(this.Imag)).append(" ");
        }
        if (this.Gmag != 0.0) {
            mags.append("G=").append(NumericFunctions.roundTo3DecNZ(this.Gmag)).append(" ");
        }
        if (this.Jmag != 0.0) {
            mags.append("J=").append(NumericFunctions.roundTo3DecNZ(this.Jmag)).append(" ");
        }
        if (this.Hmag != 0.0) {
            mags.append("H=").append(NumericFunctions.roundTo3DecNZ(this.Hmag)).append(" ");
        }
        if (this.Kmag != 0.0) {
            mags.append("K=").append(NumericFunctions.roundTo3DecNZ(this.Kmag)).append(" ");
        }
        if (this.u_mag != 0.0) {
            mags.append("u=").append(NumericFunctions.roundTo3DecNZ(this.u_mag)).append(" ");
        }
        if (this.g_mag != 0.0) {
            mags.append("g=").append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(" ");
        }
        if (this.r_mag != 0.0) {
            mags.append("r=").append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(" ");
        }
        if (this.i_mag != 0.0) {
            mags.append("i=").append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(" ");
        }
        if (this.z_mag != 0.0) {
            mags.append("z=").append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return this.plx;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return AstrometricFunctions.calculateParallacticDistance(this.plx);
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getAbsoluteGmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.Gmag, this.plx);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getSpectralType() {
        return this.spectralType;
    }

    public double getB_V() {
        if (this.Bmag == 0.0 || this.Vmag == 0.0) {
            return 0.0;
        }
        return this.Bmag - this.Vmag;
    }

    public double getU_B() {
        if (this.Umag == 0.0 || this.Bmag == 0.0) {
            return 0.0;
        }
        return this.Umag - this.Bmag;
    }

    public double getV_R() {
        if (this.Vmag == 0.0 || this.Rmag == 0.0) {
            return 0.0;
        }
        return this.Vmag - this.Rmag;
    }

    public double getV_I() {
        if (this.Vmag == 0.0 || this.Imag == 0.0) {
            return 0.0;
        }
        return this.Vmag - this.Imag;
    }

    public double getV_J() {
        if (this.Vmag == 0.0 || this.Jmag == 0.0) {
            return 0.0;
        }
        return this.Vmag - this.Jmag;
    }

    public double getR_I() {
        if (this.Rmag == 0.0 || this.Imag == 0.0) {
            return 0.0;
        }
        return this.Rmag - this.Imag;
    }

    public double getJ_H() {
        if (this.Jmag == 0.0 || this.Hmag == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.Hmag;
    }

    public double getJ_K() {
        if (this.Jmag == 0.0 || this.Kmag == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.Kmag;
    }

    public double getH_K() {
        if (this.Hmag == 0.0 || this.Kmag == 0.0) {
            return 0.0;
        }
        return this.Hmag - this.Kmag;
    }

    public double get_u_g() {
        if (this.u_mag == 0.0 || this.g_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.u_mag - ABOffset.u.val - (this.g_mag - ABOffset.g.val);
        }
        return this.u_mag - this.g_mag;
    }

    public double get_g_r() {
        if (this.g_mag == 0.0 || this.r_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.g_mag - ABOffset.g.val - (this.r_mag - ABOffset.r.val);
        }
        return this.g_mag - this.r_mag;
    }

    public double get_r_i() {
        if (this.r_mag == 0.0 || this.i_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.r_mag - ABOffset.r.val - (this.i_mag - ABOffset.i.val);
        }
        return this.r_mag - this.i_mag;
    }

    public double get_i_z() {
        if (this.i_mag == 0.0 || this.z_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.i_mag - ABOffset.i.val - (this.z_mag - ABOffset.z.val);
        }
        return this.i_mag - this.z_mag;
    }
}

