/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.Constants;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SsoCatalogEntry
implements CatalogEntry {
    public static final String CATALOG_NAME = "Solar System Objects";
    private String objectID;
    private String type;
    private double ra;
    private double dec;
    private double pra;
    private double pdec;
    private double ppm;
    private double theta;
    private double rhelio;
    private double amag;
    private double vmag;
    private double perdist;
    private double ecc;
    private double incl;
    private double pertime;
    private LocalDateTime mjd;
    private double dra;
    private double ddec;
    private double W1mag;
    private double W1_err;
    private double W2mag;
    private double W2_err;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;
    private static final Map<String, String> TYPE_TABLE = new HashMap<String, String>();

    public SsoCatalogEntry() {
    }

    public SsoCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        this.objectID = values[columns.get("objid")].replaceAll("\\s+", " ");
        this.type = values[columns.get("t")];
        this.pra = NumericFunctions.toDouble(values[columns.get("ra")]);
        this.pdec = NumericFunctions.toDouble(values[columns.get("dec")]);
        this.ppm = NumericFunctions.toDouble(values[columns.get("mu")]);
        this.theta = NumericFunctions.toDouble(values[columns.get("theta")]);
        this.rhelio = NumericFunctions.toDouble(values[columns.get("rhelio")]);
        this.amag = NumericFunctions.toDouble(values[columns.get("amag")]);
        this.vmag = NumericFunctions.toDouble(values[columns.get("vmag")]);
        this.perdist = NumericFunctions.toDouble(values[columns.get("perdist")]);
        this.ecc = NumericFunctions.toDouble(values[columns.get("ecc")]);
        this.incl = NumericFunctions.toDouble(values[columns.get("incl")]);
        this.pertime = NumericFunctions.toDouble(values[columns.get("pertime")]);
        this.mjd = AstrometricFunctions.convertMJDToDateTime(new BigDecimal(values[columns.get("mjd")]));
        this.dra = NumericFunctions.toDouble(values[columns.get("dra")]);
        this.ddec = NumericFunctions.toDouble(values[columns.get("ddec")]);
        this.W1mag = NumericFunctions.toDouble(values[columns.get("w1mpro")]);
        this.W1_err = NumericFunctions.toDouble(values[columns.get("w1sgmp")]);
        this.W2mag = NumericFunctions.toDouble(values[columns.get("w2mpro")]);
        this.W2_err = NumericFunctions.toDouble(values[columns.get("w2sgmp")]);
        this.ra = this.pra;
        this.dec = this.pdec;
    }

    @Override
    public CatalogEntry copy() {
        return new SsoCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("object id", this.objectID, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("type", TYPE_TABLE.get(this.type), Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("predicted ra", NumericFunctions.roundTo7DecNZ(this.pra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("predicted dec", NumericFunctions.roundTo7DecNZ(this.pdec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("predicted pm (arcsec/sec)", NumericFunctions.roundTo3DecNZ(this.ppm), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("pm direction (deg)", NumericFunctions.roundTo3DecNZ(this.theta), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("heliocentric dist. (AU)", NumericFunctions.roundTo3DecNZ(this.rhelio), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("absolute mag", NumericFunctions.roundTo3DecNZ(this.amag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("visual mag", NumericFunctions.roundTo3DecNZ(this.vmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("perihelion dist. (AU)", NumericFunctions.roundTo3DecNZ(this.perdist), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("orbital ecc.", NumericFunctions.roundTo3DecNZ(this.ecc), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("orbital incl. (deg)", NumericFunctions.roundTo3DecNZ(this.incl), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("perih. passage time", AstrometricFunctions.convertMJDToDateTime(new BigDecimal(Double.toString(this.pertime))).format(Constants.DATE_TIME_FORMATTER), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("observation time", this.mjd.format(Constants.DATE_TIME_FORMATTER), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dist. to predict ra (arcsec)", NumericFunctions.roundTo3DecNZ(this.dra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dist. to predict dec (arcsec)", NumericFunctions.roundTo3DecNZ(this.ddec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 (mag)", NumericFunctions.roundTo3DecNZ(this.W1mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 err", NumericFunctions.roundTo3DecNZ(this.W1_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W2 (mag)", NumericFunctions.roundTo3DecNZ(this.W2mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W2 err", NumericFunctions.roundTo3DecNZ(this.W2_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.objectID);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SsoCatalogEntry other = (SsoCatalogEntry)obj;
        return Objects.equals(this.objectID, other.objectID);
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new SsoCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return Color.BLUE;
    }

    @Override
    public String getCatalogQueryUrl() {
        return ServiceHelper.createIrsaUrl(this.ra, this.dec, this.searchRadius / 3600.0, "neowiser_p1ba_mch");
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.objectID + "," + TYPE_TABLE.get(this.type) + "," + NumericFunctions.roundTo7Dec(this.pra) + "," + NumericFunctions.roundTo7Dec(this.pdec) + "," + NumericFunctions.roundTo3Dec(this.ppm) + "," + NumericFunctions.roundTo3Dec(this.theta) + "," + NumericFunctions.roundTo3Dec(this.rhelio) + "," + NumericFunctions.roundTo3Dec(this.amag) + "," + NumericFunctions.roundTo3Dec(this.vmag) + "," + NumericFunctions.roundTo3Dec(this.perdist) + "," + NumericFunctions.roundTo3Dec(this.ecc) + "," + NumericFunctions.roundTo3Dec(this.incl) + "," + NumericFunctions.roundTo3Dec(this.pertime) + "," + this.mjd.format(Constants.DATE_TIME_FORMATTER) + "," + NumericFunctions.roundTo3Dec(this.dra) + "," + NumericFunctions.roundTo3Dec(this.ddec) + "," + NumericFunctions.roundTo3Dec(this.W1mag) + "," + NumericFunctions.roundTo3Dec(this.W1_err) + "," + NumericFunctions.roundTo3Dec(this.W2mag) + "," + NumericFunctions.roundTo3Dec(this.W2_err);
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),object id,type,predicted ra,predicted dec,predicted pm (arcsec/sec),pm direction (deg),heliocentric dist. (AU),absolute mag,visual mag,perihelion dist. (AU),orbital ecc.,orbital incl. (deg),perih. passage time,observation time,dist. to predict ra (arcsec),dist. to predict dec (arcsec),W1 (mag),W1 err,W2 (mag),W2 err";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        return new LinkedHashMap<Band, NumberPair>();
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        return new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
    }

    @Override
    public String getMagnitudes() {
        return "";
    }

    @Override
    public String getSourceId() {
        return this.objectID;
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return null;
    }

    @Override
    public void setSpt(String spt) {
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return 0.0;
    }

    @Override
    public double getPmdec() {
        return 0.0;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return 0.0;
    }

    static {
        TYPE_TABLE.put("A", "Asteroid, numbered");
        TYPE_TABLE.put("U", "Asteroid, unnumbered");
        TYPE_TABLE.put("C", "Comet, periodic");
        TYPE_TABLE.put("N", "Comet, non-periodic");
        TYPE_TABLE.put("P", "Planet");
        TYPE_TABLE.put("S", "Planetary Satellite");
    }
}

