/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.ABOffset;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TessCatalogEntry
implements CatalogEntry,
WhiteDwarf,
Extinction {
    public static final String CATALOG_NAME = "TESS Input Catalog";
    private long sourceId;
    private double ra;
    private double dec;
    private double plx;
    private double plx_err;
    private double pmra;
    private double pmra_err;
    private double pmdec;
    private double pmdec_err;
    private double teff;
    private double teff_err;
    private double logg;
    private double logg_err;
    private double rad;
    private double rad_err;
    private double mass;
    private double mass_err;
    private double lum;
    private double lum_err;
    private double dist;
    private double dist_err;
    private double Gmag;
    private double G_err;
    private double BPmag;
    private double BP_err;
    private double RPmag;
    private double RP_err;
    private double Bmag;
    private double B_err;
    private double Vmag;
    private double V_err;
    private double u_mag;
    private double u_err;
    private double g_mag;
    private double g_err;
    private double r_mag;
    private double r_err;
    private double i_mag;
    private double i_err;
    private double z_mag;
    private double z_err;
    private double W1mag;
    private double W1_err;
    private double W2mag;
    private double W2_err;
    private double W3mag;
    private double W3_err;
    private double W4mag;
    private double W4_err;
    private double Jmag;
    private double J_err;
    private double Hmag;
    private double H_err;
    private double Kmag;
    private double K_err;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private boolean toVega;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public TessCatalogEntry() {
    }

    public TessCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        this.sourceId = NumericFunctions.toLong(values[columns.get("TIC")]);
        this.ra = NumericFunctions.toDouble(values[columns.get("RAJ2000")]);
        this.dec = NumericFunctions.toDouble(values[columns.get("DEJ2000")]);
        this.plx = NumericFunctions.toDouble(values[columns.get("Plx")]);
        this.plx_err = NumericFunctions.toDouble(values[columns.get("e_Plx")]);
        this.pmra = NumericFunctions.toDouble(values[columns.get("pmRA")]);
        this.pmra_err = NumericFunctions.toDouble(values[columns.get("e_pmRA")]);
        this.pmdec = NumericFunctions.toDouble(values[columns.get("pmDE")]);
        this.pmdec_err = NumericFunctions.toDouble(values[columns.get("e_pmDE")]);
        this.teff = NumericFunctions.toDouble(values[columns.get("Teff")]);
        this.teff_err = NumericFunctions.toDouble(values[columns.get("s_Teff")]);
        this.logg = NumericFunctions.toDouble(values[columns.get("logg")]);
        this.logg_err = NumericFunctions.toDouble(values[columns.get("s_logg")]);
        this.rad = NumericFunctions.toDouble(values[columns.get("Rad")]);
        this.rad_err = NumericFunctions.toDouble(values[columns.get("s_Rad")]);
        this.mass = NumericFunctions.toDouble(values[columns.get("Mass")]);
        this.mass_err = NumericFunctions.toDouble(values[columns.get("s_Mass")]);
        this.lum = NumericFunctions.toDouble(values[columns.get("Lum")]);
        this.lum_err = NumericFunctions.toDouble(values[columns.get("s_Lum")]);
        this.dist = NumericFunctions.toDouble(values[columns.get("Dist")]);
        this.dist_err = NumericFunctions.toDouble(values[columns.get("s_Dist")]);
        this.Gmag = NumericFunctions.toDouble(values[columns.get("Gmag")]);
        this.G_err = NumericFunctions.toDouble(values[columns.get("e_Gmag")]);
        this.BPmag = NumericFunctions.toDouble(values[columns.get("BPmag")]);
        this.BP_err = NumericFunctions.toDouble(values[columns.get("e_BPmag")]);
        this.RPmag = NumericFunctions.toDouble(values[columns.get("RPmag")]);
        this.RP_err = NumericFunctions.toDouble(values[columns.get("e_RPmag")]);
        this.Bmag = NumericFunctions.toDouble(values[columns.get("Bmag")]);
        this.B_err = NumericFunctions.toDouble(values[columns.get("e_Bmag")]);
        this.Vmag = NumericFunctions.toDouble(values[columns.get("Vmag")]);
        this.V_err = NumericFunctions.toDouble(values[columns.get("e_Vmag")]);
        this.u_mag = NumericFunctions.toDouble(values[columns.get("umag")]);
        this.u_err = NumericFunctions.toDouble(values[columns.get("e_umag")]);
        this.g_mag = NumericFunctions.toDouble(values[columns.get("gmag")]);
        this.g_err = NumericFunctions.toDouble(values[columns.get("e_gmag")]);
        this.r_mag = NumericFunctions.toDouble(values[columns.get("rmag")]);
        this.r_err = NumericFunctions.toDouble(values[columns.get("e_rmag")]);
        this.i_mag = NumericFunctions.toDouble(values[columns.get("imag")]);
        this.i_err = NumericFunctions.toDouble(values[columns.get("e_imag")]);
        this.z_mag = NumericFunctions.toDouble(values[columns.get("zmag")]);
        this.z_err = NumericFunctions.toDouble(values[columns.get("e_zmag")]);
        this.W1mag = NumericFunctions.toDouble(values[columns.get("W1mag")]);
        this.W1_err = NumericFunctions.toDouble(values[columns.get("e_W1mag")]);
        this.W2mag = NumericFunctions.toDouble(values[columns.get("W2mag")]);
        this.W2_err = NumericFunctions.toDouble(values[columns.get("e_W2mag")]);
        this.W3mag = NumericFunctions.toDouble(values[columns.get("W3mag")]);
        this.W3_err = NumericFunctions.toDouble(values[columns.get("e_W3mag")]);
        this.W4mag = NumericFunctions.toDouble(values[columns.get("W4mag")]);
        this.W4_err = NumericFunctions.toDouble(values[columns.get("e_W4mag")]);
        this.Jmag = NumericFunctions.toDouble(values[columns.get("Jmag")]);
        this.J_err = NumericFunctions.toDouble(values[columns.get("e_Jmag")]);
        this.Hmag = NumericFunctions.toDouble(values[columns.get("Hmag")]);
        this.H_err = NumericFunctions.toDouble(values[columns.get("e_Hmag")]);
        this.Kmag = NumericFunctions.toDouble(values[columns.get("Kmag")]);
        this.K_err = NumericFunctions.toDouble(values[columns.get("e_Kmag")]);
    }

    @Override
    public CatalogEntry copy() {
        return new TessCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("TIC id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("plx (mas)", NumericFunctions.roundTo4DecNZ(this.plx), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("plx err", NumericFunctions.roundTo4DecNZ(this.plx_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmra), Alignment.RIGHT, Comparators.getDoubleComparator(), true, false, AstrometricFunctions.isProperMotionSpurious(this.pmra, this.pmra_err)));
        this.catalogElements.add(new CatalogElement("pmra err", NumericFunctions.roundTo3DecNZ(this.pmra_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmdec), Alignment.RIGHT, Comparators.getDoubleComparator(), true, false, AstrometricFunctions.isProperMotionSpurious(this.pmdec, this.pmdec_err)));
        this.catalogElements.add(new CatalogElement("pmdec err", NumericFunctions.roundTo3DecNZ(this.pmdec_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("teff (K)", NumericFunctions.roundTo3DecNZ(this.teff), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("teff err", NumericFunctions.roundTo3DecNZ(this.teff_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("logg (cm/s2)", NumericFunctions.roundTo4DecNZ(this.logg), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("logg err", NumericFunctions.roundTo4DecNZ(this.logg_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("radius (Rsun)", NumericFunctions.roundTo3DecNZ(this.rad), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("radius err", NumericFunctions.roundTo3DecNZ(this.rad_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("mass (Msun)", NumericFunctions.roundTo3DecNZ(this.mass), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("mass err", NumericFunctions.roundTo3DecNZ(this.mass_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("luminosity (Lsun)", NumericFunctions.roundTo5DecNZ(this.lum), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("luminosity err", NumericFunctions.roundTo5DecNZ(this.lum_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("distance (pc)", NumericFunctions.roundTo3DecNZ(this.dist), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("distance err", NumericFunctions.roundTo3DecNZ(this.dist_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("G (mag)", NumericFunctions.roundTo3DecNZ(this.Gmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("G err", NumericFunctions.roundTo3DecNZ(this.G_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP (mag)", NumericFunctions.roundTo3DecNZ(this.BPmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("BP err", NumericFunctions.roundTo3DecNZ(this.BP_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("RP (mag)", NumericFunctions.roundTo3DecNZ(this.RPmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("RP err", NumericFunctions.roundTo3DecNZ(this.RP_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("B (mag)", NumericFunctions.roundTo3DecNZ(this.Bmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("B err", NumericFunctions.roundTo3DecNZ(this.B_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("V (mag)", NumericFunctions.roundTo3DecNZ(this.Vmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("V err", NumericFunctions.roundTo3DecNZ(this.V_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u (mag)", NumericFunctions.roundTo3DecNZ(this.u_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("u err", NumericFunctions.roundTo3DecNZ(this.u_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g (mag)", NumericFunctions.roundTo3DecNZ(this.g_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("g err", NumericFunctions.roundTo3DecNZ(this.g_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r (mag)", NumericFunctions.roundTo3DecNZ(this.r_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("r err", NumericFunctions.roundTo3DecNZ(this.r_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i (mag)", NumericFunctions.roundTo3DecNZ(this.i_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("i err", NumericFunctions.roundTo3DecNZ(this.i_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z (mag)", NumericFunctions.roundTo3DecNZ(this.z_mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("z err", NumericFunctions.roundTo3DecNZ(this.z_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 (mag)", NumericFunctions.roundTo3DecNZ(this.W1mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 err", NumericFunctions.roundTo3DecNZ(this.W1_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W2 (mag)", NumericFunctions.roundTo3DecNZ(this.W2mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W2 err", NumericFunctions.roundTo3DecNZ(this.W2_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W3 (mag)", NumericFunctions.roundTo3DecNZ(this.W3mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W3 err", NumericFunctions.roundTo3DecNZ(this.W3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W4 (mag)", NumericFunctions.roundTo3DecNZ(this.W4mag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W4 err", NumericFunctions.roundTo3DecNZ(this.W4_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J (mag)", NumericFunctions.roundTo3DecNZ(this.Jmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J err", NumericFunctions.roundTo3DecNZ(this.J_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H (mag)", NumericFunctions.roundTo3DecNZ(this.Hmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H err", NumericFunctions.roundTo3DecNZ(this.H_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("K (mag)", NumericFunctions.roundTo3DecNZ(this.Kmag), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("K err", NumericFunctions.roundTo3DecNZ(this.K_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("G-RP", NumericFunctions.roundTo3DecNZ(this.getG_RP()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("BP-RP", NumericFunctions.roundTo3DecNZ(this.getBP_RP()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("B-V", NumericFunctions.roundTo3DecNZ(this.getB_V()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("u-g", NumericFunctions.roundTo3DecNZ(this.get_u_g()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("g-r", NumericFunctions.roundTo3DecNZ(this.get_g_r()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("r-i", NumericFunctions.roundTo3DecNZ(this.get_r_i()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("i-z", NumericFunctions.roundTo3DecNZ(this.get_i_z()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("W1-W2", NumericFunctions.roundTo3DecNZ(this.getW1_W2()), Alignment.RIGHT, Comparators.getDoubleComparator(), true, true));
        this.catalogElements.add(new CatalogElement("W2-W3", NumericFunctions.roundTo3DecNZ(this.getW2_W3()), Alignment.RIGHT, Comparators.getDoubleComparator(), true, true));
        this.catalogElements.add(new CatalogElement("J-W2", NumericFunctions.roundTo3DecNZ(this.getJ_W2()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("J-H", NumericFunctions.roundTo3DecNZ(this.getJ_H()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("H-K", NumericFunctions.roundTo3DecNZ(this.getH_K()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("J-K", NumericFunctions.roundTo3DecNZ(this.getJ_K()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("dist (1/plx)", NumericFunctions.roundTo3DecNZ(this.getParallacticDistance()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("tpm (mas/yr)", NumericFunctions.roundTo3DecNZ(this.getTotalProperMotion()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("Absolute G (mag)", NumericFunctions.roundTo3DecNZ(this.getAbsoluteGmag()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (int)(this.sourceId ^ this.sourceId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TessCatalogEntry other = (TessCatalogEntry)obj;
        return this.sourceId == other.sourceId;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new TessCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.LILAC.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        return ServiceHelper.createVizieRUrl(this.ra, this.dec, this.searchRadius / 3600.0, "IV/38/tic", "RAJ2000", "DEJ2000");
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo4Dec(this.plx) + "," + NumericFunctions.roundTo4Dec(this.plx_err) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmra_err) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + NumericFunctions.roundTo3Dec(this.pmdec_err) + "," + NumericFunctions.roundTo3Dec(this.teff) + "," + NumericFunctions.roundTo3Dec(this.teff_err) + "," + NumericFunctions.roundTo4Dec(this.logg) + "," + NumericFunctions.roundTo4Dec(this.logg_err) + "," + NumericFunctions.roundTo3Dec(this.rad) + "," + NumericFunctions.roundTo3Dec(this.rad_err) + "," + NumericFunctions.roundTo3Dec(this.mass) + "," + NumericFunctions.roundTo3Dec(this.mass_err) + "," + NumericFunctions.roundTo5Dec(this.lum) + "," + NumericFunctions.roundTo5Dec(this.lum_err) + "," + NumericFunctions.roundTo3Dec(this.dist) + "," + NumericFunctions.roundTo3Dec(this.dist_err) + "," + NumericFunctions.roundTo3Dec(this.Gmag) + "," + NumericFunctions.roundTo3Dec(this.G_err) + "," + NumericFunctions.roundTo3Dec(this.BPmag) + "," + NumericFunctions.roundTo3Dec(this.BP_err) + "," + NumericFunctions.roundTo3Dec(this.RPmag) + "," + NumericFunctions.roundTo3Dec(this.RP_err) + "," + NumericFunctions.roundTo3Dec(this.Bmag) + "," + NumericFunctions.roundTo3Dec(this.B_err) + "," + NumericFunctions.roundTo3Dec(this.Vmag) + "," + NumericFunctions.roundTo3Dec(this.V_err) + "," + NumericFunctions.roundTo3Dec(this.u_mag) + "," + NumericFunctions.roundTo3Dec(this.u_err) + "," + NumericFunctions.roundTo3Dec(this.g_mag) + "," + NumericFunctions.roundTo3Dec(this.g_err) + "," + NumericFunctions.roundTo3Dec(this.r_mag) + "," + NumericFunctions.roundTo3Dec(this.r_err) + "," + NumericFunctions.roundTo3Dec(this.i_mag) + "," + NumericFunctions.roundTo3Dec(this.i_err) + "," + NumericFunctions.roundTo3Dec(this.z_mag) + "," + NumericFunctions.roundTo3Dec(this.z_err) + "," + NumericFunctions.roundTo3Dec(this.W1mag) + "," + NumericFunctions.roundTo3Dec(this.W1_err) + "," + NumericFunctions.roundTo3Dec(this.W2mag) + "," + NumericFunctions.roundTo3Dec(this.W2_err) + "," + NumericFunctions.roundTo3Dec(this.W3mag) + "," + NumericFunctions.roundTo3Dec(this.W3_err) + "," + NumericFunctions.roundTo3Dec(this.W4mag) + "," + NumericFunctions.roundTo3Dec(this.W4_err) + "," + NumericFunctions.roundTo3Dec(this.Jmag) + "," + NumericFunctions.roundTo3Dec(this.J_err) + "," + NumericFunctions.roundTo3Dec(this.Hmag) + "," + NumericFunctions.roundTo3Dec(this.H_err) + "," + NumericFunctions.roundTo3Dec(this.Kmag) + "," + NumericFunctions.roundTo3Dec(this.K_err) + "," + NumericFunctions.roundTo3Dec(this.getB_V()) + "," + NumericFunctions.roundTo3Dec(this.getG_RP()) + "," + NumericFunctions.roundTo3Dec(this.getBP_RP()) + "," + NumericFunctions.roundTo3Dec(this.get_u_g()) + "," + NumericFunctions.roundTo3Dec(this.get_g_r()) + "," + NumericFunctions.roundTo3Dec(this.get_r_i()) + "," + NumericFunctions.roundTo3Dec(this.get_i_z()) + "," + NumericFunctions.roundTo3Dec(this.getW1_W2()) + "," + NumericFunctions.roundTo3Dec(this.getW2_W3()) + "," + NumericFunctions.roundTo3Dec(this.getJ_W2()) + "," + NumericFunctions.roundTo3Dec(this.getJ_H()) + "," + NumericFunctions.roundTo3Dec(this.getH_K()) + "," + NumericFunctions.roundTo3Dec(this.getJ_K()) + "," + NumericFunctions.roundTo3Dec(this.getParallacticDistance()) + "," + NumericFunctions.roundTo3Dec(this.getTotalProperMotion()) + "," + NumericFunctions.roundTo3Dec(this.getAbsoluteGmag());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),TIC id,ra,dec,plx (mas),plx err,pmra (mas/yr),pmra err,pmdec (mas/yr),pmdec err,teff (K),teff err,logg (cm/s2),logg err,radius (Rsun),radius err,mass (Msun),mass err,luminosity (Lsun),luminosity err,distance (pc),distance err,G (mag),G err,BP (mag),BP err,RP (mag),RP err,B (mag),B err,V (mag),V err,u (mag),u err,g (mag),g err,r (mag),r err,i (mag),i err,z (mag),z err,W1 (mag),W1 err,W2 (mag),W2 err,W3 (mag),W3 err,W4 (mag),W4 err,J (mag),J err,H (mag),H err,K (mag),K err,G-RP,BP-RP,B-V,u-g,g-r,r-i,i-z,W1-W2,W2-W3,J-W2,J-H,H-K,J-K,dist (1/plx),tpm (mas/yr),Absolute G (mag)";
        return columnTitles.split(",", -1);
    }

    @Override
    public void applyExtinctionCorrection(Map<String, Double> extinctionsByBand) {
        if (this.u_mag != 0.0) {
            this.u_mag -= extinctionsByBand.get("SDSS u").doubleValue();
        }
        if (this.g_mag != 0.0) {
            this.g_mag -= extinctionsByBand.get("SDSS g").doubleValue();
        }
        if (this.r_mag != 0.0) {
            this.r_mag -= extinctionsByBand.get("SDSS r").doubleValue();
        }
        if (this.i_mag != 0.0) {
            this.i_mag -= extinctionsByBand.get("SDSS i").doubleValue();
        }
        if (this.z_mag != 0.0) {
            this.z_mag -= extinctionsByBand.get("SDSS z").doubleValue();
        }
        if (this.W1mag != 0.0) {
            this.W1mag -= extinctionsByBand.get("WISE-1").doubleValue();
        }
        if (this.W2mag != 0.0) {
            this.W2mag -= extinctionsByBand.get("WISE-2").doubleValue();
        }
        if (this.Jmag != 0.0) {
            this.Jmag -= extinctionsByBand.get("2MASS J").doubleValue();
        }
        if (this.Hmag != 0.0) {
            this.Hmag -= extinctionsByBand.get("2MASS H").doubleValue();
        }
        if (this.Kmag != 0.0) {
            this.Kmag -= extinctionsByBand.get("2MASS Ks").doubleValue();
        }
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        if (this.W1_err != 0.0) {
            bands.put(Band.W1, new NumberPair(this.W1mag, this.W1_err));
        }
        if (this.W2_err != 0.0) {
            bands.put(Band.W2, new NumberPair(this.W2mag, this.W2_err));
        }
        if (this.W3_err != 0.0) {
            bands.put(Band.W3, new NumberPair(this.W3mag, this.W3_err));
        }
        if (this.J_err != 0.0) {
            bands.put(Band.J, new NumberPair(this.Jmag, this.J_err));
        }
        if (this.H_err != 0.0) {
            bands.put(Band.H, new NumberPair(this.Hmag, this.H_err));
        }
        if (this.K_err != 0.0) {
            bands.put(Band.K, new NumberPair(this.Kmag, this.K_err));
        }
        bands.put(Band.G, new NumberPair(this.Gmag, 0.0));
        bands.put(Band.BP, new NumberPair(this.BPmag, 0.0));
        bands.put(Band.RP, new NumberPair(this.RPmag, 0.0));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        this.toVega = toVega;
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.M_G, this.getAbsoluteGmag());
        colors.put(astro.tool.box.enumeration.Color.M_RP, this.getAbsoluteRPmag());
        colors.put(astro.tool.box.enumeration.Color.M_BP, this.getAbsoluteBPmag());
        colors.put(astro.tool.box.enumeration.Color.G_RP, this.getG_RP());
        colors.put(astro.tool.box.enumeration.Color.BP_RP, this.getBP_RP());
        colors.put(astro.tool.box.enumeration.Color.BP_G, this.getBP_G());
        colors.put(astro.tool.box.enumeration.Color.u_g, this.get_u_g());
        colors.put(astro.tool.box.enumeration.Color.g_r, this.get_g_r());
        colors.put(astro.tool.box.enumeration.Color.r_i, this.get_r_i());
        colors.put(astro.tool.box.enumeration.Color.i_z, this.get_i_z());
        colors.put(astro.tool.box.enumeration.Color.W1_W2, this.getW1_W2());
        colors.put(astro.tool.box.enumeration.Color.W1_W3, this.getW1_W3());
        colors.put(astro.tool.box.enumeration.Color.W1_W4, this.getW1_W4());
        colors.put(astro.tool.box.enumeration.Color.J_H, this.getJ_H());
        colors.put(astro.tool.box.enumeration.Color.H_K, this.getH_K());
        colors.put(astro.tool.box.enumeration.Color.J_K, this.getJ_K());
        colors.put(astro.tool.box.enumeration.Color.K_W1, this.getK_W1());
        colors.put(astro.tool.box.enumeration.Color.e_M_G, this.getAbsoluteGmag() - this.getAbsoluteGmagError());
        colors.put(astro.tool.box.enumeration.Color.e_M_BP, this.getAbsoluteBPmag() - this.getAbsoluteBPmagError());
        colors.put(astro.tool.box.enumeration.Color.e_M_RP, this.getAbsoluteRPmag() - this.getAbsoluteRPmagError());
        colors.put(astro.tool.box.enumeration.Color.e_G_RP, this.getG_RP() - this.getG_RP_err());
        colors.put(astro.tool.box.enumeration.Color.e_BP_RP, this.getBP_RP() - this.getBP_RP_err());
        colors.put(astro.tool.box.enumeration.Color.e_BP_G, this.getBP_G() - this.getBP_G_err());
        colors.put(astro.tool.box.enumeration.Color.E_M_G, this.getAbsoluteGmag() + this.getAbsoluteGmagError());
        colors.put(astro.tool.box.enumeration.Color.E_M_BP, this.getAbsoluteBPmag() + this.getAbsoluteBPmagError());
        colors.put(astro.tool.box.enumeration.Color.E_M_RP, this.getAbsoluteRPmag() + this.getAbsoluteRPmagError());
        colors.put(astro.tool.box.enumeration.Color.E_G_RP, this.getG_RP() + this.getG_RP_err());
        colors.put(astro.tool.box.enumeration.Color.E_BP_RP, this.getBP_RP() + this.getBP_RP_err());
        colors.put(astro.tool.box.enumeration.Color.E_BP_G, this.getBP_G() + this.getBP_G_err());
        colors.put(astro.tool.box.enumeration.Color.e_u_g, this.get_u_g() - this.get_u_g_err());
        colors.put(astro.tool.box.enumeration.Color.e_g_r, this.get_g_r() - this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.e_r_i, this.get_r_i() - this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.e_i_z, this.get_i_z() - this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.E_u_g, this.get_u_g() + this.get_u_g_err());
        colors.put(astro.tool.box.enumeration.Color.E_g_r, this.get_g_r() + this.get_g_r_err());
        colors.put(astro.tool.box.enumeration.Color.E_r_i, this.get_r_i() + this.get_r_i_err());
        colors.put(astro.tool.box.enumeration.Color.E_i_z, this.get_i_z() + this.get_i_z_err());
        colors.put(astro.tool.box.enumeration.Color.e_W1_W2, this.getW1_W2() - this.getW1_W2_err());
        colors.put(astro.tool.box.enumeration.Color.e_W1_W3, this.getW1_W3() - this.getW1_W3_err());
        colors.put(astro.tool.box.enumeration.Color.e_W1_W4, this.getW1_W4() - this.getW1_W4_err());
        colors.put(astro.tool.box.enumeration.Color.e_J_H, this.getJ_H() - this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.e_H_K, this.getH_K() - this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.e_J_K, this.getJ_K() - this.getJ_K_err());
        colors.put(astro.tool.box.enumeration.Color.e_K_W1, this.getK_W1() - this.getK_W1_err());
        colors.put(astro.tool.box.enumeration.Color.E_W1_W2, this.getW1_W2() + this.getW1_W2_err());
        colors.put(astro.tool.box.enumeration.Color.E_W1_W3, this.getW1_W3() + this.getW1_W3_err());
        colors.put(astro.tool.box.enumeration.Color.E_W1_W4, this.getW1_W4() + this.getW1_W4_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_H, this.getJ_H() + this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.E_H_K, this.getH_K() + this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_K, this.getJ_K() + this.getJ_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_K_W1, this.getK_W1() + this.getK_W1_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.Gmag != 0.0) {
            mags.append("G=").append(NumericFunctions.roundTo3DecNZ(this.Gmag)).append(" ");
        }
        if (this.BPmag != 0.0) {
            mags.append("BP=").append(NumericFunctions.roundTo3DecNZ(this.BPmag)).append(" ");
        }
        if (this.RPmag != 0.0) {
            mags.append("RP=").append(NumericFunctions.roundTo3DecNZ(this.RPmag)).append(" ");
        }
        if (this.Bmag != 0.0) {
            mags.append("B=").append(NumericFunctions.roundTo3DecNZ(this.Bmag)).append(" ");
        }
        if (this.Vmag != 0.0) {
            mags.append("V=").append(NumericFunctions.roundTo3DecNZ(this.Vmag)).append(" ");
        }
        if (this.u_mag != 0.0) {
            mags.append("u=").append(NumericFunctions.roundTo3DecNZ(this.u_mag)).append(" ");
        }
        if (this.g_mag != 0.0) {
            mags.append("g=").append(NumericFunctions.roundTo3DecNZ(this.g_mag)).append(" ");
        }
        if (this.r_mag != 0.0) {
            mags.append("r=").append(NumericFunctions.roundTo3DecNZ(this.r_mag)).append(" ");
        }
        if (this.i_mag != 0.0) {
            mags.append("i=").append(NumericFunctions.roundTo3DecNZ(this.i_mag)).append(" ");
        }
        if (this.z_mag != 0.0) {
            mags.append("z=").append(NumericFunctions.roundTo3DecNZ(this.z_mag)).append(" ");
        }
        if (this.W1mag != 0.0) {
            mags.append("W1=").append(NumericFunctions.roundTo3DecNZ(this.W1mag)).append(" ");
        }
        if (this.W2mag != 0.0) {
            mags.append("W2=").append(NumericFunctions.roundTo3DecNZ(this.W2mag)).append(" ");
        }
        if (this.W3mag != 0.0) {
            mags.append("W3=").append(NumericFunctions.roundTo3DecNZ(this.W3mag)).append(" ");
        }
        if (this.W4mag != 0.0) {
            mags.append("W4=").append(NumericFunctions.roundTo3DecNZ(this.W4mag)).append(" ");
        }
        if (this.Jmag != 0.0) {
            mags.append("J=").append(NumericFunctions.roundTo3DecNZ(this.Jmag)).append(" ");
        }
        if (this.Hmag != 0.0) {
            mags.append("H=").append(NumericFunctions.roundTo3DecNZ(this.Hmag)).append(" ");
        }
        if (this.Kmag != 0.0) {
            mags.append("K=").append(NumericFunctions.roundTo3DecNZ(this.Kmag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return this.plx;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return AstrometricFunctions.calculateParallacticDistance(this.plx);
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getAbsoluteRPmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.RPmag, this.plx);
    }

    public double getAbsoluteBPmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.BPmag, this.plx);
    }

    public double getAbsoluteGmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.Gmag, this.G_err, this.plx, this.plx_err);
    }

    public double getAbsoluteRPmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.RPmag, this.RP_err, this.plx, this.plx_err);
    }

    public double getAbsoluteBPmagError() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallaxError(this.BPmag, this.BP_err, this.plx, this.plx_err);
    }

    @Override
    public double getAbsoluteGmag() {
        return PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(this.Gmag, this.plx);
    }

    public double getG_RP() {
        if (this.Gmag == 0.0 || this.RPmag == 0.0) {
            return 0.0;
        }
        return this.Gmag - this.RPmag;
    }

    @Override
    public double getBP_RP() {
        if (this.BPmag == 0.0 || this.RPmag == 0.0) {
            return 0.0;
        }
        return this.BPmag - this.RPmag;
    }

    public double getBP_G() {
        if (this.BPmag == 0.0 || this.Gmag == 0.0) {
            return 0.0;
        }
        return this.BPmag - this.Gmag;
    }

    public double getB_V() {
        if (this.Bmag == 0.0 || this.Vmag == 0.0) {
            return 0.0;
        }
        return this.Bmag - this.Vmag;
    }

    public double get_u_g() {
        if (this.u_mag == 0.0 || this.g_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.u_mag - ABOffset.u.val - (this.g_mag - ABOffset.g.val);
        }
        return this.u_mag - this.g_mag;
    }

    public double get_g_r() {
        if (this.g_mag == 0.0 || this.r_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.g_mag - ABOffset.g.val - (this.r_mag - ABOffset.r.val);
        }
        return this.g_mag - this.r_mag;
    }

    public double get_r_i() {
        if (this.r_mag == 0.0 || this.i_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.r_mag - ABOffset.r.val - (this.i_mag - ABOffset.i.val);
        }
        return this.r_mag - this.i_mag;
    }

    public double get_i_z() {
        if (this.i_mag == 0.0 || this.z_mag == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return this.i_mag - ABOffset.i.val - (this.z_mag - ABOffset.z.val);
        }
        return this.i_mag - this.z_mag;
    }

    public double getW1_W2() {
        if (this.W1mag == 0.0 || this.W2mag == 0.0 || this.getW1_W2_err() == 0.0) {
            return 0.0;
        }
        return this.W1mag - this.W2mag;
    }

    public double getW1_W3() {
        if (this.W1mag == 0.0 || this.W3mag == 0.0 || this.getW1_W3_err() == 0.0) {
            return 0.0;
        }
        return this.W1mag - this.W3mag;
    }

    public double getW1_W4() {
        if (this.W1mag == 0.0 || this.W4mag == 0.0 || this.getW1_W4_err() == 0.0) {
            return 0.0;
        }
        return this.W1mag - this.W4mag;
    }

    public double getW2_W3() {
        if (this.W2mag == 0.0 || this.W3mag == 0.0 || this.getW2_W3_err() == 0.0) {
            return 0.0;
        }
        return this.W2mag - this.W3mag;
    }

    public double getW3_W4() {
        if (this.W3mag == 0.0 || this.W4mag == 0.0 || this.getW3_W4_err() == 0.0) {
            return 0.0;
        }
        return this.W3mag - this.W4mag;
    }

    public double getJ_H() {
        if (this.Jmag == 0.0 || this.Hmag == 0.0 || this.getJ_H_err() == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.Hmag;
    }

    public double getH_K() {
        if (this.Hmag == 0.0 || this.Kmag == 0.0 || this.getH_K_err() == 0.0) {
            return 0.0;
        }
        return this.Hmag - this.Kmag;
    }

    public double getJ_K() {
        if (this.Jmag == 0.0 || this.Kmag == 0.0 || this.getJ_K_err() == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.Kmag;
    }

    public double getK_W1() {
        if (this.Kmag == 0.0 || this.W1mag == 0.0 || this.getK_W1_err() == 0.0) {
            return 0.0;
        }
        return this.Kmag - this.W1mag;
    }

    public double getJ_W2() {
        if (this.Jmag == 0.0 || this.W2mag == 0.0 || this.getJ_W2_err() == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.W2mag;
    }

    public double getBP_RP_err() {
        if (this.BP_err == 0.0 || this.RP_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.BP_err, this.RP_err);
    }

    public double getG_RP_err() {
        if (this.G_err == 0.0 || this.RP_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.G_err, this.RP_err);
    }

    public double getBP_G_err() {
        if (this.BP_err == 0.0 || this.G_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.BP_err, this.G_err);
    }

    public double get_u_g_err() {
        if (this.u_err == 0.0 || this.g_err == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return AstrometricFunctions.calculateAdditionError(this.u_err - ABOffset.u.val, this.g_err - ABOffset.g.val);
        }
        return AstrometricFunctions.calculateAdditionError(this.u_err, this.g_err);
    }

    public double get_g_r_err() {
        if (this.g_err == 0.0 || this.r_err == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return AstrometricFunctions.calculateAdditionError(this.g_err - ABOffset.g.val, this.r_err - ABOffset.r.val);
        }
        return AstrometricFunctions.calculateAdditionError(this.g_err, this.r_err);
    }

    public double get_r_i_err() {
        if (this.r_err == 0.0 || this.i_err == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return AstrometricFunctions.calculateAdditionError(this.r_err - ABOffset.r.val, this.i_err - ABOffset.i.val);
        }
        return AstrometricFunctions.calculateAdditionError(this.r_err, this.i_err);
    }

    public double get_i_z_err() {
        if (this.i_err == 0.0 || this.z_err == 0.0) {
            return 0.0;
        }
        if (this.toVega) {
            return AstrometricFunctions.calculateAdditionError(this.i_err - ABOffset.i.val, this.z_err - ABOffset.z.val);
        }
        return AstrometricFunctions.calculateAdditionError(this.i_err, this.z_err);
    }

    public double getW1_W2_err() {
        if (this.W1_err == 0.0 || this.W2_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W1_err, this.W2_err);
    }

    public double getW1_W3_err() {
        if (this.W1_err == 0.0 || this.W3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W1_err, this.W3_err);
    }

    public double getW1_W4_err() {
        if (this.W1_err == 0.0 || this.W4_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W1_err, this.W4_err);
    }

    public double getW2_W3_err() {
        if (this.W2_err == 0.0 || this.W3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W2_err, this.W3_err);
    }

    public double getW3_W4_err() {
        if (this.W3_err == 0.0 || this.W4_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.W3_err, this.W4_err);
    }

    public double getJ_H_err() {
        if (this.J_err == 0.0 || this.H_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.J_err, this.H_err);
    }

    public double getH_K_err() {
        if (this.H_err == 0.0 || this.K_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.H_err, this.K_err);
    }

    public double getJ_K_err() {
        if (this.J_err == 0.0 || this.K_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.J_err, this.K_err);
    }

    public double getK_W1_err() {
        if (this.K_err == 0.0 || this.W1_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.K_err, this.W1_err);
    }

    public double getJ_W2_err() {
        if (this.J_err == 0.0 || this.W2_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.J_err, this.W2_err);
    }

    public double getTeff() {
        return this.teff;
    }

    public double getTeff_err() {
        return this.teff_err;
    }

    public double getLogg() {
        return this.logg;
    }

    public double getLogg_err() {
        return this.logg_err;
    }

    public double getRad() {
        return this.rad;
    }

    public double getRad_err() {
        return this.rad_err;
    }

    public double getMass() {
        return this.mass;
    }

    public double getMass_err() {
        return this.mass_err;
    }

    public double getLum() {
        return this.lum;
    }

    public double getLum_err() {
        return this.lum_err;
    }
}

