/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TwoMassCatalogEntry
implements CatalogEntry,
Extinction {
    public static final String CATALOG_NAME = "2MASS";
    public static final String NEW_LINE = "<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private String sourceId;
    private double ra;
    private double dec;
    private double Jmag;
    private double J_err;
    private double Hmag;
    private double H_err;
    private double Kmag;
    private double K_err;
    private String xdate;
    private String ph_qual;
    private String rd_flg;
    private String bl_flg;
    private String cc_flg;
    private int gal_contam;
    private int mp_flg;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public TwoMassCatalogEntry() {
    }

    public TwoMassCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        if (MiscUtils.isVizierTAP()) {
            this.sourceId = values[columns.get(CATALOG_NAME)];
            this.ra = NumericFunctions.toDouble(values[columns.get("RAJ2000")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("DEJ2000")]);
            this.Jmag = NumericFunctions.toDouble(values[columns.get("Jmag")]);
            this.J_err = NumericFunctions.toDouble(values[columns.get("e_Jmag")]);
            this.Hmag = NumericFunctions.toDouble(values[columns.get("Hmag")]);
            this.H_err = NumericFunctions.toDouble(values[columns.get("e_Hmag")]);
            this.Kmag = NumericFunctions.toDouble(values[columns.get("Kmag")]);
            this.K_err = NumericFunctions.toDouble(values[columns.get("e_Kmag")]);
            this.xdate = values[columns.get("Date")];
            this.ph_qual = values[columns.get("Qflg")];
            this.rd_flg = values[columns.get("Rflg")];
            this.bl_flg = values[columns.get("Bflg")];
            this.cc_flg = values[columns.get("Cflg")];
            this.gal_contam = NumericFunctions.toInteger(values[columns.get("Xflg")]);
            this.mp_flg = NumericFunctions.toInteger(values[columns.get("Aflg")]);
        } else {
            MiscUtils.replaceNanValuesByZero(values);
            this.sourceId = values[columns.get("designation")];
            this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
            this.Jmag = NumericFunctions.toDouble(values[columns.get("j_m")]);
            this.J_err = NumericFunctions.toDouble(values[columns.get("j_cmsig")]);
            this.Hmag = NumericFunctions.toDouble(values[columns.get("h_m")]);
            this.H_err = NumericFunctions.toDouble(values[columns.get("h_cmsig")]);
            this.Kmag = NumericFunctions.toDouble(values[columns.get("k_m")]);
            this.K_err = NumericFunctions.toDouble(values[columns.get("k_cmsig")]);
            this.xdate = values[columns.get("date")];
            this.ph_qual = values[columns.get("ph_qual")];
            this.rd_flg = values[columns.get("rd_flg")];
            this.bl_flg = values[columns.get("bl_flg")];
            this.cc_flg = values[columns.get("cc_flg")];
            this.gal_contam = NumericFunctions.toInteger(values[columns.get("gal_contam")]);
            this.mp_flg = NumericFunctions.toInteger(values[columns.get("mp_flg")]);
        }
    }

    @Override
    public CatalogEntry copy() {
        return new TwoMassCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", this.sourceId, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("observation date", this.xdate, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("ph. qual.", this.ph_qual, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), TwoMassCatalogEntry.createToolTip_ph_qual()));
        this.catalogElements.add(new CatalogElement("read flag", this.rd_flg, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), TwoMassCatalogEntry.createToolTip_rd_flg()));
        this.catalogElements.add(new CatalogElement("blend flag", this.bl_flg, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), TwoMassCatalogEntry.createToolTip_bl_flg()));
        this.catalogElements.add(new CatalogElement("cc flags", this.cc_flg, Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), TwoMassCatalogEntry.createToolTip_cc_flg()));
        this.catalogElements.add(new CatalogElement("ext. flag", String.valueOf(this.gal_contam), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), TwoMassCatalogEntry.createToolTip_gal_contam()));
        this.catalogElements.add(new CatalogElement("minor planet flag", String.valueOf(this.mp_flg), Alignment.RIGHT, (Comparator<String>)Comparators.getIntegerComparator(), TwoMassCatalogEntry.createToolTip_mp_flg()));
        this.catalogElements.add(new CatalogElement("J (mag)", NumericFunctions.roundTo3DecNZ(this.Jmag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("J err", NumericFunctions.roundTo3DecNZ(this.J_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H (mag)", NumericFunctions.roundTo3DecNZ(this.Hmag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("H err", NumericFunctions.roundTo3DecNZ(this.H_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("K (mag)", NumericFunctions.roundTo3DecNZ(this.Kmag), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("K err", NumericFunctions.roundTo3DecNZ(this.K_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J-H", NumericFunctions.roundTo3DecNZ(this.getJ_H()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("H-K", NumericFunctions.roundTo3DecNZ(this.getH_K()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
        this.catalogElements.add(new CatalogElement("J-K", NumericFunctions.roundTo3DecNZ(this.getJ_K()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public static String createToolTip_ph_qual() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Photometric quality flag (ph. qual.):</b>").append("<br/>");
        toolTip.append("\"X\" - There is a detection at this location, but no valid brightness estimate can be extracted using any algorithm. rd_flg=\"9\" and default magnitude is null.").append("<br/>");
        toolTip.append("\"U\" - Upper limit on magnitude. Source is not detected in this band (rd_flg=\"0\"), or it is detected, but not resolved in a consistent fashion with other bands (rd_flg=\"6\").").append(NEW_LINE).append("A value of ph_qual=\"U\" does not necessarily mean that there is no flux detected in this band at the location.").append(NEW_LINE).append("Whether or not flux has been detected can be determined from the value of rd_flg. When rd_flg=\"0\", no flux has been detected.").append(NEW_LINE).append("When rd_flg=\"6\", flux has been detected at the location where the images were not deblended consistently in all three bands (JHKs).").append("<br/>");
        toolTip.append("\"F\" - This category includes rd_flg=\"1\" or rd_flg=\"3\" sources where a reliable estimate of the photometric error, [jhk]_cmsig, could not be determined.").append(NEW_LINE).append("The uncertainties reported for these sources in [jhk]_cmsig and [jhk]_msigcom are flags and have numeric values &gt; 8.0.").append("<br/>");
        toolTip.append("\"E\" - This category includes detections where the goodness-of-fit quality of the profile-fit photometry was very poor (rd_flg=2 and [jhk]psf_chi &gt; 10.0),").append(NEW_LINE).append("or detections where psf fit photometry did not converge and an aperture magnitude is reported (rd_flg=4),").append(NEW_LINE).append("or detections where the number of frames was too small in relation to the number of frames in which a detection was geometrically possible (rd_flg=\"1\" or rd_flg=\"2\").").append("<br/>");
        toolTip.append("\"A\" - Detections in any brightness regime where valid measurements were made (rd_flg=\"1\",\"2\" or \"3\") with [jhk]_snr &gt; 10 AND [jhk]_cmsig &lt; 0.10857.").append("<br/>");
        toolTip.append("\"B\" - Detections in any brightness regime where valid measurements were made (rd_flg=\"1\",\"2\" or \"3\") with [jhk]_snr &gt; 7 AND [jhk]_cmsig &lt; 0.15510.").append("<br/>");
        toolTip.append("\"C\" - Detections in any brightness regime where valid measurements were made (rd_flg=\"1\",\"2\" or \"3\") with [jhk]_snr &gt; 5 AND [jhk]_cmsig &lt; 0.21714.").append("<br/>");
        toolTip.append("\"D\" - Detections in any brightness regime where valid measurements were made (rd_flg=\"1\",\"2\" or \"3\") with no [jhk]_snr or [jhk]_cmsig requirement.");
        return toolTip.toString();
    }

    public static String createToolTip_rd_flg() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Read flag:</b>").append("<br/>");
        toolTip.append("\"0\" - Source is not detected in this band. The default magnitude is the 95% confidence upper limit derived from a 4\" radius aperture measurement taken at the position").append(NEW_LINE).append(" of the source on the Atlas Image. The sky background is estimated in an annular region with inner radius of 14\" and outer radius of 20\".").append("<br/>");
        toolTip.append("\"1\" - The default magnitude is derived from aperture photometry measurements on the 51 ms \"Read_1\" exposures.").append(NEW_LINE).append("The aperture radius is 4\", with the sky background measured in an annulus with an inner radius of 14\" and an outer radius of 20\".").append(NEW_LINE).append("Used for sources that saturate one or more of the 1.3s \"Read_2\" exposures, but are not saturated on at least one of the 51 ms \"Read_1\" frames.").append("<br/>");
        toolTip.append("\"2\" - The default magnitude is derived from a profile-fitting measurement made on the 1.3 sec \"Read_2\" exposures.").append(NEW_LINE).append("The profile-fit magnitudes are normalized to curve-of-growth-corrected aperture magnitudes.").append(NEW_LINE).append("This is the most common type in the PSC, and is used for sources that have no saturated pixels in any of the 1.3 sec exposures.").append("<br/>");
        toolTip.append("\"3\" - The default magnitude is derived from a 1-d radial profile fitting measurement made on the 51 ms \"Read_1\" exposures.").append(NEW_LINE).append("Used for very bright sources that saturate all of the 51 ms \"Read 1\" exposures.").append("<br/>");
        toolTip.append("\"4\" - The default magnitude is derived from curve-of-growth-corrected 4\" radius aperture photometry measurements on the 1.3 s \"Read_2\" exposures.").append(NEW_LINE).append("This is used for sources that are not saturated in any of the Read_2 frames,").append(NEW_LINE).append("but where the profile-fitting measurements fail to converge to a solution. These magnitudes are the same as the standard aperture magnitudes (j_m_stdap, h_m_stdap, k_m_stdap),").append(NEW_LINE).append("but when they are the default magnitudes, it generally implies that they are low quality measurements.").append("<br/>");
        toolTip.append("\"6\" - The default magnitude is the 95% confidence upper limit derived from a 4\" radius aperture measurement taken at the position of the source on the Atlas Image.").append(NEW_LINE).append("The sky background is estimated in an annular region with inner radius of 14\" and outer radius of 20\".").append(NEW_LINE).append("This is used for pairs of sources which are detected and resolved in another band, but are detected and not resolved in this band.").append(NEW_LINE).append("This differs from a rd_flg=\"0\" because in this case there is a detection of the source in this band, but it is not consistently resolved across all bands.").append("<br/>");
        toolTip.append("\"9\" - The default magnitude is the 95% confidence upper limit derived from a 4\" radius aperture measurement taken at the position of the source on the Atlas Image.").append(NEW_LINE).append("The sky background is estimated in an annular region with inner radius of 14\" and outer radius of 20\".").append(NEW_LINE).append("This is used for sources that were nominally detected in this band, but which could not have a useful brightness measurement from either profile fitting or aperture photometry.").append(NEW_LINE).append("This often occurs in highly confused regions, or very near Tile edges where a significant fraction of the measurement aperture of sky annulus falls off the focal plane.");
        return toolTip.toString();
    }

    public static String createToolTip_bl_flg() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Blend flag:</b>").append("<br/>");
        toolTip.append("\"0\" - Source is not detected, or is inconsistently deblended in that band.").append("<br/>");
        toolTip.append("\"1\" - One component was fit to the source in R_2 profile-fitting photometry (rd_flg=\"2\"), or default magnitudes are from aperture photometry (rd_flg=\"1\" or \"4\")").append(NEW_LINE).append("or saturated star 1-d radial profile-fitting (rd_flg=\"3\").").append("<br/>");
        toolTip.append("\"&gt;1\" - More than one component was fit simultaneously during R2 profile-fit photometry, where the value of the field is the number of components simultaneously fit.").append(NEW_LINE).append("The maximum number of components is 7 in any band for the PSC, so this bl_flg is always a three character flag.").append(NEW_LINE).append("Multi-component fitting occurs only for profile-fitting, and only when more than one detection is found within ~5\".").append(NEW_LINE).append("Single detections that are not well-fit by a single PSF are not split.");
        return toolTip.toString();
    }

    public static String createToolTip_cc_flg() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Contamination and confusion flags (cc flags):</b>").append("<br/>");
        toolTip.append("\"p\" = Persistence. Source may be contaminated by a latent image left by a nearby bright star.").append("<br/>");
        toolTip.append("\"c\" = Photometric Confusion. Source photometry is biased by a nearby star that has contaminated the background estimation.").append(NEW_LINE).append("This is very common in high source density regions.").append("<br/>");
        toolTip.append("\"d\" = Diffraction spike confusion. Source may be contaminated by a diffraction spike from a nearby star.").append("<br/>");
        toolTip.append("\"s\" = Electronic stripe. Source measurement may be contaminated by a stripe from a nearby bright star.").append("<br/>");
        toolTip.append("\"b\" = Bandmerge confusion. In the process of merging detections in the different bands for this source,").append(NEW_LINE).append("there was more than one possible match between the different band components.").append(NEW_LINE).append("This occurs in regions of very high source density, or when multiple sources were split in one band but not another.").append("<br/>");
        toolTip.append("\"0\" = Source is unaffected by known artifacts, or is not detected in the band.");
        return toolTip.toString();
    }

    public static String createToolTip_gal_contam() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Extended source flag (ext. flag):</b>").append("<br/>");
        toolTip.append("\"0\" - Source does not fall within the elliptical profile of an extended source with semi-major axis &gt; 10'',").append(NEW_LINE).append("or it is not identified exactly with an XSC source with semi-major axis &gt; 10''.").append(NEW_LINE).append("However, the source may correspond exactly to a smaller XSC source.").append("<br/>");
        toolTip.append("\"1\" - Source is resolved by 2MASS, and is equivalent to a source in the XSC that has a semi-major axis &gt; 10'' in size.").append("<br/>");
        toolTip.append("\"2\" - Source falls within the elliptical boundary of an XSC source that has a semi-major axis &gt; 10'' in size.");
        return toolTip.toString();
    }

    public static String createToolTip_mp_flg() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append("<b>Minor planet flag:</b>").append("<br/>");
        toolTip.append("\"0\" - Source is not associated with a known solar system object.").append("<br/>");
        toolTip.append("\"1\" - Source is associated with the predicted position of a known solar system object.");
        return toolTip.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.sourceId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TwoMassCatalogEntry other = (TwoMassCatalogEntry)obj;
        return Objects.equals(this.sourceId, other.sourceId);
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new TwoMassCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.ORANGE.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return ServiceHelper.createVizieRUrl(this.ra, this.dec, this.searchRadius / 3600.0, "II/246/out", "RAJ2000", "DEJ2000");
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltCatalogQuery());
    }

    private String createAltCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT designation,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       j_m,");
        MiscUtils.addRow(query, "       j_cmsig,");
        MiscUtils.addRow(query, "       h_m,");
        MiscUtils.addRow(query, "       h_cmsig,");
        MiscUtils.addRow(query, "       k_m,");
        MiscUtils.addRow(query, "       k_cmsig,");
        MiscUtils.addRow(query, "       date,");
        MiscUtils.addRow(query, "       ph_qual,");
        MiscUtils.addRow(query, "       rd_flg,");
        MiscUtils.addRow(query, "       bl_flg,");
        MiscUtils.addRow(query, "       cc_flg,");
        MiscUtils.addRow(query, "       gal_contam,");
        MiscUtils.addRow(query, "       mp_flg");
        MiscUtils.addRow(query, "FROM   twomass.psc");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + this.xdate + "," + this.ph_qual + "," + this.rd_flg + "," + this.bl_flg + "," + this.cc_flg + "," + this.gal_contam + "," + this.mp_flg + "," + NumericFunctions.roundTo3Dec(this.Jmag) + "," + NumericFunctions.roundTo3Dec(this.J_err) + "," + NumericFunctions.roundTo3Dec(this.Hmag) + "," + NumericFunctions.roundTo3Dec(this.H_err) + "," + NumericFunctions.roundTo3Dec(this.Kmag) + "," + NumericFunctions.roundTo3Dec(this.K_err) + "," + NumericFunctions.roundTo3Dec(this.getJ_H()) + "," + NumericFunctions.roundTo3Dec(this.getH_K()) + "," + NumericFunctions.roundTo3Dec(this.getJ_K());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,observation date,ph. qual.,read flag,blend flag,cc flags,ext. flag,minor planet flag,J (mag),J err,H (mag),H err,K (mag),K err,J-H,H-K,J-K";
        return columnTitles.split(",", -1);
    }

    @Override
    public void applyExtinctionCorrection(Map<String, Double> extinctionsByBand) {
        if (this.Jmag != 0.0) {
            this.Jmag -= extinctionsByBand.get("2MASS J").doubleValue();
        }
        if (this.Hmag != 0.0) {
            this.Hmag -= extinctionsByBand.get("2MASS H").doubleValue();
        }
        if (this.Kmag != 0.0) {
            this.Kmag -= extinctionsByBand.get("2MASS Ks").doubleValue();
        }
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        if (this.J_err != 0.0) {
            bands.put(Band.J, new NumberPair(this.Jmag, this.J_err));
        }
        if (this.H_err != 0.0) {
            bands.put(Band.H, new NumberPair(this.Hmag, this.H_err));
        }
        if (this.K_err != 0.0) {
            bands.put(Band.K, new NumberPair(this.Kmag, this.K_err));
        }
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.J_H, this.getJ_H());
        colors.put(astro.tool.box.enumeration.Color.H_K, this.getH_K());
        colors.put(astro.tool.box.enumeration.Color.J_K, this.getJ_K());
        colors.put(astro.tool.box.enumeration.Color.e_J_H, this.getJ_H() - this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.e_H_K, this.getH_K() - this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.e_J_K, this.getJ_K() - this.getJ_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_H, this.getJ_H() + this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.E_H_K, this.getH_K() + this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_K, this.getJ_K() + this.getJ_K_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.Jmag != 0.0) {
            mags.append("J=").append(NumericFunctions.roundTo3DecNZ(this.Jmag)).append(" ");
        }
        if (this.Hmag != 0.0) {
            mags.append("H=").append(NumericFunctions.roundTo3DecNZ(this.Hmag)).append(" ");
        }
        if (this.Kmag != 0.0) {
            mags.append("K=").append(NumericFunctions.roundTo3DecNZ(this.Kmag)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.Jmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.Jmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.J_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.Hmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.Hmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.H_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.Kmag != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.Kmag)).append(",").append(NumericFunctions.roundTo3DecNZ(this.K_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return 0.0;
    }

    @Override
    public double getPmdec() {
        return 0.0;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return 0.0;
    }

    public LocalDateTime getObsDate() {
        return LocalDateTime.parse(this.xdate + "T00:00:00");
    }

    public double getJ_H() {
        if (this.Jmag == 0.0 || this.Hmag == 0.0 || this.getJ_H_err() == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.Hmag;
    }

    public double getH_K() {
        if (this.Hmag == 0.0 || this.Kmag == 0.0 || this.getH_K_err() == 0.0) {
            return 0.0;
        }
        return this.Hmag - this.Kmag;
    }

    public double getJ_K() {
        if (this.Jmag == 0.0 || this.Kmag == 0.0 || this.getJ_K_err() == 0.0) {
            return 0.0;
        }
        return this.Jmag - this.Kmag;
    }

    public double getJ_H_err() {
        if (this.J_err == 0.0 || this.H_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.J_err, this.H_err);
    }

    public double getH_K_err() {
        if (this.H_err == 0.0 || this.K_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.H_err, this.K_err);
    }

    public double getJ_K_err() {
        if (this.J_err == 0.0 || this.K_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.J_err, this.K_err);
    }

    public double getJmag() {
        return this.Jmag;
    }

    public double getHmag() {
        return this.Hmag;
    }

    public double getKmag() {
        return this.Kmag;
    }

    public double getJ_err() {
        return this.J_err;
    }

    public double getH_err() {
        return this.H_err;
    }

    public double getK_err() {
        return this.K_err;
    }
}

