/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.ProperMotionCatalog;
import astro.tool.box.catalog.ProperMotionQuery;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.util.Comparators;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class UhsCatalogEntry
implements CatalogEntry,
ProperMotionQuery,
ProperMotionCatalog {
    public static final String CATALOG_NAME = "UHS DR3";
    private long sourceId;
    private double ra;
    private double ra_err;
    private double dec;
    private double dec_err;
    private double pmra;
    private double pmra_err;
    private double pmdec;
    private double pmdec_err;
    private int objectType;
    private double epoch;
    private double j_ap3;
    private double j_ap3_err;
    private double h_ap3;
    private double h_ap3_err;
    private double ks_ap3;
    private double ks_ap3_err;
    private double y_j_pnt;
    private double j_h_pnt;
    private double h_ks_pnt;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private double tpm;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;
    private static final Map<Integer, String> TYPE_TABLE = new HashMap<Integer, String>();

    public UhsCatalogEntry() {
    }

    public UhsCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        this.sourceId = NumericFunctions.toLong(values[columns.get("sourceID")]);
        this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
        this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
        this.ra_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("sigRa")]));
        this.dec_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("sigDec")]));
        this.pmra = this.fixValue(NumericFunctions.toDouble(values[columns.get("muRa")]));
        this.pmra_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("sigMuRa")]));
        this.pmdec = this.fixValue(NumericFunctions.toDouble(values[columns.get("muDec")]));
        this.pmdec_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("sigMuDec")]));
        this.epoch = NumericFunctions.toDouble(values[columns.get("epoch")]);
        this.objectType = NumericFunctions.toInteger(values[columns.get("mergedClass")]);
        this.j_ap3 = this.fixValue(NumericFunctions.toDouble(values[columns.get("jAperMag3")]));
        this.j_ap3_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("jAperMag3Err")]));
        this.h_ap3 = this.fixValue(NumericFunctions.toDouble(values[columns.get("hAperMag3")]));
        this.h_ap3_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("hAperMag3Err")]));
        this.ks_ap3 = this.fixValue(NumericFunctions.toDouble(values[columns.get("kAperMag3")]));
        this.ks_ap3_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("kAperMag3Err")]));
        this.j_h_pnt = this.fixValue(NumericFunctions.toDouble(values[columns.get("jmhPnt")]));
        this.h_ks_pnt = this.fixValue(NumericFunctions.toDouble(values[columns.get("hmkPnt")]));
    }

    private double fixValue(double value) {
        return value < -999999.0 ? 0.0 : value;
    }

    @Override
    public CatalogEntry copy() {
        return new UhsCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("ra err", NumericFunctions.roundTo7DecNZ(this.ra_err), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec err", NumericFunctions.roundTo7DecNZ(this.dec_err), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmra), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra err", NumericFunctions.roundTo3DecNZ(this.pmra_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmra, this.pmra_err)));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmdec), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmdec err", NumericFunctions.roundTo3DecNZ(this.pmdec_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmdec, this.pmdec_err)));
        this.catalogElements.add(new CatalogElement("object type", TYPE_TABLE.get(this.objectType), Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("epoch", NumericFunctions.roundTo3DecNZ(this.epoch), Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("J (mag)", NumericFunctions.roundTo3DecNZ(this.j_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("J err", NumericFunctions.roundTo3DecNZ(this.j_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H (mag)", NumericFunctions.roundTo3DecNZ(this.h_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("H err", NumericFunctions.roundTo3DecNZ(this.h_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Ks (mag)", NumericFunctions.roundTo3DecNZ(this.ks_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("Ks err", NumericFunctions.roundTo3DecNZ(this.ks_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Y-J", NumericFunctions.roundTo3DecNZ(this.y_j_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J-H", NumericFunctions.roundTo3DecNZ(this.j_h_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H-Ks", NumericFunctions.roundTo3DecNZ(this.h_ks_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J-Ks", NumericFunctions.roundTo3DecNZ(this.getJ_K()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("tpm (mas/yr)", NumericFunctions.roundTo3DecNZ(this.getTotalProperMotion()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public List<CatalogEntry> findCatalogEntries() {
        ArrayList<CatalogEntry> catalogEntries = new ArrayList<CatalogEntry>();
        try {
            double radius = this.getSearchRadius() / 60.0;
            String url = "http://wsa.roe.ac.uk:8080/wsa/WSASQL?database=UHSDR3&programmeID=107&from=source&formaction=region&ra=%f&dec=%f&sys=J&radius=%f&xSize=&ySize=&format=CSV&compress=NONE&select=default";
            String paramUrl = url.formatted(this.getRa(), this.getDec(), radius);
            String htmlContent = UhsCatalogEntry.downloadHtmlFromUrl(paramUrl);
            Document doc = Jsoup.parse(htmlContent);
            Elements links = doc.select("a[href]");
            for (Element link : links) {
                int i;
                String result;
                List<String[]> csvRows;
                String href = link.attr("href");
                if (!href.endsWith(".csv") || (csvRows = UhsCatalogEntry.parseCsvData(result = UhsCatalogEntry.downloadHtmlFromUrl(href))).isEmpty()) continue;
                String[] headers = csvRows.get(0);
                HashMap<String, Integer> headerRow = new HashMap<String, Integer>();
                for (i = 0; i < headers.length; ++i) {
                    headerRow.put(headers[i], i);
                }
                for (i = 1; i < csvRows.size(); ++i) {
                    catalogEntries.add(new UhsCatalogEntry(headerRow, csvRows.get(i)));
                }
                break;
            }
        }
        catch (IOException e) {
            ToolboxHelper.writeErrorLog(e);
            ToolboxHelper.showWarnDialog(null, "%s is currently inaccessible!".formatted(CATALOG_NAME));
        }
        return catalogEntries;
    }

    public List<CatalogEntry> filterCatalogEntries() {
        return this.findCatalogEntries().stream().filter(e -> e.getTotalProperMotion() >= this.tpm).toList();
    }

    @Override
    public String getMotionQueryUrl() {
        return null;
    }

    @Override
    public void setTpm(double tpm) {
        this.tpm = tpm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadHtmlFromUrl(String url) throws IOException {
        StringBuilder content = new StringBuilder();
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        finally {
            connection.disconnect();
        }
        return content.toString();
    }

    public static List<String[]> parseCsvData(String csvData) {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String[] lines = csvData.split("\n");
        boolean isHeader = true;
        for (String line : lines) {
            if (line.trim().isEmpty() || !isHeader && line.trim().startsWith("#")) continue;
            if (isHeader) {
                line = line.replaceFirst("#", "");
                isHeader = false;
            }
            String[] rowValues = line.split(",");
            for (int i = 0; i < rowValues.length; ++i) {
                rowValues[i] = rowValues[i].trim();
            }
            rows.add(rowValues);
        }
        return rows;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (int)(this.sourceId ^ this.sourceId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UhsCatalogEntry other = (UhsCatalogEntry)obj;
        return this.sourceId == other.sourceId;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new UhsCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.DARK_YELLOW.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        return null;
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.ra_err) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo7Dec(this.dec_err) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmra_err) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + NumericFunctions.roundTo3Dec(this.pmdec_err) + "," + TYPE_TABLE.get(this.objectType) + "," + NumericFunctions.roundTo3Dec(this.epoch) + "," + NumericFunctions.roundTo3Dec(this.j_ap3) + "," + NumericFunctions.roundTo3Dec(this.j_ap3_err) + "," + NumericFunctions.roundTo3Dec(this.h_ap3) + "," + NumericFunctions.roundTo3Dec(this.h_ap3_err) + "," + NumericFunctions.roundTo3Dec(this.ks_ap3) + "," + NumericFunctions.roundTo3Dec(this.ks_ap3_err) + "," + NumericFunctions.roundTo3Dec(this.y_j_pnt) + "," + NumericFunctions.roundTo3Dec(this.j_h_pnt) + "," + NumericFunctions.roundTo3Dec(this.h_ks_pnt) + "," + NumericFunctions.roundTo3Dec(this.getJ_K()) + "," + NumericFunctions.roundTo3Dec(this.getTotalProperMotion());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,ra err,dec,dec err,pmra (mas/yr),pmra err,pmdec (mas/yr),pmdec err,object type,epoch,J (mag),J err,H (mag),H err,Ks (mag),Ks err,Y-J,J-H,H-Ks,J-Ks,tpm (mas/yr)";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.J, new NumberPair(this.j_ap3, this.j_ap3_err));
        bands.put(Band.H, new NumberPair(this.h_ap3, this.h_ap3_err));
        bands.put(Band.K, new NumberPair(this.ks_ap3, this.ks_ap3_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.J_H, this.j_h_pnt);
        colors.put(astro.tool.box.enumeration.Color.H_K, this.h_ks_pnt);
        colors.put(astro.tool.box.enumeration.Color.J_K, this.getJ_K());
        colors.put(astro.tool.box.enumeration.Color.e_J_H, this.getJ_H() - this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.e_H_K, this.getH_K() - this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.e_J_K, this.getJ_K() - this.getJ_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_H, this.getJ_H() + this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.E_H_K, this.getH_K() + this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_K, this.getJ_K() + this.getJ_K_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.j_ap3 != 0.0) {
            mags.append("J=").append(NumericFunctions.roundTo4DecNZ(this.j_ap3)).append(" ");
        }
        if (this.h_ap3 != 0.0) {
            mags.append("H=").append(NumericFunctions.roundTo4DecNZ(this.h_ap3)).append(" ");
        }
        if (this.ks_ap3 != 0.0) {
            mags.append("K=").append(NumericFunctions.roundTo4DecNZ(this.ks_ap3)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.j_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.j_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.j_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.h_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.h_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.h_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.ks_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.ks_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.ks_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getPmraErr() {
        return this.pmra_err;
    }

    @Override
    public double getPmdecErr() {
        return this.pmdec_err;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getMeanEpoch() {
        return this.epoch;
    }

    public double getJ_H() {
        return this.j_h_pnt;
    }

    public double getH_K() {
        return this.h_ks_pnt;
    }

    public double getJ_K() {
        if (this.j_ap3 == 0.0 || this.ks_ap3 == 0.0) {
            return 0.0;
        }
        return this.j_ap3 - this.ks_ap3;
    }

    public double getJ_H_err() {
        if (this.j_ap3_err == 0.0 || this.h_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.j_ap3_err, this.h_ap3_err);
    }

    public double getH_K_err() {
        if (this.h_ap3_err == 0.0 || this.ks_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.h_ap3_err, this.ks_ap3_err);
    }

    public double getJ_K_err() {
        if (this.j_ap3_err == 0.0 || this.ks_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.j_ap3_err, this.ks_ap3_err);
    }

    public double getJmag() {
        return this.j_ap3;
    }

    public double getHmag() {
        return this.h_ap3;
    }

    public double getKmag() {
        return this.ks_ap3;
    }

    public double getJ_err() {
        return this.j_ap3_err;
    }

    public double getH_err() {
        return this.h_ap3_err;
    }

    public double getK_err() {
        return this.ks_ap3_err;
    }

    static {
        TYPE_TABLE.put(1, "Galaxy");
        TYPE_TABLE.put(0, "Noise");
        TYPE_TABLE.put(-1, "Star");
        TYPE_TABLE.put(-2, "Probable star");
        TYPE_TABLE.put(-3, "Probable galaxy");
        TYPE_TABLE.put(-9, "Saturated");
    }
}

