/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.ProperMotionCatalog;
import astro.tool.box.catalog.ProperMotionQuery;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UkidssCatalogEntry
implements CatalogEntry,
ProperMotionQuery,
ProperMotionCatalog {
    public static final String CATALOG_NAME = "UKIDSS DR11";
    private long sourceId;
    private double ra;
    private double ra_err;
    private double dec;
    private double dec_err;
    private double pmra;
    private double pmra_err;
    private double pmdec;
    private double pmdec_err;
    private int objectType;
    private double epoch;
    private double y_ap3;
    private double y_ap3_err;
    private double j_ap3;
    private double j_ap3_err;
    private double h_ap3;
    private double h_ap3_err;
    private double ks_ap3;
    private double ks_ap3_err;
    private double y_j_pnt;
    private double j_h_pnt;
    private double h_ks_pnt;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private double tpm;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;
    private Survey survey;
    private static final Map<Integer, String> TYPE_TABLE = new HashMap<Integer, String>();
    private static final Map<Survey, String> SURVEY_LABEL;

    public UkidssCatalogEntry() {
    }

    public UkidssCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        this.sourceId = NumericFunctions.toLong(values[columns.get("sourceid")]);
        this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
        this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
        if (columns.get("sigra") != null) {
            this.ra_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("sigra")]));
            this.dec_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("sigdec")]));
        }
        if (columns.get("mura") != null) {
            this.pmra = this.fixValue(NumericFunctions.toDouble(values[columns.get("mura")]));
            this.pmra_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("sigmura")]));
            this.pmdec = this.fixValue(NumericFunctions.toDouble(values[columns.get("mudec")]));
            this.pmdec_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("sigmudec")]));
            this.epoch = NumericFunctions.toDouble(values[columns.get("epoch")]);
        }
        this.objectType = NumericFunctions.toInteger(values[columns.get("mergedclass")]);
        if (columns.get("yapermag3") != null) {
            this.y_ap3 = this.fixValue(NumericFunctions.toDouble(values[columns.get("yapermag3")]));
            this.y_ap3_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("yapermag3err")]));
            this.y_j_pnt = this.fixValue(NumericFunctions.toDouble(values[columns.get("ymjpnt")]));
        }
        this.j_ap3 = this.fixValue(NumericFunctions.toDouble(values[columns.get("japermag3")]));
        this.j_ap3_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("japermag3err")]));
        this.h_ap3 = this.fixValue(NumericFunctions.toDouble(values[columns.get("hapermag3")]));
        this.h_ap3_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("hapermag3err")]));
        this.ks_ap3 = this.fixValue(NumericFunctions.toDouble(values[columns.get("kapermag3")]));
        this.ks_ap3_err = this.fixValue(NumericFunctions.toDouble(values[columns.get("kapermag3err")]));
        this.j_h_pnt = this.fixValue(NumericFunctions.toDouble(values[columns.get("jmhpnt")]));
        this.h_ks_pnt = this.fixValue(NumericFunctions.toDouble(values[columns.get("hmkpnt")]));
    }

    private double fixValue(double value) {
        return value < -999999.0 ? 0.0 : value;
    }

    @Override
    public CatalogEntry copy() {
        return new UkidssCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("ra err", NumericFunctions.roundTo7DecNZ(this.ra_err), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec err", NumericFunctions.roundTo7DecNZ(this.dec_err), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmra), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmra err", NumericFunctions.roundTo3DecNZ(this.pmra_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmra, this.pmra_err)));
        this.catalogElements.add(new CatalogElement("pmdec (mas/yr)", NumericFunctions.roundTo3DecNZ(this.pmdec), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("pmdec err", NumericFunctions.roundTo3DecNZ(this.pmdec_err), Alignment.RIGHT, Comparators.getDoubleComparator(), false, false, AstrometricFunctions.isProperMotionSpurious(this.pmdec, this.pmdec_err)));
        this.catalogElements.add(new CatalogElement("UKIDSS survey", SURVEY_LABEL.get((Object)this.survey), Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("object type", TYPE_TABLE.get(this.objectType), Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("epoch", NumericFunctions.roundTo3DecNZ(this.epoch), Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("Y (mag)", NumericFunctions.roundTo3DecNZ(this.y_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("Y err", NumericFunctions.roundTo3DecNZ(this.y_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J (mag)", NumericFunctions.roundTo3DecNZ(this.j_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("J err", NumericFunctions.roundTo3DecNZ(this.j_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H (mag)", NumericFunctions.roundTo3DecNZ(this.h_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("H err", NumericFunctions.roundTo3DecNZ(this.h_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Ks (mag)", NumericFunctions.roundTo3DecNZ(this.ks_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("Ks err", NumericFunctions.roundTo3DecNZ(this.ks_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Y-J", NumericFunctions.roundTo3DecNZ(this.y_j_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J-H", NumericFunctions.roundTo3DecNZ(this.j_h_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H-Ks", NumericFunctions.roundTo3DecNZ(this.h_ks_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J-Ks", NumericFunctions.roundTo3DecNZ(this.getJ_K()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("tpm (mas/yr)", NumericFunctions.roundTo3DecNZ(this.getTotalProperMotion()), Alignment.RIGHT, Comparators.getDoubleComparator(), false, true));
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (int)(this.sourceId ^ this.sourceId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UkidssCatalogEntry other = (UkidssCatalogEntry)obj;
        return this.sourceId == other.sourceId;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        UkidssCatalogEntry entry = new UkidssCatalogEntry(columns, values);
        entry.setSurvey(this.survey);
        return entry;
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.BLOOD.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        String catalogQuery = "";
        switch (this.survey) {
            case LAS: {
                catalogQuery = this.createCatalogQueryLAS();
                break;
            }
            case GCS: {
                catalogQuery = this.createCatalogQueryGCS();
                break;
            }
            case GPS: {
                catalogQuery = this.createCatalogQueryGPS();
                break;
            }
            case DXS: {
                catalogQuery = this.createCatalogQueryDXS();
                break;
            }
            case UDS: {
                catalogQuery = this.createCatalogQueryUDS();
            }
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(catalogQuery);
    }

    @Override
    public String getMotionQueryUrl() {
        StringBuilder queryBuilder = new StringBuilder();
        String catalogQuery = "";
        switch (this.survey) {
            case LAS: {
                catalogQuery = this.createCatalogQueryLAS();
                MiscUtils.addRow(queryBuilder, catalogQuery);
                catalogQuery = this.createProperMotionQuery(queryBuilder);
                break;
            }
            case GCS: {
                catalogQuery = this.createCatalogQueryGCS();
                MiscUtils.addRow(queryBuilder, catalogQuery);
                catalogQuery = this.createProperMotionQuery(queryBuilder);
                break;
            }
            case GPS: {
                catalogQuery = this.createCatalogQueryGPS();
                MiscUtils.addRow(queryBuilder, catalogQuery);
                catalogQuery = this.createProperMotionQuery(queryBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this.survey));
            }
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(catalogQuery);
    }

    private String createCatalogQueryLAS() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT sourceid,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       sigra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       sigdec,");
        MiscUtils.addRow(query, "       mura,");
        MiscUtils.addRow(query, "       sigmura,");
        MiscUtils.addRow(query, "       mudec,");
        MiscUtils.addRow(query, "       sigmudec,");
        MiscUtils.addRow(query, "       mergedclass,");
        MiscUtils.addRow(query, "       epoch,");
        MiscUtils.addRow(query, "       yapermag3,");
        MiscUtils.addRow(query, "       yapermag3err,");
        MiscUtils.addRow(query, "       japermag3,");
        MiscUtils.addRow(query, "       japermag3err,");
        MiscUtils.addRow(query, "       hapermag3,");
        MiscUtils.addRow(query, "       hapermag3err,");
        MiscUtils.addRow(query, "       kapermag3,");
        MiscUtils.addRow(query, "       kapermag3err,");
        MiscUtils.addRow(query, "       ymjpnt,");
        MiscUtils.addRow(query, "       jmhpnt,");
        MiscUtils.addRow(query, "       hmkpnt");
        MiscUtils.addRow(query, "FROM   ukidss_dr11plus.lassource");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    private String createCatalogQueryGCS() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT sourceid,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       sigra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       sigdec,");
        MiscUtils.addRow(query, "       mura,");
        MiscUtils.addRow(query, "       sigmura,");
        MiscUtils.addRow(query, "       mudec,");
        MiscUtils.addRow(query, "       sigmudec,");
        MiscUtils.addRow(query, "       mergedclass,");
        MiscUtils.addRow(query, "       epoch,");
        MiscUtils.addRow(query, "       yapermag3,");
        MiscUtils.addRow(query, "       yapermag3err,");
        MiscUtils.addRow(query, "       japermag3,");
        MiscUtils.addRow(query, "       japermag3err,");
        MiscUtils.addRow(query, "       hapermag3,");
        MiscUtils.addRow(query, "       hapermag3err,");
        MiscUtils.addRow(query, "       kapermag3,");
        MiscUtils.addRow(query, "       kapermag3err,");
        MiscUtils.addRow(query, "       ymjpnt,");
        MiscUtils.addRow(query, "       jmhpnt,");
        MiscUtils.addRow(query, "       hmkpnt");
        MiscUtils.addRow(query, "FROM   ukidss_dr11plus.gcssource");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    private String createCatalogQueryGPS() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT sourceid,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       sigra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       sigdec,");
        MiscUtils.addRow(query, "       mura,");
        MiscUtils.addRow(query, "       sigmura,");
        MiscUtils.addRow(query, "       mudec,");
        MiscUtils.addRow(query, "       sigmudec,");
        MiscUtils.addRow(query, "       mergedclass,");
        MiscUtils.addRow(query, "       epoch,");
        MiscUtils.addRow(query, "       japermag3,");
        MiscUtils.addRow(query, "       japermag3err,");
        MiscUtils.addRow(query, "       hapermag3,");
        MiscUtils.addRow(query, "       hapermag3err,");
        MiscUtils.addRow(query, "       kapermag3,");
        MiscUtils.addRow(query, "       kapermag3err,");
        MiscUtils.addRow(query, "       jmhpnt,");
        MiscUtils.addRow(query, "       hmkpnt");
        MiscUtils.addRow(query, "FROM   ukidss_dr11plus.gpssource");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    private String createCatalogQueryDXS() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT sourceid,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       mergedclass,");
        MiscUtils.addRow(query, "       japermag3,");
        MiscUtils.addRow(query, "       japermag3err,");
        MiscUtils.addRow(query, "       hapermag3,");
        MiscUtils.addRow(query, "       hapermag3err,");
        MiscUtils.addRow(query, "       kapermag3,");
        MiscUtils.addRow(query, "       kapermag3err,");
        MiscUtils.addRow(query, "       jmhpnt,");
        MiscUtils.addRow(query, "       hmkpnt");
        MiscUtils.addRow(query, "FROM   ukidss_dr11plus.dxssource");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    private String createCatalogQueryUDS() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT sourceid,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       mergedclass,");
        MiscUtils.addRow(query, "       japermag3,");
        MiscUtils.addRow(query, "       japermag3err,");
        MiscUtils.addRow(query, "       hapermag3,");
        MiscUtils.addRow(query, "       hapermag3err,");
        MiscUtils.addRow(query, "       kapermag3,");
        MiscUtils.addRow(query, "       kapermag3err,");
        MiscUtils.addRow(query, "       jmhpnt,");
        MiscUtils.addRow(query, "       hmkpnt");
        MiscUtils.addRow(query, "FROM   ukidss_dr11plus.udssource");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    private String createProperMotionQuery(StringBuilder query) {
        MiscUtils.addRow(query, "AND    mura > -999999 AND mudec > -999999");
        MiscUtils.addRow(query, "AND    SQRT(mura * mura + mudec * mudec) >= " + this.tpm);
        return query.toString();
    }

    @Override
    public void setTpm(double tpm) {
        this.tpm = tpm;
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.ra_err) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo7Dec(this.dec_err) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmra_err) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + NumericFunctions.roundTo3Dec(this.pmdec_err) + "," + SURVEY_LABEL.get((Object)this.survey) + "," + TYPE_TABLE.get(this.objectType) + "," + NumericFunctions.roundTo3Dec(this.epoch) + "," + NumericFunctions.roundTo3Dec(this.y_ap3) + "," + NumericFunctions.roundTo3Dec(this.y_ap3_err) + "," + NumericFunctions.roundTo3Dec(this.j_ap3) + "," + NumericFunctions.roundTo3Dec(this.j_ap3_err) + "," + NumericFunctions.roundTo3Dec(this.h_ap3) + "," + NumericFunctions.roundTo3Dec(this.h_ap3_err) + "," + NumericFunctions.roundTo3Dec(this.ks_ap3) + "," + NumericFunctions.roundTo3Dec(this.ks_ap3_err) + "," + NumericFunctions.roundTo3Dec(this.y_j_pnt) + "," + NumericFunctions.roundTo3Dec(this.j_h_pnt) + "," + NumericFunctions.roundTo3Dec(this.h_ks_pnt) + "," + NumericFunctions.roundTo3Dec(this.getJ_K()) + "," + NumericFunctions.roundTo3Dec(this.getTotalProperMotion());
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,ra err,dec,dec err,pmra (mas/yr),pmra err,pmdec (mas/yr),pmdec err,UKIDSS survey,object type,epoch,Y (mag),Y err,J (mag),J err,H (mag),H err,Ks (mag),Ks err,Y-J,J-H,H-Ks,J-Ks,tpm (mas/yr)";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.J, new NumberPair(this.j_ap3, this.j_ap3_err));
        bands.put(Band.H, new NumberPair(this.h_ap3, this.h_ap3_err));
        bands.put(Band.K, new NumberPair(this.ks_ap3, this.ks_ap3_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.J_H, this.j_h_pnt);
        colors.put(astro.tool.box.enumeration.Color.H_K, this.h_ks_pnt);
        colors.put(astro.tool.box.enumeration.Color.J_K, this.getJ_K());
        colors.put(astro.tool.box.enumeration.Color.e_J_H, this.getJ_H() - this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.e_H_K, this.getH_K() - this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.e_J_K, this.getJ_K() - this.getJ_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_H, this.getJ_H() + this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.E_H_K, this.getH_K() + this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_K, this.getJ_K() + this.getJ_K_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.y_ap3 != 0.0) {
            mags.append("Y=").append(NumericFunctions.roundTo4DecNZ(this.y_ap3)).append(" ");
        }
        if (this.j_ap3 != 0.0) {
            mags.append("J=").append(NumericFunctions.roundTo4DecNZ(this.j_ap3)).append(" ");
        }
        if (this.h_ap3 != 0.0) {
            mags.append("H=").append(NumericFunctions.roundTo4DecNZ(this.h_ap3)).append(" ");
        }
        if (this.ks_ap3 != 0.0) {
            mags.append("K=").append(NumericFunctions.roundTo4DecNZ(this.ks_ap3)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.y_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.y_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.y_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.j_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.j_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.j_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.h_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.h_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.h_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.ks_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.ks_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.ks_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return this.pmra;
    }

    @Override
    public double getPmdec() {
        return this.pmdec;
    }

    @Override
    public double getPmraErr() {
        return this.pmra_err;
    }

    @Override
    public double getPmdecErr() {
        return this.pmdec_err;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return AstrometricFunctions.calculateTotalProperMotion(this.pmra, this.pmdec);
    }

    public double getMeanEpoch() {
        return this.epoch;
    }

    public void setSurvey(Survey survey) {
        this.survey = survey;
    }

    public double getJ_H() {
        return this.j_h_pnt;
    }

    public double getH_K() {
        return this.h_ks_pnt;
    }

    public double getJ_K() {
        if (this.j_ap3 == 0.0 || this.ks_ap3 == 0.0) {
            return 0.0;
        }
        return this.j_ap3 - this.ks_ap3;
    }

    public double getJ_H_err() {
        if (this.j_ap3_err == 0.0 || this.h_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.j_ap3_err, this.h_ap3_err);
    }

    public double getH_K_err() {
        if (this.h_ap3_err == 0.0 || this.ks_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.h_ap3_err, this.ks_ap3_err);
    }

    public double getJ_K_err() {
        if (this.j_ap3_err == 0.0 || this.ks_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.j_ap3_err, this.ks_ap3_err);
    }

    public double getJmag() {
        return this.j_ap3;
    }

    public double getHmag() {
        return this.h_ap3;
    }

    public double getKmag() {
        return this.ks_ap3;
    }

    public double getJ_err() {
        return this.j_ap3_err;
    }

    public double getH_err() {
        return this.h_ap3_err;
    }

    public double getK_err() {
        return this.ks_ap3_err;
    }

    static {
        TYPE_TABLE.put(1, "Galaxy");
        TYPE_TABLE.put(0, "Noise");
        TYPE_TABLE.put(-1, "Star");
        TYPE_TABLE.put(-2, "Probable star");
        TYPE_TABLE.put(-3, "Probable galaxy");
        TYPE_TABLE.put(-9, "Saturated");
        SURVEY_LABEL = new HashMap<Survey, String>();
        SURVEY_LABEL.put(Survey.LAS, "Large Area Survey");
        SURVEY_LABEL.put(Survey.GCS, "Galactic Clusters Survey");
        SURVEY_LABEL.put(Survey.GPS, "Galactic Plane Survey");
        SURVEY_LABEL.put(Survey.DXS, "Deep Extragalactic Survey");
        SURVEY_LABEL.put(Survey.UDS, "Ultra Deep Survey");
    }

    public static enum Survey {
        LAS,
        GCS,
        GPS,
        DXS,
        UDS;


        public static Survey[] motionSurveys() {
            return new Survey[]{LAS, GCS, GPS};
        }
    }
}

