/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UnWiseCatalogEntry
implements CatalogEntry,
Extinction {
    public static final String CATALOG_NAME = "unWISE";
    private String unwise_objid;
    private double ra;
    private double dec;
    private double mag_w1_vg;
    private double mag_w2_vg;
    private double w1_w2_vg;
    private double qf_w1;
    private double qf_w2;
    private int flags_unwise_w1;
    private int flags_unwise_w2;
    private int flags_info_w1;
    private int flags_info_w2;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;

    public UnWiseCatalogEntry() {
    }

    public UnWiseCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        MiscUtils.replaceNanValuesByZero(values);
        this.unwise_objid = values[columns.get("unwise_objid")];
        this.ra = NumericFunctions.toDouble(values[columns.get("ra")]);
        this.dec = NumericFunctions.toDouble(values[columns.get("dec")]);
        this.mag_w1_vg = NumericFunctions.toDouble(values[columns.get("mag_w1_vg")]);
        this.mag_w2_vg = NumericFunctions.toDouble(values[columns.get("mag_w2_vg")]);
        this.w1_w2_vg = NumericFunctions.toDouble(values[columns.get("w1_w2_vg")]);
        this.qf_w1 = NumericFunctions.toDouble(values[columns.get("qf_w1")]);
        this.qf_w2 = NumericFunctions.toDouble(values[columns.get("qf_w2")]);
        this.flags_unwise_w1 = NumericFunctions.toInteger(values[columns.get("flags_unwise_w1")]);
        this.flags_unwise_w2 = NumericFunctions.toInteger(values[columns.get("flags_unwise_w2")]);
        this.flags_info_w1 = NumericFunctions.toInteger(values[columns.get("flags_info_w1")]);
        this.flags_info_w2 = NumericFunctions.toInteger(values[columns.get("flags_info_w2")]);
    }

    @Override
    public CatalogEntry copy() {
        return new UnWiseCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", this.unwise_objid, Alignment.LEFT, Comparators.getStringComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo7DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo7DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1 (mag)", NumericFunctions.roundTo3DecNZ(this.mag_w1_vg), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("W2 (mag)", NumericFunctions.roundTo3DecNZ(this.mag_w2_vg), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("quality factor W1", NumericFunctions.roundTo3DecNZLZ(this.qf_w1), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("quality factor W2", NumericFunctions.roundTo3DecNZLZ(this.qf_w2), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("coadd flags W1", String.valueOf(this.flags_unwise_w1), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("coadd flags W2", String.valueOf(this.flags_unwise_w2), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("info flags W1", String.valueOf(this.flags_info_w1), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("info flags W2", String.valueOf(this.flags_info_w2), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("W1-W2", NumericFunctions.roundTo3DecNZ(this.w1_w2_vg), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.unwise_objid);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnWiseCatalogEntry other = (UnWiseCatalogEntry)obj;
        return Objects.equals(this.unwise_objid, other.unwise_objid);
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new UnWiseCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.MINT.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createCatalogQuery());
    }

    private String createCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT unwise_objid,");
        MiscUtils.addRow(query, "       ra,");
        MiscUtils.addRow(query, "       dec,");
        MiscUtils.addRow(query, "       mag_w1_vg,");
        MiscUtils.addRow(query, "       mag_w2_vg,");
        MiscUtils.addRow(query, "       w1_w2_vg,");
        MiscUtils.addRow(query, "       qf_w1,");
        MiscUtils.addRow(query, "       qf_w2,");
        MiscUtils.addRow(query, "       flags_unwise_w1,");
        MiscUtils.addRow(query, "       flags_unwise_w2,");
        MiscUtils.addRow(query, "       flags_info_w1,");
        MiscUtils.addRow(query, "       flags_info_w2");
        MiscUtils.addRow(query, "FROM   unwise_dr1.object");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra, dec, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.unwise_objid + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + NumericFunctions.roundTo3Dec(this.mag_w1_vg) + "," + NumericFunctions.roundTo3Dec(this.mag_w2_vg) + "," + NumericFunctions.roundTo3DecLZ(this.qf_w1) + "," + NumericFunctions.roundTo3DecLZ(this.qf_w2) + "," + this.flags_unwise_w1 + "," + this.flags_unwise_w2 + "," + this.flags_info_w1 + "," + this.flags_info_w2 + "," + NumericFunctions.roundTo3Dec(this.w1_w2_vg);
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,W1 (mag),W2 (mag),qual. fact. W1,qual. fact. W2,coadd flags W1,coadd flags W2,info flags W1,info flags W2,W1-W2";
        return columnTitles.split(",", -1);
    }

    @Override
    public void applyExtinctionCorrection(Map<String, Double> extinctionsByBand) {
        if (this.mag_w1_vg != 0.0) {
            this.mag_w1_vg -= extinctionsByBand.get("WISE-1").doubleValue();
        }
        if (this.mag_w2_vg != 0.0) {
            this.mag_w2_vg -= extinctionsByBand.get("WISE-2").doubleValue();
        }
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.W1, new NumberPair(this.mag_w1_vg, 0.1));
        bands.put(Band.W2, new NumberPair(this.mag_w2_vg, 0.1));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.W1_W2, this.w1_w2_vg);
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.mag_w1_vg != 0.0) {
            mags.append("W1=").append(NumericFunctions.roundTo3DecNZ(this.mag_w1_vg)).append(" ");
        }
        if (this.mag_w2_vg != 0.0) {
            mags.append("W2=").append(NumericFunctions.roundTo3DecNZ(this.mag_w2_vg)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.mag_w1_vg != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.mag_w1_vg)).append(",");
        } else {
            mags.append(",");
        }
        if (this.mag_w2_vg != 0.0) {
            mags.append(NumericFunctions.roundTo3DecNZ(this.mag_w2_vg)).append(",");
        } else {
            mags.append(",");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return this.unwise_objid;
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return 0.0;
    }

    @Override
    public double getPmdec() {
        return 0.0;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return 0.0;
    }

    public double getW1_w2_vg() {
        return this.w1_w2_vg;
    }

    public double getW1mag() {
        return this.mag_w1_vg;
    }

    public double getW2mag() {
        return this.mag_w2_vg;
    }
}

