/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.catalog;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.MiscUtils;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VhsCatalogEntry
implements CatalogEntry {
    public static final String CATALOG_NAME = "VHS DR5";
    private long sourceId;
    private double ra;
    private double dec;
    private int objectType;
    private double y_ap3;
    private double y_ap3_err;
    private double j_ap3;
    private double j_ap3_err;
    private double h_ap3;
    private double h_ap3_err;
    private double ks_ap3;
    private double ks_ap3_err;
    private double y_j_pnt;
    private double j_h_pnt;
    private double h_ks_pnt;
    private double j_ks_pnt;
    private double targetRa;
    private double targetDec;
    private double pixelRa;
    private double pixelDec;
    private double searchRadius;
    private String spt;
    private final List<CatalogElement> catalogElements = new ArrayList<CatalogElement>();
    private Map<String, Integer> columns;
    private String[] values;
    private static final Map<Integer, String> TYPE_TABLE = new HashMap<Integer, String>();

    public VhsCatalogEntry() {
    }

    public VhsCatalogEntry(Map<String, Integer> columns, String[] values) {
        this.columns = columns;
        this.values = values;
        if (MiscUtils.isVizierTAP()) {
            this.sourceId = NumericFunctions.toLong(values[columns.get("SrcID")]);
            this.ra = NumericFunctions.toDouble(values[columns.get("RAJ2000")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("DEJ2000")]);
            this.objectType = NumericFunctions.toInteger(values[columns.get("Mclass")]);
            this.y_ap3 = NumericFunctions.toDouble(values[columns.get("Yap3")]);
            this.y_ap3_err = NumericFunctions.toDouble(values[columns.get("e_Yap3")]);
            this.j_ap3 = NumericFunctions.toDouble(values[columns.get("Jap3")]);
            this.j_ap3_err = NumericFunctions.toDouble(values[columns.get("e_Jap3")]);
            this.h_ap3 = NumericFunctions.toDouble(values[columns.get("Hap3")]);
            this.h_ap3_err = NumericFunctions.toDouble(values[columns.get("e_Hap3")]);
            this.ks_ap3 = NumericFunctions.toDouble(values[columns.get("Ksap3")]);
            this.ks_ap3_err = NumericFunctions.toDouble(values[columns.get("e_Ksap3")]);
            this.y_j_pnt = NumericFunctions.toDouble(values[columns.get("Y-Jpnt")]);
            this.j_h_pnt = NumericFunctions.toDouble(values[columns.get("J-Hpnt")]);
            this.h_ks_pnt = NumericFunctions.toDouble(values[columns.get("H-Kspnt")]);
            this.j_ks_pnt = NumericFunctions.toDouble(values[columns.get("J-Kspnt")]);
        } else {
            MiscUtils.replaceNanValuesByZero(values);
            this.sourceId = NumericFunctions.toLong(values[columns.get("sourceid")]);
            this.ra = NumericFunctions.toDouble(values[columns.get("ra2000")]);
            this.dec = NumericFunctions.toDouble(values[columns.get("dec2000")]);
            this.objectType = NumericFunctions.toInteger(values[columns.get("mergedclass")]);
            this.y_ap3 = NumericFunctions.toDouble(values[columns.get("yapermag3")]);
            this.y_ap3_err = NumericFunctions.toDouble(values[columns.get("yapermag3err")]);
            this.j_ap3 = NumericFunctions.toDouble(values[columns.get("japermag3")]);
            this.j_ap3_err = NumericFunctions.toDouble(values[columns.get("japermag3err")]);
            this.h_ap3 = NumericFunctions.toDouble(values[columns.get("hapermag3")]);
            this.h_ap3_err = NumericFunctions.toDouble(values[columns.get("hapermag3err")]);
            this.ks_ap3 = NumericFunctions.toDouble(values[columns.get("ksapermag3")]);
            this.ks_ap3_err = NumericFunctions.toDouble(values[columns.get("ksapermag3err")]);
            this.y_j_pnt = NumericFunctions.toDouble(values[columns.get("ymjpnt")]);
            this.j_h_pnt = NumericFunctions.toDouble(values[columns.get("jmhpnt")]);
            this.h_ks_pnt = NumericFunctions.toDouble(values[columns.get("hmkspnt")]);
            this.j_ks_pnt = NumericFunctions.toDouble(values[columns.get("jmkspnt")]);
        }
    }

    @Override
    public CatalogEntry copy() {
        return new VhsCatalogEntry(this.columns, this.values);
    }

    @Override
    public void loadCatalogElements() {
        this.catalogElements.add(new CatalogElement("dist (arcsec)", NumericFunctions.roundTo3DecNZLZ(this.getTargetDistance()), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("source id", String.valueOf(this.sourceId), Alignment.LEFT, Comparators.getLongComparator()));
        this.catalogElements.add(new CatalogElement("ra", NumericFunctions.roundTo6DecNZ(this.ra), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("dec", NumericFunctions.roundTo6DecNZ(this.dec), Alignment.LEFT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("object type", TYPE_TABLE.get(this.objectType), Alignment.LEFT, (Comparator<String>)Comparators.getStringComparator(), true));
        this.catalogElements.add(new CatalogElement("Y (mag)", NumericFunctions.roundTo4DecNZ(this.y_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("Y err", NumericFunctions.roundTo4DecNZ(this.y_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J (mag)", NumericFunctions.roundTo4DecNZ(this.j_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("J err", NumericFunctions.roundTo4DecNZ(this.j_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H (mag)", NumericFunctions.roundTo4DecNZ(this.h_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("H err", NumericFunctions.roundTo4DecNZ(this.h_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Ks (mag)", NumericFunctions.roundTo4DecNZ(this.ks_ap3), Alignment.RIGHT, (Comparator<String>)Comparators.getDoubleComparator(), true));
        this.catalogElements.add(new CatalogElement("Ks err", NumericFunctions.roundTo4DecNZ(this.ks_ap3_err), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("Y-J", NumericFunctions.roundTo4DecNZ(this.y_j_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J-H", NumericFunctions.roundTo4DecNZ(this.j_h_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("H-Ks", NumericFunctions.roundTo4DecNZ(this.h_ks_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
        this.catalogElements.add(new CatalogElement("J-Ks", NumericFunctions.roundTo4DecNZ(this.j_ks_pnt), Alignment.RIGHT, Comparators.getDoubleComparator()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (int)(this.sourceId ^ this.sourceId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VhsCatalogEntry other = (VhsCatalogEntry)obj;
        return this.sourceId == other.sourceId;
    }

    @Override
    public CatalogEntry getInstance(Map<String, Integer> columns, String[] values) {
        return new VhsCatalogEntry(columns, values);
    }

    @Override
    public String getCatalogName() {
        return CATALOG_NAME;
    }

    @Override
    public Color getCatalogColor() {
        return JColor.PINK.val;
    }

    @Override
    public String getCatalogQueryUrl() {
        if (MiscUtils.isVizierTAP()) {
            return ServiceHelper.createVizieRUrl(this.ra, this.dec, this.searchRadius / 3600.0, "II/367/vhs_dr5", "RAJ2000", "DEJ2000");
        }
        return "https://datalab.noirlab.edu/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(this.createAltCatalogQuery());
    }

    private String createAltCatalogQuery() {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "SELECT sourceid,");
        MiscUtils.addRow(query, "       ra2000,");
        MiscUtils.addRow(query, "       dec2000,");
        MiscUtils.addRow(query, "       mergedclass,");
        MiscUtils.addRow(query, "       yapermag3,");
        MiscUtils.addRow(query, "       yapermag3err,");
        MiscUtils.addRow(query, "       japermag3,");
        MiscUtils.addRow(query, "       japermag3err,");
        MiscUtils.addRow(query, "       hapermag3,");
        MiscUtils.addRow(query, "       hapermag3err,");
        MiscUtils.addRow(query, "       ksapermag3,");
        MiscUtils.addRow(query, "       ksapermag3err,");
        MiscUtils.addRow(query, "       ymjpnt,");
        MiscUtils.addRow(query, "       jmhpnt,");
        MiscUtils.addRow(query, "       hmkspnt,");
        MiscUtils.addRow(query, "       jmkspnt");
        MiscUtils.addRow(query, "FROM   vhs_dr5.vhs_cat_v3");
        MiscUtils.addRow(query, "WHERE  't'=q3c_radial_query(ra2000, dec2000, " + this.ra + ", " + this.dec + ", " + this.searchRadius / 3600.0 + ")");
        return query.toString();
    }

    @Override
    public String[] getColumnValues() {
        String columnValues = NumericFunctions.roundTo3DecLZ(this.getTargetDistance()) + "," + this.sourceId + "," + NumericFunctions.roundTo6Dec(this.ra) + "," + NumericFunctions.roundTo6Dec(this.dec) + "," + TYPE_TABLE.get(this.objectType) + "," + NumericFunctions.roundTo4Dec(this.y_ap3) + "," + NumericFunctions.roundTo4Dec(this.y_ap3_err) + "," + NumericFunctions.roundTo4Dec(this.j_ap3) + "," + NumericFunctions.roundTo4Dec(this.j_ap3_err) + "," + NumericFunctions.roundTo4Dec(this.h_ap3) + "," + NumericFunctions.roundTo4Dec(this.h_ap3_err) + "," + NumericFunctions.roundTo4Dec(this.ks_ap3) + "," + NumericFunctions.roundTo4Dec(this.ks_ap3_err) + "," + NumericFunctions.roundTo4Dec(this.y_j_pnt) + "," + NumericFunctions.roundTo4Dec(this.j_h_pnt) + "," + NumericFunctions.roundTo4Dec(this.h_ks_pnt) + "," + NumericFunctions.roundTo4Dec(this.j_ks_pnt);
        return columnValues.split(",", -1);
    }

    @Override
    public String[] getColumnTitles() {
        String columnTitles = "dist (arcsec),source id,ra,dec,object type,Y (mag),Y err,J (mag),J err,H (mag),H err,Ks (mag),Ks err,Y-J,J-H,H-Ks,J-Ks";
        return columnTitles.split(",", -1);
    }

    @Override
    public Map<Band, NumberPair> getBands() {
        LinkedHashMap<Band, NumberPair> bands = new LinkedHashMap<Band, NumberPair>();
        bands.put(Band.J, new NumberPair(this.j_ap3, this.j_ap3_err));
        bands.put(Band.H, new NumberPair(this.h_ap3, this.h_ap3_err));
        bands.put(Band.K, new NumberPair(this.ks_ap3, this.ks_ap3_err));
        return bands;
    }

    @Override
    public Map<astro.tool.box.enumeration.Color, Double> getColors(boolean toVega) {
        LinkedHashMap<astro.tool.box.enumeration.Color, Double> colors = new LinkedHashMap<astro.tool.box.enumeration.Color, Double>();
        colors.put(astro.tool.box.enumeration.Color.J_H, this.j_h_pnt);
        colors.put(astro.tool.box.enumeration.Color.H_K, this.h_ks_pnt);
        colors.put(astro.tool.box.enumeration.Color.J_K, this.j_ks_pnt);
        colors.put(astro.tool.box.enumeration.Color.e_J_H, this.getJ_H() - this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.e_H_K, this.getH_K() - this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.e_J_K, this.getJ_K() - this.getJ_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_H, this.getJ_H() + this.getJ_H_err());
        colors.put(astro.tool.box.enumeration.Color.E_H_K, this.getH_K() + this.getH_K_err());
        colors.put(astro.tool.box.enumeration.Color.E_J_K, this.getJ_K() + this.getJ_K_err());
        return colors;
    }

    @Override
    public String getMagnitudes() {
        StringBuilder mags = new StringBuilder();
        if (this.y_ap3 != 0.0) {
            mags.append("Y=").append(NumericFunctions.roundTo4DecNZ(this.y_ap3)).append(" ");
        }
        if (this.j_ap3 != 0.0) {
            mags.append("J=").append(NumericFunctions.roundTo4DecNZ(this.j_ap3)).append(" ");
        }
        if (this.h_ap3 != 0.0) {
            mags.append("H=").append(NumericFunctions.roundTo4DecNZ(this.h_ap3)).append(" ");
        }
        if (this.ks_ap3 != 0.0) {
            mags.append("K=").append(NumericFunctions.roundTo4DecNZ(this.ks_ap3)).append(" ");
        }
        return mags.toString();
    }

    @Override
    public String getPhotometry() {
        StringBuilder mags = new StringBuilder();
        if (this.y_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.y_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.y_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.j_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.j_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.j_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.h_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.h_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.h_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        if (this.ks_ap3 != 0.0) {
            mags.append(NumericFunctions.roundTo4DecNZ(this.ks_ap3)).append(",").append(NumericFunctions.roundTo4DecNZ(this.ks_ap3_err)).append(",");
        } else {
            mags.append(",,");
        }
        return mags.toString();
    }

    @Override
    public String getSourceId() {
        return String.valueOf(this.sourceId);
    }

    @Override
    public double getRa() {
        return this.ra;
    }

    @Override
    public void setRa(double ra) {
        this.ra = ra;
    }

    @Override
    public double getDec() {
        return this.dec;
    }

    @Override
    public void setDec(double dec) {
        this.dec = dec;
    }

    @Override
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    @Override
    public double getTargetRa() {
        return this.targetRa;
    }

    @Override
    public void setTargetRa(double targetRa) {
        this.targetRa = targetRa;
    }

    @Override
    public double getTargetDec() {
        return this.targetDec;
    }

    @Override
    public void setTargetDec(double targetDec) {
        this.targetDec = targetDec;
    }

    @Override
    public double getPixelRa() {
        return this.pixelRa;
    }

    @Override
    public void setPixelRa(double pixelRa) {
        this.pixelRa = pixelRa;
    }

    @Override
    public double getPixelDec() {
        return this.pixelDec;
    }

    @Override
    public void setPixelDec(double pixelDec) {
        this.pixelDec = pixelDec;
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public void setSpt(String spt) {
        this.spt = spt;
    }

    @Override
    public List<CatalogElement> getCatalogElements() {
        return this.catalogElements;
    }

    @Override
    public double getPlx() {
        return 0.0;
    }

    @Override
    public double getPmra() {
        return 0.0;
    }

    @Override
    public double getPmdec() {
        return 0.0;
    }

    @Override
    public double getTargetDistance() {
        return AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(this.ra, this.dec), 3600.0);
    }

    @Override
    public double getParallacticDistance() {
        return 0.0;
    }

    @Override
    public double getTotalProperMotion() {
        return 0.0;
    }

    public double getJ_H() {
        return this.j_h_pnt;
    }

    public double getH_K() {
        return this.h_ks_pnt;
    }

    public double getJ_K() {
        return this.j_ks_pnt;
    }

    public double getJ_H_err() {
        if (this.j_ap3_err == 0.0 || this.h_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.j_ap3_err, this.h_ap3_err);
    }

    public double getH_K_err() {
        if (this.h_ap3_err == 0.0 || this.ks_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.h_ap3_err, this.ks_ap3_err);
    }

    public double getJ_K_err() {
        if (this.j_ap3_err == 0.0 || this.ks_ap3_err == 0.0) {
            return 0.0;
        }
        return AstrometricFunctions.calculateAdditionError(this.j_ap3_err, this.ks_ap3_err);
    }

    public double getJmag() {
        return this.j_ap3;
    }

    public double getHmag() {
        return this.h_ap3;
    }

    public double getKmag() {
        return this.ks_ap3;
    }

    public double getJ_err() {
        return this.j_ap3_err;
    }

    public double getH_err() {
        return this.h_ap3_err;
    }

    public double getK_err() {
        return this.ks_ap3_err;
    }

    static {
        TYPE_TABLE.put(1, "Galaxy");
        TYPE_TABLE.put(0, "Noise");
        TYPE_TABLE.put(-1, "Star");
        TYPE_TABLE.put(-2, "Probable star");
        TYPE_TABLE.put(-3, "Probable galaxy");
        TYPE_TABLE.put(-9, "Saturated");
    }
}

