/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class TextPrompt
extends JLabel
implements FocusListener,
DocumentListener {
    private JTextComponent component;
    private final Show show;
    private Document document;
    private boolean showPromptOnce;
    private int focusLost;

    public TextPrompt(String text) {
        this.setText(text);
        this.show = Show.FOCUS_LOST;
    }

    public TextPrompt(String text, Show show) {
        this.setText(text);
        this.show = show;
    }

    public void applyTo(JTextComponent component) {
        this.component = component;
        this.document = component.getDocument();
        this.document.addDocumentListener(this);
        this.setFont(component.getFont());
        this.setBorder(new EmptyBorder(component.getInsets()));
        this.setHorizontalAlignment(10);
        component.addFocusListener(this);
        component.setLayout(new BorderLayout());
        component.add(this);
        this.checkPrompt();
    }

    private void checkPrompt() {
        if (this.document.getLength() > 0 || this.showPromptOnce && this.focusLost > 0) {
            this.setForeground(this.component.getForeground());
            this.setVisible(false);
            return;
        }
        if (this.component.hasFocus()) {
            if (this.show == Show.ALWAYS || this.show == Show.FOCUS_GAINED) {
                this.setForeground(Color.GRAY);
                this.setVisible(true);
            } else {
                this.setForeground(this.component.getForeground());
                this.setVisible(false);
            }
        } else if (this.show == Show.ALWAYS || this.show == Show.FOCUS_LOST) {
            this.setForeground(Color.GRAY);
            this.setVisible(true);
        } else {
            this.setForeground(this.component.getForeground());
            this.setVisible(false);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.checkPrompt();
    }

    @Override
    public void focusLost(FocusEvent e) {
        ++this.focusLost;
        this.checkPrompt();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkPrompt();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkPrompt();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public static enum Show {
        ALWAYS,
        FOCUS_GAINED,
        FOCUS_LOST;

    }
}

