/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.container;

import astro.tool.box.function.NumericFunctions;
import java.util.List;
import java.util.stream.Collectors;

public class ClassificationResult {
    private final String catalogName;
    private final double targetRa;
    private final double targetDec;
    private final double targetDistance;
    private final double ra;
    private final double dec;
    private final String sourceId;
    private final double plx;
    private final double pmra;
    private final double pmdec;
    private final String magnitudes;
    private final List<String> spectralTypes;

    private ClassificationResult(String catalogName, double targetRa, double targetDec, double targetDistance, double ra, double dec, String sourceId, double plx, double pmra, double pmdec, String magnitudes, List<String> spectralTypes) {
        this.catalogName = catalogName;
        this.targetRa = targetRa;
        this.targetDec = targetDec;
        this.targetDistance = targetDistance;
        this.ra = ra;
        this.dec = dec;
        this.sourceId = sourceId;
        this.plx = plx;
        this.pmra = pmra;
        this.pmdec = pmdec;
        this.magnitudes = magnitudes;
        this.spectralTypes = spectralTypes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassificationResult{catalogName=").append(this.catalogName);
        sb.append(", targetRa=").append(this.targetRa);
        sb.append(", targetDec=").append(this.targetDec);
        sb.append(", targetDistance=").append(this.targetDistance);
        sb.append(", ra=").append(this.ra);
        sb.append(", dec=").append(this.dec);
        sb.append(", sourceId=").append(this.sourceId);
        sb.append(", plx=").append(this.plx);
        sb.append(", pmra=").append(this.pmra);
        sb.append(", pmdec=").append(this.pmdec);
        sb.append(", magnitudes=").append(this.magnitudes);
        sb.append(", spectralTypes=").append(this.spectralTypes);
        sb.append('}');
        return sb.toString();
    }

    public Object[] getColumnValues() {
        return this.getValues().split(",", -1);
    }

    public Object[] getColumnTitles() {
        return this.getTitles().split(",", -1);
    }

    public String getValues() {
        String values = this.catalogName + "," + NumericFunctions.roundTo7Dec(this.targetRa) + "," + NumericFunctions.roundTo7Dec(this.targetDec) + "," + (this.catalogName.isEmpty() ? NumericFunctions.roundTo3Dec(this.targetDistance) : NumericFunctions.roundTo3DecLZ(this.targetDistance)) + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + this.sourceId + "," + NumericFunctions.roundTo4Dec(this.plx) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + this.magnitudes + "," + this.joinSpetralTypes();
        return values;
    }

    public String getTitles() {
        String titles = "Catalog,Target RA,Target dec,Target dist,RA,dec,Source id,Plx,pmRA,pmdec,Magnitudes,Spectral types";
        return titles;
    }

    public String joinSpetralTypes() {
        return this.spectralTypes.stream().collect(Collectors.joining(" "));
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public double getTargetRa() {
        return this.targetRa;
    }

    public double getTargetDec() {
        return this.targetDec;
    }

    public double getTargetDistance() {
        return this.targetDistance;
    }

    public double getRa() {
        return this.ra;
    }

    public double getDec() {
        return this.dec;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public double getPlx() {
        return this.plx;
    }

    public double getPmra() {
        return this.pmra;
    }

    public double getPmdec() {
        return this.pmdec;
    }

    public String getMagnitudes() {
        return this.magnitudes;
    }

    public List<String> getSpectralTypes() {
        return this.spectralTypes;
    }

    public static class Builder {
        private String catalogName;
        private double targetRa;
        private double targetDec;
        private double targetDistance;
        private double ra;
        private double dec;
        private String sourceId;
        private double plx;
        private double pmra;
        private double pmdec;
        private String magnitudes;
        private List<String> spectralTypes;

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setTargetRa(double targetRa) {
            this.targetRa = targetRa;
            return this;
        }

        public Builder setTargetDec(double targetDec) {
            this.targetDec = targetDec;
            return this;
        }

        public Builder setTargetDistance(double targetDistance) {
            this.targetDistance = targetDistance;
            return this;
        }

        public Builder setRa(double ra) {
            this.ra = ra;
            return this;
        }

        public Builder setDec(double dec) {
            this.dec = dec;
            return this;
        }

        public Builder setSourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder setPlx(double plx) {
            this.plx = plx;
            return this;
        }

        public Builder setPmra(double pmra) {
            this.pmra = pmra;
            return this;
        }

        public Builder setPmdec(double pmdec) {
            this.pmdec = pmdec;
            return this;
        }

        public Builder setMagnitudes(String magnitudes) {
            this.magnitudes = magnitudes;
            return this;
        }

        public Builder setSpectralTypes(List<String> spectralTypes) {
            this.spectralTypes = spectralTypes;
            return this;
        }

        public ClassificationResult build() {
            return new ClassificationResult(this.catalogName, this.targetRa, this.targetDec, this.targetDistance, this.ra, this.dec, this.sourceId, this.plx, this.pmra, this.pmdec, this.magnitudes, this.spectralTypes);
        }
    }
}

