/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.container;

import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.Constants;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

public class CollectedObject {
    private final LocalDateTime discoveryDate;
    private final String objectType;
    private final String catalogName;
    private final double ra;
    private final double dec;
    private final String sourceId;
    private final double plx;
    private final double pmra;
    private final double pmdec;
    private final List<String> spectralTypes;
    private final String notes;

    private CollectedObject(LocalDateTime discoveryDate, String objectType, String catalogName, double ra, double dec, String sourceId, double plx, double pmra, double pmdec, List<String> spectralTypes, String notes) {
        this.discoveryDate = discoveryDate;
        this.objectType = objectType;
        this.catalogName = catalogName;
        this.ra = ra;
        this.dec = dec;
        this.sourceId = sourceId;
        this.plx = plx;
        this.pmra = pmra;
        this.pmdec = pmdec;
        this.spectralTypes = spectralTypes;
        this.notes = notes;
    }

    public String toString() {
        return "CollectedObject{discoveryDate=" + String.valueOf(this.discoveryDate) + ", objectType=" + this.objectType + ", catalogName=" + this.catalogName + ", ra=" + this.ra + ", dec=" + this.dec + ", sourceId=" + this.sourceId + ", plx=" + this.plx + ", pmra=" + this.pmra + ", pmdec=" + this.pmdec + ", spectralTypes=" + String.valueOf(this.spectralTypes) + ", notes=" + this.notes + "}";
    }

    public String[] getColumnValues() {
        return this.getValues().split(",", -1);
    }

    public String[] getColumnTitles() {
        return this.getTitles().split(",", -1);
    }

    public String getValues() {
        String values = this.discoveryDate.format(Constants.DATE_TIME_FORMATTER) + "," + this.objectType + "," + this.catalogName + "," + NumericFunctions.roundTo7Dec(this.ra) + "," + NumericFunctions.roundTo7Dec(this.dec) + "," + this.sourceId + "," + NumericFunctions.roundTo4Dec(this.plx) + "," + NumericFunctions.roundTo3Dec(this.pmra) + "," + NumericFunctions.roundTo3Dec(this.pmdec) + "," + this.joinSpetralTypes() + "," + this.notes;
        return values;
    }

    public String getTitles() {
        String titles = "Discovery date,Object type,Catalog,RA,dec,Source id,Plx,pmRA,pmdec,Spectral types,Notes";
        return titles;
    }

    private String joinSpetralTypes() {
        return this.spectralTypes.stream().collect(Collectors.joining(" "));
    }

    public static class Builder {
        private LocalDateTime discoveryDate;
        private String objectType;
        private String catalogName;
        private double ra;
        private double dec;
        private String sourceId;
        private double plx;
        private double pmra;
        private double pmdec;
        private List<String> spectralTypes;
        private String notes;

        public Builder setDiscoveryDate(LocalDateTime discoveryDate) {
            this.discoveryDate = discoveryDate;
            return this;
        }

        public Builder setObjectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setRa(double ra) {
            this.ra = ra;
            return this;
        }

        public Builder setDec(double dec) {
            this.dec = dec;
            return this;
        }

        public Builder setSourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder setPlx(double plx) {
            this.plx = plx;
            return this;
        }

        public Builder setPmra(double pmra) {
            this.pmra = pmra;
            return this;
        }

        public Builder setPmdec(double pmdec) {
            this.pmdec = pmdec;
            return this;
        }

        public Builder setSpectralTypes(List<String> spectralTypes) {
            this.spectralTypes = spectralTypes;
            return this;
        }

        public Builder setNotes(String notes) {
            this.notes = notes;
            return this;
        }

        public CollectedObject build() {
            return new CollectedObject(this.discoveryDate, this.objectType, this.catalogName, this.ra, this.dec, this.sourceId, this.plx, this.pmra, this.pmdec, this.spectralTypes, this.notes);
        }
    }
}

