/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.container;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.enumeration.Shape;
import java.awt.Color;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBox;

public class CustomOverlay {
    private String name;
    private Color color;
    private Shape shape;
    private int raColumnIndex;
    private int decColumnIndex;
    private File file;
    private String tableName;
    private String raColName;
    private String decColName;
    private String tapUrl;
    private String adqlQuery;
    private JCheckBox checkBox;
    private List<CatalogEntry> catalogEntries;

    public void init() {
        this.name = null;
        this.color = null;
        this.shape = null;
        this.raColumnIndex = 0;
        this.decColumnIndex = 0;
        this.file = null;
        this.tableName = null;
        this.raColName = null;
        this.decColName = null;
        this.tapUrl = null;
        this.adqlQuery = null;
        this.checkBox = null;
        this.catalogEntries = null;
    }

    public String serialize() {
        StringBuilder data = new StringBuilder();
        data.append(this.name).append(";");
        data.append(this.color.getRGB()).append(";");
        data.append(this.shape.name()).append(";");
        data.append(this.raColumnIndex).append(";");
        data.append(this.decColumnIndex).append(";");
        data.append(this.file == null ? "" : this.file.getPath()).append(";");
        data.append(this.tableName).append(";");
        data.append(this.raColName).append(";");
        data.append(this.decColName).append(";");
        data.append(this.tapUrl).append(";");
        data.append(this.adqlQuery);
        return data.toString();
    }

    public void deserialize(String data) {
        String[] values = data.split(";", -1);
        this.name = values[0];
        this.color = new Color(Integer.parseInt(values[1]));
        this.shape = Shape.valueOf(values[2]);
        this.raColumnIndex = Integer.parseInt(values[3]);
        this.decColumnIndex = Integer.parseInt(values[4]);
        if (!values[5].isEmpty()) {
            this.file = new File(values[5]);
        }
        this.tableName = values[6];
        this.raColName = values[7];
        this.decColName = values[8];
        if (values.length > 9) {
            this.tapUrl = values[9];
            this.adqlQuery = values[10];
        } else {
            this.tapUrl = "";
            this.adqlQuery = "";
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public int getRaColumnIndex() {
        return this.raColumnIndex;
    }

    public void setRaColumnIndex(int raColumnIndex) {
        this.raColumnIndex = raColumnIndex;
    }

    public int getDecColumnIndex() {
        return this.decColumnIndex;
    }

    public void setDecColumnIndex(int decColumnIndex) {
        this.decColumnIndex = decColumnIndex;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRaColName() {
        return this.raColName;
    }

    public void setRaColName(String raColName) {
        this.raColName = raColName;
    }

    public String getDecColName() {
        return this.decColName;
    }

    public void setDecColName(String decColName) {
        this.decColName = decColName;
    }

    public String getTapUrl() {
        return this.tapUrl;
    }

    public void setTapUrl(String tapUrl) {
        this.tapUrl = tapUrl;
    }

    public String getAdqlQuery() {
        return this.adqlQuery;
    }

    public void setAdqlQuery(String adqlQuery) {
        this.adqlQuery = adqlQuery;
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public void setCheckBox(JCheckBox checkBox) {
        this.checkBox = checkBox;
    }

    public List<CatalogEntry> getCatalogEntries() {
        return this.catalogEntries;
    }

    public void setCatalogEntries(List<CatalogEntry> catalogEntries) {
        this.catalogEntries = catalogEntries;
    }
}

