/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum TabCode {
    CQ("Catalog Search"),
    IS("Image Series"),
    PC("Photometric Classifier"),
    VC("VizieR Catalogs"),
    AQ("ADQL Query"),
    BQ("Batch Search"),
    FB("File Browser"),
    OC("Object Collection"),
    CO("Custom Overlays"),
    TO("Calculators & Converters"),
    LO("Photometric Relations");

    public String val;
    private static final Map<String, String> TAB_CODES;
    private static final Map<String, String> TAB_LABELS;

    private TabCode(String val) {
        this.val = val;
    }

    private static String getTabLabel(String tabCode) {
        return TAB_CODES.get(tabCode);
    }

    private static String getTabCode(String tabLabel) {
        return TAB_LABELS.get(tabLabel);
    }

    public static List<String> convertTabCodeToLabel(String tabCodes) {
        if (tabCodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tabLabels = new ArrayList<String>();
        for (String tabCode : Arrays.asList(tabCodes.split(",", -1))) {
            String tabLabel = TabCode.getTabLabel(tabCode);
            if (tabLabel == null) continue;
            tabLabels.add(tabLabel);
        }
        return tabLabels;
    }

    public static String convertTabLabelToCode(List<String> tabLabels) {
        if (tabLabels.isEmpty()) {
            return "";
        }
        ArrayList<String> tabCodes = new ArrayList<String>();
        for (String tabLabel : tabLabels) {
            String tabCode = TabCode.getTabCode(tabLabel);
            if (tabCode == null) continue;
            tabCodes.add(tabCode);
        }
        return tabCodes.stream().collect(Collectors.joining(","));
    }

    public static String getTabCodes() {
        ArrayList<String> tabCodes = new ArrayList<String>();
        for (TabCode tabCode : TabCode.values()) {
            tabCodes.add(tabCode.name());
        }
        return tabCodes.stream().collect(Collectors.joining(","));
    }

    public static List<String> getTabLabels() {
        ArrayList<String> tabLabels = new ArrayList<String>();
        for (TabCode tabCode : TabCode.values()) {
            tabLabels.add(tabCode.val);
        }
        return tabLabels;
    }

    static {
        TAB_CODES = new HashMap<String, String>();
        for (TabCode tabCode : TabCode.values()) {
            TAB_CODES.put(tabCode.name(), tabCode.val);
        }
        TAB_LABELS = new HashMap<String, String>();
        for (TabCode tabCode : TabCode.values()) {
            TAB_LABELS.put(tabCode.val, tabCode.name());
        }
    }
}

