/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.function;

import astro.tool.box.container.NumberPair;
import astro.tool.box.container.StringPair;
import astro.tool.box.enumeration.Unit;
import astro.tool.box.function.NumericFunctions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

public class AstrometricFunctions {
    public static double VELOCITY_C = 4.74;

    public static double calculateAngularDistance(NumberPair fromCoords, NumberPair toCoords, Double conversionFactor) {
        double ra = Math.toRadians(toCoords.getX());
        double dec = Math.toRadians(toCoords.getY());
        double ra0 = Math.toRadians(fromCoords.getX());
        double dec0 = Math.toRadians(fromCoords.getY());
        double cosc = Math.sin(dec0) * Math.sin(dec) + Math.cos(dec0) * Math.cos(dec) * Math.cos(ra - ra0);
        double distance = Math.toDegrees(Math.acos(cosc)) * conversionFactor;
        return Double.isInfinite(distance) || Double.isNaN(distance) ? 0.0 : distance;
    }

    public static NumberPair calculateDifferenceBetweenCoords(NumberPair fromCoords, NumberPair toCoords) {
        double ra = Math.toRadians(toCoords.getX());
        double dec = Math.toRadians(toCoords.getY());
        double ra0 = Math.toRadians(fromCoords.getX());
        double dec0 = Math.toRadians(fromCoords.getY());
        double cosc = Math.sin(dec0) * Math.sin(dec) + Math.cos(dec0) * Math.cos(dec) * Math.cos(ra - ra0);
        double x = Math.cos(dec) * Math.sin(ra - ra0) / cosc;
        double y = (Math.cos(dec0) * Math.sin(dec) - Math.sin(dec0) * Math.cos(dec) * Math.cos(ra - ra0)) / cosc;
        return new NumberPair(Math.toDegrees(x), Math.toDegrees(y));
    }

    public static NumberPair calculatePositionFromProperMotion(NumberPair coords, NumberPair properMotion) {
        if (properMotion.getX() == 0.0 && properMotion.getY() == 0.0) {
            return coords;
        }
        double x = Math.toRadians(properMotion.getX());
        double y = Math.toRadians(properMotion.getY());
        double ra0 = Math.toRadians(coords.getX());
        double dec0 = Math.toRadians(coords.getY());
        double p = Math.sqrt(x * x + y * y);
        double c = Math.atan(p);
        double ra = ra0 + Math.atan2(x * Math.sin(c), p * Math.cos(dec0) * Math.cos(c) - y * Math.sin(dec0) * Math.sin(c));
        double dec = Math.asin(Math.cos(c) * Math.sin(dec0) + y * Math.sin(c) * Math.cos(dec0) / p);
        return new NumberPair(Math.toDegrees(ra), Math.toDegrees(dec));
    }

    public static double calculateLinearDistance(NumberPair fromCoords, NumberPair toCoords, double fromParallax, double toParallax) {
        double fromRA = Math.toRadians(fromCoords.getX());
        double fromDE = Math.toRadians(fromCoords.getY());
        double fromDist = AstrometricFunctions.calculateParallacticDistance(fromParallax);
        double toRA = Math.toRadians(toCoords.getX());
        double toDE = Math.toRadians(toCoords.getY());
        double toDist = AstrometricFunctions.calculateParallacticDistance(toParallax);
        double x1 = fromDist * Math.cos(fromRA) * Math.cos(fromDE);
        double y1 = fromDist * Math.sin(fromRA) * Math.cos(fromDE);
        double z1 = fromDist * Math.sin(fromDE);
        double x2 = toDist * Math.cos(toRA) * Math.cos(toDE);
        double y2 = toDist * Math.sin(toRA) * Math.cos(toDE);
        double z2 = toDist * Math.sin(toDE);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double calculateParallacticDistance(double parallax) {
        if (parallax < 0.1) {
            return 0.0;
        }
        return 1000.0 / parallax;
    }

    public static NumberPair calculateProperMotions(NumberPair fromCoords, NumberPair toCoords, int fromDays, int toDays, Double conversionFactor) {
        NumberPair diffCoords = AstrometricFunctions.calculateDifferenceBetweenCoords(fromCoords, toCoords);
        double diffRA = diffCoords.getX();
        double diffDE = diffCoords.getY();
        int diffDays = Math.abs(fromDays - toDays);
        double pmRA = diffRA / (double)diffDays * 365.0;
        double pmDE = diffDE / (double)diffDays * 365.0;
        return new NumberPair(pmRA * conversionFactor, pmDE * conversionFactor);
    }

    public static double calculateTotalProperMotion(double pmRA, double pmDE) {
        return Math.sqrt(pmRA * pmRA + pmDE * pmDE);
    }

    public static double calculateTangentialVelocityFromParallax(double pmRA, double pmDE, double parallax) {
        return VELOCITY_C * (AstrometricFunctions.calculateTotalProperMotion(pmRA, pmDE) / 1000.0) * AstrometricFunctions.calculateParallacticDistance(parallax);
    }

    public static double calculateTangentialVelocityFromDistance(double pmRA, double pmDE, double distance) {
        return VELOCITY_C * (AstrometricFunctions.calculateTotalProperMotion(pmRA, pmDE) / 1000.0) * distance;
    }

    public static double calculateTotalVelocity(double tangentialVelocity, double radialVelocity) {
        if (tangentialVelocity == 0.0 || radialVelocity == 0.0) {
            return 0.0;
        }
        return Math.sqrt(tangentialVelocity * tangentialVelocity + radialVelocity * radialVelocity);
    }

    public static double convertToUnit(double toConvert, Unit fromUnit, Unit toUnit) {
        switch (fromUnit) {
            case DEGREE: {
                return switch (toUnit) {
                    case Unit.DEGREE -> toConvert;
                    case Unit.ARCSEC -> toConvert * 3600.0;
                    case Unit.MAS -> toConvert * 3600000.0;
                    default -> 0.0;
                };
            }
            case ARCSEC: {
                return switch (toUnit) {
                    case Unit.DEGREE -> toConvert / 3600.0;
                    case Unit.ARCSEC -> toConvert;
                    case Unit.MAS -> toConvert * 1000.0;
                    default -> 0.0;
                };
            }
            case MAS: {
                return switch (toUnit) {
                    case Unit.DEGREE -> toConvert / 3600000.0;
                    case Unit.ARCSEC -> toConvert / 1000.0;
                    case Unit.MAS -> toConvert;
                    default -> 0.0;
                };
            }
        }
        return 0.0;
    }

    public static NumberPair convertToDecimalCoords(String hmsRA, String dmsDE) {
        String[] parts = hmsRA.trim().replaceAll("[:hms'\"]", " ").split("\\s+");
        int hRA = NumericFunctions.toInteger(parts[0]);
        int mRA = NumericFunctions.toInteger(parts[1]);
        double sRA = NumericFunctions.toDouble(parts[2]);
        double degRA = (double)(hRA * 15) + (double)(mRA * 15) / 60.0 + sRA * 15.0 / 3600.0;
        parts = dmsDE.trim().replaceAll("[:dms\u00b0'\"]", " ").split("\\s+");
        boolean isNegative = parts[0].startsWith("-");
        int dDE = NumericFunctions.toInteger(parts[0]);
        int mDE = NumericFunctions.toInteger(parts[1]);
        double sDE = NumericFunctions.toDouble(parts[2]);
        int sign = dDE < 0 ? -1 : (dDE == 0 ? (isNegative ? -1 : 1) : 1);
        double degDE = (double)dDE + (double)sign * ((double)mDE / 60.0) + (double)sign * (sDE / 3600.0);
        return new NumberPair(degRA, degDE);
    }

    public static StringPair convertToSexagesimalCoords(double degRA, double degDE) {
        int hRA = (int)Math.floor(degRA / 15.0);
        int mRA = (int)Math.floor((degRA / 15.0 - (double)hRA) * 60.0);
        double sRA = (degRA / 15.0 - (double)hRA) * 3600.0 - (double)mRA * 60.0;
        String signDE = "";
        if (degDE < 0.0) {
            degDE = -degDE;
            signDE = "-";
        }
        int dDE = (int)Math.floor(degDE);
        int mDE = (int)Math.floor((degDE - (double)dDE) * 60.0);
        double sDE = (degDE - (double)dDE) * 3600.0 - (double)mDE * 60.0;
        return new StringPair(NumericFunctions.formatInteger(hRA, "00") + " " + NumericFunctions.formatInteger(mRA, "00") + " " + NumericFunctions.formatDouble(sRA, "00.00"), signDE + NumericFunctions.formatInteger(dDE, "00") + " " + NumericFunctions.formatInteger(mDE, "00") + " " + NumericFunctions.formatDouble(sDE, "00.00"));
    }

    public static NumberPair convertToGalacticCoords(double raEquatorial, double decEquatorial) {
        double ra = Math.toRadians(raEquatorial);
        double dec = Math.toRadians(decEquatorial);
        double ra0 = Math.toRadians(192.85948);
        double dec0 = Math.toRadians(27.12825);
        double glon0 = Math.toRadians(122.93192);
        double glon = glon0 - Math.atan(Math.cos(dec) * Math.sin(ra - ra0) / (Math.sin(dec) * Math.cos(dec0) - Math.cos(dec) * Math.sin(dec0) * Math.cos(ra - ra0)));
        double glat = Math.asin(Math.sin(dec) * Math.sin(dec0) + Math.cos(dec) * Math.cos(dec0) * Math.cos(ra - ra0));
        return new NumberPair(Math.toDegrees(glon), Math.toDegrees(glat));
    }

    public static LocalDateTime convertMJDToDateTime(BigDecimal mjd) {
        Instant epoch = OffsetDateTime.of(1858, 11, 17, 0, 0, 0, 0, ZoneOffset.UTC).toInstant();
        BigInteger days = mjd.toBigInteger();
        BigDecimal fractionOfADay = mjd.subtract(new BigDecimal(days));
        BigDecimal decimalSeconds = new BigDecimal(TimeUnit.DAYS.toSeconds(1L)).multiply(fractionOfADay);
        BigInteger integerSeconds = decimalSeconds.toBigInteger();
        BigInteger nanos = decimalSeconds.subtract(new BigDecimal(integerSeconds)).multiply(new BigDecimal(1000000000L)).toBigInteger();
        Duration duration = Duration.ofDays(days.longValue()).plusSeconds(integerSeconds.longValue()).plusNanos(nanos.longValue());
        Instant instant = epoch.plus(duration);
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public static BigDecimal convertDateTimeToMJD(LocalDateTime dateTime) {
        Instant epoch = OffsetDateTime.of(1858, 11, 17, 0, 0, 0, 0, ZoneOffset.UTC).toInstant();
        Duration duration = Duration.between(epoch, dateTime.toInstant(ZoneOffset.UTC));
        Duration durationRemainder = duration.minusDays(duration.toDays());
        BigDecimal wholeDays = new BigDecimal(duration.toDays());
        BigDecimal partialDayInNanos = new BigDecimal(durationRemainder.toNanos());
        BigDecimal nanosInADay = new BigDecimal(TimeUnit.DAYS.toNanos(1L));
        BigDecimal partialDay = partialDayInNanos.divide(nanosInADay, 9, RoundingMode.HALF_EVEN);
        return wholeDays.add(partialDay);
    }

    public static double convertDateToYear(LocalDateTime dateTime) {
        long days = ChronoUnit.DAYS.between(LocalDate.of(0, Month.JANUARY, 1), dateTime);
        return (double)days / 365.2425;
    }

    public static LocalDate convertMJDToDate(double mjd) {
        return AstrometricFunctions.convertMJDToDateTime(new BigDecimal(Double.toString(mjd))).toLocalDate();
    }

    public static boolean isProperMotionSpurious(double value, double error) {
        return Math.abs(value) / error < 2.0;
    }

    public static boolean isProperMotionErroneous(double pmra, double e_pmra, double pmdec, double e_pmdec) {
        return Math.pow(pmra / e_pmra, 2.0) + Math.pow(pmdec / e_pmdec, 2.0) > 27.0;
    }

    public static double calculateChanceAlignmentProbability(int properMotionMatches, double seperation) {
        return (double)properMotionMatches / 41252.96125 * Math.pow(seperation / 3600.0, 2.0) * Math.PI;
    }

    public static double calculatePositionAngle(NumberPair fromCoords, NumberPair toCoords) {
        double ra = Math.toRadians(toCoords.getX());
        double dec = Math.toRadians(toCoords.getY());
        double ra0 = Math.toRadians(fromCoords.getX());
        double dec0 = Math.toRadians(fromCoords.getY());
        double denominator = Math.cos(dec0) * Math.tan(dec) - Math.sin(dec0) * Math.cos(ra - ra0);
        double pa = Math.atan(Math.sin(ra - ra0) / denominator);
        pa = Math.toDegrees(pa);
        return denominator < 0.0 ? pa + 180.0 : (pa < 0.0 ? pa + 360.0 : pa);
    }

    public static double calculateParallaxError(double a, double ae) {
        return Math.sqrt(Math.pow(1000.0 / (a * a) * ae, 2.0));
    }

    public static double calculateDistanceError(double a, double ae) {
        return Math.sqrt(Math.pow(1000.0 / (a * a) * ae, 2.0));
    }

    public static double calculateTotalProperMotionError(double a, double ae, double b, double be) {
        return Math.sqrt(Math.pow(a * 2.0 / (2.0 * Math.sqrt(a * a + b * b)) * ae, 2.0) + Math.pow(b * 2.0 / (2.0 * Math.sqrt(a * a + b * b)) * be, 2.0));
    }

    public static double calculateTangentialVelocityError(double a, double ae, double b, double be, double c, double ce) {
        return Math.sqrt(Math.pow(VELOCITY_C / (a * a) * Math.sqrt(b * b + c * c) * ae, 2.0) + Math.pow(VELOCITY_C * 2.0 / a / (2.0 * Math.sqrt(b * b + c * c)) * b * be, 2.0) + Math.pow(VELOCITY_C * 2.0 / a / (2.0 * Math.sqrt(b * b + c * c)) * c * ce, 2.0));
    }

    public static double calculateAdditionError(double ae, double be) {
        return Math.sqrt(ae * ae + be * be);
    }
}

