/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.function;

import astro.tool.box.container.StringPair;
import astro.tool.box.enumeration.Color;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.lookup.LookupResult;
import astro.tool.box.lookup.SpectralTypeLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PhotometricFunctions {
    public static LookupResult evaluateSpectralType(Color colorKey, double colorValue, SpectralTypeLookup minEntry, SpectralTypeLookup maxEntry) {
        Double minColorValue = minEntry.getColors().get((Object)colorKey);
        Double maxColorValue = maxEntry.getColors().get((Object)colorKey);
        if (minColorValue == null || maxColorValue == null || minColorValue == 0.0 || maxColorValue == 0.0 || colorValue == 0.0) {
            return null;
        }
        if (minColorValue > maxColorValue) {
            double tempColorValue = minColorValue;
            minColorValue = maxColorValue;
            maxColorValue = tempColorValue;
            SpectralTypeLookup tempEntry = minEntry;
            minEntry = maxEntry;
            maxEntry = tempEntry;
        }
        double offset = 0.5;
        double avgColorValue = (minColorValue + maxColorValue) / 2.0;
        if (colorValue >= minColorValue && colorValue < avgColorValue && colorValue <= minColorValue + offset) {
            return new LookupResult(colorKey, colorValue, minEntry.getSpt(), minEntry.getTeff(), minEntry.getRsun(), minEntry.getMsun(), minColorValue, Math.abs(colorValue - minColorValue));
        }
        if (colorValue >= avgColorValue && colorValue <= maxColorValue && colorValue >= maxColorValue - offset) {
            return new LookupResult(colorKey, colorValue, maxEntry.getSpt(), maxEntry.getTeff(), maxEntry.getRsun(), maxEntry.getMsun(), maxColorValue, Math.abs(colorValue - maxColorValue));
        }
        return null;
    }

    public static double calculatePhotometricDistance(double apparent, double absolute) {
        return Math.pow(10.0, (apparent - absolute + 5.0) / 5.0);
    }

    public static double calculateAbsoluteMagnitudeFromParallax(double apparentMagnitude, double parallax) {
        if (apparentMagnitude == 0.0 || parallax == 0.0) {
            return 0.0;
        }
        double absoluteMagnitude = apparentMagnitude + 5.0 - 5.0 * Math.log10(AstrometricFunctions.calculateParallacticDistance(parallax));
        return Double.isInfinite(absoluteMagnitude) || Double.isNaN(absoluteMagnitude) ? 0.0 : absoluteMagnitude;
    }

    public static double calculateAbsoluteMagnitudeFromParallaxError(double m, double e_m, double p, double e_p) {
        if (m == 0.0 || p == 0.0) {
            return 0.0;
        }
        return Math.sqrt(e_m * e_m + Math.pow(-(1.0 / p * 5.0 / (1000.0 * Math.log(10.0)) * -1000.0) * e_p, 2.0));
    }

    public static double calculateAbsoluteMagnitudeFromDistance(double apparentMagnitude, double distance) {
        if (distance == 0.0) {
            return 0.0;
        }
        return apparentMagnitude + 5.0 - 5.0 * Math.log10(distance);
    }

    public static boolean isAPossibleAGN(double W1_W2, double W2_W3) {
        return W1_W2 >= 0.5 && W1_W2 <= 2.7 && W2_W3 >= 2.3 && W2_W3 <= 5.7;
    }

    public static boolean isAPossibleWD(double MGmag, double BP_RP) {
        return MGmag >= 10.0 && MGmag <= 17.0 && BP_RP != 0.0 && BP_RP <= 1.5;
    }

    public static List<StringPair> getFlagLabels(Integer flag, Map<Integer, String> flagStore) {
        ArrayList<StringPair> flagLabels = new ArrayList<StringPair>();
        char[] chars = Integer.toBinaryString(flag).toCharArray();
        int x = 1;
        for (int i = chars.length - 1; i > -1; --i) {
            if (chars[i] == '1') {
                flagLabels.add(new StringPair(String.valueOf(x), flagStore.get(x)));
            }
            x *= 2;
        }
        return flagLabels;
    }

    public static double convertMagnitudeToFluxJansky(double magnitude, double zeroPointFlux) {
        return magnitude == 0.0 ? 0.0 : zeroPointFlux * Math.pow(10.0, -magnitude / 2.5);
    }

    public static double convertMagnitudeToFluxDensity(double magnitude, double zeroPointFlux, double wavelength) {
        return PhotometricFunctions.convertMagnitudeToFluxJansky(magnitude, zeroPointFlux) * Math.pow(10.0, -26.0) * (2.99792458E8 / wavelength * 1000000.0);
    }

    public static double convertMagnitudeToFluxLambda(double magnitude, double zeroPointFlux, double wavelength) {
        return PhotometricFunctions.convertMagnitudeToFluxDensity(magnitude, zeroPointFlux, wavelength) / wavelength;
    }

    public static double calculatePhotometricDistanceError(double a, double ae, double b, double be) {
        if (ae == 0.0 || be == 0.0) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(Math.log(10.0) * Math.pow(10.0, (a - b + 5.0) / 5.0) / 5.0 * ae, 2.0) + Math.pow(Math.pow(10.0, (a - b + 5.0) / 5.0) * -1.0 / 5.0 * Math.log(10.0) * be, 2.0));
    }

    public static double calculateMeanPhotometricDistanceError(double ae, double be) {
        return Math.sqrt(Math.pow(0.5 * ae, 2.0) + Math.pow(0.5 * be, 2.0));
    }
}

