/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.function;

import astro.tool.box.enumeration.StatType;
import astro.tool.box.function.NumericFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class StatisticFunctions {
    public static List<Double> removeOutliers(List<Double> values, double numberOfStds, StatType statType) {
        double avg = StatType.MEAN.equals((Object)statType) ? StatisticFunctions.calculateMean(values) : StatisticFunctions.determineMedian(values);
        double std = StatisticFunctions.calculateStandardDeviation(values);
        return values.stream().filter(val -> StatisticFunctions.isNoOutlier(val, avg, std * numberOfStds)).collect(Collectors.toList());
    }

    public static List<List<Double>> removeOutliers(List<List<Double>> table, int columnIndex, double numberOfStds, StatType statType) {
        List<Double> values = table.stream().map(v -> (Double)v.get(columnIndex)).collect(Collectors.toList());
        double avg = StatType.MEAN.equals((Object)statType) ? StatisticFunctions.calculateMean(values) : StatisticFunctions.determineMedian(values);
        double std = StatisticFunctions.calculateStandardDeviation(values);
        return table.stream().filter(v -> StatisticFunctions.isNoOutlier((Double)v.get(columnIndex), avg, std * numberOfStds)).collect(Collectors.toList());
    }

    private static boolean isNoOutlier(double val, double avg, double dev) {
        return val > avg - dev && val < avg + dev;
    }

    public static List<Double> removeOutliers(List<Double> values, double lowPercentile, double highPercentile) {
        if (lowPercentile < 0.0 || lowPercentile > 100.0) {
            throw new IllegalArgumentException("Low percentile (=%s) out of range. Must be between 0 and 100.".formatted(NumericFunctions.roundTo2Dec(lowPercentile)));
        }
        if (highPercentile < 0.0 || highPercentile > 100.0) {
            throw new IllegalArgumentException("High percentile (=%s) out of range. Must be between 0 and 100.".formatted(NumericFunctions.roundTo2Dec(highPercentile)));
        }
        values.sort(Comparator.naturalOrder());
        int size = values.size();
        int half = size / 2;
        int lowOuliers = (int)((double)half * lowPercentile / 100.0);
        List<Double> lowOuliersRemoved = values.subList(lowOuliers, half);
        int highOutliers = (int)((double)half * (100.0 - highPercentile) / 100.0);
        List<Double> highOutliersRemoved = values.subList(half, size - highOutliers);
        ArrayList<Double> outliersRemoved = new ArrayList<Double>();
        outliersRemoved.addAll(lowOuliersRemoved);
        outliersRemoved.addAll(highOutliersRemoved);
        return outliersRemoved;
    }

    public static double determineMedian(List<Double> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        values.sort(Comparator.naturalOrder());
        int size = values.size();
        int half = size / 2 - 1;
        int n = half = half < 0 ? 0 : half;
        if (size % 2 == 0) {
            return StatisticFunctions.calculateMean(values.get(half), values.get(half + 1));
        }
        return values.get(half);
    }

    public static double calculateMean(double ... values) {
        if (values.length == 0) {
            return 0.0;
        }
        return Arrays.stream(values).average().getAsDouble();
    }

    public static double calculateMean(List<Double> values) {
        return StatisticFunctions.calculateMean(StatisticFunctions.convertToArray(values));
    }

    public static double calculateQuadrature(double ... values) {
        if (values.length == 0) {
            return 0.0;
        }
        double squaredSum = Arrays.stream(values).map(value -> Math.pow(value, 2.0)).sum();
        return Math.sqrt(squaredSum);
    }

    public static double calculateQuadrature(List<Double> values) {
        return StatisticFunctions.calculateQuadrature(StatisticFunctions.convertToArray(values));
    }

    public static double calculateStandardDeviation(double ... values) {
        if (values.length == 0) {
            return 0.0;
        }
        double mean = StatisticFunctions.calculateMean(values);
        double variance = Arrays.stream(values).map(value -> Math.pow(value - mean, 2.0)).average().getAsDouble();
        return Math.sqrt(variance);
    }

    public static double calculateStandardDeviation(List<Double> values) {
        return StatisticFunctions.calculateStandardDeviation(StatisticFunctions.convertToArray(values));
    }

    public static double calculateStandardError(double ... values) {
        if (values.length == 0) {
            return 0.0;
        }
        double standardDeviation = StatisticFunctions.calculateStandardDeviation(values);
        return standardDeviation / Math.sqrt(values.length);
    }

    public static double calculateStandardError(List<Double> values) {
        return StatisticFunctions.calculateStandardError(StatisticFunctions.convertToArray(values));
    }

    public static double[] convertToArray(List<Double> values) {
        double[] doubles = new double[values.size()];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = values.get(i);
        }
        return doubles;
    }
}

