/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.lookup;

import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.Color;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.lookup.SpectralTypeLookup;
import astro.tool.box.tab.SettingsTab;
import java.util.HashMap;
import java.util.Map;

public class BrownDwarfLookupEntry
implements SpectralTypeLookup {
    private final String spt;
    private final Map<Band, Double> magnitudes;
    private final Map<Band, Double> errors;
    private final Map<Color, Double> colors;

    public BrownDwarfLookupEntry(String[] values) {
        this.spt = values[0];
        this.magnitudes = new HashMap<Band, Double>();
        this.magnitudes.put(Band.g, NumericFunctions.toDouble(values[1]));
        this.magnitudes.put(Band.r, NumericFunctions.toDouble(values[2]));
        this.magnitudes.put(Band.i, NumericFunctions.toDouble(values[3]));
        this.magnitudes.put(Band.z, NumericFunctions.toDouble(values[4]));
        this.magnitudes.put(Band.y, NumericFunctions.toDouble(values[5]));
        this.magnitudes.put(Band.J, NumericFunctions.toDouble(values[6]));
        this.magnitudes.put(Band.H, NumericFunctions.toDouble(values[7]));
        this.magnitudes.put(Band.K, NumericFunctions.toDouble(values[8]));
        this.magnitudes.put(Band.W1, NumericFunctions.toDouble(values[9]));
        this.magnitudes.put(Band.W2, NumericFunctions.toDouble(values[10]));
        this.magnitudes.put(Band.W3, NumericFunctions.toDouble(values[11]));
        this.magnitudes.put(Band.BP, NumericFunctions.toDouble(values[36]));
        this.magnitudes.put(Band.G, NumericFunctions.toDouble(values[37]));
        this.magnitudes.put(Band.RP, NumericFunctions.toDouble(values[38]));
        this.colors = new HashMap<Color, Double>();
        this.colors.put(Color.g_r_PS1, NumericFunctions.toDouble(values[12]));
        this.colors.put(Color.r_i_PS1, NumericFunctions.toDouble(values[13]));
        this.colors.put(Color.i_z_PS1, NumericFunctions.toDouble(values[14]));
        this.colors.put(Color.z_y_PS1, NumericFunctions.toDouble(values[15]));
        this.colors.put(Color.i_y_PS1, NumericFunctions.toDouble(values[22]));
        this.colors.put(Color.J_K, NumericFunctions.toDouble(values[25]));
        this.colors.put(Color.W1_W2, NumericFunctions.toDouble(values[20]));
        this.colors.put(Color.i_z_NSC, NumericFunctions.toDouble(values[27]));
        this.colors.put(Color.i_z_DES, NumericFunctions.toDouble(values[27]));
        this.colors.put(Color.i_z, NumericFunctions.toDouble(values[30]));
        this.colors.put(Color.G_RP, NumericFunctions.toDouble(values[33]));
        this.colors.put(Color.BP_RP, NumericFunctions.toDouble(values[34]));
        this.colors.put(Color.BP_G, NumericFunctions.toDouble(values[35]));
        this.colors.put(Color.M_BP, NumericFunctions.toDouble(values[36]));
        this.colors.put(Color.M_G, NumericFunctions.toDouble(values[37]));
        this.colors.put(Color.M_RP, NumericFunctions.toDouble(values[38]));
        boolean photometricErrors = Boolean.parseBoolean(SettingsTab.getUserSetting("photometricErrors", "false"));
        if (photometricErrors) {
            this.colors.put(Color.e_g_r_PS1, NumericFunctions.toDouble(values[12]));
            this.colors.put(Color.e_r_i_PS1, NumericFunctions.toDouble(values[13]));
            this.colors.put(Color.e_i_z_PS1, NumericFunctions.toDouble(values[14]));
            this.colors.put(Color.e_z_y_PS1, NumericFunctions.toDouble(values[15]));
            this.colors.put(Color.e_i_y_PS1, NumericFunctions.toDouble(values[22]));
            this.colors.put(Color.E_g_r_PS1, NumericFunctions.toDouble(values[12]));
            this.colors.put(Color.E_r_i_PS1, NumericFunctions.toDouble(values[13]));
            this.colors.put(Color.E_i_z_PS1, NumericFunctions.toDouble(values[14]));
            this.colors.put(Color.E_z_y_PS1, NumericFunctions.toDouble(values[15]));
            this.colors.put(Color.E_i_y_PS1, NumericFunctions.toDouble(values[22]));
            this.colors.put(Color.e_J_K, NumericFunctions.toDouble(values[25]));
            this.colors.put(Color.E_J_K, NumericFunctions.toDouble(values[25]));
            this.colors.put(Color.e_W1_W2, NumericFunctions.toDouble(values[20]));
            this.colors.put(Color.E_W1_W2, NumericFunctions.toDouble(values[20]));
            this.colors.put(Color.e_i_z_NSC, NumericFunctions.toDouble(values[27]));
            this.colors.put(Color.E_i_z_NSC, NumericFunctions.toDouble(values[27]));
            this.colors.put(Color.e_i_z_DES, NumericFunctions.toDouble(values[27]));
            this.colors.put(Color.E_i_z_DES, NumericFunctions.toDouble(values[27]));
            this.colors.put(Color.e_i_z, NumericFunctions.toDouble(values[30]));
            this.colors.put(Color.E_i_z, NumericFunctions.toDouble(values[30]));
            this.colors.put(Color.e_G_RP, NumericFunctions.toDouble(values[33]));
            this.colors.put(Color.e_BP_RP, NumericFunctions.toDouble(values[34]));
            this.colors.put(Color.e_BP_G, NumericFunctions.toDouble(values[35]));
            this.colors.put(Color.e_M_BP, NumericFunctions.toDouble(values[36]));
            this.colors.put(Color.e_M_G, NumericFunctions.toDouble(values[37]));
            this.colors.put(Color.e_M_RP, NumericFunctions.toDouble(values[38]));
            this.colors.put(Color.E_G_RP, NumericFunctions.toDouble(values[33]));
            this.colors.put(Color.E_BP_RP, NumericFunctions.toDouble(values[34]));
            this.colors.put(Color.E_BP_G, NumericFunctions.toDouble(values[35]));
            this.colors.put(Color.E_M_BP, NumericFunctions.toDouble(values[36]));
            this.colors.put(Color.E_M_G, NumericFunctions.toDouble(values[37]));
            this.colors.put(Color.E_M_RP, NumericFunctions.toDouble(values[38]));
        }
        this.errors = new HashMap<Band, Double>();
        this.errors.put(Band.g, NumericFunctions.toDouble(values[39]));
        this.errors.put(Band.r, NumericFunctions.toDouble(values[40]));
        this.errors.put(Band.i, NumericFunctions.toDouble(values[41]));
        this.errors.put(Band.z, NumericFunctions.toDouble(values[42]));
        this.errors.put(Band.y, NumericFunctions.toDouble(values[43]));
        this.errors.put(Band.J, NumericFunctions.toDouble(values[44]));
        this.errors.put(Band.H, NumericFunctions.toDouble(values[45]));
        this.errors.put(Band.K, NumericFunctions.toDouble(values[46]));
        this.errors.put(Band.W1, NumericFunctions.toDouble(values[47]));
        this.errors.put(Band.W2, NumericFunctions.toDouble(values[48]));
        this.errors.put(Band.W3, NumericFunctions.toDouble(values[49]));
        this.errors.put(Band.BP, NumericFunctions.toDouble(values[50]));
        this.errors.put(Band.G, NumericFunctions.toDouble(values[51]));
        this.errors.put(Band.RP, NumericFunctions.toDouble(values[52]));
    }

    public String toString() {
        return "BrownDwarfLookupEntry{spt=" + this.spt + ", bands=" + String.valueOf(this.magnitudes) + ", errors=" + String.valueOf(this.errors) + ", colors=" + String.valueOf(this.colors) + "}";
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public int getTeff() {
        return 0;
    }

    @Override
    public double getRsun() {
        return 0.0;
    }

    @Override
    public double getMsun() {
        return 0.0;
    }

    public Map<Band, Double> getMagnitudes() {
        return this.magnitudes;
    }

    public Map<Band, Double> getErrors() {
        return this.errors;
    }

    @Override
    public Map<Color, Double> getColors() {
        return this.colors;
    }
}

