/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.lookup;

import astro.tool.box.enumeration.Band;
import java.util.Objects;

public class DistanceLookupResult {
    private final Band bandKey;
    private final double bandValue;
    private final String spt;
    private final double distance;
    private final double distanceError;

    public DistanceLookupResult(Band bandKey, double bandValue, String spt, double distance, double distanceError) {
        this.bandKey = bandKey;
        this.bandValue = bandValue;
        this.spt = spt;
        this.distance = distance;
        this.distanceError = distanceError;
    }

    public String toString() {
        return "DistanceLookupResult{bandKey=" + String.valueOf((Object)this.bandKey) + ", bandValue=" + this.bandValue + ", spt=" + this.spt + ", distance=" + this.distance + ", distanceError=" + this.distanceError + "}";
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode((Object)this.bandKey);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.bandValue) ^ Double.doubleToLongBits(this.bandValue) >>> 32);
        hash = 47 * hash + Objects.hashCode(this.spt);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.distance) ^ Double.doubleToLongBits(this.distance) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.distanceError) ^ Double.doubleToLongBits(this.distanceError) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DistanceLookupResult other = (DistanceLookupResult)obj;
        if (Double.doubleToLongBits(this.bandValue) != Double.doubleToLongBits(other.bandValue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        if (Double.doubleToLongBits(this.distanceError) != Double.doubleToLongBits(other.distanceError)) {
            return false;
        }
        if (!Objects.equals(this.spt, other.spt)) {
            return false;
        }
        return this.bandKey == other.bandKey;
    }

    public Band getBandKey() {
        return this.bandKey;
    }

    public double getBandValue() {
        return this.bandValue;
    }

    public String getSpt() {
        return this.spt;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getDistanceError() {
        return this.distanceError;
    }
}

