/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.lookup;

import astro.tool.box.enumeration.Color;
import java.util.Objects;

public class LookupResult {
    private final Color colorKey;
    private final double colorValue;
    private final String spt;
    private final int teff;
    private final double rsun;
    private final double msun;
    private final double nearest;
    private final double gap;
    private Double sptNum;

    public LookupResult(Color colorKey, double colorValue, String spt, int teff, double rsun, double msun, double nearest, double gap) {
        this.colorKey = colorKey;
        this.colorValue = colorValue;
        this.spt = spt;
        this.teff = teff;
        this.rsun = rsun;
        this.msun = msun;
        this.nearest = nearest;
        this.gap = gap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LookupResult{colorKey=").append((Object)this.colorKey);
        sb.append(", colorValue=").append(this.colorValue);
        sb.append(", spt=").append(this.spt);
        sb.append(", teff=").append(this.teff);
        sb.append(", rsun=").append(this.rsun);
        sb.append(", msun=").append(this.msun);
        sb.append(", nearest=").append(this.nearest);
        sb.append(", gap=").append(this.gap);
        sb.append(", sptNum=").append(this.sptNum);
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode((Object)this.colorKey);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.colorValue) ^ Double.doubleToLongBits(this.colorValue) >>> 32);
        hash = 17 * hash + Objects.hashCode(this.spt);
        hash = 17 * hash + this.teff;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.rsun) ^ Double.doubleToLongBits(this.rsun) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.msun) ^ Double.doubleToLongBits(this.msun) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.nearest) ^ Double.doubleToLongBits(this.nearest) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.gap) ^ Double.doubleToLongBits(this.gap) >>> 32);
        hash = 17 * hash + Objects.hashCode(this.sptNum);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LookupResult other = (LookupResult)obj;
        if (Double.doubleToLongBits(this.colorValue) != Double.doubleToLongBits(other.colorValue)) {
            return false;
        }
        if (this.teff != other.teff) {
            return false;
        }
        if (Double.doubleToLongBits(this.rsun) != Double.doubleToLongBits(other.rsun)) {
            return false;
        }
        if (Double.doubleToLongBits(this.msun) != Double.doubleToLongBits(other.msun)) {
            return false;
        }
        if (Double.doubleToLongBits(this.nearest) != Double.doubleToLongBits(other.nearest)) {
            return false;
        }
        if (Double.doubleToLongBits(this.gap) != Double.doubleToLongBits(other.gap)) {
            return false;
        }
        if (!Objects.equals(this.spt, other.spt)) {
            return false;
        }
        if (this.colorKey != other.colorKey) {
            return false;
        }
        return Objects.equals(this.sptNum, other.sptNum);
    }

    public Color getColorKey() {
        return this.colorKey;
    }

    public double getColorValue() {
        return this.colorValue;
    }

    public String getSpt() {
        return this.spt;
    }

    public int getTeff() {
        return this.teff;
    }

    public double getRsun() {
        return this.rsun;
    }

    public double getMsun() {
        return this.msun;
    }

    public double getNearest() {
        return this.nearest;
    }

    public double getGap() {
        return this.gap;
    }

    public Double getSptNum() {
        return this.sptNum;
    }

    public void setSptNum(Double sptNum) {
        this.sptNum = sptNum;
    }
}

