/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.lookup;

import astro.tool.box.enumeration.Color;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.lookup.SpectralTypeLookup;
import astro.tool.box.tab.SettingsTab;
import java.util.HashMap;
import java.util.Map;

public class SpectralTypeLookupEntry
implements SpectralTypeLookup {
    private final String spt;
    private final int teff;
    private final double rsun;
    private final double msun;
    private final Map<Color, Double> colors;

    public SpectralTypeLookupEntry(String[] values) {
        this.spt = values[0];
        this.teff = NumericFunctions.toInteger(values[1]);
        this.rsun = NumericFunctions.toDouble(values[29]);
        this.msun = NumericFunctions.toDouble(values[30]);
        this.colors = new HashMap<Color, Double>();
        this.colors.put(Color.BP_RP, NumericFunctions.toDouble(values[10]));
        this.colors.put(Color.G_RP, NumericFunctions.toDouble(values[11]));
        this.colors.put(Color.M_G, NumericFunctions.toDouble(values[12]));
        this.colors.put(Color.W1_W2, NumericFunctions.toDouble(values[21]));
        this.colors.put(Color.i_z, NumericFunctions.toDouble(values[27]));
        boolean photometricErrors = Boolean.parseBoolean(SettingsTab.getUserSetting("photometricErrors", "false"));
        if (photometricErrors) {
            this.colors.put(Color.e_BP_RP, NumericFunctions.toDouble(values[10]));
            this.colors.put(Color.e_G_RP, NumericFunctions.toDouble(values[11]));
            this.colors.put(Color.e_M_G, NumericFunctions.toDouble(values[12]));
            this.colors.put(Color.E_BP_RP, NumericFunctions.toDouble(values[10]));
            this.colors.put(Color.E_G_RP, NumericFunctions.toDouble(values[11]));
            this.colors.put(Color.E_M_G, NumericFunctions.toDouble(values[12]));
            this.colors.put(Color.e_W1_W2, NumericFunctions.toDouble(values[21]));
            this.colors.put(Color.E_W1_W2, NumericFunctions.toDouble(values[21]));
            this.colors.put(Color.e_i_z, NumericFunctions.toDouble(values[27]));
            this.colors.put(Color.E_i_z, NumericFunctions.toDouble(values[27]));
        }
    }

    public String toString() {
        return "SpectralTypeLookupEntry{spt=" + this.spt + ", teff=" + this.teff + ", rsun=" + this.rsun + ", msun=" + this.msun + ", colors=" + String.valueOf(this.colors) + "}";
    }

    @Override
    public String getSpt() {
        return this.spt;
    }

    @Override
    public int getTeff() {
        return this.teff;
    }

    @Override
    public double getRsun() {
        return this.rsun;
    }

    @Override
    public double getMsun() {
        return this.msun;
    }

    @Override
    public Map<Color, Double> getColors() {
        return this.colors;
    }
}

