/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.main;

import astro.tool.box.container.NumberTriplet;
import astro.tool.box.container.Version;
import astro.tool.box.enumeration.TabCode;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.tab.AdqlQueryTab;
import astro.tool.box.tab.BatchQueryTab;
import astro.tool.box.tab.CatalogQueryTab;
import astro.tool.box.tab.CustomOverlaysTab;
import astro.tool.box.tab.FileBrowserTab;
import astro.tool.box.tab.ImageSeriesTab;
import astro.tool.box.tab.ImageViewerTab;
import astro.tool.box.tab.LookupTab;
import astro.tool.box.tab.ObjectCollectionTab;
import astro.tool.box.tab.PhotometricClassifierTab;
import astro.tool.box.tab.SettingsTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.tab.ToolTab;
import astro.tool.box.tab.VizierCatalogsTab;
import astro.tool.box.util.CSVParser;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.ToolTipManager;

public class Application {
    private int defaultCloseOperation;
    private JFrame baseFrame;
    private JTabbedPane tabbedPane;
    private CatalogQueryTab catalogQueryTab;
    private ImageViewerTab imageViewerTab;
    private static boolean versionLoaded;
    public static List<NumberTriplet> CMD_DATA;

    public Application() {
        try {
            SettingsTab.loadUserSettings();
            SettingsTab.setLookAndFeel(SettingsTab.getLookAndFeel());
            ToolTipManager manager = ToolTipManager.sharedInstance();
            manager.setInitialDelay(100);
            manager.setDismissDelay(60000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        block16: {
            Tab tab;
            this.baseFrame = new JFrame();
            this.baseFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            this.baseFrame.setTitle("%s %s".formatted("AstroToolBox", "4.5.0"));
            this.baseFrame.setSize(new Dimension(ToolboxHelper.BASE_FRAME_WIDTH, ToolboxHelper.BASE_FRAME_HEIGHT));
            this.baseFrame.setDefaultCloseOperation(this.defaultCloseOperation);
            this.tabbedPane = new JTabbedPane(1, 1);
            this.baseFrame.add(this.tabbedPane);
            String sourceTabs = SettingsTab.USER_SETTINGS.getProperty("sourceTabs", "");
            String destTabs = SettingsTab.USER_SETTINGS.getProperty("destTabs", TabCode.getTabCodes());
            HashMap<String, Tab> tabs = new HashMap<String, Tab>();
            this.imageViewerTab = new ImageViewerTab(this.baseFrame, this.tabbedPane);
            this.imageViewerTab.init(true);
            this.catalogQueryTab = new CatalogQueryTab(this.baseFrame, this.tabbedPane);
            tabs.put(TabCode.CQ.name(), this.catalogQueryTab);
            ImageSeriesTab imageSeriesTab = new ImageSeriesTab(this.baseFrame, this.tabbedPane, this.imageViewerTab);
            tabs.put(TabCode.IS.name(), imageSeriesTab);
            PhotometricClassifierTab photoClassTab = new PhotometricClassifierTab(this.baseFrame, this.tabbedPane, this.catalogQueryTab, this.imageViewerTab);
            tabs.put(TabCode.PC.name(), photoClassTab);
            VizierCatalogsTab vizierCatalogsTab = new VizierCatalogsTab(this.baseFrame, this.tabbedPane);
            tabs.put(TabCode.VC.name(), vizierCatalogsTab);
            AdqlQueryTab adqlQueryTab = new AdqlQueryTab(this.baseFrame, this.tabbedPane);
            tabs.put(TabCode.AQ.name(), adqlQueryTab);
            BatchQueryTab batchQueryTab = new BatchQueryTab(this.baseFrame, this.tabbedPane, this.catalogQueryTab, this.imageViewerTab);
            tabs.put(TabCode.BQ.name(), batchQueryTab);
            FileBrowserTab fileBrowserTab = new FileBrowserTab(this.baseFrame, this.tabbedPane, this.catalogQueryTab, this.imageViewerTab);
            tabs.put(TabCode.FB.name(), fileBrowserTab);
            ObjectCollectionTab objectCollectionTab = new ObjectCollectionTab(this.baseFrame, this.tabbedPane, this.catalogQueryTab, this.imageViewerTab);
            tabs.put(TabCode.OC.name(), objectCollectionTab);
            CustomOverlaysTab customOverlaysTab = new CustomOverlaysTab(this.baseFrame, this.tabbedPane, this.imageViewerTab);
            tabs.put(TabCode.CO.name(), customOverlaysTab);
            ToolTab toolTab = new ToolTab(this.baseFrame, this.tabbedPane);
            tabs.put(TabCode.TO.name(), toolTab);
            LookupTab lookupTab = new LookupTab(this.baseFrame, this.tabbedPane);
            tabs.put(TabCode.LO.name(), lookupTab);
            for (String sourceTab : sourceTabs.split(",", -1)) {
                if (sourceTab.isEmpty() || (tab = (Tab)tabs.get(sourceTab)) == null) continue;
                tab.init(false);
            }
            for (String destTab : destTabs.split(",", -1)) {
                if (destTab.isEmpty() || (tab = (Tab)tabs.get(destTab)) == null) continue;
                tab.init(true);
            }
            SettingsTab settingsTab = new SettingsTab(this.baseFrame, this.tabbedPane, this.catalogQueryTab, this.imageViewerTab, batchQueryTab);
            settingsTab.init(true);
            this.baseFrame.setLocationRelativeTo(null);
            this.baseFrame.setVisible(true);
            boolean checkVersion = Boolean.parseBoolean(SettingsTab.getUserSetting("checkVersion", "true"));
            if (!versionLoaded && checkVersion) {
                try {
                    String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection("https://fkiwy.github.io/AstroToolBox/releases/versions.txt"), "AstroToolBox version file");
                    if (response.isEmpty()) break block16;
                    String currentVersion = "4.5.0";
                    String latestVersion = "Not available!";
                    LocalDate referenceDate = LocalDate.now().minusMonths(1L);
                    LocalDate releaseDate = LocalDate.MIN;
                    String versionMessage = "";
                    try (Scanner scanner = new Scanner(response);){
                        while (scanner.hasNextLine()) {
                            String[] values = CSVParser.parseLine(scanner.nextLine());
                            Version version = new Version(values[0], Boolean.parseBoolean(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]), Integer.parseInt(values[4]), values[5]);
                            if (!version.isLatest()) continue;
                            latestVersion = version.getNumber();
                            releaseDate = version.getDate();
                            versionMessage = version.getMessage();
                        }
                    }
                    int latestVersion_num = Integer.parseInt(latestVersion.replace(".", ""));
                    int currentVersion_num = Integer.parseInt(currentVersion.replace(".", ""));
                    if (currentVersion_num < latestVersion_num) {
                        long remainingDays = ChronoUnit.DAYS.between(referenceDate, releaseDate);
                        this.showVersionPanel(this.baseFrame, currentVersion, latestVersion, remainingDays, versionMessage);
                        if (referenceDate.isEqual(releaseDate) || referenceDate.isAfter(releaseDate)) {
                            System.exit(0);
                        }
                    }
                }
                catch (IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
                finally {
                    versionLoaded = true;
                }
            }
        }
    }

    private void showVersionPanel(JFrame baseFrame, String currentVersion, String latestVersion, long remainingDays, String versionMessage) {
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.add(new JLabel("There's a new AstroToolBox version available!"));
        container.add(ToolboxHelper.createHyperlink("> Download new version", "https://fkiwy.github.io/AstroToolBox/releases/" + "executables/AstroToolBox-%s.jar".formatted(latestVersion)));
        container.add(ToolboxHelper.createHyperlink("> Check release notes", "https://fkiwy.github.io/AstroToolBox/releases/release%20notes.md"));
        container.add(new JLabel("Please make sure to always use the latest version of this tool!"));
        container.add(new JLabel("Previous versions may contain bugs and/or may no longer work properly."));
        container.add(new JLabel("Latest version: " + latestVersion));
        String versionText = "Current version: " + currentVersion;
        JLabel versionLabel = new JLabel();
        if (remainingDays < 1L) {
            versionLabel.setText(versionText + " has expired!");
            versionLabel.setForeground(Color.RED);
        } else {
            versionLabel.setText(versionText + " will expire in " + remainingDays + " days.");
        }
        container.add(versionLabel);
        if (!versionMessage.isEmpty()) {
            JTextPane textPane = new JTextPane();
            textPane.setText(versionMessage);
            textPane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(textPane);
            scrollPane.setBorder(ToolboxHelper.createEtchedBorder("Info"));
            scrollPane.setPreferredSize(new Dimension(300, 100));
            container.add(scrollPane);
        }
        JOptionPane.showMessageDialog(baseFrame, container, "Version info", 1);
    }

    public void setDefaultCloseOperation(int defaultCloseOperation) {
        this.defaultCloseOperation = defaultCloseOperation;
    }

    public JFrame getBaseFrame() {
        return this.baseFrame;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public CatalogQueryTab getCatalogQueryTab() {
        return this.catalogQueryTab;
    }

    public ImageViewerTab getImageViewerTab() {
        return this.imageViewerTab;
    }
}

