/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.main;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.SimbadCatalogEntry;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.container.BatchResult;
import astro.tool.box.container.Couple;
import astro.tool.box.container.FlipbookComponent;
import astro.tool.box.container.NirImage;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.lookup.BrownDwarfLookupEntry;
import astro.tool.box.lookup.SpectralTypeLookup;
import astro.tool.box.lookup.SpectralTypeLookupEntry;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.main.WatermarkedCell;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.service.SpectralTypeLookupService;
import astro.tool.box.tab.ImageViewerTab;
import astro.tool.box.tab.SettingsTab;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class ImageSeriesPdf {
    private static final Font HEADER_FONT = FontFactory.getFont("Helvetica", 16.0f, BaseColor.DARK_GRAY);
    private static final Font LARGE_FONT = FontFactory.getFont("Helvetica", 9.0f, BaseColor.BLACK);
    private static final Font MEDIUM_FONT = FontFactory.getFont("Helvetica", 7.5f, BaseColor.BLACK);
    private static final Font SMALL_FONT = FontFactory.getFont("Helvetica", 6.0f, BaseColor.BLACK);
    private static final Font SMALL_WHITE_FONT = FontFactory.getFont("Helvetica", 6.0f, BaseColor.WHITE);
    private final double targetRa;
    private final double targetDec;
    private final int size;
    private final ImageViewerTab imageViewerTab;
    private final Map<String, CatalogEntry> catalogInstances;
    private final CatalogQueryService catalogQueryService;
    private final SpectralTypeLookupService mainSequenceLookupService;
    private final SpectralTypeLookupService brownDwarfsLookupService;

    public ImageSeriesPdf(double targetRa, double targetDec, int size, ImageViewerTab imageViewerTab) {
        List<SpectralTypeLookup> entries;
        Stream<String> stream;
        InputStream input;
        this.targetRa = targetRa;
        this.targetDec = targetDec;
        this.size = size;
        this.imageViewerTab = imageViewerTab;
        this.catalogInstances = ToolboxHelper.getCatalogInstances();
        this.catalogQueryService = new CatalogQueryService();
        try {
            input = this.getClass().getResourceAsStream("/SpectralTypeLookupTable.csv");
            try {
                stream = new BufferedReader(new InputStreamReader(input)).lines();
                entries = stream.skip(1L).map(line -> new SpectralTypeLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                this.mainSequenceLookupService = new SpectralTypeLookupService(entries);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            input = this.getClass().getResourceAsStream("/BrownDwarfLookupTable.csv");
            try {
                stream = new BufferedReader(new InputStreamReader(input)).lines();
                entries = stream.skip(1L).map(line -> new BrownDwarfLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                this.brownDwarfsLookupService = new SpectralTypeLookupService(entries);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean create(JFrame baseFrame) {
        this.imageViewerTab.setWaitCursor(false);
        JTextField coordsField = this.imageViewerTab.getCoordsField();
        ActionListener actionListener = coordsField.getActionListeners()[0];
        coordsField.removeActionListener(actionListener);
        coordsField.setText(NumericFunctions.roundTo7DecNZ(this.targetRa) + " " + NumericFunctions.roundTo7DecNZ(this.targetDec));
        coordsField.addActionListener(actionListener);
        JTextField sizeField = this.imageViewerTab.getSizeField();
        actionListener = sizeField.getActionListeners()[0];
        sizeField.removeActionListener(actionListener);
        sizeField.setText(String.valueOf(this.size));
        sizeField.addActionListener(actionListener);
        try {
            Map<String, String> imageInfos;
            String imageLabel;
            int year;
            NirImage nirImage;
            String band;
            Map<String, NirImage> nirImages;
            int year_2ir;
            this.imageViewerTab.getZoomSlider().setValue(250);
            this.imageViewerTab.getSkipIntermediateEpochs().setSelected(false);
            this.imageViewerTab.createFlipbook();
            baseFrame.setCursor(Cursor.getPredefinedCursor(3));
            File tmpFile = File.createTempFile("Target_" + NumericFunctions.roundTo2DecNZ(this.targetRa) + NumericFunctions.addPlusSign(NumericFunctions.roundDouble(this.targetDec, "#.##")) + "_", ".pdf");
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(tmpFile));
            DocumentFooter event = new DocumentFooter();
            writer.setPageEvent(event);
            document.open();
            Chunk chunk = new Chunk("Target: " + NumericFunctions.roundTo6DecNZ(this.targetRa) + " " + NumericFunctions.addPlusSign(NumericFunctions.roundDouble(this.targetDec, "#.######")) + " FoV: " + this.size + "\"", HEADER_FONT);
            document.add(chunk);
            document.add(new Paragraph(" "));
            ArrayList<Couple> timeSeries = new ArrayList<Couple>();
            ArrayList<Couple<String, BufferedImage>> images = new ArrayList<Couple<String, BufferedImage>>();
            int year_1b = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss1_blue");
            int year_1r = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss1_red");
            int year_2b = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss2ukstu_blue");
            int year_2r = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss2ukstu_red");
            int year_2ir_1r_1b = year_2ir = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss2ukstu_ir");
            BufferedImage bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss1_blue&type=jpgurl");
            if (bufferedImage != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DSS1 B", year_1b), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss1_red&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DSS1 R", year_1r), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss2ukstu_blue&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DSS2 B", year_2b), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss2ukstu_red&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DSS2 R", year_2r), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "dss", "dss_bands=poss2ukstu_ir&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DSS2 IR", year_2ir), bufferedImage));
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DSS IR", year_2ir), new NirImage(year_2ir, bufferedImage)));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "dss", "file_type=colorimage")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DSS IR-R-B", year_2ir_1r_1b), bufferedImage));
            }
            this.createPdfTable(images, writer, document);
            int year_j = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "2mass", "twomass_bands=j");
            int year_h = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "2mass", "twomass_bands=h");
            int year_k = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "2mass", "twomass_bands=k");
            int year_k_h_j = ToolboxHelper.getMeanEpoch(year_k, year_h, year_j);
            images = new ArrayList();
            bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "2mass", "twomass_bands=j&type=jpgurl");
            if (bufferedImage != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("2MASS J", year_j), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "2mass", "twomass_bands=h&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("2MASS H", year_h), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "2mass", "twomass_bands=k&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("2MASS K", year_k), bufferedImage));
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("2MASS K", year_k), new NirImage(year_k, bufferedImage)));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "2mass", "file_type=colorimage")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("2MASS K-H-J", year_k_h_j), bufferedImage));
            }
            this.createPdfTable(images, writer, document);
            int year_u = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=u");
            int year_g = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=g");
            int year_r = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=r");
            int year_i = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=i");
            int year_z = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=z");
            int year_z_g_u = ToolboxHelper.getMeanEpoch(year_z, year_g, year_u);
            images = new ArrayList();
            bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=u&type=jpgurl");
            if (bufferedImage != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("SDSS u", year_u), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=g&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("SDSS g", year_g), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=r&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("SDSS r", year_r), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=i&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("SDSS i", year_i), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "sdss", "sdss_bands=z&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("SDSS z", year_z), bufferedImage));
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("SDSS z", year_z), new NirImage(year_z, bufferedImage)));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "sdss", "file_type=colorimage")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("SDSS z-g-u", year_z_g_u), bufferedImage));
            }
            this.createPdfTable(images, writer, document);
            int year_ch1 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:IRAC1");
            int year_ch2 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:IRAC2");
            int year_ch3 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:IRAC3");
            int year_ch4 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:IRAC4");
            int year_mips24 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:MIPS24");
            int year_ch3_ch2_ch1 = ToolboxHelper.getMeanEpoch(year_ch3, year_ch2, year_ch1);
            images = new ArrayList();
            bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:IRAC1&type=jpgurl");
            if (bufferedImage != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("IRAC1", year_ch1), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:IRAC2&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("IRAC2", year_ch2), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:IRAC3&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("IRAC3", year_ch3), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:IRAC4&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("IRAC4", year_ch4), bufferedImage));
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("IRAC4", year_ch4), new NirImage(2003, bufferedImage)));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "seip", "seip_bands=spitzer.seip_science:MIPS24&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("MIPS24", year_mips24), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "seip", "file_type=colorimage")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("IRAC3-2-1", year_ch3_ch2_ch1), bufferedImage));
            }
            this.createPdfTable(images, writer, document);
            int year_w1 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "wise", "wise_bands=1");
            int year_w2 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "wise", "wise_bands=2");
            int year_w3 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "wise", "wise_bands=3");
            int year_w4 = ToolboxHelper.getEpoch(this.targetRa, this.targetDec, this.size, "wise", "wise_bands=4");
            int year_w4_w2_w1 = ToolboxHelper.getMeanEpoch(year_w4, year_w2, year_w1);
            images = new ArrayList();
            bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "wise", "wise_bands=1&type=jpgurl");
            if (bufferedImage != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("WISE W1", year_w1), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "wise", "wise_bands=2&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("WISE W2", year_w2), bufferedImage));
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("WISE W2", year_w2), new NirImage(2010, bufferedImage)));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "wise", "wise_bands=3&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("WISE W3", year_w3), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "wise", "wise_bands=4&type=jpgurl")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("WISE W4", year_w4), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveImage(this.targetRa, this.targetDec, this.size, "wise", "file_type=colorimage")) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("WISE W4-W2-W1", year_w4_w2_w1), bufferedImage));
            }
            this.createPdfTable(images, writer, document);
            if (this.targetDec > -5.0) {
                images = new ArrayList();
                nirImages = ToolboxHelper.retrieveNearInfraredImages(this.targetRa, this.targetDec, this.size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UKIDSSDR11PLUS&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UKIDSS");
                if (!nirImages.isEmpty()) {
                    for (Map.Entry<String, NirImage> entry : nirImages.entrySet()) {
                        band = entry.getKey();
                        nirImage = entry.getValue();
                        bufferedImage = nirImage.getImage();
                        year = nirImage.getYear();
                        if (bufferedImage == null) continue;
                        imageLabel = "UKIDSS " + band;
                        images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel(imageLabel, year), bufferedImage));
                        if (!band.equals("K")) continue;
                        timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel(imageLabel, year), new NirImage(year, bufferedImage)));
                    }
                    this.createPdfTable(images, writer, document);
                }
            }
            if (this.targetDec > -5.0) {
                images = new ArrayList();
                nirImages = ToolboxHelper.retrieveNearInfraredImages(this.targetRa, this.targetDec, this.size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UHSDR3&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UHS");
                if (!nirImages.isEmpty()) {
                    for (Map.Entry<String, NirImage> entry : nirImages.entrySet()) {
                        band = entry.getKey();
                        nirImage = entry.getValue();
                        bufferedImage = nirImage.getImage();
                        year = nirImage.getYear();
                        if (bufferedImage == null) continue;
                        imageLabel = "UHS " + band;
                        images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel(imageLabel, year), bufferedImage));
                        if (!band.equals("K")) continue;
                        timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel(imageLabel, year), new NirImage(year, bufferedImage)));
                    }
                    this.createPdfTable(images, writer, document);
                }
            }
            if (this.targetDec < 5.0) {
                images = new ArrayList();
                nirImages = ToolboxHelper.retrieveNearInfraredImages(this.targetRa, this.targetDec, this.size, "http://vsa.roe.ac.uk:8080/vdfs/GetImage?database=VHSDR6&programmeID=110&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=tilestack", "VHS");
                if (!nirImages.isEmpty()) {
                    for (Map.Entry<String, NirImage> entry : nirImages.entrySet()) {
                        band = entry.getKey();
                        nirImage = entry.getValue();
                        bufferedImage = nirImage.getImage();
                        year = nirImage.getYear();
                        if (bufferedImage == null) continue;
                        imageLabel = "VHS " + band;
                        images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel(imageLabel, year), bufferedImage));
                        if (!band.equals("K")) continue;
                        timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel(imageLabel, year), new NirImage(year, bufferedImage)));
                    }
                    this.createPdfTable(images, writer, document);
                }
            }
            if (!(imageInfos = ToolboxHelper.getPs1FileNames(this.targetRa, this.targetDec)).isEmpty()) {
                Map<String, Double> years = ToolboxHelper.getPs1Epochs(this.targetRa, this.targetDec);
                year_g = years.get("g").intValue();
                year_r = years.get("r").intValue();
                year_i = years.get("i").intValue();
                year_z = years.get("z").intValue();
                int year_y = years.get("y").intValue();
                int year_y_i_g = ToolboxHelper.getMeanEpoch(year_y, year_i, year_g);
                images = new ArrayList();
                bufferedImage = ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("g")), this.targetRa, this.targetDec, this.size, true);
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("PS1 g", year_g), bufferedImage));
                bufferedImage = ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("r")), this.targetRa, this.targetDec, this.size, true);
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("PS1 r", year_r), bufferedImage));
                bufferedImage = ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("i")), this.targetRa, this.targetDec, this.size, true);
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("PS1 i", year_i), bufferedImage));
                bufferedImage = ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("z")), this.targetRa, this.targetDec, this.size, true);
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("PS1 z", year_z), bufferedImage));
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("PS1 z", year_z), new NirImage(year_z, bufferedImage)));
                bufferedImage = ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("y")), this.targetRa, this.targetDec, this.size, true);
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("PS1 y", year_y), bufferedImage));
                bufferedImage = ToolboxHelper.retrievePs1Image("red=%s&green=%s&blue=%s".formatted(imageInfos.get("y"), imageInfos.get("i"), imageInfos.get("g")), this.targetRa, this.targetDec, this.size, false);
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("PS1 y-i-g", year_y_i_g), bufferedImage));
                this.createPdfTable(images, writer, document);
            }
            images = new ArrayList();
            bufferedImage = ToolboxHelper.retrieveDesiImage(this.targetRa, this.targetDec, this.size, "g", true);
            if (bufferedImage != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DECaLS g", "DR10"), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveDesiImage(this.targetRa, this.targetDec, this.size, "r", true)) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DECaLS r", "DR10"), bufferedImage));
            }
            if ((bufferedImage = ToolboxHelper.retrieveDesiImage(this.targetRa, this.targetDec, this.size, "z", true)) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DECaLS z", "DR10"), bufferedImage));
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DECaLS z", "DR10"), new NirImage(2017, bufferedImage)));
            }
            if ((bufferedImage = ToolboxHelper.retrieveDesiImage(this.targetRa, this.targetDec, this.size, "griz", false)) != null) {
                images.add(new Couple<String, BufferedImage>(ToolboxHelper.getImageLabel("DECaLS", "DR10"), bufferedImage));
            }
            this.createPdfTable(images, writer, document);
            images = new ArrayList();
            timeSeries.sort(Comparator.comparing(c -> ((NirImage)c.getB()).getYear()));
            for (Couple couple : timeSeries) {
                images.add(new Couple(couple.getA(), ((NirImage)couple.getB()).getImage()));
            }
            this.createPdfTable(images, writer, document);
            images = new ArrayList();
            List<FlipbookComponent> flipbook = this.imageViewerTab.getFlipbook();
            for (int i = 0; i < flipbook.size(); ++i) {
                FlipbookComponent component = flipbook.get(i);
                images.add(new Couple<String, BufferedImage>(component.getTitle(), this.imageViewerTab.processImage(component, i)));
            }
            this.createPdfTable(images, writer, document);
            int searchRadius = 10;
            ArrayList<CatalogEntry> catalogEntries = new ArrayList<CatalogEntry>();
            List<String> selectedCatalogs = SettingsTab.getSelectedCatalogs(this.catalogInstances);
            for (CatalogEntry catalogEntry : this.catalogInstances.values()) {
                if (!selectedCatalogs.contains(catalogEntry.getCatalogName())) continue;
                catalogEntry.setRa(this.targetRa);
                catalogEntry.setDec(this.targetDec);
                catalogEntry.setSearchRadius(searchRadius);
                List<CatalogEntry> results = this.performQuery(catalogEntry);
                if (results == null) continue;
                catalogEntries.addAll(results);
            }
            String mainHeader = "CATALOG ENTRIES (Search radius = " + NumericFunctions.roundTo1DecNZ(searchRadius) + "\")";
            document.add(this.createCatalogEntriesTable(this.mainSequenceLookupService, catalogEntries, "Main sequence spectral type estimates (*)", mainHeader));
            document.add(new Paragraph("(*) Uses color-spectral type relations from Eric Mamajek's Modern Mean Dwarf Stellar Color & Effective Temperature Sequence", SMALL_FONT));
            document.add(this.createCatalogEntriesTable(this.brownDwarfsLookupService, catalogEntries, "M, L & T dwarfs spectral type estimates (*)", null));
            document.add(new Paragraph("(*) Uses color-spectral type relations from Skrzypek et al. (2015), Skrzypek et al. (2016), Deacon et al. (2016), Best et al. (2018), Carnero Rosell et al. (2019) and Kiman et al. (2019)", SMALL_FONT));
            document.close();
            Desktop.getDesktop().open(tmpFile);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(baseFrame, ex);
        }
        finally {
            this.imageViewerTab.setWaitCursor(true);
            baseFrame.setCursor(Cursor.getDefaultCursor());
            coordsField.setCursor(Cursor.getDefaultCursor());
            sizeField.setCursor(Cursor.getDefaultCursor());
        }
        return true;
    }

    private PdfPTable createCatalogEntriesTable(SpectralTypeLookupService spectralTypeLookupService, List<CatalogEntry> catalogEntries, String header, String mainHeader) throws Exception {
        PdfPCell tableHeader;
        ArrayList<BatchResult> batchResults = new ArrayList<BatchResult>();
        for (CatalogEntry catalogEntry : catalogEntries) {
            Object entry;
            List<String> spectralTypes = ToolboxHelper.lookupSpectralTypes(catalogEntry.getColors(true), spectralTypeLookupService, true);
            if (catalogEntry instanceof SimbadCatalogEntry) {
                SimbadCatalogEntry simbadEntry = (SimbadCatalogEntry)catalogEntry;
                StringBuilder simbadType = new StringBuilder();
                simbadType.append(simbadEntry.getObjectType());
                if (!simbadEntry.getSpectralType().isEmpty()) {
                    simbadType.append(" ").append(simbadEntry.getSpectralType());
                }
                simbadType.append("; ");
                spectralTypes.add(0, simbadType.toString());
            }
            if (catalogEntry instanceof AllWiseCatalogEntry && PhotometricFunctions.isAPossibleAGN(((AllWiseCatalogEntry)(entry = (AllWiseCatalogEntry)catalogEntry)).getW1_W2(), ((AllWiseCatalogEntry)entry).getW2_W3())) {
                spectralTypes.add("Possible AGN!");
            }
            if (catalogEntry instanceof WhiteDwarf && PhotometricFunctions.isAPossibleWD((entry = (WhiteDwarf)((Object)catalogEntry)).getAbsoluteGmag(), entry.getBP_RP())) {
                spectralTypes.add("Possible white dwarf!");
            }
            BatchResult batchResult = new BatchResult.Builder().setCatalogName(catalogEntry.getCatalogName()).setTargetRa(this.targetRa).setTargetDec(this.targetDec).setTargetDistance(catalogEntry.getTargetDistance()).setRa(catalogEntry.getRa()).setDec(catalogEntry.getDec()).setSourceId(catalogEntry.getSourceId() + " ").setPlx(catalogEntry.getPlx()).setPmra(catalogEntry.getTotalProperMotion() > 100000.0 ? 0.0 : catalogEntry.getPmra()).setPmdec(catalogEntry.getTotalProperMotion() > 100000.0 ? 0.0 : catalogEntry.getPmdec()).setMagnitudes(catalogEntry.getMagnitudes()).setSpectralTypes(spectralTypes).build();
            batchResults.add(batchResult);
        }
        int numberOfCols = 10;
        PdfPTable table = new PdfPTable(numberOfCols);
        table.setTotalWidth(new float[]{50.0f, 30.0f, 40.0f, 40.0f, 80.0f, 30.0f, 35.0f, 35.0f, 100.0f, 100.0f});
        table.setLockedWidth(true);
        table.setSpacingBefore(10.0f);
        table.setKeepTogether(true);
        table.setHorizontalAlignment(0);
        if (mainHeader != null) {
            tableHeader = new PdfPCell(new Phrase(mainHeader, LARGE_FONT));
            tableHeader.setHorizontalAlignment(0);
            tableHeader.setColspan(numberOfCols);
            tableHeader.setBorderWidth(0.0f);
            tableHeader.setPaddingBottom(10.0f);
            table.addCell(tableHeader);
        }
        tableHeader = new PdfPCell(new Phrase(header, MEDIUM_FONT));
        tableHeader.setHorizontalAlignment(0);
        tableHeader.setColspan(numberOfCols);
        tableHeader.setBorderWidth(0.0f);
        tableHeader.setPaddingBottom(5.0f);
        table.addCell(tableHeader);
        this.addHeaderCell(table, "Catalog", 0);
        this.addHeaderCell(table, "Target dist. (\")", 2);
        this.addHeaderCell(table, "RA", 0);
        this.addHeaderCell(table, "dec", 0);
        this.addHeaderCell(table, "Source id", 0);
        this.addHeaderCell(table, "Plx (mas)", 2);
        this.addHeaderCell(table, "pmRA (mas/yr)", 2);
        this.addHeaderCell(table, "pmdec (mas/yr)", 2);
        this.addHeaderCell(table, "Magnitudes", 0);
        this.addHeaderCell(table, "Spectral types", 0);
        for (int i = 0; i < batchResults.size(); ++i) {
            BatchResult batchResult = (BatchResult)batchResults.get(i);
            this.addCell(table, batchResult.getCatalogName(), 0, i, SMALL_FONT);
            this.addCell(table, NumericFunctions.roundTo3Dec(batchResult.getTargetDistance()), 2, i, SMALL_FONT);
            this.addCell(table, NumericFunctions.roundTo6DecNZ(batchResult.getRa()), 0, i, SMALL_FONT);
            this.addCell(table, NumericFunctions.roundTo6DecNZ(batchResult.getDec()), 0, i, SMALL_FONT);
            this.addCell(table, batchResult.getSourceId(), 0, i, SMALL_FONT);
            this.addCell(table, NumericFunctions.roundTo3Dec(batchResult.getPlx()), 2, i, SMALL_FONT);
            this.addCell(table, NumericFunctions.roundTo3Dec(batchResult.getPmra()), 2, i, SMALL_FONT);
            this.addCell(table, NumericFunctions.roundTo3Dec(batchResult.getPmdec()), 2, i, SMALL_FONT);
            this.addCell(table, batchResult.getMagnitudes(), 0, i, SMALL_FONT);
            this.addCell(table, batchResult.joinSpetralTypes(), 0, i, SMALL_FONT);
        }
        return table;
    }

    private void createPdfTable(List<Couple<String, BufferedImage>> images, PdfWriter writer, Document document) throws Exception {
        int numberOfImages = images.size();
        if (numberOfImages == 0) {
            return;
        }
        int maxCellsPerRow = 7;
        int cellsPerRow = numberOfImages;
        int totalCells = numberOfImages;
        if (numberOfImages > maxCellsPerRow) {
            cellsPerRow = maxCellsPerRow;
            int remainder = numberOfImages % maxCellsPerRow;
            int numberOfRows = numberOfImages / maxCellsPerRow;
            numberOfRows = remainder > 0 ? numberOfRows + 1 : numberOfRows;
            totalCells = numberOfRows * maxCellsPerRow;
        }
        float[] widths = new float[cellsPerRow];
        for (int i = 0; i < cellsPerRow; ++i) {
            widths[i] = 75.0f;
        }
        PdfPTable table = new PdfPTable(cellsPerRow);
        table.setTotalWidth(widths);
        table.setLockedWidth(true);
        table.setSpacingAfter(5.0f);
        table.setHorizontalAlignment(0);
        for (int i = 0; i < totalCells; ++i) {
            if (i < numberOfImages) {
                Couple<String, BufferedImage> couple = images.get(i);
                String label = couple.getA();
                BufferedImage bi = ToolboxHelper.drawCenterShape(couple.getB());
                com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance(writer, (Image)bi, 1.0f);
                PdfPCell cell = new PdfPCell(image, true);
                cell.setCellEvent(new WatermarkedCell(label));
                cell.setBorderWidth(0.0f);
                cell.setPadding(1.0f);
                table.addCell(cell);
                continue;
            }
            PdfPCell cell = new PdfPCell();
            cell.setBorderWidth(0.0f);
            cell.setPadding(1.0f);
            table.addCell(cell);
        }
        document.add(table);
    }

    private void addHeaderCell(PdfPTable table, Object value, int alignment) {
        PdfPCell cell = new PdfPCell(new Phrase(value.toString(), SMALL_WHITE_FONT));
        cell.setHorizontalAlignment(alignment);
        cell.setBackgroundColor(BaseColor.DARK_GRAY);
        cell.setBorderColor(BaseColor.WHITE);
        cell.setBorderWidth(0.0f);
        cell.setPadding(2.0f);
        table.addCell(cell);
    }

    private void addCell(PdfPTable table, Object value, int alignment, int rowIndex, Font font) {
        PdfPCell cell = new PdfPCell(new Phrase(value.toString(), font));
        cell.setHorizontalAlignment(alignment);
        cell.setBackgroundColor(rowIndex % 2 == 0 ? BaseColor.WHITE : BaseColor.LIGHT_GRAY);
        cell.setBorderColor(BaseColor.WHITE);
        cell.setBorderWidth(0.0f);
        cell.setPadding(2.0f);
        table.addCell(cell);
    }

    private List<CatalogEntry> performQuery(CatalogEntry catalogQuery) throws IOException {
        List<CatalogEntry> catalogEntries = this.catalogQueryService.getCatalogEntriesByCoords(catalogQuery);
        catalogEntries.forEach(catalogEntry -> {
            catalogEntry.setTargetRa(catalogQuery.getRa());
            catalogEntry.setTargetDec(catalogQuery.getDec());
        });
        if (!catalogEntries.isEmpty()) {
            catalogEntries.sort(Comparator.comparingDouble(CatalogEntry::getTargetDistance));
            return catalogEntries;
        }
        return null;
    }

    class DocumentFooter
    extends PdfPageEventHelper {
        DocumentFooter() {
        }

        @Override
        public void onEndPage(PdfWriter writer, Document document) {
            PdfContentByte cb = writer.getDirectContent();
            Phrase footer = new Phrase("AstroToolBox 4.5.0 - Page " + writer.getPageNumber(), SMALL_FONT);
            ColumnText.showTextAligned(cb, 1, footer, (document.right() - document.left()) / 2.0f + document.leftMargin(), document.bottom() - 10.0f, 0.0f);
        }
    }
}

