/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.main;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.CatWiseCatalogEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.DesCatalogEntry;
import astro.tool.box.catalog.GaiaDR2CatalogEntry;
import astro.tool.box.catalog.GaiaDR3CatalogEntry;
import astro.tool.box.catalog.GaiaWDCatalogEntry;
import astro.tool.box.catalog.MocaCatalogEntry;
import astro.tool.box.catalog.NoirlabCatalogEntry;
import astro.tool.box.catalog.PanStarrsCatalogEntry;
import astro.tool.box.catalog.SdssCatalogEntry;
import astro.tool.box.catalog.SimbadCatalogEntry;
import astro.tool.box.catalog.TessCatalogEntry;
import astro.tool.box.catalog.TwoMassCatalogEntry;
import astro.tool.box.catalog.UhsCatalogEntry;
import astro.tool.box.catalog.UkidssCatalogEntry;
import astro.tool.box.catalog.UnWiseCatalogEntry;
import astro.tool.box.catalog.VhsCatalogEntry;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.component.TranslucentLabel;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.CollectedObject;
import astro.tool.box.container.Couple;
import astro.tool.box.container.MjdEpoch;
import astro.tool.box.container.NirImage;
import astro.tool.box.container.NumberPair;
import astro.tool.box.container.Tiles;
import astro.tool.box.enumeration.Alignment;
import astro.tool.box.enumeration.BasicDataType;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.lookup.DistanceLookupResult;
import astro.tool.box.lookup.LookupResult;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.service.DistanceLookupService;
import astro.tool.box.service.NameResolverService;
import astro.tool.box.service.SpectralTypeLookupService;
import astro.tool.box.shape.Circle;
import astro.tool.box.tab.SettingsTab;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.Constants;
import astro.tool.box.util.ExternalResources;
import astro.tool.box.util.FileTypeFilter;
import astro.tool.box.util.GifSequencer;
import astro.tool.box.util.ServiceHelper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jfree.chart.JFreeChart;

public class ToolboxHelper {
    public static final String PGM_NAME = "AstroToolBox";
    public static final String PGM_VERSION = "4.5.0";
    public static final String RELEASES_URL = "https://fkiwy.github.io/AstroToolBox/releases/";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String AGN_WARNING = "Possible AGN!";
    public static final String WD_WARNING = "Possible white dwarf!";
    public static final String INFO_ICON = "<span style='color:red'>&#9432;</span>";
    public static final String PHOT_DIST_INFO = "Clicking on a table row displays photometric distance estimates for the specified spectral type.";
    private static final String ERROR_FILE_NAME = "/AstroToolBoxError.txt";
    private static final String ERROR_FILE_PATH = USER_HOME + "/AstroToolBoxError.txt";
    public static int BASE_FRAME_WIDTH = 1275;
    public static int BASE_FRAME_HEIGHT = 875;
    public static int BUFFER_SIZE = 8192;

    public static Image getToolBoxImage() {
        ImageIcon icon = new ImageIcon(ToolboxHelper.class.getResource("/icons/toolbox.png"));
        return icon.getImage();
    }

    public static ImageIcon getInfoIcon() {
        return new ImageIcon(ToolboxHelper.class.getResource("/icons/info.png"));
    }

    public static Map<String, CatalogEntry> getCatalogInstances() {
        LinkedHashMap<String, CatalogEntry> catalogInstances = new LinkedHashMap<String, CatalogEntry>();
        SimbadCatalogEntry simbadCatalogEntry = new SimbadCatalogEntry();
        catalogInstances.put(simbadCatalogEntry.getCatalogName(), simbadCatalogEntry);
        AllWiseCatalogEntry allWiseCatalogEntry = new AllWiseCatalogEntry();
        catalogInstances.put(allWiseCatalogEntry.getCatalogName(), allWiseCatalogEntry);
        CatWiseCatalogEntry catWiseCatalogEntry = new CatWiseCatalogEntry();
        catalogInstances.put(catWiseCatalogEntry.getCatalogName(), catWiseCatalogEntry);
        UnWiseCatalogEntry unWiseCatalogEntry = new UnWiseCatalogEntry();
        catalogInstances.put(unWiseCatalogEntry.getCatalogName(), unWiseCatalogEntry);
        GaiaDR2CatalogEntry gaiaCatalogEntry = new GaiaDR2CatalogEntry();
        catalogInstances.put(gaiaCatalogEntry.getCatalogName(), gaiaCatalogEntry);
        GaiaDR3CatalogEntry gaiaDR3CatalogEntry = new GaiaDR3CatalogEntry();
        catalogInstances.put(gaiaDR3CatalogEntry.getCatalogName(), gaiaDR3CatalogEntry);
        NoirlabCatalogEntry noirlabCatalogEntry = new NoirlabCatalogEntry();
        catalogInstances.put(noirlabCatalogEntry.getCatalogName(), noirlabCatalogEntry);
        PanStarrsCatalogEntry panStarrsCatalogEntry = new PanStarrsCatalogEntry();
        catalogInstances.put(panStarrsCatalogEntry.getCatalogName(), panStarrsCatalogEntry);
        SdssCatalogEntry sdssCatalogEntry = new SdssCatalogEntry();
        catalogInstances.put(sdssCatalogEntry.getCatalogName(), sdssCatalogEntry);
        VhsCatalogEntry vhsCatalogEntry = new VhsCatalogEntry();
        catalogInstances.put(vhsCatalogEntry.getCatalogName(), vhsCatalogEntry);
        UhsCatalogEntry uhsCatalogEntry = new UhsCatalogEntry();
        catalogInstances.put(uhsCatalogEntry.getCatalogName(), uhsCatalogEntry);
        UkidssCatalogEntry ukidssCatalogEntry = new UkidssCatalogEntry();
        catalogInstances.put(ukidssCatalogEntry.getCatalogName(), ukidssCatalogEntry);
        TwoMassCatalogEntry twoMassCatalogEntry = new TwoMassCatalogEntry();
        catalogInstances.put(twoMassCatalogEntry.getCatalogName(), twoMassCatalogEntry);
        TessCatalogEntry tessCatalogEntry = new TessCatalogEntry();
        catalogInstances.put(tessCatalogEntry.getCatalogName(), tessCatalogEntry);
        DesCatalogEntry desCatalogEntry = new DesCatalogEntry();
        catalogInstances.put(desCatalogEntry.getCatalogName(), desCatalogEntry);
        GaiaWDCatalogEntry gaiaWDCatalogEntry = new GaiaWDCatalogEntry();
        catalogInstances.put(gaiaWDCatalogEntry.getCatalogName(), gaiaWDCatalogEntry);
        MocaCatalogEntry mocaCatalogEntry = new MocaCatalogEntry();
        catalogInstances.put(mocaCatalogEntry.getCatalogName(), mocaCatalogEntry);
        return catalogInstances;
    }

    public static JLabel createHyperlink(String label, String uri) {
        return ToolboxHelper.createHyperlink(new JLabel(label), uri);
    }

    public static JLabel createHyperlink(JLabel label, final String uri) {
        label.setForeground(JColor.LINK_BLUE.val);
        label.setCursor(Cursor.getPredefinedCursor(12));
        if (label.getMouseListeners().length > 0) {
            label.removeMouseListener(label.getMouseListeners()[0]);
        }
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(uri));
                }
                catch (IOException | URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return label;
    }

    public static void showScrollableDialog(JFrame baseFrame, String title, String message) {
        JOptionPane.showMessageDialog(baseFrame, ToolboxHelper.createMessagePanel(message), title, -1);
    }

    public static void showInfoDialog(JFrame baseFrame, String message) {
        JOptionPane.showMessageDialog(baseFrame, message, "Info", 1);
    }

    public static void showWarnDialog(JFrame baseFrame, String message) {
        JOptionPane.showMessageDialog(baseFrame, message, "Warning", 2);
    }

    public static void showErrorDialog(JFrame baseFrame, String message) {
        JOptionPane.showMessageDialog(baseFrame, message, "Error", 0);
    }

    public static void showScrollableErrorDialog(JFrame baseFrame, String message) {
        JOptionPane.showMessageDialog(baseFrame, ToolboxHelper.createMessagePanel(message), "Error", 0);
    }

    public static void showExceptionDialog(JFrame baseFrame, Exception error) {
        ToolboxHelper.writeErrorLog(error);
        JOptionPane.showMessageDialog(baseFrame, ToolboxHelper.createMessagePanel(ToolboxHelper.formatError(error)), "Error", 0);
    }

    public static void writeErrorLog(Exception error) {
        ToolboxHelper.writeLogEntry(ToolboxHelper.formatError(error));
    }

    public static void writeMessageLog(String message) {
        ToolboxHelper.writeLogEntry(ToolboxHelper.formatMessage(message));
    }

    private static void writeLogEntry(String entry) {
        try {
            Files.write(Paths.get(ERROR_FILE_PATH, new String[0]), entry.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static JScrollPane createMessagePanel(String message) {
        JTextPane textPane = new JTextPane();
        textPane.setText(message);
        textPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        scrollPane.setPreferredSize(new Dimension(700, 500));
        return scrollPane;
    }

    public static boolean showConfirmDialog(JFrame baseFrame, String message) {
        int option = JOptionPane.showConfirmDialog(baseFrame, message, "Confimation", 2);
        return option == 0;
    }

    public static String red(String text) {
        return ToolboxHelper.html("<span style='color:red'>" + text + "</span>");
    }

    public static String bold(String text) {
        return ToolboxHelper.html("<b>" + text + "</b>");
    }

    public static String html(String text) {
        return "<html>" + text + "</html>";
    }

    public static JLabel createHeaderLabel(String text) {
        return ToolboxHelper.createHeaderLabel(text, 2);
    }

    public static JLabel createHeaderLabel(String text, int alignment) {
        JLabel header = new JLabel(text);
        header.setBorder(new EmptyBorder(0, 5, 0, 0));
        header.setBackground(Color.GRAY.brighter());
        header.setForeground(Color.BLACK);
        header.setOpaque(true);
        header.setHorizontalAlignment(alignment);
        return header;
    }

    public static JCheckBox createHeaderBox(String text) {
        JCheckBox box = new JCheckBox(text);
        box.setBackground(Color.GRAY.brighter());
        box.setForeground(Color.BLACK);
        return box;
    }

    public static JLabel createMessageLabel() {
        return ToolboxHelper.createLabel("", JColor.DARK_GREEN);
    }

    public static JLabel createLabel(Object text, JColor color) {
        JLabel label = new JLabel(text.toString());
        label.setForeground(color.val);
        return label;
    }

    public static Border createEtchedBorder(String boderTitle) {
        return ToolboxHelper.createEtchedBorder(boderTitle, null);
    }

    public static Border createEtchedBorder(String boderTitle, Color titleColor) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), boderTitle, 1, 2, null, titleColor);
    }

    public static Border createEmptyBorder(String boderTitle) {
        return ToolboxHelper.createEmptyBorder(boderTitle, null);
    }

    public static Border createEmptyBorder(String boderTitle, Color titleColor) {
        return BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), boderTitle, 1, 2, null, titleColor);
    }

    public static boolean isSameTarget(double targetRa, double targetDec, double size, double previousRa, double previousDec, double previousSize) {
        return targetRa == previousRa && targetDec == previousDec && size == previousSize;
    }

    public static NumberPair getCoordinates(String coords) {
        coords = coords.replace('\u2212', '-');
        Pattern pattern = Pattern.compile(".*[a-zA-Z]+.*");
        Matcher matcher = pattern.matcher(coords);
        if (matcher.matches()) {
            try {
                NameResolverService nameResolverService = new NameResolverService();
                coords = nameResolverService.getCoordinatesByName(coords);
            }
            catch (Exception ex) {
                coords = coords.replaceAll("[^\\d .-]", "");
            }
        }
        String[] parts = ToolboxHelper.splitCoordinates(coords);
        double ra = NumericFunctions.toDouble(parts[0].trim());
        double dec = NumericFunctions.toDouble(parts[1].trim());
        return new NumberPair(ra, dec);
    }

    private static String[] splitCoordinates(String coords) {
        coords = ToolboxHelper.convertToDecimalCoords(coords);
        return coords.trim().replaceAll("[,;]", " ").split("\\s+");
    }

    private static String convertToDecimalCoords(String coords) {
        String[] parts = coords.replaceAll("[:hdms\u00b0'\"]", " ").split("\\s+");
        if (parts.length == 6) {
            Object ra = "";
            for (int i = 0; i < 3; ++i) {
                ra = (String)ra + parts[i] + " ";
            }
            Object dec = "";
            for (int i = 3; i < 6; ++i) {
                dec = (String)dec + parts[i] + " ";
            }
            NumberPair decCoords = AstrometricFunctions.convertToDecimalCoords((String)ra, (String)dec);
            return NumericFunctions.roundTo7DecNZ(decCoords.getX()) + " " + NumericFunctions.roundTo7DecNZ(decCoords.getY());
        }
        return coords;
    }

    public static void copyCoordsToClipboard(double degRA, double degDE) {
        String coordsToCopy = NumericFunctions.roundTo7DecNZ(degRA) + " " + NumericFunctions.roundTo7DecNZ(degDE);
        ToolboxHelper.copyToClipboard(coordsToCopy);
    }

    public static void copyToClipboard(String toCopy) {
        StringSelection stringSelection = new StringSelection(toCopy);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public static void addEmptyCatalogElement(JPanel detailPanel) {
        ToolboxHelper.addLabelToPanel(new CatalogElement(), detailPanel);
        ToolboxHelper.addLabelToPanel(new CatalogElement(), detailPanel);
    }

    public static void addLabelToPanel(CatalogElement element, JPanel panel) {
        String name = element.getName();
        JLabel label = new JLabel((String)(name == null ? "" : name + ": "), 4);
        if (element.getToolTip() != null) {
            label.setToolTipText(ToolboxHelper.html(element.getToolTip()));
        }
        panel.add(label);
    }

    public static void addFieldToPanel(CatalogElement element, JPanel panel) {
        boolean hasToolTip;
        String value = element.getValue();
        boolean bl = hasToolTip = element.getToolTip() != null;
        JTextField field = new JTextField((String)(value == null ? "" : value + (hasToolTip ? " (*)" : "")));
        field.setBackground(new JLabel().getBackground());
        if (element.isComputed()) {
            field.setForeground(JColor.DARK_GREEN.val);
        }
        if (element.isFaulty()) {
            field.setForeground(JColor.RED.val);
        }
        field.setCaretPosition(0);
        field.setBorder(BorderFactory.createEmptyBorder());
        field.setEditable(false);
        if (hasToolTip) {
            field.setToolTipText(ToolboxHelper.html(element.getToolTip()));
        }
        field.setPreferredSize(new Dimension(100, field.getPreferredSize().height));
        panel.add(field);
    }

    public static void alignCatalogColumns(JTable table, CatalogEntry entry) {
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        leftRenderer.setHorizontalAlignment(2);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        List<CatalogElement> elements = entry.getCatalogElements();
        for (int i = 0; i < elements.size(); ++i) {
            Alignment alignment = elements.get(i).getAlignment();
            table.getColumnModel().getColumn(i).setCellRenderer(alignment.equals((Object)Alignment.LEFT) ? leftRenderer : rightRenderer);
        }
    }

    public static TableRowSorter createCatalogTableSorter(DefaultTableModel defaultTableModel, CatalogEntry entry) {
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(defaultTableModel);
        List<CatalogElement> elements = entry.getCatalogElements();
        for (int i = 0; i < elements.size(); ++i) {
            sorter.setComparator(i, elements.get(i).getComparator());
        }
        return sorter;
    }

    public static void alignResultColumns(JTable table, List<String[]> rows) {
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        leftRenderer.setHorizontalAlignment(2);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        Map<Integer, BasicDataType> types = ToolboxHelper.determineBasicTypes(rows);
        for (int i = 0; i < types.size(); ++i) {
            DefaultTableCellRenderer cellRenderer = BasicDataType.NUMERIC.equals((Object)types.get(i)) ? rightRenderer : leftRenderer;
            table.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
        }
    }

    public static TableRowSorter createResultTableSorter(DefaultTableModel defaultTableModel, List<String[]> rows) {
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>();
        ToolboxHelper.addComparatorsToTableSorter(sorter, defaultTableModel, rows);
        return sorter;
    }

    public static void addComparatorsToTableSorter(TableRowSorter<TableModel> sorter, DefaultTableModel defaultTableModel, List<String[]> rows) {
        sorter.setModel(defaultTableModel);
        Map<Integer, BasicDataType> types = ToolboxHelper.determineBasicTypes(rows);
        for (int i = 0; i < types.size(); ++i) {
            Comparator comparator = BasicDataType.NUMERIC.equals((Object)types.get(i)) ? Comparators.getDoubleComparator() : Comparators.getStringComparator();
            sorter.setComparator(i, comparator);
        }
    }

    private static Map<Integer, BasicDataType> determineBasicTypes(List<String[]> rows) {
        HashMap<Integer, BasicDataType> types = new HashMap<Integer, BasicDataType>();
        rows.forEach(row -> {
            for (int i = 0; i < ((String[])row).length; ++i) {
                String columnValue = row[i];
                if (columnValue.isEmpty()) continue;
                BasicDataType type = (BasicDataType)((Object)((Object)types.get(i)));
                if (type == null) {
                    type = BasicDataType.NONE;
                }
                if (type.equals((Object)BasicDataType.ALPHA_NUMERIC)) continue;
                type = NumericFunctions.isNumeric(columnValue) ? BasicDataType.NUMERIC : BasicDataType.ALPHA_NUMERIC;
                types.put(i, type);
            }
        });
        return types;
    }

    public static void resizeColumnWidth(JTable table) {
        ToolboxHelper.resizeColumnWidth(table, 300);
    }

    public static void resizeColumnWidth(JTable table, int maxColWidth) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            int width = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component component = table.prepareRenderer(renderer, row, column);
                width = Math.max(component.getPreferredSize().width + 1, width);
            }
            if (maxColWidth > 0 && width > maxColWidth) {
                width = maxColWidth;
            }
            columnModel.getColumn(column).setPreferredWidth(width + 20);
        }
    }

    public static RowFilter getCustomRowFilter(final String filterText) {
        return new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    if (!entry.getStringValue(i).toUpperCase().contains(filterText.toUpperCase())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static void alignResultColumns(JTable table) {
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        leftRenderer.setHorizontalAlignment(2);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        int i = 0;
        table.getColumnModel().getColumn(i++).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(rightRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(leftRenderer);
        table.getColumnModel().getColumn(i++).setCellRenderer(leftRenderer);
    }

    public static TableRowSorter createResultTableSorter(DefaultTableModel defaultTableModel) {
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(defaultTableModel);
        int i = 0;
        sorter.setComparator(i++, Comparators.getIntegerComparator());
        sorter.setComparator(i++, Comparators.getIntegerComparator());
        sorter.setComparator(i++, Comparators.getStringComparator());
        sorter.setComparator(i++, Comparators.getDoubleComparator());
        sorter.setComparator(i++, Comparators.getDoubleComparator());
        sorter.setComparator(i++, Comparators.getDoubleComparator());
        sorter.setComparator(i++, Comparators.getDoubleComparator());
        sorter.setComparator(i++, Comparators.getDoubleComparator());
        sorter.setComparator(i++, Comparators.getStringComparator());
        sorter.setComparator(i++, Comparators.getDoubleComparator());
        sorter.setComparator(i++, Comparators.getDoubleComparator());
        sorter.setComparator(i++, Comparators.getDoubleComparator());
        sorter.setComparator(i++, Comparators.getStringComparator());
        sorter.setComparator(i++, Comparators.getStringComparator());
        return sorter;
    }

    public static List<String> lookupSpectralTypes(Map<astro.tool.box.enumeration.Color, Double> colors, SpectralTypeLookupService spectralTypeLookupService, boolean includeColors) {
        List<LookupResult> results = spectralTypeLookupService.lookup(colors);
        ArrayList<String> spectralTypes = new ArrayList<String>();
        results.forEach(entry -> {
            Object spectralType = entry.getSpt();
            if (includeColors) {
                String matchedColor = entry.getColorKey().val + "=" + NumericFunctions.roundTo3DecNZ(entry.getColorValue());
                spectralType = (String)spectralType + ": " + matchedColor;
            }
            spectralType = (String)spectralType + "; ";
            spectralTypes.add((String)spectralType);
        });
        return spectralTypes;
    }

    public static void collectObject(String objectType, CatalogEntry catalogEntry, JFrame baseFrame, SpectralTypeLookupService spectralTypeLookupService, JTable collectionTable) {
        WhiteDwarf entry;
        AllWiseCatalogEntry allWiseEntry;
        List<String> spectralTypes = ToolboxHelper.lookupSpectralTypes(catalogEntry.getColors(true), spectralTypeLookupService, true);
        if (catalogEntry instanceof SimbadCatalogEntry) {
            SimbadCatalogEntry simbadEntry = (SimbadCatalogEntry)catalogEntry;
            StringBuilder simbadType = new StringBuilder();
            simbadType.append(simbadEntry.getObjectType());
            if (!simbadEntry.getSpectralType().isEmpty()) {
                simbadType.append(" ").append(simbadEntry.getSpectralType());
            }
            simbadType.append("; ");
            spectralTypes.add(0, simbadType.toString());
        }
        if (catalogEntry instanceof AllWiseCatalogEntry && PhotometricFunctions.isAPossibleAGN((allWiseEntry = (AllWiseCatalogEntry)catalogEntry).getW1_W2(), allWiseEntry.getW2_W3())) {
            spectralTypes.add(AGN_WARNING);
        }
        if (catalogEntry instanceof WhiteDwarf && PhotometricFunctions.isAPossibleWD((entry = (WhiteDwarf)((Object)catalogEntry)).getAbsoluteGmag(), entry.getBP_RP())) {
            spectralTypes.add(WD_WARNING);
        }
        CollectedObject collectedObject = new CollectedObject.Builder().setDiscoveryDate(LocalDateTime.now()).setObjectType(objectType).setCatalogName(catalogEntry.getCatalogName()).setRa(catalogEntry.getRa()).setDec(catalogEntry.getDec()).setSourceId(catalogEntry.getSourceId() + " ").setPlx(catalogEntry.getPlx()).setPmra(catalogEntry.getPmra()).setPmdec(catalogEntry.getPmdec()).setSpectralTypes(spectralTypes).setNotes("").build();
        String objectCollectionPath = SettingsTab.getUserSetting("objectCollectionPath");
        if (objectCollectionPath == null || objectCollectionPath.isEmpty()) {
            ToolboxHelper.showErrorDialog(baseFrame, "Specify file location of object collection in the Settings tab.");
            return;
        }
        boolean newFile = false;
        File objectCollection = new File(objectCollectionPath);
        if (!objectCollection.exists()) {
            try {
                objectCollection.createNewFile();
                newFile = true;
            }
            catch (IOException ex) {
                ToolboxHelper.showExceptionDialog(baseFrame, ex);
                return;
            }
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(objectCollection, true));){
            if (newFile) {
                pw.println(collectedObject.getTitles());
            }
            pw.println(collectedObject.getValues());
        }
        catch (IOException ex) {
            ToolboxHelper.showExceptionDialog(baseFrame, ex);
            return;
        }
        if (collectionTable != null) {
            DefaultTableModel tableModel = (DefaultTableModel)collectionTable.getModel();
            tableModel.addRow(ToolboxHelper.concatArrays(new String[]{""}, collectedObject.getColumnValues()));
        }
    }

    public static String copyObjectCoordinates(CatalogEntry catalogEntry) {
        StringBuilder toCopy = new StringBuilder();
        toCopy.append(NumericFunctions.roundTo7DecNZ(catalogEntry.getRa()));
        toCopy.append(" ");
        toCopy.append(NumericFunctions.roundTo7DecNZ(catalogEntry.getDec()));
        return toCopy.toString();
    }

    public static String copyObjectSummary(CatalogEntry catalogEntry) {
        StringBuilder toCopy = new StringBuilder();
        toCopy.append(catalogEntry.getCatalogName()).append(": ").append(catalogEntry.getSourceId());
        toCopy.append(Constants.LINE_SEP);
        toCopy.append("ra=").append(NumericFunctions.roundTo7DecNZ(catalogEntry.getRa()));
        toCopy.append(" ");
        toCopy.append("dec=").append(NumericFunctions.roundTo7DecNZ(catalogEntry.getDec()));
        toCopy.append(Constants.LINE_SEP);
        if (catalogEntry.getPlx() != 0.0) {
            toCopy.append("plx=").append(NumericFunctions.roundTo3DecNZ(catalogEntry.getPlx())).append(" mas");
            toCopy.append(Constants.LINE_SEP);
        }
        if (catalogEntry.getParallacticDistance() != 0.0) {
            toCopy.append("dist=").append(NumericFunctions.roundTo3DecNZ(catalogEntry.getParallacticDistance())).append(" pc");
            toCopy.append(Constants.LINE_SEP);
        }
        if (catalogEntry.getPmra() != 0.0 || catalogEntry.getPmdec() != 0.0) {
            toCopy.append("pmra=").append(NumericFunctions.roundTo3DecNZ(catalogEntry.getPmra()));
            toCopy.append(" ");
            toCopy.append("pmdec=").append(NumericFunctions.roundTo3DecNZ(catalogEntry.getPmdec()));
            toCopy.append(Constants.LINE_SEP);
            toCopy.append("tpm=").append(NumericFunctions.roundTo3DecNZ(catalogEntry.getTotalProperMotion())).append(" mas/yr");
            toCopy.append(Constants.LINE_SEP);
        }
        toCopy.append(catalogEntry.getMagnitudes());
        toCopy.append(Constants.LINE_SEP);
        Map<astro.tool.box.enumeration.Color, Double> colors = catalogEntry.getColors(false);
        colors.entrySet().forEach(entry -> {
            String label;
            double value = (Double)entry.getValue();
            if (value != 0.0 && !(label = ((astro.tool.box.enumeration.Color)((Object)((Object)entry.getKey()))).val).contains("err")) {
                toCopy.append(label).append("=").append(NumericFunctions.roundTo3DecNZ(value));
                toCopy.append(Constants.LINE_SEP);
            }
        });
        return toCopy.toString();
    }

    public static String copyObjectInfo(CatalogEntry catalogEntry, List<LookupResult> mainSequenceResults, List<LookupResult> brownDwarfsResults, DistanceLookupService distanceLookupService) {
        StringBuilder toCopy = new StringBuilder();
        toCopy.append(catalogEntry.getEntryData());
        toCopy.append(Constants.LINE_SEP).append(Constants.LINE_SEP).append("Spectral type estimates:");
        if (mainSequenceResults != null) {
            toCopy.append(Constants.LINE_SEP).append("* Main sequence table:");
            mainSequenceResults.forEach(entry -> toCopy.append(Constants.LINE_SEP).append("  + ").append(entry.getColorKey().val).append(" = ").append(NumericFunctions.roundTo3DecNZ(entry.getColorValue())).append(" -> ").append(entry.getSpt()));
        }
        if (brownDwarfsResults != null) {
            toCopy.append(Constants.LINE_SEP).append("* M, L & T dwarfs only:");
            brownDwarfsResults.forEach(entry -> {
                toCopy.append(Constants.LINE_SEP).append("  + ").append(entry.getColorKey().val).append(" = ").append(NumericFunctions.roundTo3DecNZ(entry.getColorValue())).append(" -> ").append(entry.getSpt());
                List<DistanceLookupResult> distanceResults = distanceLookupService.lookup(entry.getSpt(), catalogEntry.getBands());
                toCopy.append(Constants.LINE_SEP).append("      Distance estimates for ").append(entry.getSpt()).append(":");
                distanceResults.forEach(result -> toCopy.append(Constants.LINE_SEP).append("      - ").append(result.getBandKey().val).append(" = ").append(NumericFunctions.roundTo3DecNZ(result.getBandValue())).append(" -> ").append(NumericFunctions.roundTo3DecNZ(result.getDistance())).append(" pc"));
            });
        }
        return toCopy.toString();
    }

    public static void fillTygoForm(CatalogEntry catalogEntry, CatalogQueryService catalogQueryService, JFrame baseFrame) {
        String userEmail;
        StringBuilder params = new StringBuilder();
        String userName = SettingsTab.getUserSetting("userName", "");
        if (!userName.isEmpty()) {
            params.append("entry.472808084=").append(userName);
        }
        if (!(userEmail = SettingsTab.getUserSetting("userEmail", "")).isEmpty()) {
            params.append("&entry.1241683426=").append(userEmail);
        }
        params.append("&entry.1014230382=").append(NumericFunctions.roundTo7DecNZ(catalogEntry.getRa()));
        params.append("&entry.504539104=").append(NumericFunctions.roundTo7DecNZ(catalogEntry.getDec()));
        if (!AllWiseCatalogEntry.class.isInstance(catalogEntry)) {
            params.append("&entry.690953267=").append("Coordinates are from ").append(catalogEntry.getCatalogName());
        }
        GaiaDR3CatalogEntry gaiaEntry = new GaiaDR3CatalogEntry();
        gaiaEntry.setRa(catalogEntry.getRa());
        gaiaEntry.setDec(catalogEntry.getDec());
        gaiaEntry.setSearchRadius(5.0);
        gaiaEntry = (GaiaDR3CatalogEntry)ToolboxHelper.retrieveCatalogEntry(gaiaEntry, catalogQueryService, baseFrame);
        if (gaiaEntry != null) {
            if (gaiaEntry.getPmra() != 0.0) {
                params.append("&entry.905761395=").append(NumericFunctions.roundTo3DecNZ(gaiaEntry.getPmra())).append(" ").append(NumericFunctions.roundTo3DecNZ(gaiaEntry.getPmraErr()));
            }
            if (gaiaEntry.getPmdec() != 0.0) {
                params.append("&entry.965290776=").append(NumericFunctions.roundTo3DecNZ(gaiaEntry.getPmdec())).append(" ").append(NumericFunctions.roundTo3DecNZ(gaiaEntry.getPmdecErr()));
            }
            if (gaiaEntry.getRadvel() != 0.0) {
                params.append("&entry.702334724=").append(NumericFunctions.roundTo3DecNZ(gaiaEntry.getRadvel())).append(" ").append(NumericFunctions.roundTo3DecNZ(gaiaEntry.getRadvelErr()));
            }
            if (gaiaEntry.getPlx() != 0.0) {
                params.append("&entry.1383168065=").append(NumericFunctions.roundTo4DecNZ(gaiaEntry.getPlx())).append(" ").append(NumericFunctions.roundTo4DecNZ(gaiaEntry.getPlxErr()));
            }
            params.append("&entry.1411207241=").append(gaiaEntry.getSourceId());
        }
        try {
            Desktop.getDesktop().browse(new URI(ExternalResources.getTygoFormUrl() + params.toString().replace(" ", "%20")));
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static CatalogEntry retrieveCatalogEntry(CatalogEntry catalogQuery, CatalogQueryService catalogQueryService, JFrame baseFrame) {
        try {
            List<CatalogEntry> catalogEntries = catalogQueryService.getCatalogEntriesByCoords(catalogQuery);
            catalogEntries.forEach(catalogEntry -> {
                catalogEntry.setTargetRa(catalogQuery.getRa());
                catalogEntry.setTargetDec(catalogQuery.getDec());
            });
            if (!catalogEntries.isEmpty()) {
                catalogEntries.sort(Comparator.comparingDouble(CatalogEntry::getTargetDistance));
                return catalogEntries.get(0);
            }
        }
        catch (IOException ex) {
            ToolboxHelper.showExceptionDialog(baseFrame, ex);
        }
        return null;
    }

    public static Tiles getWiseTiles(double degRA, double degDE) throws IOException {
        String url = "http://byw.tools/tiles?ra=%f&dec=%f".formatted(degRA, degDE);
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(url), "WiseView");
        return new Gson().fromJson(response, Tiles.class);
    }

    public static List<JLabel> getNearestZooniverseSubjects(double degRA, double degDE) {
        ArrayList<JLabel> subjects = new ArrayList<JLabel>();
        try {
            String url = "http://byw.tools/xref?ra=%f&dec=%f".formatted(degRA, degDE);
            String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(url), "Zooniverse");
            if (!response.isEmpty()) {
                JsonObject jelement = JsonParser.parseString(response).getAsJsonObject();
                JsonObject jobject = jelement.getAsJsonObject();
                JsonArray jarray = jobject.getAsJsonArray("ids");
                for (JsonElement element : jarray) {
                    String id = element.getAsString();
                    subjects.add(ToolboxHelper.createHyperlink(id, "https://www.zooniverse.org/projects/marckuchner/backyard-worlds-planet-9/talk/subjects/" + id));
                }
            }
        }
        catch (JsonSyntaxException | IOException exception) {
            // empty catch block
        }
        return subjects;
    }

    public static String getImageLabel(String text, int epoch) {
        return text + (String)(epoch > 0 ? " " + epoch : "");
    }

    public static String getImageLabel(String text, String epoch) {
        return text + " " + epoch;
    }

    public static int getMeanEpoch(int ... epochs) {
        int sum = 0;
        int i = 0;
        for (int epoch : epochs) {
            if (epoch == 0) continue;
            sum += epoch;
            ++i;
        }
        return i == 0 ? i : sum / i;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getEpoch(double targetRa, double targetDec, double size, String survey, String band) {
        try {
            String downloadUrl = "https://irsa.ipac.caltech.edu/applications/finderchart/servlet/api?RA=%f&DEC=%f&subsetsize=%s&survey=%s&%s".formatted(targetRa, targetDec, NumericFunctions.roundTo2DecNZ(size / 60.0), survey, band);
            String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(downloadUrl), "IRSA");
            try (Scanner scanner = new Scanner(response);){
                String line;
                do {
                    if (!scanner.hasNextLine()) return 0;
                } while (!(line = scanner.nextLine()).contains("obsdate"));
                String[] parts = line.split("<obsdate>");
                parts = parts[1].split("-");
                int n = Integer.parseInt(parts[0]);
                return n;
            }
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
        return 0;
    }

    public static BufferedImage retrieveImage(double targetRa, double targetDec, int size, String survey, String band) {
        BufferedImage bi;
        String imageUrl = "https://irsa.ipac.caltech.edu/applications/finderchart/servlet/api?mode=getImage&RA=%f&DEC=%f&subsetsize=%s&thumbnail_size=small&survey=%s&%s".formatted(targetRa, targetDec, NumericFunctions.roundTo2DecNZ((float)size / 60.0f), survey, band);
        try {
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
            BufferedInputStream stream = new BufferedInputStream(connection.getInputStream(), BUFFER_SIZE);
            bi = ImageIO.read(stream);
            if (!band.contains("colorimage")) {
                ToolboxHelper.invertColors(bi);
            }
        }
        catch (IOException ex) {
            bi = null;
        }
        return bi;
    }

    public static void invertColors(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgba = image.getRGB(x, y);
                int a = rgba >> 24 & 0xFF;
                int r = rgba >> 16 & 0xFF;
                int g = rgba >> 8 & 0xFF;
                int b = rgba & 0xFF;
                r = 255 - r;
                g = 255 - g;
                b = 255 - b;
                rgba = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, y, rgba);
            }
        }
    }

    public static int getPs1Epoch(double targetRa, double targetDec, String filters) {
        String downloadUrl = "http://ps1images.stsci.edu/cgi-bin/ps1filenames.py?RA=%f&DEC=%f&filters=%s&type=warp&sep=comma".formatted(targetRa, targetDec, filters);
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(downloadUrl), "Pan-STARRS");
        Scanner scanner = new Scanner(response);
        try {
            int i;
            String[] columnNames = scanner.nextLine().split(",");
            int mjd = 0;
            for (i = 0; i < columnNames.length; ++i) {
                if (!columnNames[i].equals("mjd")) continue;
                mjd = i;
                break;
            }
            i = 0;
            double epoch = 0.0;
            while (scanner.hasNextLine()) {
                String[] columnValues = scanner.nextLine().split(",");
                epoch += NumericFunctions.toDouble(columnValues[mjd]);
                ++i;
            }
            int n = AstrometricFunctions.convertMJDToDate(epoch / (double)i).get(ChronoField.YEAR);
            scanner.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return 0;
            }
        }
    }

    public static Map<String, Double> getPs1Epochs(double targetRa, double targetDec) {
        String downloadUrl = "http://ps1images.stsci.edu/cgi-bin/ps1filenames.py?RA=%f&DEC=%f&filters=grizy&type=warp&sep=comma".formatted(targetRa, targetDec);
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(downloadUrl), "Pan-STARRS");
        Scanner scanner = new Scanner(response);
        try {
            String[] columnNames = scanner.nextLine().split(",");
            int filter = 0;
            int mjd = 0;
            for (int i = 0; i < columnNames.length; ++i) {
                if (columnNames[i].equals("filter")) {
                    filter = i;
                }
                if (!columnNames[i].equals("mjd")) continue;
                mjd = i;
            }
            ArrayList<MjdEpoch> epochs = new ArrayList<MjdEpoch>();
            while (scanner.hasNextLine()) {
                String[] columnValues = scanner.nextLine().split(",");
                String band = columnValues[filter];
                double epoch = NumericFunctions.toDouble(columnValues[mjd]);
                epochs.add(new MjdEpoch(band, AstrometricFunctions.convertMJDToDate(epoch).get(ChronoField.YEAR)));
            }
            Map<String, Double> map = epochs.stream().collect(Collectors.groupingBy(MjdEpoch::getBand, Collectors.averagingInt(MjdEpoch::getEpoch)));
            scanner.close();
            return map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return new HashMap<String, Double>();
            }
        }
    }

    public static Map<String, String> getPs1FileNames(double targetRa, double targetDec) {
        LinkedHashMap<String, String> fileNames = new LinkedHashMap<String, String>();
        try {
            String downloadUrl = "http://ps1images.stsci.edu/cgi-bin/ps1filenames.py?RA=%f&DEC=%f&filters=grizy&sep=comma".formatted(targetRa, targetDec);
            String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(downloadUrl), "Pan-STARRS");
            try (Scanner scanner = new Scanner(response);){
                String[] columnNames = scanner.nextLine().split(",");
                int filter = 0;
                int fileName = 0;
                for (int i = 0; i < columnNames.length; ++i) {
                    if (columnNames[i].equals("filter")) {
                        filter = i;
                    }
                    if (!columnNames[i].equals("filename")) continue;
                    fileName = i;
                }
                while (scanner.hasNextLine()) {
                    String[] columnValues = scanner.nextLine().split(",");
                    fileNames.put(columnValues[filter], columnValues[fileName]);
                }
            }
        }
        catch (IOException ex) {
            ToolboxHelper.writeErrorLog(ex);
        }
        return fileNames;
    }

    public static BufferedImage retrievePs1Image(String fileNames, double targetRa, double targetDec, int size, boolean invert) {
        BufferedImage bi;
        String imageUrl = "http://ps1images.stsci.edu/cgi-bin/fitscut.cgi?%s&ra=%f&dec=%f&size=%d&output_size=%d&autoscale=95.0&invert=%s".formatted(fileNames, targetRa, targetDec, size * 4, 256, invert);
        try {
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
            BufferedInputStream stream = new BufferedInputStream(connection.getInputStream(), BUFFER_SIZE);
            bi = ImageIO.read(stream);
        }
        catch (IOException ex) {
            bi = new BufferedImage(256, 256, 1);
        }
        return bi;
    }

    public static BufferedImage retrieveDesiImage(double targetRa, double targetDec, int size, String band, boolean invert) {
        return ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, band, invert, "ls-dr10");
    }

    public static BufferedImage retrieveDesiImage(double targetRa, double targetDec, int size, String band, boolean invert, String layer) {
        BufferedImage image;
        if (band == null) {
            band = "";
        }
        if (!((String)band).isEmpty()) {
            band = "&bands=" + (String)band;
        }
        String imageUrl = "https://www.legacysurvey.org/viewer/jpeg-cutout?ra=%f&dec=%f&pixscale=%f&layer=%s&size=%d%s".formatted(targetRa, targetDec, 0.25, layer, size * 4, band);
        try {
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
            BufferedInputStream stream = new BufferedInputStream(connection.getInputStream(), BUFFER_SIZE);
            image = ImageIO.read(stream);
            if (invert) {
                image = ToolboxHelper.convertToGrayImage(image);
                image = ToolboxHelper.invertImage(image);
            }
            image = ToolboxHelper.zoomImage(image, 256);
        }
        catch (IOException ex) {
            image = null;
        }
        return image;
    }

    public static Map<String, NirImage> retrieveNearInfraredImages(double targetRa, double targetDec, double size, String surveyUrl, String surveyLabel) throws Exception {
        String[] filterIds;
        String imageSize = NumericFunctions.roundTo2DecNZ(size / 60.0);
        ArrayList<NirImage> nirImages = new ArrayList<NirImage>();
        for (String filterId : filterIds = new String[]{"2", "3", "4", "5"}) {
            String downloadUrl = surveyUrl.formatted(targetRa, targetDec, filterId, imageSize, imageSize);
            String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(downloadUrl), surveyLabel);
            int i = 0;
            String imageUrl = "";
            String extNo = "";
            String year = "";
            try (Scanner scanner = new Scanner(response);){
                while (scanner.hasNextLine()) {
                    String[] parts;
                    String line = scanner.nextLine();
                    if (line.contains("href")) {
                        parts = line.split("href=\"");
                        parts = parts[1].split("\"");
                        imageUrl = parts[0].replace("getImage", "getJImage");
                        parts = line.split("extNo=");
                        parts = parts[1].split("&");
                        extNo = parts[0];
                        i = 1;
                    }
                    if (i == 7) {
                        try {
                            parts = line.split("<td nowrap>");
                            parts = parts[1].split("-");
                            year = parts[0];
                        }
                        catch (Exception ex) {
                            year = "2010";
                        }
                        break;
                    }
                    if (i <= 0) continue;
                    ++i;
                }
            }
            if (imageUrl.isEmpty()) continue;
            nirImages.add(new NirImage(filterId, extNo, Integer.parseInt(year), imageUrl));
        }
        LinkedHashMap<String, NirImage> images = new LinkedHashMap<String, NirImage>();
        if (nirImages.isEmpty()) {
            return images;
        }
        for (NirImage nirImage : nirImages) {
            String band = ToolboxHelper.getBand(nirImage.getFilderId());
            String extNo = nirImage.getExtNo();
            String imageUrl = nirImage.getImageUrl();
            try {
                HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
                BufferedInputStream stream = new BufferedInputStream(connection.getInputStream(), BUFFER_SIZE);
                BufferedImage image = ImageIO.read(stream);
                int width = image.getWidth();
                int height = image.getHeight();
                int offset = 2;
                if (width > height + offset || width < height - offset) {
                    return new LinkedHashMap<String, NirImage>();
                }
                if (surveyLabel.equals("UHS") || surveyLabel.equals("UKIDSS")) {
                    switch (extNo) {
                        case "1": {
                            image = ToolboxHelper.rotateImage(image, 1);
                            break;
                        }
                        case "2": {
                            break;
                        }
                        case "3": {
                            image = ToolboxHelper.rotateImage(image, 3);
                            break;
                        }
                        case "4": {
                            image = ToolboxHelper.rotateImage(image, 2);
                        }
                    }
                }
                image = ToolboxHelper.flipImage(image);
                nirImage.setImage(image);
                images.put(band, nirImage);
            }
            catch (IOException connection) {}
        }
        NirImage nir1 = (NirImage)images.get("K");
        NirImage nir2 = (NirImage)images.get("H");
        NirImage nir3 = (NirImage)images.get("J");
        if (nir1 != null && nir2 != null && nir3 != null) {
            i1 = nir1.getImage();
            BufferedImage i2 = nir2.getImage();
            BufferedImage i3 = nir3.getImage();
            int width = i3.getWidth();
            int height = i3.getHeight();
            i1 = ToolboxHelper.resizeImage(i1, width, height);
            i2 = ToolboxHelper.resizeImage(i2, width, height);
            int y1 = nir1.getYear();
            int y2 = nir2.getYear();
            int y3 = nir3.getYear();
            BufferedImage colorImage = ToolboxHelper.createColorImage(ToolboxHelper.invertImage(i1), ToolboxHelper.invertImage(i2), ToolboxHelper.invertImage(i3));
            NirImage nirImage = new NirImage(ToolboxHelper.getMeanEpoch(y1, y2, y3), colorImage);
            images.put("K-H-J", nirImage);
        } else if (nir1 != null && nir3 != null) {
            i1 = nir1.getImage();
            BufferedImage i3 = nir3.getImage();
            int width = i3.getWidth();
            int height = i3.getHeight();
            i1 = ToolboxHelper.resizeImage(i1, width, height);
            int y1 = nir1.getYear();
            int y3 = nir3.getYear();
            BufferedImage colorImage = ToolboxHelper.createColorImage(ToolboxHelper.invertImage(i1), ToolboxHelper.invertImage(i3));
            NirImage nirImage = new NirImage(ToolboxHelper.getMeanEpoch(y1, y3), colorImage);
            images.put("K-J", nirImage);
        }
        return images;
    }

    private static String getBand(String filterId) {
        return switch (filterId) {
            case "2" -> "Y";
            case "3" -> "J";
            case "4" -> "H";
            case "5" -> "K";
            default -> "?";
        };
    }

    public static BufferedImage copyImage(BufferedImage bufferImage) {
        ColorModel colorModel = bufferImage.getColorModel();
        WritableRaster raster = bufferImage.copyData(null);
        boolean isAlphaPremultiplied = colorModel.isAlphaPremultiplied();
        return new BufferedImage(colorModel, raster, isAlphaPremultiplied, null);
    }

    public static BufferedImage zoomImage(BufferedImage image, int zoom) {
        zoom = zoom == 0 ? 1 : zoom;
        return ToolboxHelper.resizeImage(image, zoom, zoom);
    }

    private static BufferedImage resizeImage(BufferedImage image, int width, int height) {
        Image scaledImage = image.getScaledInstance(width, height, 1);
        BufferedImage zoomedImage = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 1);
        Graphics2D graphics = zoomedImage.createGraphics();
        graphics.drawImage(scaledImage, 0, 0, null);
        graphics.dispose();
        return zoomedImage;
    }

    public static BufferedImage invertImage(BufferedImage image) {
        BufferedImage invertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                Color c = new Color(rgb, true);
                c = new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
                invertedImage.setRGB(x, y, c.getRGB());
            }
        }
        return invertedImage;
    }

    public static BufferedImage flipImage(BufferedImage image) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -image.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    public static BufferedImage rotateImage(BufferedImage image, int numberOfQuadrants) {
        if (numberOfQuadrants == 0) {
            return image;
        }
        AffineTransform tx = AffineTransform.getQuadrantRotateInstance(numberOfQuadrants, image.getWidth() / 2, image.getHeight() / 2);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        return op.filter(image, null);
    }

    public static BufferedImage convertToGray(BufferedImage colorImage) {
        BufferedImage grayImage = new BufferedImage(colorImage.getWidth(), colorImage.getHeight(), 10);
        Graphics graphics = grayImage.getGraphics();
        graphics.drawImage(colorImage, 0, 0, null);
        graphics.dispose();
        return grayImage;
    }

    public static BufferedImage convertToGrayImage(BufferedImage colorImage) {
        int width = colorImage.getWidth();
        int height = colorImage.getHeight();
        BufferedImage grayscaleImage = new BufferedImage(width, height, 10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = new Color(colorImage.getRGB(x, y));
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                int grayscaleValue = Math.min(red + green + blue, 255);
                grayscaleImage.setRGB(x, y, new Color(grayscaleValue, grayscaleValue, grayscaleValue).getRGB());
            }
        }
        return grayscaleImage;
    }

    public static BufferedImage enhanceContrast(BufferedImage grayscaleImage, double contrastFactor) {
        int width = grayscaleImage.getWidth();
        int height = grayscaleImage.getHeight();
        BufferedImage contrastEnhancedImage = new BufferedImage(width, height, 10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixelValue = new Color(grayscaleImage.getRGB(x, y)).getRed();
                int contrastEnhancedValue = (int)(contrastFactor * (double)pixelValue);
                contrastEnhancedValue = Math.min(Math.max(contrastEnhancedValue, 0), 255);
                contrastEnhancedImage.setRGB(x, y, new Color(contrastEnhancedValue, contrastEnhancedValue, contrastEnhancedValue).getRGB());
            }
        }
        return contrastEnhancedImage;
    }

    public static BufferedImage createColorImage(BufferedImage i1, BufferedImage i2) {
        BufferedImage colorImage = new BufferedImage(i1.getWidth(), i1.getHeight(), 1);
        for (int x = 0; x < colorImage.getWidth(); ++x) {
            for (int y = 0; y < colorImage.getHeight(); ++y) {
                try {
                    int rgb1 = i1.getRGB(x, y);
                    int rgb2 = i2.getRGB(x, y);
                    Color c1 = new Color(rgb1, true);
                    Color c2 = new Color(rgb2, true);
                    Color color = new Color(c1.getRed(), (c1.getRed() + c2.getRed()) / 2, c2.getRed());
                    colorImage.setRGB(x, y, color.getRGB());
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return colorImage;
    }

    public static BufferedImage createColorImage(BufferedImage i1, BufferedImage i2, BufferedImage i3) {
        BufferedImage colorImage = new BufferedImage(i1.getWidth(), i1.getHeight(), 1);
        for (int x = 0; x < colorImage.getWidth(); ++x) {
            for (int y = 0; y < colorImage.getHeight(); ++y) {
                try {
                    int rgb1 = i1.getRGB(x, y);
                    int rgb2 = i2.getRGB(x, y);
                    int rgb3 = i3.getRGB(x, y);
                    Color c1 = new Color(rgb1, true);
                    Color c2 = new Color(rgb2, true);
                    Color c3 = new Color(rgb3, true);
                    Color color = new Color(c1.getRed(), c2.getRed(), c3.getRed());
                    colorImage.setRGB(x, y, color.getRGB());
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return colorImage;
    }

    public static BufferedImage drawCenterShape(BufferedImage image) {
        image = ToolboxHelper.zoomImage(image, 175);
        double x = image.getWidth() / 2;
        double y = image.getHeight() / 2;
        Graphics g = image.getGraphics();
        Circle drawable = new Circle(x, y, 30.0, Color.RED);
        drawable.draw(g);
        return image;
    }

    public static String[] concatArrays(String[] arg1, String[] arg2) {
        int length = arg1.length + arg2.length;
        String[] array = new String[length];
        System.arraycopy(arg1, 0, array, 0, arg1.length);
        System.arraycopy(arg2, 0, array, arg1.length, arg2.length);
        return array;
    }

    public static String formatError(Exception error) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(LocalDateTime.now().toString() + " ");
        error.printStackTrace(pw);
        return sw.toString();
    }

    public static String formatMessage(String message) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(LocalDateTime.now().toString() + " ");
        pw.println(message);
        return sw.toString();
    }

    public static JLabel addTextToImage(BufferedImage image, String text) {
        return ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(ToolboxHelper.drawCenterShape(image))), text);
    }

    public static JLabel addTextToImage(JLabel background, String text) {
        background.setLayout(new BoxLayout(background, 1));
        TranslucentLabel label = new TranslucentLabel(text);
        label.setFont(label.getFont().deriveFont(10.0f));
        label.setBackground(new Color(255, 255, 255, 200));
        label.setBorder(new EmptyBorder(0, 3, 0, 3));
        label.setForeground(Color.BLACK);
        background.add(label);
        return background;
    }

    public static void saveAnimatedGif(List<Couple<String, BufferedImage>> imageList, Component container) throws Exception {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileTypeFilter(".gif", ".gif files"));
        int returnVal = fileChooser.showSaveDialog(container);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            file = new File(file.getPath() + ".gif");
            BufferedImage[] imageSet = new BufferedImage[imageList.size()];
            int i = 0;
            for (Couple<String, BufferedImage> imageData : imageList) {
                BufferedImage imageBuffer = imageData.getB();
                imageSet[i++] = ToolboxHelper.drawCenterShape(imageBuffer);
            }
            if (imageSet.length > 0) {
                GifSequencer sequencer = new GifSequencer();
                sequencer.generateFromBI(imageSet, file, 50, true);
            }
        }
    }

    public static void createPDF(JFreeChart chart, File tmpFile, int width, int height) throws Exception {
        Rectangle pagesize = new Rectangle(width, height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(tmpFile));
        document.open();
        PdfContentByte contentByte = writer.getDirectContent();
        PdfTemplate template = contentByte.createTemplate(width, height);
        PdfGraphics2D graphics = new PdfGraphics2D(contentByte, width, height);
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, width, height);
        chart.draw(graphics, rectangle);
        ((Graphics)graphics).dispose();
        contentByte.addTemplate(template, 0.0f, 0.0f);
        document.close();
    }

    public static void addUndoManager(JTextArea textArea) {
        final UndoManager manger = new UndoManager();
        javax.swing.text.Document document = textArea.getDocument();
        document.addUndoableEditListener(evt -> manger.addEdit(evt.getEdit()));
        textArea.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (manger.canUndo()) {
                        manger.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        textArea.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textArea.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (manger.canRedo()) {
                        manger.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        textArea.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public static WindowAdapter getChildWindowAdapter(final JFrame baseFrame) {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                baseFrame.setFocusableWindowState(true);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                baseFrame.setFocusableWindowState(true);
            }

            @Override
            public void windowIconified(WindowEvent e) {
                baseFrame.setFocusableWindowState(true);
                baseFrame.toFront();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                baseFrame.setFocusableWindowState(true);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                baseFrame.setFocusableWindowState(false);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                baseFrame.setFocusableWindowState(false);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                baseFrame.setFocusableWindowState(false);
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                baseFrame.setFocusableWindowState(false);
            }
        };
    }
}

