/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.main;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPCellEvent;

class WatermarkedCell
implements PdfPCellEvent {
    private static final Font SMALL_FONT = FontFactory.getFont("Helvetica", 5.0f, BaseColor.BLACK);
    String watermark;

    public WatermarkedCell(String watermark) {
        this.watermark = watermark;
    }

    @Override
    public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
        PdfContentByte canvas = canvases[3];
        canvas.saveState();
        PdfGState state = new PdfGState();
        state.setFillOpacity(0.75f);
        canvas.setGState(state);
        Chunk text = new Chunk(this.watermark, SMALL_FONT);
        text.setBackground(BaseColor.WHITE, 1.0f, 0.5f, 1.2f, 1.5f);
        ColumnText.showTextAligned(canvas, 0, new Phrase(text), position.getLeft() + 2.0f, position.getTop() - 6.0f, 0.0f);
        canvas.restoreState();
    }
}

