/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.panel;

import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.panel.CustomListModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class DualListBox
extends JPanel {
    private final JList sourceList;
    private final JList destList;
    private final JButton showButton;
    private final JButton hideButton;
    private final JButton showAllButton;
    private final JButton hideAllButton;
    private final JButton resetButton;
    private final CustomListModel sourceListModel;
    private final CustomListModel destListModel;
    private List allElements;

    public DualListBox(int width, int height) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        JPanel globalLayout = new JPanel(new GridLayout(1, 3));
        globalLayout.setPreferredSize(new Dimension(width, height));
        this.add(globalLayout);
        this.sourceListModel = new CustomListModel();
        this.sourceList = new JList(this.sourceListModel);
        globalLayout.add(new JScrollPane(this.sourceList));
        JPanel buttonLayout = new JPanel(new GridLayout(5, 1));
        globalLayout.add(buttonLayout);
        this.showButton = new JButton(ToolboxHelper.html("Show tab &raquo;"));
        this.showButton.setAlignmentX(0.5f);
        this.showButton.addActionListener(new AddListener());
        buttonLayout.add(this.showButton);
        this.hideButton = new JButton(ToolboxHelper.html("&laquo; Hide tab"));
        this.hideButton.setAlignmentX(0.5f);
        this.hideButton.addActionListener(new RemoveListener());
        buttonLayout.add(this.hideButton);
        this.showAllButton = new JButton(ToolboxHelper.html("Show all &raquo;"));
        this.showAllButton.setAlignmentX(0.5f);
        this.showAllButton.addActionListener(new AddAllListener());
        buttonLayout.add(this.showAllButton);
        this.hideAllButton = new JButton(ToolboxHelper.html("&laquo; Hide all"));
        this.hideAllButton.setAlignmentX(0.5f);
        this.hideAllButton.addActionListener(new RemoveAllListener());
        buttonLayout.add(this.hideAllButton);
        this.resetButton = new JButton("Reset");
        this.resetButton.setAlignmentX(0.5f);
        this.resetButton.addActionListener(new ResetListener());
        buttonLayout.add(this.resetButton);
        this.destListModel = new CustomListModel();
        this.destList = new JList(this.destListModel);
        globalLayout.add(new JScrollPane(this.destList));
    }

    public List getAllElements() {
        return this.allElements;
    }

    public void setAllElements(List allElements) {
        this.allElements = allElements;
    }

    public void clearSourceListModel() {
        this.sourceListModel.clear();
    }

    public void clearDestinationListModel() {
        this.destListModel.clear();
    }

    public void addSourceElements(ListModel newValue) {
        this.fillListModel(this.sourceListModel, newValue);
    }

    public void setSourceElements(ListModel newValue) {
        this.clearSourceListModel();
        this.addSourceElements(newValue);
    }

    public void addDestinationElements(ListModel newValue) {
        this.fillListModel(this.destListModel, newValue);
    }

    public void setDestinationElements(ListModel newValue) {
        this.clearDestinationListModel();
        this.addDestinationElements(newValue);
    }

    private void fillListModel(CustomListModel model, ListModel newValues) {
        int size = newValues.getSize();
        for (int i = 0; i < size; ++i) {
            model.add(newValues.getElementAt(i));
        }
    }

    public void addSourceElements(List newValue) {
        this.fillListModel(this.sourceListModel, newValue);
    }

    public void setSourceElements(List newValue) {
        this.clearSourceListModel();
        this.addSourceElements(newValue);
    }

    public List getSourceElements() {
        return this.sourceListModel.getModel();
    }

    public void addDestinationElements(List newValue) {
        this.fillListModel(this.destListModel, newValue);
    }

    public void setDestinationElements(List newValue) {
        this.clearDestinationListModel();
        this.addDestinationElements(newValue);
    }

    public List getDestinationElements() {
        return this.destListModel.getModel();
    }

    private void fillListModel(CustomListModel model, List newValues) {
        model.addAll(newValues);
    }

    public Iterator sourceIterator() {
        return this.sourceListModel.iterator();
    }

    public Iterator destinationIterator() {
        return this.destListModel.iterator();
    }

    public void setSourceCellRenderer(ListCellRenderer newValue) {
        this.sourceList.setCellRenderer(newValue);
    }

    public ListCellRenderer getSourceCellRenderer() {
        return this.sourceList.getCellRenderer();
    }

    public void setDestinationCellRenderer(ListCellRenderer newValue) {
        this.destList.setCellRenderer(newValue);
    }

    public ListCellRenderer getDestinationCellRenderer() {
        return this.destList.getCellRenderer();
    }

    public void setVisibleRowCount(int newValue) {
        this.sourceList.setVisibleRowCount(newValue);
        this.destList.setVisibleRowCount(newValue);
    }

    public int getVisibleRowCount() {
        return this.sourceList.getVisibleRowCount();
    }

    public void setSelectionBackground(Color newValue) {
        this.sourceList.setSelectionBackground(newValue);
        this.destList.setSelectionBackground(newValue);
    }

    public Color getSelectionBackground() {
        return this.sourceList.getSelectionBackground();
    }

    public void setSelectionForeground(Color newValue) {
        this.sourceList.setSelectionForeground(newValue);
        this.destList.setSelectionForeground(newValue);
    }

    public Color getSelectionForeground() {
        return this.sourceList.getSelectionForeground();
    }

    private void clearSourceSelected() {
        List selected = this.sourceList.getSelectedValuesList();
        for (int i = selected.size() - 1; i >= 0; --i) {
            this.sourceListModel.removeElement(selected.get(i));
        }
        this.sourceList.getSelectionModel().clearSelection();
    }

    private void clearDestinationSelected() {
        List selected = this.destList.getSelectedValuesList();
        for (int i = selected.size() - 1; i >= 0; --i) {
            this.destListModel.removeElement(selected.get(i));
        }
        this.destList.getSelectionModel().clearSelection();
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selected = DualListBox.this.sourceList.getSelectedValuesList();
            DualListBox.this.addDestinationElements(selected);
            DualListBox.this.clearSourceSelected();
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selected = DualListBox.this.destList.getSelectedValuesList();
            DualListBox.this.addSourceElements(selected);
            DualListBox.this.clearDestinationSelected();
        }
    }

    private class AddAllListener
    implements ActionListener {
        private AddAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DualListBox.this.destListModel.addAll(DualListBox.this.sourceListModel.getModel());
            DualListBox.this.sourceListModel.clear();
        }
    }

    private class RemoveAllListener
    implements ActionListener {
        private RemoveAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DualListBox.this.sourceListModel.addAll(DualListBox.this.destListModel.getModel());
            DualListBox.this.destListModel.clear();
        }
    }

    private class ResetListener
    implements ActionListener {
        private ResetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DualListBox.this.destListModel.setModel(DualListBox.this.allElements);
            DualListBox.this.sourceListModel.clear();
        }
    }
}

