/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.panel;

import astro.tool.box.catalog.GaiaCmd;
import astro.tool.box.container.NumberTriplet;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.Application;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.util.CSVParser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GaiaCmdPanel
extends JPanel {
    private static final String FONT_NAME = "Tahoma";
    private final JRadioButton g_rpButton;
    private final JCheckBox coolingSequencesH;
    private final JCheckBox coolingSequencesHe;
    private final int min = 2;
    private final int max = 14;
    private JFreeChart chart;
    private static final List<Color> COLORS = new ArrayList<Color>();
    private String targetLabel;

    public GaiaCmdPanel(GaiaCmd catalogEntry) {
        this.setLayout(new BoxLayout(this, 1));
        JPanel commandPanel = new JPanel(new FlowLayout(0));
        JButton showImageButton = new JButton("Show reference CMD");
        showImageButton.addActionListener(e -> this.displayReferenceCmd());
        this.g_rpButton = new JRadioButton("G-RP", true);
        commandPanel.add(this.g_rpButton);
        this.g_rpButton.addActionListener(e -> commandPanel.remove(showImageButton));
        JRadioButton bp_rpButton = new JRadioButton("BP-RP", false);
        commandPanel.add(bp_rpButton);
        bp_rpButton.addActionListener(e -> commandPanel.add(showImageButton));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.g_rpButton);
        buttonGroup.add(bp_rpButton);
        String coolingTracksText = "Montreal cooling tracks for white dwarfs with masses between 0.2 (top) and 1.3 (bottom) Msun in steps of 0.1 Msun <br/>(red is pure H atmosphere or DA WDs, blue is pure He atmosphere or DB WDs)";
        JLabel coolingTracksToolTip = new JLabel(ToolboxHelper.getInfoIcon());
        coolingTracksToolTip.setToolTipText(ToolboxHelper.html(coolingTracksText));
        commandPanel.add(coolingTracksToolTip);
        JLabel coolingTracksLabel = new JLabel("White dwarf cooling sequences");
        coolingTracksLabel.setToolTipText(ToolboxHelper.html(coolingTracksText));
        commandPanel.add(coolingTracksLabel);
        this.coolingSequencesH = new JCheckBox("DA");
        commandPanel.add(this.coolingSequencesH);
        this.coolingSequencesHe = new JCheckBox("DB");
        commandPanel.add(this.coolingSequencesHe);
        JButton createButton = new JButton("Create PDF");
        commandPanel.add(createButton);
        createButton.addActionListener(e -> {
            try {
                File tmpFile = File.createTempFile("Target_" + NumericFunctions.roundTo2DecNZ(catalogEntry.getRa()) + NumericFunctions.addPlusSign(NumericFunctions.roundDouble(catalogEntry.getDec(), "#.##")) + "_", ".pdf");
                ToolboxHelper.createPDF(this.chart, tmpFile, 800, 700);
                Desktop.getDesktop().open(tmpFile);
            }
            catch (Exception ex) {
                ToolboxHelper.writeErrorLog(ex);
            }
        });
        String infoText = "Right-clicking on the chart, opens a context menu with additional functions like printing and saving.";
        JLabel infoToolTip = new JLabel(ToolboxHelper.getInfoIcon());
        infoToolTip.setToolTipText(infoText);
        commandPanel.add(infoToolTip);
        JLabel infoLabel = new JLabel("Tooltip");
        infoLabel.setToolTipText(infoText);
        commandPanel.add(infoLabel);
        this.loadCmdData();
        this.createChartPanel(catalogEntry);
        this.g_rpButton.addActionListener(e -> {
            this.remove(0);
            this.createChartPanel(catalogEntry);
            if (this.coolingSequencesH.isSelected()) {
                this.addCoolingSequencesH(this.chart);
            }
            if (this.coolingSequencesHe.isSelected()) {
                this.addCoolingSequencesHe(this.chart);
            }
        });
        bp_rpButton.addActionListener(e -> {
            this.remove(0);
            this.createChartPanel(catalogEntry);
            if (this.coolingSequencesH.isSelected()) {
                this.addCoolingSequencesH(this.chart);
            }
            if (this.coolingSequencesHe.isSelected()) {
                this.addCoolingSequencesHe(this.chart);
            }
        });
        this.coolingSequencesH.addActionListener(e -> {
            if (this.coolingSequencesH.isSelected()) {
                this.addCoolingSequencesH(this.chart);
            } else {
                this.removeCoolingSequencesH(this.chart);
            }
        });
        this.coolingSequencesHe.addActionListener(e -> {
            if (this.coolingSequencesHe.isSelected()) {
                this.addCoolingSequencesHe(this.chart);
            } else {
                this.removeCoolingSequencesHe(this.chart);
            }
        });
        this.add(commandPanel);
    }

    private void displayReferenceCmd() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/Gaia CMD BP-RP.png"));
        JFrame sedFrame = new JFrame();
        sedFrame.setIconImage(ToolboxHelper.getToolBoxImage());
        sedFrame.setTitle("Gaia CMD G vs. BP-RP");
        sedFrame.add(new JLabel(icon));
        sedFrame.setSize(icon.getIconWidth() + 20, icon.getIconHeight());
        sedFrame.setLocation(0, 0);
        sedFrame.setAlwaysOnTop(false);
        sedFrame.setResizable(true);
        sedFrame.setVisible(true);
    }

    private void createChartPanel(GaiaCmd catalogEntry) {
        XYSeriesCollection mainCollection = this.createMainCollection();
        XYSeriesCollection targetCollection = this.createTargetCollection(catalogEntry);
        this.createChart(targetCollection, mainCollection);
        ChartPanel chartPanel = new ChartPanel(this.chart){

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        chartPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        chartPanel.setBackground(Color.WHITE);
        this.add((Component)chartPanel, 0);
        this.revalidate();
        this.repaint();
    }

    private XYSeriesCollection createMainCollection() {
        XYSeriesCollection collection = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)""));
        Application.CMD_DATA.forEach(triplet -> {
            double x = this.g_rpButton.isSelected() ? triplet.getY() : triplet.getZ();
            double y = triplet.getX();
            if (x != 0.0 && y != 0.0) {
                series.add(x, y);
            }
        });
        collection.addSeries(series);
        return collection;
    }

    private XYSeriesCollection createTargetCollection(GaiaCmd catalogEntry) {
        XYSeriesCollection collection = new XYSeriesCollection();
        double xTarget = this.g_rpButton.isSelected() ? catalogEntry.getG_RP() : catalogEntry.getBP_RP();
        double yTarget = catalogEntry.getAbsoluteGmag();
        if (xTarget != 0.0 && yTarget != 0.0) {
            this.targetLabel = catalogEntry.getCatalogName() + " " + catalogEntry.getSourceId() + ": G=" + NumericFunctions.roundTo3DecNZ(yTarget) + " " + (this.g_rpButton.isSelected() ? "G-RP" : "BP-RP") + "=" + NumericFunctions.roundTo3DecNZ(xTarget);
            XYSeries seriesTarget = new XYSeries((Comparable)((Object)this.targetLabel));
            seriesTarget.add(xTarget, yTarget);
            collection.addSeries(seriesTarget);
        }
        return collection;
    }

    private XYSeriesCollection createSpectralTypeCollection(String fileName) {
        XYSeriesCollection collection = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)fileName), false);
        this.loadSpectralType(fileName).forEach(triplet -> {
            double x = this.g_rpButton.isSelected() ? triplet.getY() : triplet.getZ();
            double y = triplet.getX();
            if (x != 0.0 && y != 0.0) {
                series.add(x, y);
            }
        });
        collection.addSeries(series);
        return collection;
    }

    private XYSeriesCollection createCoolingSequenceCollection(String fileName) {
        XYSeriesCollection collection = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)fileName), false);
        this.loadCoolingSequence(fileName).forEach(triplet -> {
            double x = this.g_rpButton.isSelected() ? triplet.getY() : triplet.getZ();
            double y = triplet.getX();
            if (x != 0.0 && y != 0.0) {
                series.add(x, y);
            }
        });
        collection.addSeries(series);
        return collection;
    }

    private void createChart(XYSeriesCollection targetCollection, XYSeriesCollection mainCollection) {
        this.chart = ChartFactory.createXYLineChart("Gaia Color-Magnitude Diagram", "", "", null);
        this.chart.setPadding(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        XYPlot plot = this.chart.getXYPlot();
        plot.setDataset(30, targetCollection);
        int j = 31;
        for (int i = 0; i < 10; ++i) {
            plot.setDataset(j++, this.createSpectralTypeCollection("M" + i));
        }
        plot.setDataset(41, mainCollection);
        NumberAxis xAxis = new NumberAxis(this.g_rpButton.isSelected() ? "G-RP" : "BP-RP");
        xAxis.setTickUnit(new NumberTickUnit(0.5));
        xAxis.setRange(this.g_rpButton.isSelected() ? -0.5 : -1.0, this.g_rpButton.isSelected() ? 2.5 : 5.5);
        plot.setDomainAxis(xAxis);
        NumberAxis yAxis = new NumberAxis("Abs G (mag)");
        yAxis.setTickUnit(new NumberTickUnit(5.0));
        yAxis.setRange(-2.0, 22.0);
        plot.setRangeAxis(yAxis);
        Font tickLabelFont = new Font(FONT_NAME, 0, 20);
        xAxis.setTickLabelFont(tickLabelFont);
        yAxis.setTickLabelFont(tickLabelFont);
        Font labelFont = new Font(FONT_NAME, 0, 20);
        xAxis.setLabelFont(labelFont);
        yAxis.setLabelFont(labelFont);
        double size = 10.0;
        double delta = size / 2.0;
        Ellipse2D.Double targetShape = new Ellipse2D.Double(-delta, -delta, size, size);
        XYLineAndShapeRenderer targetRenderer = new XYLineAndShapeRenderer();
        targetRenderer.setSeriesPaint(0, Color.RED);
        targetRenderer.setSeriesLinesVisible(0, false);
        targetRenderer.setSeriesVisibleInLegend(0, true);
        targetRenderer.setSeriesShape(0, targetShape);
        size = 1.0;
        delta = size / 2.0;
        Ellipse2D.Double mainShape = new Ellipse2D.Double(-delta, -delta, size, size);
        XYLineAndShapeRenderer mainRenderer = new XYLineAndShapeRenderer();
        mainRenderer.setSeriesPaint(0, Color.GRAY);
        mainRenderer.setSeriesLinesVisible(0, false);
        mainRenderer.setSeriesVisibleInLegend(0, false);
        mainRenderer.setSeriesShape(0, mainShape);
        plot.setRenderer(30, targetRenderer);
        int j2 = 31;
        for (Color color : COLORS) {
            plot.setRenderer(j2++, this.getSpectralTypeRenderer(color));
        }
        plot.setRenderer(41, mainRenderer);
        LegendItemCollection itemCollection = new LegendItemCollection();
        int i = 0;
        for (Color color : COLORS) {
            LegendItem item = new LegendItem("M" + i++, color);
            item.setShape(targetShape);
            itemCollection.add(item);
        }
        if (targetCollection.getSeriesCount() > 0) {
            LegendItem item = new LegendItem(this.targetLabel, Color.RED);
            item.setShape(targetShape);
            itemCollection.add(item);
        }
        plot.setFixedLegendItems(itemCollection);
        plot.setBackgroundPaint(Color.WHITE);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint(Color.LIGHT_GRAY);
        plot.setRangeGridlineStroke(new BasicStroke());
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint(Color.LIGHT_GRAY);
        plot.setDomainGridlineStroke(new BasicStroke());
        plot.getRangeAxis().setInverted(true);
        Font legendFont = new Font(FONT_NAME, 0, 20);
        this.chart.getLegend().setFrame(BlockBorder.NONE);
        this.chart.getLegend().setItemFont(legendFont);
        Font titleFont = new Font(FONT_NAME, 0, 24);
        this.chart.getTitle().setFont(titleFont);
    }

    private XYLineAndShapeRenderer getSpectralTypeRenderer(Color color) {
        double size = 1.0;
        double delta = size / 2.0;
        Ellipse2D.Double seriesShape = new Ellipse2D.Double(-delta, -delta, size, size);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, color);
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesVisibleInLegend(0, false);
        renderer.setSeriesShape(0, seriesShape);
        return renderer;
    }

    private void addCoolingSequencesH(JFreeChart chart) {
        XYPlot plot = chart.getXYPlot();
        for (int i = 2; i < 14; ++i) {
            String mass = NumericFunctions.roundTo1Dec((double)i / 10.0);
            plot.setDataset(i, this.createCoolingSequenceCollection("Mass %s H".formatted(mass)));
        }
        XYLineAndShapeRenderer sequenceRendererH = new XYLineAndShapeRenderer();
        sequenceRendererH.setSeriesPaint(0, Color.RED);
        sequenceRendererH.setSeriesLinesVisible(0, true);
        sequenceRendererH.setSeriesShapesVisible(0, false);
        sequenceRendererH.setSeriesVisibleInLegend(0, false);
        for (int i = 2; i < 14; ++i) {
            plot.setRenderer(i, sequenceRendererH);
        }
    }

    private void addCoolingSequencesHe(JFreeChart chart) {
        XYPlot plot = chart.getXYPlot();
        for (int i = 2; i < 14; ++i) {
            String mass = NumericFunctions.roundTo1Dec((double)i / 10.0);
            plot.setDataset(i + 14 - 2, this.createCoolingSequenceCollection("Mass %s He".formatted(mass)));
        }
        XYLineAndShapeRenderer sequenceRendererHe = new XYLineAndShapeRenderer();
        sequenceRendererHe.setSeriesPaint(0, Color.BLUE);
        sequenceRendererHe.setSeriesLinesVisible(0, true);
        sequenceRendererHe.setSeriesShapesVisible(0, false);
        sequenceRendererHe.setSeriesVisibleInLegend(0, false);
        for (int i = 2; i < 14; ++i) {
            plot.setRenderer(i + 14 - 2, sequenceRendererHe);
        }
    }

    private void removeCoolingSequencesH(JFreeChart chart) {
        for (int i = 2; i < 14; ++i) {
            XYSeriesCollection targetCollection = (XYSeriesCollection)chart.getXYPlot().getDataset(i);
            targetCollection.removeAllSeries();
        }
    }

    private void removeCoolingSequencesHe(JFreeChart chart) {
        for (int i = 2; i < 14; ++i) {
            XYSeriesCollection targetCollection = (XYSeriesCollection)chart.getXYPlot().getDataset(i + 14 - 2);
            targetCollection.removeAllSeries();
        }
    }

    private void loadCmdData() {
        byte[] fileBytes;
        if (Application.CMD_DATA != null) {
            return;
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        Path filePath = Paths.get(tempDir, "Gaia_CMD_sample.csv");
        try {
            fileBytes = Files.readAllBytes(filePath);
        }
        catch (IOException ex) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/Gaia CMD sample.csv");
                Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
                fileBytes = Files.readAllBytes(filePath);
            }
            catch (IOException e) {
                return;
            }
        }
        try (Scanner scanner = new Scanner(new String(fileBytes));){
            scanner.nextLine();
            Application.CMD_DATA = new ArrayList<NumberTriplet>();
            while (scanner.hasNextLine()) {
                String[] columnValues = scanner.nextLine().split(",", -1);
                double x = NumericFunctions.toDouble(columnValues[0]);
                double y = NumericFunctions.toDouble(columnValues[1]);
                double z = NumericFunctions.toDouble(columnValues[2]);
                Application.CMD_DATA.add(new NumberTriplet(x, y, z));
            }
        }
    }

    private List<NumberTriplet> loadSpectralType(String fileName) {
        ArrayList<NumberTriplet> spectralType = new ArrayList<NumberTriplet>();
        InputStream input = this.getClass().getResourceAsStream("/spectralTypes/" + fileName + ".csv");
        try (Scanner fileScanner = new Scanner(input);){
            String headerLine = fileScanner.nextLine();
            String[] headers = CSVParser.parseLine(headerLine);
            HashMap<String, Integer> columns = new HashMap<String, Integer>();
            for (int i = 0; i < headers.length; ++i) {
                columns.put(headers[i], i);
            }
            while (fileScanner.hasNextLine()) {
                String bodyLine = fileScanner.nextLine();
                String[] values = CSVParser.parseLine(bodyLine);
                double G = NumericFunctions.toDouble(values[(Integer)columns.get("M_G")]);
                double G_RP = NumericFunctions.toDouble(values[(Integer)columns.get("G-RP")]);
                double BP_RP = NumericFunctions.toDouble(values[(Integer)columns.get("BP-RP")]);
                spectralType.add(new NumberTriplet(G, G_RP, BP_RP));
            }
        }
        return spectralType;
    }

    private List<NumberTriplet> loadCoolingSequence(String fileName) {
        ArrayList<NumberTriplet> coolingSequence = new ArrayList<NumberTriplet>();
        InputStream input = this.getClass().getResourceAsStream("/coolingSequences/" + fileName + ".csv");
        try (Scanner fileScanner = new Scanner(input);){
            String headerLine = fileScanner.nextLine();
            String[] headers = CSVParser.parseLine(headerLine);
            HashMap<String, Integer> columns = new HashMap<String, Integer>();
            for (int i = 0; i < headers.length; ++i) {
                columns.put(headers[i], i);
            }
            while (fileScanner.hasNextLine()) {
                String bodyLine = fileScanner.nextLine();
                String[] values = CSVParser.parseLine(bodyLine);
                double G = NumericFunctions.toDouble(values[(Integer)columns.get("G3")]);
                double BP = NumericFunctions.toDouble(values[(Integer)columns.get("G3_BP")]);
                double RP = NumericFunctions.toDouble(values[(Integer)columns.get("G3_RP")]);
                coolingSequence.add(new NumberTriplet(G, G - RP, BP - RP));
            }
        }
        return coolingSequence;
    }

    static {
        COLORS.add(new Color(68, 1, 84));
        COLORS.add(new Color(72, 40, 120));
        COLORS.add(new Color(62, 73, 137));
        COLORS.add(new Color(49, 104, 142));
        COLORS.add(new Color(38, 130, 142));
        COLORS.add(new Color(31, 158, 137));
        COLORS.add(new Color(53, 183, 121));
        COLORS.add(new Color(110, 206, 88));
        COLORS.add(new Color(181, 222, 43));
        COLORS.add(new Color(253, 231, 37));
    }
}

