/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.panel;

import astro.tool.box.enumeration.FileType;
import astro.tool.box.main.ToolboxHelper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class JPlot {
    private static final String TEMP_FILE_PREFIX = "DataPlot_";
    private final String title;
    private final JFreeChart chart;
    private final XYPlot plot;
    private NumberAxis xLinearAxis;
    private NumberAxis yLinearAxis;
    private LogAxis xLogAxis;
    private LogAxis yLogAxis;
    private boolean logarithmicScale;
    private boolean ignoreZeroValues;
    private int index = -1;

    public JPlot(String title) {
        this.title = title;
        this.deleteTempFiles();
        this.chart = ChartFactory.createXYLineChart(title, "", "", null);
        this.applyChartTheme();
        this.plot = this.chart.getXYPlot();
        this.plot.setBackgroundPaint(Color.WHITE);
    }

    public JPlot backgroundColor(Color color) {
        this.plot.setBackgroundPaint(color);
        return this;
    }

    public JPlot gridlines() {
        this.gridlines(Color.LIGHT_GRAY, 0.5f);
        return this;
    }

    public JPlot ignoreZeroValues(boolean ignoreZeroValues) {
        this.ignoreZeroValues = ignoreZeroValues;
        return this;
    }

    public JPlot gridlines(Color color, float thickness) {
        this.plot.setRangeGridlinesVisible(true);
        this.plot.setRangeGridlinePaint(color);
        this.plot.setRangeGridlineStroke(new BasicStroke(thickness));
        this.plot.setDomainGridlinesVisible(true);
        this.plot.setDomainGridlinePaint(color);
        this.plot.setDomainGridlineStroke(new BasicStroke(thickness));
        return this;
    }

    public JPlot xAxis(String axisLabel) {
        return this.xAxis(axisLabel, false);
    }

    public JPlot xAxis(String axisLabel, boolean logarithmicScale) {
        if (logarithmicScale) {
            this.xLogAxis = new LogAxis(axisLabel);
            this.plot.setDomainAxis(this.xLogAxis);
        } else {
            this.xLinearAxis = new NumberAxis(axisLabel);
            this.plot.setDomainAxis(this.xLinearAxis);
            this.xLinearAxis.setAutoRangeIncludesZero(false);
        }
        this.logarithmicScale = logarithmicScale;
        return this;
    }

    public JPlot xAxisNumberFormat(NumberFormat format) {
        if (this.logarithmicScale) {
            this.xLogAxis.setNumberFormatOverride(format);
        } else {
            this.xLinearAxis.setNumberFormatOverride(format);
        }
        return this;
    }

    public JPlot xAxisInverted(boolean inverted) {
        if (this.logarithmicScale) {
            this.xLogAxis.setInverted(inverted);
        } else {
            this.xLinearAxis.setInverted(inverted);
        }
        return this;
    }

    public JPlot xAxisRange(double from, double to) {
        if (this.logarithmicScale) {
            this.xLogAxis.setRange(from, to);
        } else {
            this.xLinearAxis.setRange(from, to);
        }
        return this;
    }

    public JPlot xAxisLowerBound(double lowerBound) {
        if (this.logarithmicScale) {
            this.xLogAxis.setAutoRangeMinimumSize(lowerBound);
        } else {
            this.xLinearAxis.setAutoRangeMinimumSize(lowerBound);
        }
        return this;
    }

    public JPlot xAxisTickInterval(double tickInterval) {
        if (this.logarithmicScale) {
            this.xLogAxis.setTickUnit(new NumberTickUnit(tickInterval));
        } else {
            this.xLinearAxis.setTickUnit(new NumberTickUnit(tickInterval));
        }
        return this;
    }

    public JPlot yAxis(String axisLabel) {
        return this.yAxis(axisLabel, false);
    }

    public JPlot yAxis(String axisLabel, boolean logarithmicScale) {
        if (logarithmicScale) {
            this.yLogAxis = new LogAxis(axisLabel);
            this.plot.setRangeAxis(this.yLogAxis);
        } else {
            this.yLinearAxis = new NumberAxis(axisLabel);
            this.plot.setRangeAxis(this.yLinearAxis);
            this.yLinearAxis.setAutoRangeIncludesZero(false);
        }
        this.logarithmicScale = logarithmicScale;
        return this;
    }

    public JPlot yAxisNumberFormat(NumberFormat format) {
        if (this.logarithmicScale) {
            this.yLogAxis.setNumberFormatOverride(format);
        } else {
            this.yLinearAxis.setNumberFormatOverride(format);
        }
        return this;
    }

    public JPlot yAxisInverted(boolean inverted) {
        if (this.logarithmicScale) {
            this.yLogAxis.setInverted(inverted);
        } else {
            this.yLinearAxis.setInverted(inverted);
        }
        return this;
    }

    public JPlot yAxisRange(double from, double to) {
        if (this.logarithmicScale) {
            this.yLogAxis.setRange(from, to);
        } else {
            this.yLinearAxis.setRange(from, to);
        }
        return this;
    }

    public JPlot yAxisLowerBound(double lowerBound) {
        if (this.logarithmicScale) {
            this.yLogAxis.setAutoRangeMinimumSize(lowerBound);
        } else {
            this.yLinearAxis.setAutoRangeMinimumSize(lowerBound);
        }
        return this;
    }

    public JPlot yAxisTickInterval(double tickInterval) {
        if (this.logarithmicScale) {
            this.yLogAxis.setTickUnit(new NumberTickUnit(tickInterval));
        } else {
            this.yLinearAxis.setTickUnit(new NumberTickUnit(tickInterval));
        }
        return this;
    }

    public JPlot error(String legendEntry, List<Double> x, List<Double> y, List<Double> error, Color color, boolean plot) {
        return this.error(legendEntry, x, y, error, error, color, plot);
    }

    public JPlot error(String legendEntry, List<Double> x, List<Double> y, List<Double> lowerError, List<Double> upperError, Color color, boolean plot) {
        if (plot) {
            ArrayList<Double> upperBound = new ArrayList<Double>();
            ArrayList<Double> lowerBound = new ArrayList<Double>();
            for (int i = 0; i < y.size(); ++i) {
                upperBound.add(y.get(i) + upperError.get(i));
                lowerBound.add(y.get(i) - lowerError.get(i));
            }
            ++this.index;
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesVisible(0, true);
            this.addRenderer(legendEntry, x, y, color, renderer);
            ++this.index;
            XYLineAndShapeRenderer upperErrorRenderer = new XYLineAndShapeRenderer();
            upperErrorRenderer.setSeriesLinesVisible(0, false);
            upperErrorRenderer.setSeriesShapesVisible(0, true);
            this.addRenderer(null, x, upperBound, color, upperErrorRenderer, this.getUpperErrorShape());
            ++this.index;
            XYLineAndShapeRenderer lowerErrorRenderer = new XYLineAndShapeRenderer();
            lowerErrorRenderer.setSeriesLinesVisible(0, false);
            lowerErrorRenderer.setSeriesShapesVisible(0, true);
            this.addRenderer(null, x, lowerBound, color, lowerErrorRenderer, this.getLowerErrorShape());
        }
        return this;
    }

    public JPlot scatter(String legendEntry, List<Double> x, List<Double> y, Color color, boolean plot) {
        if (plot) {
            ++this.index;
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setSeriesLinesVisible(0, false);
            renderer.setSeriesShapesVisible(0, true);
            this.addRenderer(legendEntry, x, y, color, renderer);
        }
        return this;
    }

    public JPlot line(String legendEntry, List<Double> x, List<Double> y, Color color, boolean showDataPoints, boolean plot) {
        if (plot) {
            ++this.index;
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesVisible(0, showDataPoints);
            this.addRenderer(legendEntry, x, y, color, renderer);
        }
        return this;
    }

    public JPlot curve(String legendEntry, List<Double> x, List<Double> y, Color color, boolean showDataPoints, boolean plot) {
        if (plot) {
            ++this.index;
            XYSplineRenderer renderer = new XYSplineRenderer(100);
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesVisible(0, showDataPoints);
            this.addRenderer(legendEntry, x, y, color, renderer);
        }
        return this;
    }

    public JPlot save(String filePath, FileType fileType, int width, int height) {
        try {
            File file = new File(this.addExtension(filePath, fileType));
            this.savePlot(file, fileType, width, height);
            return this;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public JPlot show(int width, int height, FileType fileType) {
        try {
            File file = File.createTempFile(TEMP_FILE_PREFIX, fileType.val);
            this.savePlot(file, fileType, width, height);
            Desktop.getDesktop().open(file);
            return this;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void show(int width, int height, JFrame baseFrame) {
        ChartPanel chartPanel = new ChartPanel(this.chart){

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        chartPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        chartPanel.setBackground(Color.WHITE);
        JFrame frame = new JFrame();
        frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(baseFrame));
        frame.setIconImage(ToolboxHelper.getToolBoxImage());
        frame.setTitle(this.title);
        frame.add(chartPanel);
        frame.setSize(width, height);
        frame.setLocation(0, 0);
        frame.setAlwaysOnTop(false);
        frame.setResizable(true);
        frame.setVisible(true);
    }

    private void savePlot(File file, FileType fileType, int width, int height) {
        try {
            switch (fileType) {
                case JPEG: {
                    ChartUtils.saveChartAsJPEG(file, this.chart, width, height);
                    break;
                }
                case PNG: {
                    ChartUtils.saveChartAsPNG(file, this.chart, width, height);
                    break;
                }
                case PDF: {
                    this.savePDF(file, width, height);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addRenderer(String legendEntry, List<Double> x, List<Double> y, Color color, XYItemRenderer renderer) {
        this.addRenderer(legendEntry, x, y, color, renderer, this.getShape());
    }

    private void addRenderer(String legendEntry, List<Double> x, List<Double> y, Color color, XYItemRenderer renderer, Shape shape) {
        if (legendEntry == null || ((String)legendEntry).isEmpty()) {
            legendEntry = "Dataset" + this.index;
            renderer.setSeriesVisibleInLegend(0, false);
        }
        renderer.setSeriesPaint(0, color);
        renderer.setSeriesShape(0, shape);
        this.plot.setRenderer(this.index, renderer);
        this.addDataset((String)legendEntry, x, y);
    }

    private void addDataset(String label, List<Double> x, List<Double> y) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)label));
        for (int i = 0; i < x.size(); ++i) {
            double xVal = x.get(i);
            double yVal = y.get(i);
            if (this.ignoreZeroValues && (xVal == 0.0 || yVal == 0.0)) continue;
            series.add(xVal, yVal);
        }
        dataset.addSeries(series);
        this.plot.setDataset(this.index, dataset);
    }

    private String addExtension(String filePath, FileType fileType) {
        int lastIndex = filePath.lastIndexOf(46);
        if (lastIndex == -1) {
            return filePath + fileType.val;
        }
        return filePath.substring(0, lastIndex) + fileType.val;
    }

    private Shape getShape() {
        double size = 6.0;
        double delta = size / 2.0;
        return new Ellipse2D.Double(-delta, -delta, size, size);
    }

    private Shape getUpperErrorShape() {
        Path2D.Double tShape = new Path2D.Double();
        ((Path2D)tShape).moveTo(0.0, 0.0);
        ((Path2D)tShape).lineTo(-3.0, 0.0);
        ((Path2D)tShape).moveTo(0.0, 0.0);
        ((Path2D)tShape).lineTo(3.0, 0.0);
        ((Path2D)tShape).moveTo(0.0, 0.0);
        ((Path2D)tShape).lineTo(0.0, -6.0);
        return tShape;
    }

    private Shape getLowerErrorShape() {
        Path2D.Double tShape = new Path2D.Double();
        ((Path2D)tShape).moveTo(0.0, 0.0);
        ((Path2D)tShape).lineTo(-3.0, 0.0);
        ((Path2D)tShape).moveTo(0.0, 0.0);
        ((Path2D)tShape).lineTo(3.0, 0.0);
        ((Path2D)tShape).moveTo(0.0, 0.0);
        ((Path2D)tShape).lineTo(0.0, 6.0);
        return tShape;
    }

    private void savePDF(File file, int width, int height) throws Exception {
        Rectangle pagesize = new Rectangle(width, height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(file));
        document.open();
        PdfContentByte contentByte = writer.getDirectContent();
        PdfTemplate template = contentByte.createTemplate(width, height);
        PdfGraphics2D graphics = new PdfGraphics2D(contentByte, width, height);
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.chart.draw(graphics, rectangle);
        ((Graphics)graphics).dispose();
        contentByte.addTemplate(template, 0.0f, 0.0f);
        document.close();
    }

    private void applyChartTheme() {
        StandardChartTheme chartTheme = (StandardChartTheme)StandardChartTheme.createJFreeTheme();
        Font extraLargeFont = chartTheme.getExtraLargeFont();
        Font largeFont = chartTheme.getLargeFont();
        Font regularFont = chartTheme.getRegularFont();
        Font smallFont = chartTheme.getSmallFont();
        extraLargeFont = new Font("Sans-serif", extraLargeFont.getStyle(), extraLargeFont.getSize());
        largeFont = new Font("Sans-serif", largeFont.getStyle(), largeFont.getSize());
        regularFont = new Font("Sans-serif", regularFont.getStyle(), regularFont.getSize());
        smallFont = new Font("Sans-serif", smallFont.getStyle(), smallFont.getSize());
        chartTheme.setExtraLargeFont(extraLargeFont);
        chartTheme.setLargeFont(largeFont);
        chartTheme.setRegularFont(regularFont);
        chartTheme.setSmallFont(smallFont);
        chartTheme.apply(this.chart);
    }

    private void deleteTempFiles() {
        File[] files;
        String tmpdir = System.getProperty("java.io.tmpdir");
        for (File file : files = new File(tmpdir).listFiles(f -> f.getName().startsWith(TEMP_FILE_PREFIX))) {
            file.delete();
        }
    }

    public JFreeChart getChart() {
        return this.chart;
    }
}

