/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.panel;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.CatWiseCatalogEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.DesCatalogEntry;
import astro.tool.box.catalog.GaiaDR3CatalogEntry;
import astro.tool.box.catalog.NoirlabCatalogEntry;
import astro.tool.box.catalog.PanStarrsCatalogEntry;
import astro.tool.box.catalog.TwoMassCatalogEntry;
import astro.tool.box.catalog.UhsCatalogEntry;
import astro.tool.box.catalog.UkidssCatalogEntry;
import astro.tool.box.catalog.UnWiseCatalogEntry;
import astro.tool.box.catalog.VhsCatalogEntry;
import astro.tool.box.container.SedBestMatch;
import astro.tool.box.container.SedFluxes;
import astro.tool.box.container.SedReferences;
import astro.tool.box.container.WhiteDwarfEntry;
import astro.tool.box.enumeration.Band;
import astro.tool.box.enumeration.Sed;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.function.StatisticFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.util.CSVParser;
import astro.tool.box.util.Constants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class SedWdPanel
extends JPanel {
    private static final String FONT_NAME = "Tahoma";
    private final List<WhiteDwarfEntry> whiteDwarfEntries = new ArrayList<WhiteDwarfEntry>();
    private final CatalogQueryService catalogQueryService;
    private final JFrame baseFrame;
    private final JTextField photSearchRadius;
    private final JButton createButton;
    private final JButton removeButton;
    private final JCheckBox bestMatch;
    private final JCheckBox overplotTemplates;
    private final JCheckBox gaiaPhot;
    private final JCheckBox panStarrsPhot;
    private final JCheckBox noirlabPhot;
    private final JCheckBox desPhot;
    private final JCheckBox twoMassPhot;
    private final JCheckBox ukidssPhot;
    private final JCheckBox uhsPhot;
    private final JCheckBox vhsPhot;
    private final JCheckBox allwisePhot;
    private final JCheckBox catwisePhot;
    private final JCheckBox unwisePhot;
    private Map<Band, SedReferences> sedReferences;
    private Map<Band, SedFluxes> sedFluxes;
    private Map<Band, Double> sedPhotometry;
    private Map<Band, String> sedCatalogs;
    private StringBuilder sedDataPoints;
    private boolean useGaiaPhotometry;

    public SedWdPanel(CatalogQueryService catalogQueryService, CatalogEntry catalogEntry, JFrame baseFrame) {
        this.createWhiteDwarfSedEntries();
        this.catalogQueryService = catalogQueryService;
        this.baseFrame = baseFrame;
        this.photSearchRadius = new JTextField("5", 3);
        this.createButton = new JButton("Create SED");
        this.removeButton = new JButton("Remove templates");
        this.bestMatch = new JCheckBox("Best match", true);
        this.overplotTemplates = new JCheckBox("Overplot templates", true);
        this.gaiaPhot = new JCheckBox("Gaia  ", true);
        this.panStarrsPhot = new JCheckBox("Pan-STARRS  ", false);
        this.noirlabPhot = new JCheckBox("NSC  ", false);
        this.desPhot = new JCheckBox("DES  ", false);
        this.twoMassPhot = new JCheckBox("2MASS  ", true);
        this.ukidssPhot = new JCheckBox("UKIDSS  ", false);
        this.uhsPhot = new JCheckBox("UHS  ", false);
        this.vhsPhot = new JCheckBox("VHS  ", false);
        this.allwisePhot = new JCheckBox("AllWISE  ", true);
        this.catwisePhot = new JCheckBox("CatWISE  ", false);
        this.unwisePhot = new JCheckBox("unWISE  ", false);
        XYSeriesCollection collection = this.createSed(catalogEntry, null, true);
        JFreeChart chart = this.createChart(collection);
        ChartPanel chartPanel = new ChartPanel(chart){

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        chartPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        chartPanel.setPreferredSize(new Dimension(1000, 850));
        chartPanel.setBackground(Color.WHITE);
        this.add(chartPanel);
        JPanel commandPanel = new JPanel(new FlowLayout(0));
        this.add(commandPanel);
        commandPanel.add(new JLabel("Search radius (\")"));
        commandPanel.add(this.photSearchRadius);
        commandPanel.add(this.gaiaPhot);
        this.gaiaPhot.addActionListener(e -> {
            this.panStarrsPhot.setSelected(false);
            this.noirlabPhot.setSelected(false);
            this.desPhot.setSelected(false);
        });
        commandPanel.add(this.panStarrsPhot);
        this.panStarrsPhot.addActionListener(e -> {
            this.gaiaPhot.setSelected(false);
            this.noirlabPhot.setSelected(false);
            this.desPhot.setSelected(false);
        });
        commandPanel.add(this.noirlabPhot);
        this.noirlabPhot.addActionListener(e -> {
            this.gaiaPhot.setSelected(false);
            this.panStarrsPhot.setSelected(false);
            this.desPhot.setSelected(false);
        });
        commandPanel.add(this.desPhot);
        this.desPhot.addActionListener(e -> {
            this.gaiaPhot.setSelected(false);
            this.panStarrsPhot.setSelected(false);
            this.noirlabPhot.setSelected(false);
        });
        commandPanel.add(this.twoMassPhot);
        this.twoMassPhot.addActionListener(e -> {
            this.ukidssPhot.setSelected(false);
            this.uhsPhot.setSelected(false);
            this.vhsPhot.setSelected(false);
        });
        commandPanel.add(this.ukidssPhot);
        this.ukidssPhot.addActionListener(e -> {
            this.twoMassPhot.setSelected(false);
            this.uhsPhot.setSelected(false);
            this.vhsPhot.setSelected(false);
        });
        commandPanel.add(this.uhsPhot);
        this.uhsPhot.addActionListener(e -> {
            this.twoMassPhot.setSelected(false);
            this.ukidssPhot.setSelected(false);
            this.vhsPhot.setSelected(false);
        });
        commandPanel.add(this.vhsPhot);
        this.vhsPhot.addActionListener(e -> {
            this.twoMassPhot.setSelected(false);
            this.ukidssPhot.setSelected(false);
            this.uhsPhot.setSelected(false);
        });
        commandPanel.add(this.allwisePhot);
        this.allwisePhot.addActionListener(e -> {
            this.catwisePhot.setSelected(false);
            this.unwisePhot.setSelected(false);
        });
        commandPanel.add(this.catwisePhot);
        this.catwisePhot.addActionListener(e -> {
            this.allwisePhot.setSelected(false);
            this.unwisePhot.setSelected(false);
        });
        commandPanel.add(this.unwisePhot);
        this.unwisePhot.addActionListener(e -> {
            this.allwisePhot.setSelected(false);
            this.catwisePhot.setSelected(false);
        });
        commandPanel.add(this.createButton);
        this.createButton.setFont(this.createButton.getFont().deriveFont(1, 14.0f));
        this.createButton.setMargin(new Insets(2, 10, 2, 10));
        this.createButton.addActionListener(e -> {
            collection.removeAllSeries();
            this.createSed(catalogEntry, collection, true);
            this.setSeriesShape(chart);
            XYPlot plot = chart.getXYPlot();
            plot.getRenderer().setSeriesToolTipGenerator(0, this.addToolTips());
        });
        commandPanel = new JPanel(new FlowLayout(0));
        this.add(commandPanel);
        commandPanel.add(this.removeButton);
        this.removeButton.addActionListener(e -> {
            collection.removeAllSeries();
            this.createSed(catalogEntry, collection, false);
            this.setSeriesShape(chart);
        });
        commandPanel.add(this.bestMatch);
        this.bestMatch.addActionListener(e -> {
            collection.removeAllSeries();
            this.createSed(catalogEntry, collection, true);
            this.setSeriesShape(chart);
        });
        commandPanel.add(this.overplotTemplates);
        this.overplotTemplates.addActionListener(e -> {
            collection.removeAllSeries();
            this.createSed(catalogEntry, collection, true);
            this.setSeriesShape(chart);
        });
        JButton createButton = new JButton("Create PDF");
        commandPanel.add(createButton);
        createButton.addActionListener(e -> {
            try {
                File tmpFile = File.createTempFile("Target_" + NumericFunctions.roundTo2DecNZ(catalogEntry.getRa()) + NumericFunctions.addPlusSign(NumericFunctions.roundDouble(catalogEntry.getDec(), "#.##")) + "_", ".pdf");
                ToolboxHelper.createPDF(chart, tmpFile, 800, 700);
                Desktop.getDesktop().open(tmpFile);
            }
            catch (Exception ex) {
                ToolboxHelper.writeErrorLog(ex);
            }
        });
        JButton dataButton = new JButton("Get SED data points");
        commandPanel.add(dataButton);
        dataButton.addActionListener(e -> ToolboxHelper.showScrollableDialog(baseFrame, "SED data points", this.sedDataPoints.toString()));
        String info = "Holding the mouse pointer over a data point on your object's SED (black line), shows the corresponding filter and wavelength.<br/>Right-clicking on the chart, opens a context menu with additional functions like printing and saving.";
        JLabel infoLabel = new JLabel("Tooltip");
        infoLabel.setToolTipText(ToolboxHelper.html(info));
        commandPanel.add(infoLabel);
        JLabel toolTip = new JLabel(ToolboxHelper.getInfoIcon());
        toolTip.setToolTipText(ToolboxHelper.html(info));
        commandPanel.add(toolTip);
        commandPanel.add(new JLabel("This feature uses the"));
        commandPanel.add(ToolboxHelper.createHyperlink("Montreal cooling sequences.", "http://www.astro.umontreal.ca/~bergeron/CoolingModels"));
        this.setLayout(new BoxLayout(this, 1));
    }

    private XYSeriesCollection createSed(CatalogEntry catalogEntry, XYSeriesCollection collection, boolean addReferenceSeds) {
        CatalogEntry retrievedEntry;
        this.photSearchRadius.setCursor(Cursor.getPredefinedCursor(3));
        this.createButton.setCursor(Cursor.getPredefinedCursor(3));
        this.removeButton.setCursor(Cursor.getPredefinedCursor(3));
        this.bestMatch.setCursor(Cursor.getPredefinedCursor(3));
        this.overplotTemplates.setCursor(Cursor.getPredefinedCursor(3));
        this.gaiaPhot.setCursor(Cursor.getPredefinedCursor(3));
        this.panStarrsPhot.setCursor(Cursor.getPredefinedCursor(3));
        this.noirlabPhot.setCursor(Cursor.getPredefinedCursor(3));
        this.desPhot.setCursor(Cursor.getPredefinedCursor(3));
        this.twoMassPhot.setCursor(Cursor.getPredefinedCursor(3));
        this.ukidssPhot.setCursor(Cursor.getPredefinedCursor(3));
        this.uhsPhot.setCursor(Cursor.getPredefinedCursor(3));
        this.vhsPhot.setCursor(Cursor.getPredefinedCursor(3));
        this.allwisePhot.setCursor(Cursor.getPredefinedCursor(3));
        this.catwisePhot.setCursor(Cursor.getPredefinedCursor(3));
        this.unwisePhot.setCursor(Cursor.getPredefinedCursor(3));
        this.sedReferences = new HashMap<Band, SedReferences>();
        this.sedFluxes = new HashMap<Band, SedFluxes>();
        this.sedPhotometry = new HashMap<Band, Double>();
        this.sedCatalogs = new HashMap<Band, String>();
        this.sedDataPoints = new StringBuilder();
        double searchRadius = NumericFunctions.toDouble(this.photSearchRadius.getText());
        searchRadius = searchRadius < 1.0 ? 1.0 : searchRadius;
        StringBuilder seriesLabel = new StringBuilder();
        this.useGaiaPhotometry = false;
        if (this.gaiaPhot.isSelected()) {
            GaiaDR3CatalogEntry gaiaEntry = new GaiaDR3CatalogEntry();
            gaiaEntry.setRa(catalogEntry.getRa());
            gaiaEntry.setDec(catalogEntry.getDec());
            gaiaEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(gaiaEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                this.gaiaPhot.setSelected(false);
                this.panStarrsPhot.setSelected(true);
            } else {
                this.useGaiaPhotometry = true;
                gaiaEntry = (GaiaDR3CatalogEntry)retrievedEntry;
                seriesLabel.append(gaiaEntry.getCatalogName()).append(": ").append(gaiaEntry.getSourceId()).append(" ");
                this.sedCatalogs.put(Band.BP, gaiaEntry.getCatalogName());
                this.sedCatalogs.put(Band.G, gaiaEntry.getCatalogName());
                this.sedCatalogs.put(Band.RP, gaiaEntry.getCatalogName());
                this.addGaiaReferences();
                this.sedPhotometry.put(Band.BP, gaiaEntry.getBPmag());
                this.sedPhotometry.put(Band.G, gaiaEntry.getGmag());
                this.sedPhotometry.put(Band.RP, gaiaEntry.getRPmag());
            }
        }
        if (this.panStarrsPhot.isSelected()) {
            PanStarrsCatalogEntry panStarrsEntry = new PanStarrsCatalogEntry();
            panStarrsEntry.setRa(catalogEntry.getRa());
            panStarrsEntry.setDec(catalogEntry.getDec());
            panStarrsEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(panStarrsEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                this.panStarrsPhot.setSelected(false);
                this.noirlabPhot.setSelected(true);
            } else {
                panStarrsEntry = (PanStarrsCatalogEntry)retrievedEntry;
                seriesLabel.append(panStarrsEntry.getCatalogName()).append(": ").append(panStarrsEntry.getSourceId()).append(" ");
                this.sedCatalogs.put(Band.g, panStarrsEntry.getCatalogName());
                this.sedCatalogs.put(Band.r, panStarrsEntry.getCatalogName());
                this.sedCatalogs.put(Band.i, panStarrsEntry.getCatalogName());
                this.sedCatalogs.put(Band.z, panStarrsEntry.getCatalogName());
                this.sedCatalogs.put(Band.y, panStarrsEntry.getCatalogName());
                this.addPanStarrsReferences();
                this.sedPhotometry.put(Band.g, panStarrsEntry.get_g_err() == 0.0 ? 0.0 : panStarrsEntry.get_g_mag());
                this.sedPhotometry.put(Band.r, panStarrsEntry.get_r_err() == 0.0 ? 0.0 : panStarrsEntry.get_r_mag());
                this.sedPhotometry.put(Band.i, panStarrsEntry.get_i_err() == 0.0 ? 0.0 : panStarrsEntry.get_i_mag());
                this.sedPhotometry.put(Band.z, panStarrsEntry.get_z_err() == 0.0 ? 0.0 : panStarrsEntry.get_z_mag());
                this.sedPhotometry.put(Band.y, panStarrsEntry.get_y_err() == 0.0 ? 0.0 : panStarrsEntry.get_y_mag());
            }
        }
        if (this.noirlabPhot.isSelected()) {
            NoirlabCatalogEntry noirlabEntry = new NoirlabCatalogEntry();
            noirlabEntry.setRa(catalogEntry.getRa());
            noirlabEntry.setDec(catalogEntry.getDec());
            noirlabEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(noirlabEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                this.noirlabPhot.setSelected(false);
                this.desPhot.setSelected(true);
            } else {
                noirlabEntry = (NoirlabCatalogEntry)retrievedEntry;
                seriesLabel.append(noirlabEntry.getCatalogName()).append(": ").append(noirlabEntry.getSourceId()).append(" ");
                this.sedCatalogs.put(Band.g, noirlabEntry.getCatalogName());
                this.sedCatalogs.put(Band.r, noirlabEntry.getCatalogName());
                this.sedCatalogs.put(Band.i, noirlabEntry.getCatalogName());
                this.sedCatalogs.put(Band.z, noirlabEntry.getCatalogName());
                this.sedCatalogs.put(Band.y, noirlabEntry.getCatalogName());
                this.addDecamReferences();
                this.sedPhotometry.put(Band.g, noirlabEntry.get_g_mag());
                this.sedPhotometry.put(Band.r, noirlabEntry.get_r_mag());
                this.sedPhotometry.put(Band.i, noirlabEntry.get_i_mag());
                this.sedPhotometry.put(Band.z, noirlabEntry.get_z_mag());
                this.sedPhotometry.put(Band.y, noirlabEntry.get_y_mag());
            }
        }
        if (this.desPhot.isSelected()) {
            DesCatalogEntry desEntry = new DesCatalogEntry();
            desEntry.setRa(catalogEntry.getRa());
            desEntry.setDec(catalogEntry.getDec());
            desEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(desEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                this.desPhot.setSelected(false);
            } else {
                desEntry = (DesCatalogEntry)retrievedEntry;
                seriesLabel.append(desEntry.getCatalogName()).append(": ").append(desEntry.getSourceId()).append(" ");
                this.sedCatalogs.put(Band.g, desEntry.getCatalogName());
                this.sedCatalogs.put(Band.r, desEntry.getCatalogName());
                this.sedCatalogs.put(Band.i, desEntry.getCatalogName());
                this.sedCatalogs.put(Band.z, desEntry.getCatalogName());
                this.sedCatalogs.put(Band.y, desEntry.getCatalogName());
                this.addDecamReferences();
                this.sedPhotometry.put(Band.g, desEntry.get_g_caut() > 3 ? 0.0 : desEntry.get_g_mag());
                this.sedPhotometry.put(Band.r, desEntry.get_r_caut() > 3 ? 0.0 : desEntry.get_r_mag());
                this.sedPhotometry.put(Band.i, desEntry.get_i_caut() > 3 ? 0.0 : desEntry.get_i_mag());
                this.sedPhotometry.put(Band.z, desEntry.get_z_caut() > 3 ? 0.0 : desEntry.get_z_mag());
                this.sedPhotometry.put(Band.y, desEntry.get_y_caut() > 3 ? 0.0 : desEntry.get_y_mag());
            }
        }
        this.add2MassReferences();
        this.sedPhotometry.put(Band.J, 0.0);
        this.sedPhotometry.put(Band.H, 0.0);
        this.sedPhotometry.put(Band.K, 0.0);
        if (this.twoMassPhot.isSelected()) {
            TwoMassCatalogEntry twoMassEntry = new TwoMassCatalogEntry();
            twoMassEntry.setRa(catalogEntry.getRa());
            twoMassEntry.setDec(catalogEntry.getDec());
            twoMassEntry.setSearchRadius(searchRadius * 2.0);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(twoMassEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                this.twoMassPhot.setSelected(false);
                this.ukidssPhot.setSelected(true);
            } else {
                twoMassEntry = (TwoMassCatalogEntry)retrievedEntry;
                seriesLabel.append(twoMassEntry.getCatalogName()).append(": ").append(twoMassEntry.getSourceId()).append(" ");
                this.sedCatalogs.put(Band.J, twoMassEntry.getCatalogName());
                this.sedCatalogs.put(Band.H, twoMassEntry.getCatalogName());
                this.sedCatalogs.put(Band.K, twoMassEntry.getCatalogName());
                this.add2MassReferences();
                this.sedPhotometry.put(Band.J, twoMassEntry.getJ_err() == 0.0 ? 0.0 : twoMassEntry.getJmag());
                this.sedPhotometry.put(Band.H, twoMassEntry.getH_err() == 0.0 ? 0.0 : twoMassEntry.getHmag());
                this.sedPhotometry.put(Band.K, twoMassEntry.getK_err() == 0.0 ? 0.0 : twoMassEntry.getKmag());
            }
        }
        if (this.ukidssPhot.isSelected()) {
            if (catalogEntry.getDec() > -5.0) {
                UkidssCatalogEntry ukidssEntry = new UkidssCatalogEntry();
                ukidssEntry.setRa(catalogEntry.getRa());
                ukidssEntry.setDec(catalogEntry.getDec());
                ukidssEntry.setSearchRadius(searchRadius);
                retrievedEntry = ToolboxHelper.retrieveCatalogEntry(ukidssEntry, this.catalogQueryService, this.baseFrame);
                if (retrievedEntry == null) {
                    this.ukidssPhot.setSelected(false);
                    this.uhsPhot.setSelected(true);
                } else if (ukidssEntry.getJmag() == 0.0 && ukidssEntry.getHmag() == 0.0 && ukidssEntry.getKmag() == 0.0) {
                    this.ukidssPhot.setSelected(false);
                    this.uhsPhot.setSelected(true);
                } else {
                    ukidssEntry = (UkidssCatalogEntry)retrievedEntry;
                    seriesLabel.append(ukidssEntry.getCatalogName()).append(": ").append(ukidssEntry.getSourceId()).append(" ");
                    this.sedCatalogs.put(Band.J, ukidssEntry.getCatalogName());
                    this.sedCatalogs.put(Band.H, ukidssEntry.getCatalogName());
                    this.sedCatalogs.put(Band.K, ukidssEntry.getCatalogName());
                    this.addUkidssReferences();
                    this.sedPhotometry.put(Band.J, ukidssEntry.getJmag());
                    this.sedPhotometry.put(Band.H, ukidssEntry.getHmag());
                    this.sedPhotometry.put(Band.K, ukidssEntry.getKmag());
                }
            } else {
                this.ukidssPhot.setSelected(false);
                this.vhsPhot.setSelected(true);
            }
        }
        if (this.uhsPhot.isSelected()) {
            if (catalogEntry.getDec() > -5.0) {
                UhsCatalogEntry uhsEntry = new UhsCatalogEntry();
                uhsEntry.setRa(catalogEntry.getRa());
                uhsEntry.setDec(catalogEntry.getDec());
                uhsEntry.setSearchRadius(searchRadius);
                retrievedEntry = ToolboxHelper.retrieveCatalogEntry(uhsEntry, this.catalogQueryService, this.baseFrame);
                if (retrievedEntry == null) {
                    this.uhsPhot.setSelected(false);
                    this.vhsPhot.setSelected(true);
                } else {
                    uhsEntry = (UhsCatalogEntry)retrievedEntry;
                    seriesLabel.append(uhsEntry.getCatalogName()).append(": ").append(uhsEntry.getSourceId()).append(" ");
                    this.sedCatalogs.put(Band.J, uhsEntry.getCatalogName());
                    this.sedCatalogs.put(Band.H, uhsEntry.getCatalogName());
                    this.sedCatalogs.put(Band.K, uhsEntry.getCatalogName());
                    this.addUkidssReferences();
                    this.sedPhotometry.put(Band.J, uhsEntry.getJmag());
                    this.sedPhotometry.put(Band.H, uhsEntry.getHmag());
                    this.sedPhotometry.put(Band.K, uhsEntry.getKmag());
                }
            } else {
                this.uhsPhot.setSelected(false);
                this.vhsPhot.setSelected(true);
            }
        }
        if (this.vhsPhot.isSelected()) {
            if (catalogEntry.getDec() < 5.0) {
                VhsCatalogEntry vhsEntry = new VhsCatalogEntry();
                vhsEntry.setRa(catalogEntry.getRa());
                vhsEntry.setDec(catalogEntry.getDec());
                vhsEntry.setSearchRadius(searchRadius);
                retrievedEntry = ToolboxHelper.retrieveCatalogEntry(vhsEntry, this.catalogQueryService, this.baseFrame);
                if (retrievedEntry == null) {
                    this.vhsPhot.setSelected(false);
                } else {
                    vhsEntry = (VhsCatalogEntry)retrievedEntry;
                    seriesLabel.append(vhsEntry.getCatalogName()).append(": ").append(vhsEntry.getSourceId()).append(" ");
                    this.sedCatalogs.put(Band.J, vhsEntry.getCatalogName());
                    this.sedCatalogs.put(Band.H, vhsEntry.getCatalogName());
                    this.sedCatalogs.put(Band.K, vhsEntry.getCatalogName());
                    this.addVhsReferences();
                    this.sedPhotometry.put(Band.J, vhsEntry.getJmag());
                    this.sedPhotometry.put(Band.H, vhsEntry.getHmag());
                    this.sedPhotometry.put(Band.K, vhsEntry.getKmag());
                }
            } else {
                this.vhsPhot.setSelected(false);
            }
        }
        if (this.allwisePhot.isSelected()) {
            AllWiseCatalogEntry allWiseEntry = new AllWiseCatalogEntry();
            allWiseEntry.setRa(catalogEntry.getRa());
            allWiseEntry.setDec(catalogEntry.getDec());
            allWiseEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(allWiseEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                this.allwisePhot.setSelected(false);
                this.catwisePhot.setSelected(true);
            } else {
                allWiseEntry = (AllWiseCatalogEntry)retrievedEntry;
                seriesLabel.append(allWiseEntry.getCatalogName()).append(": ").append(allWiseEntry.getSourceId()).append(" ");
                this.sedCatalogs.put(Band.W1, allWiseEntry.getCatalogName());
                this.sedCatalogs.put(Band.W2, allWiseEntry.getCatalogName());
                this.sedCatalogs.put(Band.W3, allWiseEntry.getCatalogName());
                this.addWiseReferences();
                this.sedPhotometry.put(Band.W1, allWiseEntry.getW1_err() == 0.0 ? 0.0 : allWiseEntry.getW1mag());
                this.sedPhotometry.put(Band.W2, allWiseEntry.getW2_err() == 0.0 ? 0.0 : allWiseEntry.getW2mag());
                this.sedPhotometry.put(Band.W3, allWiseEntry.getW3_err() == 0.0 ? 0.0 : allWiseEntry.getW3mag());
            }
        }
        if (this.catwisePhot.isSelected()) {
            CatWiseCatalogEntry catWiseEntry = new CatWiseCatalogEntry();
            catWiseEntry.setRa(catalogEntry.getRa());
            catWiseEntry.setDec(catalogEntry.getDec());
            catWiseEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(catWiseEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                this.catwisePhot.setSelected(false);
                this.unwisePhot.setSelected(true);
            } else {
                catWiseEntry = (CatWiseCatalogEntry)retrievedEntry;
                seriesLabel.append(catWiseEntry.getCatalogName()).append(": ").append(catWiseEntry.getSourceId()).append(" ");
                this.sedCatalogs.put(Band.W1, catWiseEntry.getCatalogName());
                this.sedCatalogs.put(Band.W2, catWiseEntry.getCatalogName());
                this.addWiseReferences();
                this.sedPhotometry.put(Band.W1, catWiseEntry.getW1mag());
                this.sedPhotometry.put(Band.W2, catWiseEntry.getW2mag());
            }
        }
        if (this.unwisePhot.isSelected()) {
            UnWiseCatalogEntry unWiseEntry = new UnWiseCatalogEntry();
            unWiseEntry.setRa(catalogEntry.getRa());
            unWiseEntry.setDec(catalogEntry.getDec());
            unWiseEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(unWiseEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                this.unwisePhot.setSelected(false);
            } else {
                unWiseEntry = (UnWiseCatalogEntry)retrievedEntry;
                seriesLabel.append(unWiseEntry.getCatalogName()).append(": ").append(unWiseEntry.getSourceId()).append(" ");
                this.sedCatalogs.put(Band.W1, unWiseEntry.getCatalogName());
                this.sedCatalogs.put(Band.W2, unWiseEntry.getCatalogName());
                this.addWiseReferences();
                this.sedPhotometry.put(Band.W1, unWiseEntry.getW1mag());
                this.sedPhotometry.put(Band.W2, unWiseEntry.getW2mag());
            }
        }
        List<Band> sedBands = this.useGaiaPhotometry ? Band.getWdSedBands() : Band.getSedBands();
        sedBands.forEach(band -> {
            Double photometry = this.sedPhotometry.get(band);
            if (photometry != null) {
                SedReferences references = this.sedReferences.get(band);
                this.sedFluxes.put((Band)((Object)band), new SedFluxes(photometry, PhotometricFunctions.convertMagnitudeToFluxDensity(photometry, references.getZeropoint(), references.getWavelenth()), PhotometricFunctions.convertMagnitudeToFluxJansky(photometry, references.getZeropoint()), PhotometricFunctions.convertMagnitudeToFluxLambda(photometry, references.getZeropoint(), references.getWavelenth())));
            }
        });
        XYSeries series = new XYSeries((Comparable)((Object)seriesLabel.toString()));
        this.sedDataPoints.append(seriesLabel.toString()).append(Constants.LINE_SEP);
        sedBands.forEach(band -> {
            Double photometry = this.sedPhotometry.get(band);
            if (photometry != null) {
                SedReferences references = this.sedReferences.get(band);
                SedFluxes fluxes = this.sedFluxes.get(band);
                series.add(references.getWavelenth(), (Number)(photometry == 0.0 ? null : Double.valueOf(fluxes.getFluxLambda())));
                if (photometry != 0.0) {
                    this.sedDataPoints.append("(").append(references.getWavelenth()).append(",").append(fluxes.getFluxLambda()).append(")").append(Constants.LINE_SEP);
                }
            }
        });
        if (collection == null) {
            collection = new XYSeriesCollection();
            collection.addSeries(series);
        } else {
            ArrayList savedSeries = new ArrayList();
            savedSeries.addAll(collection.getSeries());
            collection.removeAllSeries();
            collection.addSeries(series);
            for (int y = 1; y < savedSeries.size(); ++y) {
                collection.addSeries((XYSeries)savedSeries.get(y));
            }
        }
        if (addReferenceSeds) {
            this.addReferenceSeds(this.sedPhotometry, collection);
        }
        this.photSearchRadius.setCursor(Cursor.getDefaultCursor());
        this.createButton.setCursor(Cursor.getDefaultCursor());
        this.removeButton.setCursor(Cursor.getDefaultCursor());
        this.bestMatch.setCursor(Cursor.getDefaultCursor());
        this.overplotTemplates.setCursor(Cursor.getDefaultCursor());
        this.panStarrsPhot.setCursor(Cursor.getDefaultCursor());
        this.noirlabPhot.setCursor(Cursor.getDefaultCursor());
        this.desPhot.setCursor(Cursor.getDefaultCursor());
        this.twoMassPhot.setCursor(Cursor.getDefaultCursor());
        this.ukidssPhot.setCursor(Cursor.getDefaultCursor());
        this.uhsPhot.setCursor(Cursor.getDefaultCursor());
        this.vhsPhot.setCursor(Cursor.getDefaultCursor());
        this.allwisePhot.setCursor(Cursor.getDefaultCursor());
        this.catwisePhot.setCursor(Cursor.getDefaultCursor());
        this.unwisePhot.setCursor(Cursor.getDefaultCursor());
        return collection;
    }

    private void addGaiaReferences() {
        this.sedReferences.put(Band.BP, new SedReferences(Sed.GAIA_BP.zeropoint, Sed.GAIA_BP.wavelenth));
        this.sedReferences.put(Band.G, new SedReferences(Sed.GAIA_G.zeropoint, Sed.GAIA_G.wavelenth));
        this.sedReferences.put(Band.RP, new SedReferences(Sed.GAIA_RP.zeropoint, Sed.GAIA_RP.wavelenth));
    }

    private void addPanStarrsReferences() {
        this.sedReferences.put(Band.g, new SedReferences(Sed.PS1_G.zeropoint, Sed.PS1_G.wavelenth));
        this.sedReferences.put(Band.r, new SedReferences(Sed.PS1_R.zeropoint, Sed.PS1_R.wavelenth));
        this.sedReferences.put(Band.i, new SedReferences(Sed.PS1_I.zeropoint, Sed.PS1_I.wavelenth));
        this.sedReferences.put(Band.z, new SedReferences(Sed.PS1_Z.zeropoint, Sed.PS1_Z.wavelenth));
        this.sedReferences.put(Band.y, new SedReferences(Sed.PS1_Y.zeropoint, Sed.PS1_Y.wavelenth));
    }

    private void addDecamReferences() {
        this.sedReferences.put(Band.g, new SedReferences(Sed.DECAM_G.zeropoint, Sed.DECAM_G.wavelenth));
        this.sedReferences.put(Band.r, new SedReferences(Sed.DECAM_R.zeropoint, Sed.DECAM_R.wavelenth));
        this.sedReferences.put(Band.i, new SedReferences(Sed.DECAM_I.zeropoint, Sed.DECAM_I.wavelenth));
        this.sedReferences.put(Band.z, new SedReferences(Sed.DECAM_Z.zeropoint, Sed.DECAM_Z.wavelenth));
        this.sedReferences.put(Band.y, new SedReferences(Sed.DECAM_Y.zeropoint, Sed.DECAM_Y.wavelenth));
    }

    private void add2MassReferences() {
        this.sedReferences.put(Band.J, new SedReferences(Sed.MASS_J.zeropoint, Sed.MASS_J.wavelenth));
        this.sedReferences.put(Band.H, new SedReferences(Sed.MASS_H.zeropoint, Sed.MASS_H.wavelenth));
        this.sedReferences.put(Band.K, new SedReferences(Sed.MASS_K.zeropoint, Sed.MASS_K.wavelenth));
    }

    private void addUkidssReferences() {
        this.sedReferences.put(Band.J, new SedReferences(Sed.UKIDSS_J.zeropoint, Sed.UKIDSS_J.wavelenth));
        this.sedReferences.put(Band.H, new SedReferences(Sed.UKIDSS_H.zeropoint, Sed.UKIDSS_H.wavelenth));
        this.sedReferences.put(Band.K, new SedReferences(Sed.UKIDSS_K.zeropoint, Sed.UKIDSS_K.wavelenth));
    }

    private void addVhsReferences() {
        this.sedReferences.put(Band.J, new SedReferences(Sed.VHS_J.zeropoint, Sed.VHS_J.wavelenth));
        this.sedReferences.put(Band.H, new SedReferences(Sed.VHS_H.zeropoint, Sed.VHS_H.wavelenth));
        this.sedReferences.put(Band.K, new SedReferences(Sed.VHS_K.zeropoint, Sed.VHS_K.wavelenth));
    }

    private void addWiseReferences() {
        this.sedReferences.put(Band.W1, new SedReferences(Sed.WISE_W1.zeropoint, Sed.WISE_W1.wavelenth));
        this.sedReferences.put(Band.W2, new SedReferences(Sed.WISE_W2.zeropoint, Sed.WISE_W2.wavelenth));
        this.sedReferences.put(Band.W3, new SedReferences(Sed.WISE_W3.zeropoint, Sed.WISE_W3.wavelenth));
    }

    private void addReferenceSeds(Map<Band, Double> sedPhotometry, XYSeriesCollection collection) {
        ArrayList<SedBestMatch> matches = new ArrayList<SedBestMatch>();
        for (WhiteDwarfEntry entry : this.whiteDwarfEntries) {
            Map<Band, Double> bands = entry.getBands();
            String spectralType = entry.getInfo();
            ArrayList<Double> diffMags = new ArrayList<Double>();
            List<Band> sedBands = this.useGaiaPhotometry ? Band.getWdSedBands() : Band.getSedBands();
            sedBands.forEach(band -> {
                if (sedPhotometry.get(band) != null && (Double)sedPhotometry.get(band) != 0.0 && (Double)bands.get(band) != 0.0) {
                    double diffMag = (Double)sedPhotometry.get(band) - (Double)bands.get(band);
                    diffMags.add(diffMag);
                }
            });
            double medianDiffMag = StatisticFunctions.determineMedian(diffMags);
            int totalMags = diffMags.size();
            if (totalMags < 4) continue;
            int selectedMags = 0;
            ArrayList<Double> correctedDiffMags = new ArrayList<Double>();
            for (Double diffMag : diffMags) {
                double correctedDiffMag = Math.abs(diffMag - medianDiffMag);
                correctedDiffMags.add(correctedDiffMag);
                if (!(correctedDiffMag < 0.3)) continue;
                ++selectedMags;
            }
            if (selectedMags < totalMags - 2) continue;
            double meanDiffMag = StatisticFunctions.calculateMean(correctedDiffMags);
            matches.add(new SedBestMatch(spectralType, medianDiffMag, meanDiffMag));
        }
        if (!matches.isEmpty()) {
            matches.sort(Comparator.comparing(SedBestMatch::getMeanDiffMag));
            int j = this.bestMatch.isSelected() ? 1 : 3;
            for (int i = 0; i < j && i < matches.size(); ++i) {
                SedBestMatch match = (SedBestMatch)matches.get(i);
                this.createReferenceSed(match.getSpt(), collection, match.getMedianDiffMag());
            }
        }
    }

    private void createReferenceSed(String spectralType, XYSeriesCollection collection, double medianDiffMag) {
        Map<Band, Double> magnitudes = this.provideReferenceMagnitudes(spectralType);
        if (magnitudes == null) {
            return;
        }
        if (!this.overplotTemplates.isSelected()) {
            medianDiffMag = 0.0;
        }
        XYSeries series = new XYSeries((Comparable)((Object)spectralType));
        if (this.useGaiaPhotometry) {
            series.add(Sed.GAIA_BP.wavelenth, (Number)(magnitudes.get((Object)Band.BP) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.BP) + medianDiffMag, Sed.GAIA_BP.zeropoint, Sed.GAIA_BP.wavelenth))));
            series.add(Sed.GAIA_G.wavelenth, (Number)(magnitudes.get((Object)Band.G) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.G) + medianDiffMag, Sed.GAIA_G.zeropoint, Sed.GAIA_G.wavelenth))));
            series.add(Sed.GAIA_RP.wavelenth, (Number)(magnitudes.get((Object)Band.RP) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.RP) + medianDiffMag, Sed.GAIA_RP.zeropoint, Sed.GAIA_RP.wavelenth))));
        } else {
            series.add(Sed.PS1_G.wavelenth, (Number)(magnitudes.get((Object)Band.g) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.g) + medianDiffMag, Sed.PS1_G.zeropoint, Sed.PS1_G.wavelenth))));
            series.add(Sed.PS1_R.wavelenth, (Number)(magnitudes.get((Object)Band.r) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.r) + medianDiffMag, Sed.PS1_R.zeropoint, Sed.PS1_R.wavelenth))));
            series.add(Sed.PS1_I.wavelenth, (Number)(magnitudes.get((Object)Band.i) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.i) + medianDiffMag, Sed.PS1_I.zeropoint, Sed.PS1_I.wavelenth))));
            series.add(Sed.PS1_Z.wavelenth, (Number)(magnitudes.get((Object)Band.z) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.z) + medianDiffMag, Sed.PS1_Z.zeropoint, Sed.PS1_Z.wavelenth))));
            series.add(Sed.PS1_Y.wavelenth, (Number)(magnitudes.get((Object)Band.y) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.y) + medianDiffMag, Sed.PS1_Y.zeropoint, Sed.PS1_Y.wavelenth))));
        }
        series.add(Sed.MASS_J.wavelenth, (Number)(magnitudes.get((Object)Band.J) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.J) + medianDiffMag, Sed.MASS_J.zeropoint, Sed.MASS_J.wavelenth))));
        series.add(Sed.MASS_H.wavelenth, (Number)(magnitudes.get((Object)Band.H) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.H) + medianDiffMag, Sed.MASS_H.zeropoint, Sed.MASS_H.wavelenth))));
        series.add(Sed.MASS_K.wavelenth, (Number)(magnitudes.get((Object)Band.K) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.K) + medianDiffMag, Sed.MASS_K.zeropoint, Sed.MASS_K.wavelenth))));
        series.add(Sed.WISE_W1.wavelenth, (Number)(magnitudes.get((Object)Band.W1) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.W1) + medianDiffMag, Sed.WISE_W1.zeropoint, Sed.WISE_W1.wavelenth))));
        series.add(Sed.WISE_W2.wavelenth, (Number)(magnitudes.get((Object)Band.W2) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.W2) + medianDiffMag, Sed.WISE_W2.zeropoint, Sed.WISE_W2.wavelenth))));
        series.add(Sed.WISE_W3.wavelenth, (Number)(magnitudes.get((Object)Band.W3) == 0.0 ? null : Double.valueOf(PhotometricFunctions.convertMagnitudeToFluxLambda(magnitudes.get((Object)Band.W3) + medianDiffMag, Sed.WISE_W3.zeropoint, Sed.WISE_W3.wavelenth))));
        this.sedDataPoints.append(Constants.LINE_SEP).append(spectralType).append(":").append(Constants.LINE_SEP);
        for (Object item : series.getItems()) {
            XYDataItem dataItem = (XYDataItem)item;
            if (Double.isNaN(dataItem.getYValue())) continue;
            this.sedDataPoints.append("(").append(dataItem.getXValue()).append(",").append(dataItem.getYValue()).append(")").append(Constants.LINE_SEP);
        }
        try {
            collection.addSeries(series);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private JFreeChart createChart(XYSeriesCollection collection) {
        JFreeChart chart = ChartFactory.createXYLineChart("Spectral Energy Distribution", "", "", collection);
        chart.setPadding(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        XYPlot plot = chart.getXYPlot();
        LogAxis xAxis = new LogAxis("Wavelength (\u03bcm)");
        xAxis.setAutoRangeMinimumSize(0.1);
        xAxis.setTickUnit(new NumberTickUnit(0.2));
        plot.setDomainAxis(xAxis);
        LogAxis yAxis = new LogAxis("Flux (W/m\u00b2/\u03bcm)");
        yAxis.setAutoRangeMinimumSize(1.0E-18);
        yAxis.setTickUnit(new NumberTickUnit(0.5));
        plot.setRangeAxis(yAxis);
        Font tickLabelFont = new Font(FONT_NAME, 0, 18);
        xAxis.setTickLabelFont(tickLabelFont);
        yAxis.setTickLabelFont(tickLabelFont);
        Font labelFont = new Font(FONT_NAME, 0, 18);
        xAxis.setLabelFont(labelFont);
        yAxis.setLabelFont(labelFont);
        double size = 6.0;
        double delta = size / 2.0;
        Ellipse2D.Double shape = new Ellipse2D.Double(-delta, -delta, size, size);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesShape(0, shape);
        renderer.setSeriesPaint(0, Color.BLACK);
        renderer.setSeriesStroke(0, new BasicStroke(2.0f));
        renderer.setSeriesToolTipGenerator(0, this.addToolTips());
        plot.setRenderer(renderer);
        this.setSeriesShape(chart);
        plot.setBackgroundPaint(Color.WHITE);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint(Color.LIGHT_GRAY);
        plot.setRangeGridlineStroke(new BasicStroke());
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint(Color.LIGHT_GRAY);
        plot.setDomainGridlineStroke(new BasicStroke());
        Font legendFont = new Font(FONT_NAME, 0, 18);
        chart.getLegend().setFrame(BlockBorder.NONE);
        chart.getLegend().setItemFont(legendFont);
        Font titleFont = new Font(FONT_NAME, 0, 22);
        chart.getTitle().setFont(titleFont);
        return chart;
    }

    private void setSeriesShape(JFreeChart chart) {
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        double size = 8.0;
        double delta = size / 2.0;
        Ellipse2D.Double shape = new Ellipse2D.Double(-delta, -delta, size, size);
        for (int i = 1; i < plot.getSeriesCount(); ++i) {
            renderer.setSeriesShape(i, shape);
        }
    }

    private CustomXYToolTipGenerator addToolTips() {
        ArrayList toolTips = new ArrayList();
        List<Band> sedBands = this.useGaiaPhotometry ? Band.getWdSedBands() : Band.getSedBands();
        sedBands.forEach(band -> {
            SedFluxes fluxes = this.sedFluxes.get(band);
            if (fluxes != null) {
                toolTips.add(ToolboxHelper.html(this.sedCatalogs.get(band) + " " + band.val + "=" + NumericFunctions.roundTo3DecNZ(fluxes.getMagnitude()) + " mag<br>\u03bb=" + this.sedReferences.get(band).getWavelenth() + " \u03bcm<br>F(\u03bd)=" + NumericFunctions.roundTo3DecSN(fluxes.getFluxJansky()) + " Jy<br>\u03bbF(\u03bb)=" + NumericFunctions.roundTo3DecSN(fluxes.getFluxDensity()) + " W/m\u00b2<br>F(\u03bb)=" + NumericFunctions.roundTo3DecSN(fluxes.getFluxLambda()) + " W/m\u00b2/\u03bcm"));
            }
        });
        CustomXYToolTipGenerator generator = new CustomXYToolTipGenerator();
        generator.addToolTipSeries(toolTips);
        return generator;
    }

    private Map<Band, Double> provideReferenceMagnitudes(String spt) {
        Map<Band, Double> absoluteMagnitudes = null;
        for (WhiteDwarfEntry entry : this.whiteDwarfEntries) {
            if (!entry.getInfo().equals(spt)) continue;
            absoluteMagnitudes = entry.getBands();
        }
        return absoluteMagnitudes;
    }

    public void createWhiteDwarfSedEntries() {
        InputStream input = this.getClass().getResourceAsStream("/WhiteDwarfLookupTable.csv");
        try (Scanner fileScanner = new Scanner(input);){
            String headerLine = fileScanner.nextLine();
            String[] headers = CSVParser.parseLine(headerLine);
            HashMap<String, Integer> columns = new HashMap<String, Integer>();
            for (int i = 0; i < headers.length; ++i) {
                columns.put(headers[i], i);
            }
            while (fileScanner.hasNextLine()) {
                String bodyLine = fileScanner.nextLine();
                String[] values = CSVParser.parseLine(bodyLine);
                String type = values[(Integer)columns.get("Type")];
                int teff = NumericFunctions.toInteger(values[(Integer)columns.get("Teff")]);
                double logG = NumericFunctions.toDouble(values[(Integer)columns.get("log g")]);
                double mass = NumericFunctions.toDouble(values[(Integer)columns.get("M/Mo")]);
                String age = values[(Integer)columns.get("Age")];
                double Gmag = NumericFunctions.toDouble(values[(Integer)columns.get("G3")]);
                double BPmag = NumericFunctions.toDouble(values[(Integer)columns.get("G3_BP")]);
                double RPmag = NumericFunctions.toDouble(values[(Integer)columns.get("G3_RP")]);
                double g_mag = NumericFunctions.toDouble(values[(Integer)columns.get("PS1_g")]);
                double r_mag = NumericFunctions.toDouble(values[(Integer)columns.get("PS1_r")]);
                double i_mag = NumericFunctions.toDouble(values[(Integer)columns.get("PS1_i")]);
                double z_mag = NumericFunctions.toDouble(values[(Integer)columns.get("PS1_z")]);
                double y_mag = NumericFunctions.toDouble(values[(Integer)columns.get("PS1_y")]);
                double Jmag = NumericFunctions.toDouble(values[(Integer)columns.get("2MASS_J")]);
                double Hmag = NumericFunctions.toDouble(values[(Integer)columns.get("2MASS_H")]);
                double Kmag = NumericFunctions.toDouble(values[(Integer)columns.get("2MASS_Ks")]);
                double W1mag = NumericFunctions.toDouble(values[(Integer)columns.get("W1")]);
                double W2mag = NumericFunctions.toDouble(values[(Integer)columns.get("W2")]);
                double W3mag = NumericFunctions.toDouble(values[(Integer)columns.get("W3")]);
                double W4mag = NumericFunctions.toDouble(values[(Integer)columns.get("W4")]);
                HashMap<Band, Double> bands = new HashMap<Band, Double>();
                bands.put(Band.G, Gmag);
                bands.put(Band.BP, BPmag);
                bands.put(Band.RP, RPmag);
                bands.put(Band.g, g_mag);
                bands.put(Band.r, r_mag);
                bands.put(Band.i, i_mag);
                bands.put(Band.z, z_mag);
                bands.put(Band.y, y_mag);
                bands.put(Band.J, Jmag);
                bands.put(Band.H, Hmag);
                bands.put(Band.K, Kmag);
                bands.put(Band.W1, W1mag);
                bands.put(Band.W2, W2mag);
                bands.put(Band.W3, W3mag);
                bands.put(Band.W4, W4mag);
                this.whiteDwarfEntries.add(new WhiteDwarfEntry(type, teff, logG, mass, age, bands));
            }
        }
    }
}

