/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.panel;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.CatWiseCatalogEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.TwoMassCatalogEntry;
import astro.tool.box.catalog.UkidssCatalogEntry;
import astro.tool.box.catalog.UnWiseCatalogEntry;
import astro.tool.box.catalog.VhsCatalogEntry;
import astro.tool.box.container.NumberPair;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.util.CSVParser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class WiseCcdPanel
extends JPanel {
    private static final String FONT_NAME = "Tahoma";
    private final CatalogQueryService catalogQueryService;
    private final JFrame baseFrame;
    private final JTextField photSearchRadius;
    private JFreeChart chart;
    private static final List<Color> COLORS = new ArrayList<Color>();
    private static final List<String> LABELS;
    private StringBuilder seriesLabel;

    public WiseCcdPanel(CatalogQueryService catalogQueryService, CatalogEntry catalogEntry, JFrame baseFrame) {
        this.catalogQueryService = catalogQueryService;
        this.baseFrame = baseFrame;
        this.setLayout(new BoxLayout(this, 1));
        JPanel commandPanel = new JPanel(new FlowLayout(0));
        commandPanel.add(new JLabel("Photometry search radius"));
        this.photSearchRadius = new JTextField("5", 3);
        commandPanel.add(this.photSearchRadius);
        this.photSearchRadius.addActionListener(e -> {
            this.photSearchRadius.setCursor(Cursor.getPredefinedCursor(3));
            this.remove(0);
            this.createChartPanel(this.getPhotometry(catalogEntry));
            this.photSearchRadius.setCursor(Cursor.getDefaultCursor());
        });
        JButton createButton = new JButton("Create PDF");
        commandPanel.add(createButton);
        createButton.addActionListener(e -> {
            try {
                File tmpFile = File.createTempFile("Target_" + NumericFunctions.roundTo2DecNZ(catalogEntry.getRa()) + NumericFunctions.addPlusSign(NumericFunctions.roundDouble(catalogEntry.getDec(), "#.##")) + "_", ".pdf");
                ToolboxHelper.createPDF(this.chart, tmpFile, 800, 700);
                Desktop.getDesktop().open(tmpFile);
            }
            catch (Exception ex) {
                ToolboxHelper.writeErrorLog(ex);
            }
        });
        String infoText = "Right-clicking on the chart, opens a context menu with additional functions like printing and saving.";
        JLabel infoToolTip = new JLabel(ToolboxHelper.getInfoIcon());
        infoToolTip.setToolTipText(infoText);
        commandPanel.add(infoToolTip);
        JLabel infoLabel = new JLabel("Tooltip");
        infoLabel.setToolTipText(infoText);
        commandPanel.add(infoLabel);
        this.createChartPanel(this.getPhotometry(catalogEntry));
        this.add((Component)commandPanel, 1);
    }

    private NumberPair getPhotometry(CatalogEntry catalogEntry) {
        CatalogEntry retrievedEntry;
        AllWiseCatalogEntry allWiseEntry;
        double searchRadius = NumericFunctions.toDouble(this.photSearchRadius.getText());
        double W1mag = 0.0;
        double W2mag = 0.0;
        double Jmag = 0.0;
        if (catalogEntry instanceof AllWiseCatalogEntry) {
            AllWiseCatalogEntry entry;
            allWiseEntry = entry = (AllWiseCatalogEntry)catalogEntry;
        } else {
            allWiseEntry = new AllWiseCatalogEntry();
            allWiseEntry.setRa(catalogEntry.getRa());
            allWiseEntry.setDec(catalogEntry.getDec());
            allWiseEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(allWiseEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry != null) {
                allWiseEntry = (AllWiseCatalogEntry)retrievedEntry;
            }
        }
        this.seriesLabel = new StringBuilder();
        if (allWiseEntry.getSourceId() != null) {
            this.seriesLabel.append(allWiseEntry.getCatalogName()).append(": ").append(allWiseEntry.getSourceId()).append(" ");
            W1mag = allWiseEntry.getW1mag();
            W2mag = allWiseEntry.getW2mag();
            Jmag = allWiseEntry.getJmag();
        }
        if (allWiseEntry.getSourceId() == null) {
            CatWiseCatalogEntry catWiseEntry = new CatWiseCatalogEntry();
            catWiseEntry.setRa(catalogEntry.getRa());
            catWiseEntry.setDec(catalogEntry.getDec());
            catWiseEntry.setSearchRadius(searchRadius);
            retrievedEntry = ToolboxHelper.retrieveCatalogEntry(catWiseEntry, this.catalogQueryService, this.baseFrame);
            if (retrievedEntry == null) {
                UnWiseCatalogEntry unWiseEntry = new UnWiseCatalogEntry();
                unWiseEntry.setRa(catalogEntry.getRa());
                unWiseEntry.setDec(catalogEntry.getDec());
                unWiseEntry.setSearchRadius(searchRadius);
                retrievedEntry = ToolboxHelper.retrieveCatalogEntry(unWiseEntry, this.catalogQueryService, this.baseFrame);
                if (retrievedEntry != null) {
                    unWiseEntry = (UnWiseCatalogEntry)retrievedEntry;
                    this.seriesLabel.append(unWiseEntry.getCatalogName()).append(": ").append(unWiseEntry.getSourceId()).append(" ");
                    W1mag = unWiseEntry.getW1mag();
                    W2mag = unWiseEntry.getW2mag();
                }
            } else {
                catWiseEntry = (CatWiseCatalogEntry)retrievedEntry;
                this.seriesLabel.append(catWiseEntry.getCatalogName()).append(": ").append(catWiseEntry.getSourceId()).append(" ");
                W1mag = catWiseEntry.getW1mag();
                W2mag = catWiseEntry.getW2mag();
            }
        }
        if (Jmag == 0.0) {
            VhsCatalogEntry vhsEntry;
            CatalogEntry retrievedEntry2 = null;
            if (catalogEntry.getDec() < 5.0) {
                vhsEntry = new VhsCatalogEntry();
                vhsEntry.setRa(catalogEntry.getRa());
                vhsEntry.setDec(catalogEntry.getDec());
                vhsEntry.setSearchRadius(searchRadius);
                retrievedEntry2 = ToolboxHelper.retrieveCatalogEntry(vhsEntry, this.catalogQueryService, this.baseFrame);
            }
            if (retrievedEntry2 != null) {
                vhsEntry = (VhsCatalogEntry)retrievedEntry2;
                this.seriesLabel.append(vhsEntry.getCatalogName()).append(": ").append(vhsEntry.getSourceId()).append(" ");
                Jmag = vhsEntry.getJmag();
            } else {
                UkidssCatalogEntry ukidssEntry;
                if (catalogEntry.getDec() > -5.0) {
                    ukidssEntry = new UkidssCatalogEntry();
                    ukidssEntry.setRa(catalogEntry.getRa());
                    ukidssEntry.setDec(catalogEntry.getDec());
                    ukidssEntry.setSearchRadius(searchRadius);
                    retrievedEntry2 = ToolboxHelper.retrieveCatalogEntry(ukidssEntry, this.catalogQueryService, this.baseFrame);
                }
                if (retrievedEntry2 != null) {
                    ukidssEntry = (UkidssCatalogEntry)retrievedEntry2;
                    this.seriesLabel.append(ukidssEntry.getCatalogName()).append(": ").append(ukidssEntry.getSourceId()).append(" ");
                    Jmag = ukidssEntry.getJmag();
                } else {
                    TwoMassCatalogEntry twoMassEntry = new TwoMassCatalogEntry();
                    twoMassEntry.setRa(catalogEntry.getRa());
                    twoMassEntry.setDec(catalogEntry.getDec());
                    twoMassEntry.setSearchRadius(searchRadius * 2.0);
                    retrievedEntry2 = ToolboxHelper.retrieveCatalogEntry(twoMassEntry, this.catalogQueryService, this.baseFrame);
                    if (retrievedEntry2 != null) {
                        twoMassEntry = (TwoMassCatalogEntry)retrievedEntry2;
                        this.seriesLabel.append(twoMassEntry.getCatalogName()).append(": ").append(twoMassEntry.getSourceId()).append(" ");
                        Jmag = twoMassEntry.getJmag();
                    }
                }
            }
        }
        double W1_W2 = W1mag == 0.0 || W2mag == 0.0 ? 0.0 : W1mag - W2mag;
        double J_W2 = Jmag == 0.0 || W2mag == 0.0 ? 0.0 : Jmag - W2mag;
        return new NumberPair(W1_W2, J_W2);
    }

    private void createChartPanel(NumberPair pair) {
        XYSeriesCollection targetCollection = this.createTargetCollection(pair);
        this.createChart(targetCollection);
        ChartPanel chartPanel = new ChartPanel(this.chart){

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        chartPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        chartPanel.setBackground(Color.WHITE);
        this.add((Component)chartPanel, 0);
        this.revalidate();
        this.repaint();
    }

    private XYSeriesCollection createTargetCollection(NumberPair pair) {
        XYSeriesCollection collection = new XYSeriesCollection();
        double xTarget = pair.getX();
        double yTarget = pair.getY();
        if (xTarget != 0.0 && yTarget != 0.0) {
            XYSeries seriesTarget = new XYSeries((Comparable)((Object)this.seriesLabel.toString()));
            seriesTarget.add(xTarget, yTarget);
            collection.addSeries(seriesTarget);
        }
        return collection;
    }

    private XYSeriesCollection createSpectralTypeCollection(String fileName) {
        XYSeriesCollection collection = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)fileName), false);
        this.loadSpectralType(fileName).forEach(pair -> {
            double x = pair.getX();
            double y = pair.getY();
            if (x != 0.0 && y != 0.0) {
                series.add(x, y);
            }
        });
        collection.addSeries(series);
        return collection;
    }

    private void createChart(XYSeriesCollection targetCollection) {
        this.chart = ChartFactory.createXYLineChart("WISE Color-Color Diagram", "", "", null);
        this.chart.setPadding(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        XYPlot plot = this.chart.getXYPlot();
        plot.setDataset(0, targetCollection);
        int j = 1;
        for (int i = 0; i < 6; ++i) {
            plot.setDataset(j++, this.createSpectralTypeCollection(LABELS.get(i)));
        }
        NumberAxis xAxis = new NumberAxis("W1-W2");
        plot.setDomainAxis(xAxis);
        NumberAxis yAxis = new NumberAxis("J-W2");
        plot.setRangeAxis(yAxis);
        Font tickLabelFont = new Font(FONT_NAME, 0, 20);
        xAxis.setTickLabelFont(tickLabelFont);
        yAxis.setTickLabelFont(tickLabelFont);
        Font labelFont = new Font(FONT_NAME, 0, 20);
        xAxis.setLabelFont(labelFont);
        yAxis.setLabelFont(labelFont);
        double size = 10.0;
        double delta = size / 2.0;
        Ellipse2D.Double targetShape = new Ellipse2D.Double(-delta, -delta, size, size);
        XYLineAndShapeRenderer targetRenderer = new XYLineAndShapeRenderer();
        targetRenderer.setSeriesPaint(0, Color.RED);
        targetRenderer.setSeriesLinesVisible(0, false);
        targetRenderer.setSeriesVisibleInLegend(0, true);
        targetRenderer.setSeriesShape(0, targetShape);
        plot.setRenderer(0, targetRenderer);
        int j2 = 1;
        for (Color color : COLORS) {
            plot.setRenderer(j2++, this.getSpectralTypeRenderer(color));
        }
        LegendItemCollection itemCollection = new LegendItemCollection();
        int i = 0;
        for (Color color : COLORS) {
            LegendItem item = new LegendItem(LABELS.get(i++), color);
            item.setShape(targetShape);
            itemCollection.add(item);
        }
        if (targetCollection.getSeriesCount() > 0) {
            LegendItem item = new LegendItem(this.seriesLabel.toString(), Color.RED);
            item.setShape(targetShape);
            itemCollection.add(item);
        }
        plot.setFixedLegendItems(itemCollection);
        plot.setBackgroundPaint(Color.WHITE);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint(Color.LIGHT_GRAY);
        plot.setRangeGridlineStroke(new BasicStroke());
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint(Color.LIGHT_GRAY);
        plot.setDomainGridlineStroke(new BasicStroke());
        Font legendFont = new Font(FONT_NAME, 0, 20);
        this.chart.getLegend().setFrame(BlockBorder.NONE);
        this.chart.getLegend().setItemFont(legendFont);
        Font titleFont = new Font(FONT_NAME, 0, 24);
        this.chart.getTitle().setFont(titleFont);
    }

    private XYLineAndShapeRenderer getSpectralTypeRenderer(Color color) {
        double size = 6.0;
        double delta = size / 2.0;
        Ellipse2D.Double seriesShape = new Ellipse2D.Double(-delta, -delta, size, size);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, color);
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesVisibleInLegend(0, false);
        renderer.setSeriesShape(0, seriesShape);
        return renderer;
    }

    private List<NumberPair> loadSpectralType(String fileName) {
        ArrayList<NumberPair> spectralType = new ArrayList<NumberPair>();
        InputStream input = this.getClass().getResourceAsStream("/spectralTypes/" + fileName + ".csv");
        try (Scanner fileScanner = new Scanner(input);){
            String headerLine = fileScanner.nextLine();
            String[] headers = CSVParser.parseLine(headerLine);
            HashMap<String, Integer> columns = new HashMap<String, Integer>();
            for (int i = 0; i < headers.length; ++i) {
                columns.put(headers[i], i);
            }
            while (fileScanner.hasNextLine()) {
                String bodyLine = fileScanner.nextLine();
                String[] values = CSVParser.parseLine(bodyLine);
                double W1_W2 = NumericFunctions.toDouble(values[(Integer)columns.get("W1-W2")]);
                double J_W2 = NumericFunctions.toDouble(values[(Integer)columns.get("J-W2")]);
                spectralType.add(new NumberPair(W1_W2, J_W2));
            }
        }
        return spectralType;
    }

    static {
        COLORS.add(new Color(68, 1, 84));
        COLORS.add(new Color(65, 68, 135));
        COLORS.add(new Color(42, 120, 142));
        COLORS.add(new Color(34, 168, 132));
        COLORS.add(new Color(122, 209, 81));
        COLORS.add(new Color(253, 231, 37));
        LABELS = new ArrayList<String>();
        LABELS.add("Late M");
        LABELS.add("Early L");
        LABELS.add("Late L");
        LABELS.add("Early T");
        LABELS.add("Late T");
        LABELS.add("Early Y");
    }
}

