/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.panel;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.StatType;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.StatisticFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.panel.JPlot;
import astro.tool.box.util.ServiceHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class WiseLcPanel
extends JPanel {
    private final JTextField searchRadius;
    private final JTextField numberOfStds;
    private final JCheckBox w1Phot;
    private final JCheckBox w2Phot;
    private final JCheckBox curves;
    private JFreeChart chart;
    private List<List<Double>> data = new ArrayList<List<Double>>();

    public WiseLcPanel(CatalogEntry catalogEntry, JFrame baseFrame) {
        this.setLayout(new BoxLayout(this, 1));
        JPanel commandPanel = new JPanel(new FlowLayout(0));
        commandPanel.add(new JLabel("Photometry search radius"));
        this.searchRadius = new JTextField("5", 3);
        commandPanel.add(this.searchRadius);
        this.searchRadius.addActionListener(e -> {
            this.searchRadius.setCursor(Cursor.getPredefinedCursor(3));
            this.remove(0);
            try {
                this.collectPhotometry(catalogEntry);
                this.createPlot();
            }
            catch (IOException ex) {
                ToolboxHelper.showExceptionDialog(baseFrame, ex);
            }
            finally {
                this.searchRadius.setCursor(Cursor.getDefaultCursor());
            }
        });
        commandPanel.add(new JLabel("Number of std deviations"));
        this.numberOfStds = new JTextField("3", 2);
        commandPanel.add(this.numberOfStds);
        this.numberOfStds.addActionListener(e -> {
            this.remove(0);
            this.createPlot();
        });
        this.w1Phot = new JCheckBox("W1", true);
        commandPanel.add(this.w1Phot);
        this.w1Phot.addActionListener(e -> {
            this.remove(0);
            this.createPlot();
        });
        this.w2Phot = new JCheckBox("W2", true);
        commandPanel.add(this.w2Phot);
        this.w2Phot.addActionListener(e -> {
            this.remove(0);
            this.createPlot();
        });
        this.curves = new JCheckBox("Curves", true);
        commandPanel.add(this.curves);
        this.curves.addActionListener(e -> {
            this.remove(0);
            this.createPlot();
        });
        JButton createButton = new JButton("Create PDF");
        commandPanel.add(createButton);
        createButton.addActionListener(e -> {
            try {
                File tmpFile = File.createTempFile("Target_" + NumericFunctions.roundTo2DecNZ(catalogEntry.getRa()) + NumericFunctions.addPlusSign(NumericFunctions.roundDouble(catalogEntry.getDec(), "#.##")) + "_", ".pdf");
                ToolboxHelper.createPDF(this.chart, tmpFile, 800, 700);
                Desktop.getDesktop().open(tmpFile);
            }
            catch (Exception ex) {
                ToolboxHelper.writeErrorLog(ex);
            }
        });
        String infoText = "Right-clicking on the chart, opens a context menu with additional functions like printing and saving.";
        JLabel infoToolTip = new JLabel(ToolboxHelper.getInfoIcon());
        infoToolTip.setToolTipText(infoText);
        commandPanel.add(infoToolTip);
        JLabel infoLabel = new JLabel("Tooltip");
        infoLabel.setToolTipText(infoText);
        commandPanel.add(infoLabel);
        try {
            this.collectPhotometry(catalogEntry);
            this.createPlot();
        }
        catch (IOException ex) {
            ToolboxHelper.showExceptionDialog(baseFrame, ex);
        }
        this.add((Component)commandPanel, 1);
    }

    private void collectPhotometry(CatalogEntry catalogEntry) throws IOException {
        ArrayList<Double> row;
        double mjd;
        String w2;
        String w1;
        int i;
        int col3;
        int col2;
        int col1;
        String[] columnNames;
        double radius = NumericFunctions.toDouble(this.searchRadius.getText());
        double ra = catalogEntry.getRa();
        double dec = catalogEntry.getDec();
        String queryUrl = ServiceHelper.createIrsaUrl(ra, dec, radius / 3600.0, "allwise_p3as_mep");
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(queryUrl), "AllWISE");
        this.data = new ArrayList<List<Double>>();
        try (Scanner scanner = new Scanner(response);){
            columnNames = scanner.nextLine().split(",");
            col1 = 0;
            col2 = 0;
            col3 = 0;
            for (i = 0; i < columnNames.length; ++i) {
                if (columnNames[i].equals("w1mpro_ep")) {
                    col1 = i;
                }
                if (columnNames[i].equals("w2mpro_ep")) {
                    col2 = i;
                }
                if (!columnNames[i].equals("mjd")) continue;
                col3 = i;
            }
            while (scanner.hasNextLine()) {
                String[] columnValues = scanner.nextLine().split(",");
                w1 = columnValues[col1];
                w2 = columnValues[col2];
                if (w1.isEmpty() || w2.isEmpty()) continue;
                mjd = Double.parseDouble(columnValues[col3]);
                row = new ArrayList<Double>();
                row.add(Double.valueOf(w1));
                row.add(Double.valueOf(w2));
                row.add(this.getObsTime(mjd));
                row.add(Double.valueOf(Math.round(this.getObsTime(mjd) / 0.5)));
                this.data.add(row);
            }
        }
        queryUrl = ServiceHelper.createIrsaUrl(ra, dec, radius / 3600.0, "neowiser_p1bs_psd");
        response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(queryUrl), "NeoWISE");
        scanner = new Scanner(response);
        try {
            columnNames = scanner.nextLine().split(",");
            col1 = 0;
            col2 = 0;
            col3 = 0;
            for (i = 0; i < columnNames.length; ++i) {
                if (columnNames[i].equals("w1mpro")) {
                    col1 = i;
                }
                if (columnNames[i].equals("w2mpro")) {
                    col2 = i;
                }
                if (!columnNames[i].equals("mjd")) continue;
                col3 = i;
            }
            while (scanner.hasNextLine()) {
                String[] columnValues = scanner.nextLine().split(",");
                w1 = columnValues[col1];
                w2 = columnValues[col2];
                if (w1.isEmpty() || w2.isEmpty()) continue;
                mjd = Double.parseDouble(columnValues[col3]);
                row = new ArrayList();
                row.add(Double.valueOf(w1));
                row.add(Double.valueOf(w2));
                row.add(this.getObsTime(mjd));
                row.add(Double.valueOf(Math.round(this.getObsTime(mjd) / 0.5)));
                this.data.add(row);
            }
        }
        finally {
            scanner.close();
        }
    }

    private void createPlot() {
        double stds = NumericFunctions.toDouble(this.numberOfStds.getText());
        List<List<Double>> list = StatisticFunctions.removeOutliers(this.data, 0, stds, StatType.MEAN);
        list = StatisticFunctions.removeOutliers(list, 1, stds, StatType.MEAN);
        List<Double> w1 = list.stream().map(v -> (Double)v.get(0)).collect(Collectors.toList());
        List<Double> w2 = list.stream().map(v -> (Double)v.get(1)).collect(Collectors.toList());
        List timeBin = list.stream().map(v -> (Double)v.get(3)).collect(Collectors.toList());
        ArrayList<NumberPair> w1Data = new ArrayList<NumberPair>();
        for (int i = 0; i < w1.size(); ++i) {
            w1Data.add(new NumberPair((Double)timeBin.get(i), (Double)w1.get(i)));
        }
        Map<Double, Double> w1Median = w1Data.stream().collect(Collectors.groupingBy(e -> e.getX(), Collectors.collectingAndThen(Collectors.toList(), e -> this.getMedian((List<NumberPair>)e))));
        Map<Double, Double> w1Error = w1Data.stream().collect(Collectors.groupingBy(e -> e.getX(), Collectors.collectingAndThen(Collectors.toList(), e -> this.getError((List<NumberPair>)e))));
        List<Double> w1Time = w1Median.keySet().stream().map(e -> e * 0.5).collect(Collectors.toList());
        ArrayList<Double> w1Values = new ArrayList<Double>(w1Median.values());
        ArrayList<Double> w1Errors = new ArrayList<Double>(w1Error.values());
        ArrayList<NumberPair> w2Data = new ArrayList<NumberPair>();
        for (int i = 0; i < w2.size(); ++i) {
            w2Data.add(new NumberPair((Double)timeBin.get(i), (Double)w2.get(i)));
        }
        Map<Double, Double> w2Median = w2Data.stream().collect(Collectors.groupingBy(e -> e.getX(), Collectors.collectingAndThen(Collectors.toList(), e -> this.getMedian((List<NumberPair>)e))));
        Map<Double, Double> w2Error = w2Data.stream().collect(Collectors.groupingBy(e -> e.getX(), Collectors.collectingAndThen(Collectors.toList(), e -> this.getError((List<NumberPair>)e))));
        List<Double> w2Time = w2Median.keySet().stream().map(e -> e * 0.5).collect(Collectors.toList());
        ArrayList<Double> w2Values = new ArrayList<Double>(w2Median.values());
        ArrayList<Double> w2Errors = new ArrayList<Double>(w2Error.values());
        w1 = list.stream().map(v -> (Double)v.get(0)).collect(Collectors.toList());
        w2 = list.stream().map(v -> (Double)v.get(1)).collect(Collectors.toList());
        List<Double> obsTime = list.stream().map(v -> (Double)v.get(2)).collect(Collectors.toList());
        JPlot plot = new JPlot("WISE light curves").gridlines().xAxis("Year").xAxisNumberFormat(new DecimalFormat("#.#")).yAxis("Magnitude (mag)").yAxisInverted(true).error("W2 median", w2Time, w2Values, w2Errors, Color.RED, this.w2Phot.isSelected() && this.curves.isSelected()).error("W1 median", w1Time, w1Values, w1Errors, Color.BLUE, this.w1Phot.isSelected() && this.curves.isSelected()).scatter("W2", obsTime, w2, Color.PINK, this.w2Phot.isSelected()).scatter("W1", obsTime, w1, Color.CYAN, this.w1Phot.isSelected());
        this.chart = plot.getChart();
        ChartPanel chartPanel = new ChartPanel(this.chart){

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        chartPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        chartPanel.setBackground(Color.WHITE);
        this.add((Component)chartPanel, 0);
        this.revalidate();
        this.repaint();
    }

    private double getMedian(List<NumberPair> pairs) {
        List<Double> values = pairs.stream().map(NumberPair::getY).collect(Collectors.toList());
        return StatisticFunctions.determineMedian(values);
    }

    private double getError(List<NumberPair> pairs) {
        List<Double> values = pairs.stream().map(NumberPair::getY).collect(Collectors.toList());
        return StatisticFunctions.calculateStandardError(values);
    }

    private double getObsTime(double mjd) {
        LocalDateTime dt = AstrometricFunctions.convertMJDToDateTime(new BigDecimal(mjd));
        int year = dt.getYear();
        double day = dt.getDayOfYear();
        double days = dt.toLocalDate().isLeapYear() ? 366.0 : 365.0;
        return (double)year + day / days;
    }
}

