/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.service;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.MocaCatalogEntry;
import astro.tool.box.catalog.ProperMotionQuery;
import astro.tool.box.catalog.UhsCatalogEntry;
import astro.tool.box.catalog.UkidssCatalogEntry;
import astro.tool.box.util.ServiceHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CatalogQueryService {
    public List<CatalogEntry> getCatalogEntriesByCoords(CatalogEntry catalogEntry) throws IOException {
        if (catalogEntry instanceof UkidssCatalogEntry) {
            UkidssCatalogEntry entry = (UkidssCatalogEntry)catalogEntry;
            ArrayList<CatalogEntry> catalogEntries = new ArrayList<CatalogEntry>();
            for (UkidssCatalogEntry.Survey survey : UkidssCatalogEntry.Survey.values()) {
                entry.setSurvey(survey);
                catalogEntries.addAll(ServiceHelper.transformResponseToCatalogEntries(ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(entry.getCatalogQueryUrl()), entry.getCatalogName()), entry));
            }
            return catalogEntries;
        }
        if (catalogEntry instanceof UhsCatalogEntry) {
            UhsCatalogEntry entry = (UhsCatalogEntry)catalogEntry;
            return entry.findCatalogEntries();
        }
        if (catalogEntry instanceof MocaCatalogEntry) {
            MocaCatalogEntry entry = (MocaCatalogEntry)catalogEntry;
            return entry.findCatalogEntries();
        }
        return ServiceHelper.transformResponseToCatalogEntries(ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(catalogEntry.getCatalogQueryUrl()), catalogEntry.getCatalogName()), catalogEntry);
    }

    public List<CatalogEntry> getCatalogEntriesByCoordsAndTpm(ProperMotionQuery catalogEntry) throws IOException {
        if (catalogEntry instanceof UkidssCatalogEntry) {
            UkidssCatalogEntry entry = (UkidssCatalogEntry)catalogEntry;
            ArrayList<CatalogEntry> catalogEntries = new ArrayList<CatalogEntry>();
            for (UkidssCatalogEntry.Survey survey : UkidssCatalogEntry.Survey.motionSurveys()) {
                entry.setSurvey(survey);
                catalogEntries.addAll(ServiceHelper.transformResponseToCatalogEntries(ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(entry.getMotionQueryUrl()), entry.getCatalogName()), entry));
            }
            return catalogEntries;
        }
        if (catalogEntry instanceof UhsCatalogEntry) {
            UhsCatalogEntry entry = (UhsCatalogEntry)catalogEntry;
            return entry.filterCatalogEntries();
        }
        return ServiceHelper.transformResponseToCatalogEntries(ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(catalogEntry.getMotionQueryUrl()), catalogEntry.getCatalogName()), catalogEntry);
    }
}

