/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.service;

import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Band;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.lookup.BrownDwarfLookupEntry;
import astro.tool.box.lookup.DistanceLookupResult;
import astro.tool.box.lookup.SpectralTypeLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DistanceLookupService {
    private final List<SpectralTypeLookup> entries;

    public DistanceLookupService(List<SpectralTypeLookup> entries) {
        this.entries = entries;
    }

    public List<DistanceLookupResult> lookup(String spt, Map<Band, NumberPair> apparentMagnitudes) {
        ArrayList<DistanceLookupResult> results = new ArrayList<DistanceLookupResult>();
        if (spt == null || apparentMagnitudes.isEmpty()) {
            return results;
        }
        spt = spt.replace("V", "");
        Map<Band, Double> absoluteMagnitudes = null;
        Map<Band, Double> absoluteMagnitudesErrors = null;
        for (SpectralTypeLookup spectralTypeLookup : this.entries) {
            BrownDwarfLookupEntry entry = (BrownDwarfLookupEntry)spectralTypeLookup;
            if (!entry.getSpt().equals(spt)) continue;
            absoluteMagnitudes = entry.getMagnitudes();
            absoluteMagnitudesErrors = entry.getErrors();
        }
        if (absoluteMagnitudes == null) {
            return results;
        }
        for (Map.Entry entry : apparentMagnitudes.entrySet()) {
            double absoluteMagnitude;
            double apparentMagnitude = ((NumberPair)entry.getValue()).getX();
            if (apparentMagnitude == 0.0 || (absoluteMagnitude = absoluteMagnitudes.get(entry.getKey()).doubleValue()) == 0.0) continue;
            double distance = PhotometricFunctions.calculatePhotometricDistance(apparentMagnitude, absoluteMagnitude);
            double apparentMagnitudeError = ((NumberPair)entry.getValue()).getY();
            double absoluteMagnitudeError = absoluteMagnitudesErrors.get(entry.getKey());
            if (absoluteMagnitudeError == 0.0) {
                absoluteMagnitudeError = 0.5;
            }
            double distanceError = apparentMagnitudeError == 0.0 ? 0.0 : PhotometricFunctions.calculatePhotometricDistanceError(apparentMagnitude, apparentMagnitudeError, absoluteMagnitude, absoluteMagnitudeError);
            results.add(new DistanceLookupResult((Band)((Object)entry.getKey()), apparentMagnitude, spt, distance, distanceError));
        }
        return results;
    }
}

