/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.service;

import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.ServiceHelper;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DustExtinctionService {
    private static final String SERVICE_PROVIDER = "IRSA Dust Extinction Tool";
    private static final String BASE_URL = "https://irsa.ipac.caltech.edu/cgi-bin/DUST/nph-dust";
    private static final String CHAR = "\\s+(?=([^\"]*\"[^\"]*\")*[^\"]*$)";

    public Map<String, Double> getExtinctionsByBand(double degRA, double degDE, double degSize) throws Exception {
        HashMap<String, Double> extinctionsByBand = new HashMap<String, Double>();
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection("https://irsa.ipac.caltech.edu/cgi-bin/DUST/nph-dust?locstr=" + degRA + "+" + degDE + "&regSize=" + degSize), SERVICE_PROVIDER);
        if (response.isEmpty()) {
            return extinctionsByBand;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(response)));
        Element root = document.getDocumentElement();
        String tableLink = root.getElementsByTagName("table").item(0).getTextContent().trim();
        response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(tableLink), SERVICE_PROVIDER);
        if (response.isEmpty()) {
            return extinctionsByBand;
        }
        try (Scanner scanner = new Scanner(response);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.contains("SDSS u")) {
                    extinctionsByBand.put("SDSS u", NumericFunctions.toDouble(line.split(CHAR)[5]));
                    continue;
                }
                if (line.contains("SDSS g")) {
                    extinctionsByBand.put("SDSS g", NumericFunctions.toDouble(line.split(CHAR)[5]));
                    continue;
                }
                if (line.contains("SDSS r")) {
                    extinctionsByBand.put("SDSS r", NumericFunctions.toDouble(line.split(CHAR)[5]));
                    continue;
                }
                if (line.contains("SDSS i")) {
                    extinctionsByBand.put("SDSS i", NumericFunctions.toDouble(line.split(CHAR)[5]));
                    continue;
                }
                if (line.contains("SDSS z")) {
                    extinctionsByBand.put("SDSS z", NumericFunctions.toDouble(line.split(CHAR)[5]));
                    continue;
                }
                if (line.contains("2MASS J")) {
                    extinctionsByBand.put("2MASS J", NumericFunctions.toDouble(line.split(CHAR)[5]));
                    continue;
                }
                if (line.contains("2MASS H")) {
                    extinctionsByBand.put("2MASS H", NumericFunctions.toDouble(line.split(CHAR)[5]));
                    continue;
                }
                if (line.contains("2MASS Ks")) {
                    extinctionsByBand.put("2MASS Ks", NumericFunctions.toDouble(line.split(CHAR)[5]));
                    continue;
                }
                if (line.contains("WISE-1")) {
                    extinctionsByBand.put("WISE-1", NumericFunctions.toDouble(line.split(CHAR)[4]));
                    continue;
                }
                if (line.contains("WISE-2")) {
                    extinctionsByBand.put("WISE-2", NumericFunctions.toDouble(line.split(CHAR)[4]));
                    continue;
                }
                if (line.contains("IRAC-1")) {
                    extinctionsByBand.put("IRAC-1", NumericFunctions.toDouble(line.split(CHAR)[4]));
                    continue;
                }
                if (!line.contains("IRAC-2")) continue;
                extinctionsByBand.put("IRAC-2", NumericFunctions.toDouble(line.split(CHAR)[4]));
            }
        }
        return extinctionsByBand;
    }
}

