/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.service;

import astro.tool.box.function.NumericFunctions;
import astro.tool.box.util.CSVParser;
import astro.tool.box.util.MiscUtils;
import astro.tool.box.util.ServiceHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimbadQueryService {
    private static final String SERVICE_PROVIDER = "SIMBAD";

    /*
     * Exception decompiling
     */
    public List<String[]> getObjectIdentifiers(String mainIdentifier) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String[]> getObjectReferences(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select r.\"year\", r.journal, r.volume, r.title, r.bibcode, r.oidbib");
        MiscUtils.addRow(query, "from   ref as r, has_ref as h, basic as b");
        MiscUtils.addRow(query, "where  r.oidbib = h.oidbibref");
        MiscUtils.addRow(query, "and    h.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by bibcode desc");
        String queryUrl = ServiceHelper.getSimbadBaseUrl() + MiscUtils.encodeQuery(query.toString());
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(queryUrl), SERVICE_PROVIDER);
        ArrayList<String[]> references = new ArrayList<String[]>();
        try (Scanner scanner = new Scanner(response);){
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String[] reference = CSVParser.parseLine(scanner.nextLine());
                references.add(reference);
            }
        }
        return references;
    }

    public String getAbstract(Integer bibRef) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select abstract");
        MiscUtils.addRow(query, "from   ref");
        MiscUtils.addRow(query, "where  oidbib = " + bibRef);
        String queryUrl = ServiceHelper.getSimbadBaseUrl() + MiscUtils.encodeQuery(query.toString());
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(queryUrl), SERVICE_PROVIDER);
        try (Scanner scanner = new Scanner(response);){
            scanner.nextLine();
            if (scanner.hasNext()) {
                String string = MiscUtils.removeFirstAndLastCharacter(scanner.nextLine());
                return string;
            }
        }
        return "";
    }

    public List<String[]> getAuthors(Integer bibRef) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select name");
        MiscUtils.addRow(query, "from   author");
        MiscUtils.addRow(query, "where  oidbibref = " + bibRef);
        MiscUtils.addRow(query, "order by pos asc");
        String queryUrl = ServiceHelper.getSimbadBaseUrl() + MiscUtils.encodeQuery(query.toString());
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(queryUrl), SERVICE_PROVIDER);
        ArrayList<String[]> authors = new ArrayList<String[]>();
        try (Scanner scanner = new Scanner(response);){
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String author = MiscUtils.removeFirstAndLastCharacter(scanner.nextLine());
                authors.add(new String[]{author});
            }
        }
        return authors;
    }

    public List<String> getVizierCatalogs(String bibcode) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select name");
        MiscUtils.addRow(query, "from   METAcat");
        MiscUtils.addRow(query, "where  bibcode = '" + bibcode + "'");
        MiscUtils.addRow(query, "order by name asc");
        String queryUrl = "http://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(query.toString());
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(queryUrl), SERVICE_PROVIDER);
        ArrayList<String> catalogs = new ArrayList<String>();
        try (Scanner scanner = new Scanner(response);){
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String catalog = MiscUtils.removeFirstAndLastCharacter(scanner.nextLine());
                catalogs.add(catalog);
            }
        }
        return catalogs;
    }

    public List<String[]> getObjectFluxes(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select f.filter, f.flux, f.flux_err, f.qual, i.description, i.unit, f.bibcode ");
        MiscUtils.addRow(query, "from   flux as f, filter as i, basic as b");
        MiscUtils.addRow(query, "where  f.oidref = b.oid");
        MiscUtils.addRow(query, "and    f.filter = i.filtername");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectTypes(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select t.otypes");
        MiscUtils.addRow(query, "from   alltypes as t, basic as b");
        MiscUtils.addRow(query, "where  t.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        ArrayList<String[]> objectTypes = new ArrayList<String[]>();
        List<String[]> allTypes = this.executeQuery(query.toString());
        if (!allTypes.isEmpty()) {
            List types = Stream.of(allTypes.get(0)[0].split("\\|")).distinct().map(String::trim).collect(Collectors.toList());
            for (String type : types) {
                objectTypes.addAll(this.getObjectType(type));
            }
        }
        return objectTypes;
    }

    public List<String[]> getObjectType(String type) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select otype_shortname, otype_longname");
        MiscUtils.addRow(query, "from   otypedef");
        MiscUtils.addRow(query, "where  otype_shortname = '" + type + "'");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectVariabilities(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select v.vartyp, v.lowVmax, v.vmax, v.r_vmax, v.magtyp, v.uppVmin, v.vmin, v.r_vmin, v.upperiod, v.period, v.r_period, v.epoch, v.r_epoch, v.raisingTime, v.r_raisingTime, v.bibcode");
        MiscUtils.addRow(query, "from   mesVar as v, basic as b");
        MiscUtils.addRow(query, "where  v.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by mespos asc");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectDistances(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select d.dist, d.qual, d.unit, d.minus_err, d.plus_err, d.method, d.bibcode");
        MiscUtils.addRow(query, "from   mesDistance as d, basic as b");
        MiscUtils.addRow(query, "where  d.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by mespos asc");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectProperMotions(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select p.pmra, p.pmra_err, p.pmde, p.pmde_err, p.coosystem, p.bibcode");
        MiscUtils.addRow(query, "from   mesPM as p, basic as b");
        MiscUtils.addRow(query, "where  p.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by mespos asc");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectVelocities(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select v.velType, v.velValue, v.meanError, v.quality, v.nbmes, v.nature, v.qual, v.wdomain, v.resolution, v.obsdate, v.remarks, v.origin, v.bibcode");
        MiscUtils.addRow(query, "from   mesVelocities as v, basic as b");
        MiscUtils.addRow(query, "where  v.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by mespos asc");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectRotations(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select r.upvsini, r.vsini, r.vsini_err, r.nbmes, r.qual, r.bibcode");
        MiscUtils.addRow(query, "from   mesRot as r, basic as b");
        MiscUtils.addRow(query, "where  r.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by mespos asc");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectSpectralTypes(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select s.sptype, s.bibcode");
        MiscUtils.addRow(query, "from   mesSpT as s, basic as b");
        MiscUtils.addRow(query, "where  s.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by mespos asc");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectParallaxes(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select p.plx, p.plx_err, p.bibcode");
        MiscUtils.addRow(query, "from   mesPlx as p, basic as b");
        MiscUtils.addRow(query, "where  p.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by mespos asc");
        return this.executeQuery(query.toString());
    }

    public List<String[]> getObjectMetallicities(String mainIdentifier) throws IOException {
        StringBuilder query = new StringBuilder();
        MiscUtils.addRow(query, "select m.teff, m.log_g, m.fe_h, m.flag, m.compstar, m.catno, m.bibcode");
        MiscUtils.addRow(query, "from   mesFe_H as m, basic as b");
        MiscUtils.addRow(query, "where  m.oidref = b.oid");
        MiscUtils.addRow(query, "and    b.main_id = '" + mainIdentifier + "'");
        MiscUtils.addRow(query, "order by mespos asc");
        return this.executeQuery(query.toString());
    }

    private List<String[]> executeQuery(String query) throws IOException {
        String queryUrl = ServiceHelper.getSimbadBaseUrl() + MiscUtils.encodeQuery(query);
        String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(queryUrl), SERVICE_PROVIDER);
        ArrayList<String[]> results = new ArrayList<String[]>();
        try (Scanner scanner = new Scanner(response);){
            scanner.nextLine();
            while (scanner.hasNextLine()) {
                String[] values = CSVParser.parseLine(scanner.nextLine());
                for (int i = 0; i < values.length; ++i) {
                    if (!NumericFunctions.isDecimal(values[i])) continue;
                    values[i] = NumericFunctions.roundTo3Dec(NumericFunctions.toDouble(values[i]));
                }
                results.add(values);
            }
        }
        return results;
    }
}

