/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.service;

import astro.tool.box.enumeration.Color;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.lookup.LookupResult;
import astro.tool.box.lookup.SpectralTypeLookup;
import astro.tool.box.util.MiscUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SpectralTypeLookupService {
    private final List<SpectralTypeLookup> entries;

    public SpectralTypeLookupService(List<SpectralTypeLookup> entries) {
        this.entries = entries;
    }

    public List<LookupResult> lookup(Map<Color, Double> colors) {
        ArrayList<LookupResult> results = new ArrayList<LookupResult>();
        SpectralTypeLookup minEntry = this.entries.get(0);
        for (SpectralTypeLookup maxEntry : this.entries) {
            for (Map.Entry<Color, Double> color : colors.entrySet()) {
                Double colorValue;
                Color colorKey = color.getKey();
                LookupResult result = PhotometricFunctions.evaluateSpectralType(colorKey, colorValue = color.getValue(), minEntry, maxEntry);
                if (result == null) continue;
                Double sptNum = MiscUtils.SPECTRAL_TYPES.get(result.getSpt().replace("V", ""));
                result.setSptNum(sptNum);
                results.add(result);
            }
            minEntry = maxEntry;
        }
        return results.stream().distinct().sorted(Comparator.comparing(LookupResult::getSptNum)).collect(Collectors.toList());
    }
}

