/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.shape;

import astro.tool.box.shape.Drawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class Arrow
implements Drawable {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final double size;
    private final Color color;

    public Arrow(double x1, double y1, double x2, double y2, double size, Color color) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.size = size + 2.0;
        this.color = color;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        double xDiff = this.x1 - this.x2;
        double vectorAngle = xDiff == 0.0 ? 1.5707963267948966 : Math.atan((this.y1 - this.y2) / xDiff) + (this.x1 < this.x2 ? Math.PI : 0.0);
        double arrowAngle = 0.3490658503988659;
        double xLeft = this.size * Math.cos(vectorAngle - arrowAngle);
        double yLeft = this.size * Math.sin(vectorAngle - arrowAngle);
        double xRight = this.size * Math.cos(vectorAngle + arrowAngle);
        double yRight = this.size * Math.sin(vectorAngle + arrowAngle);
        g2d.setColor(this.color);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawLine((int)Math.round(this.x2), (int)Math.round(this.y2), (int)Math.round(this.x2 + xLeft), (int)Math.round(this.y2 + yLeft));
        g2d.drawLine((int)Math.round(this.x2), (int)Math.round(this.y2), (int)Math.round(this.x2 + xRight), (int)Math.round(this.y2 + yRight));
        g2d.drawLine((int)Math.round(this.x1), (int)Math.round(this.y1), (int)Math.round(this.x2), (int)Math.round(this.y2));
    }
}

