/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.shape;

import astro.tool.box.shape.Drawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CrossHair
implements Drawable {
    private final int x;
    private final int y;
    private final int size;
    private final Color color;
    private final String label;

    public CrossHair(double x, double y, double size, Color color, String label) {
        this.x = (int)Math.round(x);
        this.y = (int)Math.round(y);
        this.size = (int)Math.round(size / 2.0);
        this.color = color;
        this.label = label;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(this.color);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawLine(this.x - this.size, this.y, this.x + this.size, this.y);
        g2d.drawLine(this.x, this.y - this.size, this.x, this.y + this.size);
        g2d.setFont(new Font("default", 0, this.size - 2));
        int width = g2d.getFontMetrics().stringWidth(this.label);
        g2d.drawString(this.label, this.x - width / 2 + 5, this.y - this.size);
    }
}

