/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.shape;

import astro.tool.box.shape.Drawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class Text
implements Drawable {
    private final int x;
    private final int y;
    private final int size;
    private final Color color;
    private final String label;

    public Text(double x, double y, double size, Color color, String label) {
        this.x = (int)Math.round(x - size / 2.0);
        this.y = (int)Math.round(y + size / 2.0);
        this.size = (int)size;
        this.color = color;
        this.label = label;
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.label == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(this.color);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(new Font("default", 1, this.size + 2));
        g2d.drawString(this.label, this.x, this.y);
    }
}

