/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.enumeration.JColor;
import astro.tool.box.enumeration.JobStatus;
import astro.tool.box.enumeration.TapProvider;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.tab.SettingsTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.CSVParser;
import astro.tool.box.util.MiscUtils;
import astro.tool.box.util.ServiceHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AdqlQueryTab
implements Tab {
    public static final String TAB_NAME = "ADQL Query";
    public static final String QUERY_SERVICE = "TAP service";
    private static final String AVAILABLE_TABLES = "Available tables";
    private static final String ADQL_TAP_PROVIDER = "adqlTapProvider";
    private static final String DEFAULT_TAP_PROVIDER = TapProvider.VIZIER.name();
    private static final Font MONO_FONT = new Font("Monospaced", 0, 12);
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private JPanel centerPanel;
    private JPanel catalogPanel;
    private JTextField statusField;
    private JTextField elapsedTime;
    private JComboBox tapProvider;
    private JComboBox jobIds;
    private TableRowSorter<TableModel> catalogTableSorter;
    private TableRowSorter<TableModel> catalogColumnSorter;
    private Timer checkQueryStatus;
    private Instant startTime;
    private File file;
    private String jobId;
    private String jobStatus;
    private String queryResults;
    private String previousTableName;
    private DocumentBuilder builder;

    public AdqlQueryTab(JFrame baseFrame, JTabbedPane tabbedPane) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
    }

    @Override
    public void init(boolean visible) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.builder = factory.newDocumentBuilder();
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel topPanel = new JPanel(new GridLayout(2, 1));
            mainPanel.add((Component)topPanel, "First");
            JPanel firstRow = new JPanel(new FlowLayout(0));
            topPanel.add(firstRow);
            JPanel secondRow = new JPanel(new FlowLayout(0));
            topPanel.add(secondRow);
            JTextArea textEditor = new JTextArea();
            textEditor.setBorder(new EmptyBorder(5, 5, 5, 5));
            textEditor.setFont(MONO_FONT);
            textEditor.setEditable(true);
            ToolboxHelper.addUndoManager(textEditor);
            JScrollPane scrollEditor = new JScrollPane(textEditor);
            scrollEditor.setPreferredSize(new Dimension(scrollEditor.getWidth(), 200));
            scrollEditor.setBorder(ToolboxHelper.createEtchedBorder("ADQL query"));
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
            this.centerPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JSplitPane splitPane = new JSplitPane(0, scrollEditor, this.centerPanel);
            mainPanel.add((Component)splitPane, "Center");
            JFileChooser fileChooser = new JFileChooser();
            JButton importButton = new JButton("Import query");
            firstRow.add(importButton);
            importButton.addActionListener(evt -> {
                int returnVal = fileChooser.showOpenDialog(firstRow);
                if (returnVal == 0) {
                    this.file = fileChooser.getSelectedFile();
                    try {
                        List<String> lines = Files.readAllLines(this.file.toPath());
                        String content = String.join((CharSequence)"\n", lines);
                        textEditor.setText(content);
                        scrollEditor.setBorder(ToolboxHelper.createEtchedBorder("Current file: " + this.file.getName()));
                    }
                    catch (IOException ex) {
                        ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                    }
                }
            });
            String saveMessage = "File saved!";
            JLabel message = ToolboxHelper.createMessageLabel();
            Timer timer = new Timer(3000, e -> message.setText(""));
            JButton saveButton = new JButton("Save query");
            firstRow.add(saveButton);
            saveButton.addActionListener(evt -> {
                if (this.file == null) {
                    int returnVal = fileChooser.showSaveDialog(firstRow);
                    if (returnVal == 0) {
                        this.file = fileChooser.getSelectedFile();
                        try (FileWriter writer = new FileWriter(this.file);){
                            writer.write(textEditor.getText());
                            scrollEditor.setBorder(ToolboxHelper.createEtchedBorder("Current file: " + this.file.getName()));
                            message.setText(saveMessage);
                            timer.restart();
                        }
                        catch (Exception ex) {
                            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                        }
                    }
                    return;
                }
                try (FileWriter writer = new FileWriter(this.file);){
                    writer.write(textEditor.getText());
                    message.setText(saveMessage);
                    timer.restart();
                }
                catch (Exception ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            JButton saveAsButton = new JButton("Save As...");
            firstRow.add(saveAsButton);
            saveAsButton.addActionListener(evt -> {
                int returnVal = fileChooser.showSaveDialog(firstRow);
                if (returnVal == 0) {
                    this.file = fileChooser.getSelectedFile();
                    try (FileWriter writer = new FileWriter(this.file);){
                        writer.write(textEditor.getText());
                        scrollEditor.setBorder(ToolboxHelper.createEtchedBorder("Current file: " + this.file.getName()));
                        message.setText(saveMessage);
                        timer.restart();
                    }
                    catch (Exception ex) {
                        ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                    }
                }
            });
            JButton runButton = new JButton("Run query");
            firstRow.add(runButton);
            runButton.addActionListener(evt -> {
                block13: {
                    String response;
                    String query = textEditor.getText();
                    if (query.isEmpty()) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, "No query to run!");
                        return;
                    }
                    this.removeResultPanel();
                    this.jobStatus = JobStatus.PENDING.toString();
                    this.statusField.setText(this.jobStatus);
                    this.statusField.setBackground(this.getStatusColor((String)this.jobStatus).val);
                    this.queryResults = null;
                    this.jobId = null;
                    if (!TapProvider.NOIRLAB.equals((Object)this.getTapProvider())) {
                        try {
                            JsonObject jelement;
                            JsonObject jobject;
                            String validation;
                            response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(this.createValidatorUrl(MiscUtils.encodeQuery(query))), "Query validator");
                            if (!response.isEmpty() && !(validation = (jobject = (jelement = JsonParser.parseString(response).getAsJsonObject()).getAsJsonObject()).get("validation").getAsString()).equals("ok")) {
                                JsonArray jarray = jobject.getAsJsonArray("errors");
                                jobject = jarray.get(0).getAsJsonObject();
                                String errorMessage = jobject.get("message").getAsString();
                                ToolboxHelper.showErrorDialog(this.baseFrame, errorMessage);
                                this.initStatus();
                                return;
                            }
                        }
                        catch (JsonSyntaxException | IOException jelement) {
                            // empty catch block
                        }
                    }
                    this.startClock();
                    try {
                        runButton.setCursor(Cursor.getPredefinedCursor(3));
                        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                        params.add(new BasicNameValuePair("request", "doQuery"));
                        params.add(new BasicNameValuePair("lang", "ADQL"));
                        params.add(new BasicNameValuePair("format", "csv"));
                        params.add(new BasicNameValuePair("query", MiscUtils.omitQueryComments(query)));
                        response = this.doPost(this.createAsynchQueryUrl(), params);
                        if (response.isEmpty()) break block13;
                        try {
                            this.jobId = this.getJobIdentifier(response);
                            params = new ArrayList();
                            params.add(new BasicNameValuePair("PHASE", "RUN"));
                            response = this.doPost(this.createStatusUrl(this.jobId), params);
                            this.addJobId(this.jobId, this.getTapProvider());
                        }
                        catch (Exception ex) {
                            this.stopClock();
                            this.initStatus();
                            ToolboxHelper.showErrorDialog(this.baseFrame, ex.getMessage());
                        }
                        String errorMessage = this.getErrorMessage(response);
                        if (!errorMessage.isEmpty()) {
                            ToolboxHelper.showScrollableErrorDialog(this.baseFrame, errorMessage);
                        }
                    }
                    catch (Exception ex) {
                        this.stopClock();
                        this.initStatus();
                        ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                    }
                    finally {
                        runButton.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            firstRow.add(new JLabel("Status:"));
            this.statusField = new JTextField(10);
            firstRow.add(this.statusField);
            this.statusField.setEditable(false);
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            this.checkQueryStatus = new Timer(10000, e -> {
                if (this.jobId == null) {
                    this.stopClock();
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No query submitted!");
                    return;
                }
                try {
                    this.jobStatus = this.doGet(this.createStatusUrl(this.jobId));
                    this.statusField.setText(this.jobStatus);
                    this.statusField.setBackground(this.getStatusColor((String)this.jobStatus).val);
                    if (this.jobStatus.equals(JobStatus.ERROR.toString()) || this.jobStatus.equals(JobStatus.ABORTED.toString()) || this.jobStatus.equals(JobStatus.COMPLETED.toString())) {
                        this.stopClock();
                    }
                    Duration duration = Duration.between(this.startTime, Instant.now());
                    LocalTime time = LocalTime.ofSecondOfDay(duration.getSeconds());
                    this.elapsedTime.setText(time.format(timeFormatter));
                }
                catch (IOException ex) {
                    this.stopClock();
                    this.initStatus();
                }
            });
            firstRow.add(new JLabel("Elapsed time:"));
            this.elapsedTime = new JTextField(6);
            this.elapsedTime.setEditable(false);
            firstRow.add(this.elapsedTime);
            JButton displayButton = new JButton("Display result");
            firstRow.add(displayButton);
            displayButton.addActionListener(evt -> {
                if (this.jobId == null) {
                    ToolboxHelper.showInfoDialog(this.baseFrame, "No query submitted!");
                    return;
                }
                displayButton.setCursor(Cursor.getPredefinedCursor(3));
                this.removeResultPanel();
                try {
                    this.jobStatus = this.doGet(this.createStatusUrl(this.jobId));
                    this.statusField.setText(this.jobStatus);
                    this.statusField.setBackground(this.getStatusColor((String)this.jobStatus).val);
                    if (this.jobStatus.equals(JobStatus.PENDING.toString())) {
                        ToolboxHelper.showInfoDialog(this.baseFrame, "Query is still pending!");
                    } else if (this.jobStatus.equals(JobStatus.QUEUED.toString())) {
                        ToolboxHelper.showInfoDialog(this.baseFrame, "Query is still queued!");
                    } else if (this.jobStatus.equals(JobStatus.EXECUTING.toString())) {
                        ToolboxHelper.showInfoDialog(this.baseFrame, "Query is still running!");
                    } else if (this.jobStatus.equals(JobStatus.COMPLETED.toString())) {
                        this.queryResults = this.doGet(this.createResultUrl(this.jobId));
                        this.centerPanel.add(this.readQueryResult(new TableRowSorter<TableModel>(), this.queryResults, "Query results"));
                        this.baseFrame.setVisible(true);
                    } else if (this.jobStatus.equals(JobStatus.ERROR.toString())) {
                        String response = this.doGet(this.createErrorUrl(this.jobId));
                        String errorMessage = this.getErrorMessage(response);
                        ToolboxHelper.showScrollableErrorDialog(this.baseFrame, errorMessage.isEmpty() ? response : errorMessage);
                    } else if (this.jobStatus.equals(JobStatus.ABORTED.toString())) {
                        ToolboxHelper.showInfoDialog(this.baseFrame, "Query was aborted!");
                    } else {
                        this.displayNoResultAvailable();
                    }
                }
                catch (Exception ex) {
                    this.initStatus();
                    ToolboxHelper.showInfoDialog(this.baseFrame, "No result to display!");
                }
                finally {
                    displayButton.setCursor(Cursor.getDefaultCursor());
                }
            });
            JButton downloadButton = new JButton("Download result");
            firstRow.add(downloadButton);
            downloadButton.addActionListener(evt -> {
                block20: {
                    if (this.jobId == null) {
                        ToolboxHelper.showInfoDialog(this.baseFrame, "No query submitted!");
                        return;
                    }
                    downloadButton.setCursor(Cursor.getPredefinedCursor(3));
                    this.removeResultPanel();
                    try {
                        this.jobStatus = this.doGet(this.createStatusUrl(this.jobId));
                        this.statusField.setText(this.jobStatus);
                        this.statusField.setBackground(this.getStatusColor((String)this.jobStatus).val);
                        if (this.jobStatus.equals(JobStatus.PENDING.toString())) {
                            ToolboxHelper.showInfoDialog(this.baseFrame, "Query is still pending!");
                            break block20;
                        }
                        if (this.jobStatus.equals(JobStatus.QUEUED.toString())) {
                            ToolboxHelper.showInfoDialog(this.baseFrame, "Query is still queued!");
                            break block20;
                        }
                        if (this.jobStatus.equals(JobStatus.EXECUTING.toString())) {
                            ToolboxHelper.showInfoDialog(this.baseFrame, "Query is still running!");
                            break block20;
                        }
                        if (this.jobStatus.equals(JobStatus.COMPLETED.toString())) {
                            this.queryResults = this.doGet(this.createResultUrl(this.jobId));
                            JFileChooser fileSelector = new JFileChooser();
                            FileNameExtensionFilter filter = new FileNameExtensionFilter("CSV Files", "csv");
                            fileChooser.setFileFilter(filter);
                            fileSelector.setDialogTitle("Save CSV File");
                            int userSelection = fileSelector.showSaveDialog(null);
                            if (userSelection != 0) break block20;
                            File fileToSave = fileSelector.getSelectedFile();
                            if (!fileToSave.getName().toLowerCase().endsWith(".csv")) {
                                fileToSave = new File(fileToSave.getAbsolutePath() + ".csv");
                            }
                            try (FileWriter writer = new FileWriter(fileToSave);){
                                writer.write(this.queryResults);
                                break block20;
                            }
                        }
                        if (this.jobStatus.equals(JobStatus.ERROR.toString())) {
                            String response = this.doGet(this.createErrorUrl(this.jobId));
                            String errorMessage = this.getErrorMessage(response);
                            ToolboxHelper.showScrollableErrorDialog(this.baseFrame, errorMessage.isEmpty() ? response : errorMessage);
                        } else if (this.jobStatus.equals(JobStatus.ABORTED.toString())) {
                            ToolboxHelper.showInfoDialog(this.baseFrame, "Query was aborted!");
                        } else {
                            this.displayNoResultAvailable();
                        }
                    }
                    catch (Exception ex) {
                        this.initStatus();
                        ToolboxHelper.showInfoDialog(this.baseFrame, "No result to download!");
                    }
                    finally {
                        downloadButton.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            JButton abortButton = new JButton("Abort query");
            firstRow.add(abortButton);
            abortButton.addActionListener(evt -> {
                if (TapProvider.IRSA.equals((Object)this.getTapProvider())) {
                    ToolboxHelper.showInfoDialog(this.baseFrame, "IRSA does not allow to abort queries.");
                    return;
                }
                if (!ToolboxHelper.showConfirmDialog(this.baseFrame, "Do you really want to abort this query?")) {
                    return;
                }
                try {
                    ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                    params.add(new BasicNameValuePair("PHASE", "ABORT"));
                    this.doPost(this.createStatusUrl(this.jobId), params);
                    this.removeJobId(this.jobId, this.getTapProvider());
                    ToolboxHelper.showInfoDialog(this.baseFrame, "Query aborted!");
                }
                catch (IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            JButton deleteButton = new JButton("Delete query");
            firstRow.add(deleteButton);
            deleteButton.addActionListener(evt -> {
                if (TapProvider.IRSA.equals((Object)this.getTapProvider())) {
                    ToolboxHelper.showInfoDialog(this.baseFrame, "IRSA does not allow to delete queries.");
                    return;
                }
                if (!ToolboxHelper.showConfirmDialog(this.baseFrame, "Do you really want to delete this query?")) {
                    return;
                }
                try {
                    ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                    params.add(new BasicNameValuePair("ACTION", "DELETE"));
                    this.doPost(this.createDeleteUrl(this.jobId), params);
                    this.removeJobId(this.jobId, this.getTapProvider());
                    ToolboxHelper.showInfoDialog(this.baseFrame, "Query deleted!");
                }
                catch (IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            firstRow.add(message);
            secondRow.add(new JLabel("TAP provider:"));
            this.tapProvider = new JComboBox<TapProvider>(TapProvider.values());
            secondRow.add(this.tapProvider);
            this.tapProvider.setSelectedItem((Object)TapProvider.valueOf(SettingsTab.getUserSetting(ADQL_TAP_PROVIDER, DEFAULT_TAP_PROVIDER)));
            this.tapProvider.addActionListener(evt -> {
                this.refreshJobIdList();
                SettingsTab.setUserSetting(ADQL_TAP_PROVIDER, this.getTapProvider().name());
                SettingsTab.saveSettings();
            });
            secondRow.add(new JLabel("Job ids for selected TAP provider:"));
            String[] ids = this.retrieveJobIds(this.getTapProvider());
            this.jobIds = new JComboBox<String>(ids);
            secondRow.add(this.jobIds);
            this.jobIds.addActionListener(evt -> {
                this.jobId = (String)this.jobIds.getSelectedItem();
            });
            this.jobId = (String)this.jobIds.getSelectedItem();
            JButton removeButton = new JButton("Remove job ids");
            secondRow.add(removeButton);
            removeButton.addActionListener(evt -> {
                if (ToolboxHelper.showConfirmDialog(this.baseFrame, "Do you really want to remove all job ids?")) {
                    this.removeAllJobIds(this.getTapProvider());
                }
            });
            JButton resumeButton = new JButton("Resume query");
            secondRow.add(resumeButton);
            resumeButton.addActionListener(evt -> {
                this.jobId = (String)this.jobIds.getSelectedItem();
                if (this.jobId != null && !this.jobId.isEmpty()) {
                    this.statusField.setText("Resuming ...");
                    this.statusField.setBackground(JColor.LIGHT_NAVY.val);
                    this.startClock();
                }
            });
            JButton browseButton = new JButton("Browse tables");
            secondRow.add(browseButton);
            browseButton.addActionListener(evt -> {
                browseButton.setCursor(Cursor.getPredefinedCursor(3));
                this.removeResultPanel();
                String query = "select schema_name, table_name, table_type, description from tap_schema.tables where schema_name != 'mydb' order by table_name";
                String encodedQuery = query.replaceAll(" +", "%20");
                try {
                    String result = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(this.createSynchQueryUrl(encodedQuery)), QUERY_SERVICE);
                    if (TapProvider.ESA_GAIA.equals((Object)this.getTapProvider())) {
                        result = result.replace("\n\"\r\n", "").replace("\n\"", "[br]").replace("\r\n", " ").replace("[br]", "\n\"");
                    }
                    this.catalogPanel = new JPanel(new GridLayout(1, 2));
                    this.centerPanel.add(this.catalogPanel);
                    JPanel catalogTablePanel = new JPanel();
                    this.catalogPanel.add(catalogTablePanel);
                    catalogTablePanel.setLayout(new BoxLayout(catalogTablePanel, 1));
                    this.catalogTableSorter = new TableRowSorter();
                    catalogTablePanel.add(this.readQueryResult(this.catalogTableSorter, result, AVAILABLE_TABLES));
                    JPanel filterPanel = new JPanel(new FlowLayout(0));
                    catalogTablePanel.add(filterPanel);
                    filterPanel.add(new JLabel("Table filter:"));
                    final JTextField filterField = new JTextField(30);
                    filterPanel.add(filterField);
                    filterField.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            AdqlQueryTab.this.catalogTableSorter.setRowFilter(ToolboxHelper.getCustomRowFilter(filterField.getText()));
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            AdqlQueryTab.this.catalogTableSorter.setRowFilter(ToolboxHelper.getCustomRowFilter(filterField.getText()));
                        }
                    });
                    this.baseFrame.setVisible(true);
                }
                catch (IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
                finally {
                    browseButton.setCursor(Cursor.getDefaultCursor());
                }
            });
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, new JScrollPane(mainPanel));
            }
        }
        catch (ParserConfigurationException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void displayNoResultAvailable() {
        this.statusField.setText(null);
        this.statusField.setBackground(this.elapsedTime.getBackground());
        ToolboxHelper.showInfoDialog(this.baseFrame, "No result available!");
        ToolboxHelper.writeMessageLog("No ADQL result available. Reason: " + this.jobStatus);
    }

    private void addJobId(String id, TapProvider provider) {
        List<String> ids = this.retrieveJobIdsAsList(provider);
        if (!ids.contains(id)) {
            ids.add(0, id);
            this.saveJobIds(ids, provider);
        }
    }

    private void removeJobId(String id, TapProvider provider) {
        List<String> ids = this.retrieveJobIdsAsList(provider);
        if (ids.contains(id)) {
            ids.remove(id);
            this.saveJobIds(ids, provider);
        }
    }

    private void removeAllJobIds(TapProvider provider) {
        this.saveJobIds(null, provider);
    }

    private void saveJobIds(List<String> ids, TapProvider provider) {
        String idList = ids == null || ids.isEmpty() ? "" : String.join((CharSequence)",", ids);
        SettingsTab.setUserSetting(provider.name(), idList);
        SettingsTab.saveSettings();
        this.refreshJobIdList();
    }

    private String[] retrieveJobIds(TapProvider provider) {
        String ids = SettingsTab.getUserSetting(provider.name(), "");
        if (ids.isEmpty()) {
            return new String[0];
        }
        return ids.split(",", -1);
    }

    private List<String> retrieveJobIdsAsList(TapProvider provider) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(Arrays.asList(this.retrieveJobIds(provider)));
        return ids;
    }

    private void refreshJobIdList() {
        this.jobIds.removeAllItems();
        String[] ids = this.retrieveJobIds(this.getTapProvider());
        if (ids.length > 0) {
            for (String id : ids) {
                this.jobIds.addItem(id);
            }
        }
    }

    private void startClock() {
        this.checkQueryStatus.restart();
        this.startTime = Instant.now();
        this.elapsedTime.setText("");
    }

    private void stopClock() {
        this.checkQueryStatus.stop();
    }

    private JScrollPane readQueryResult(TableRowSorter<TableModel> sorter, String queryResult, String panelName) {
        Scanner scanner = new Scanner(queryResult);
        try {
            String[] columnNames = CSVParser.parseLine(scanner.nextLine());
            int rowNumber = 0;
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (scanner.hasNextLine()) {
                String[] columnValues = CSVParser.parseLine(scanner.nextLine());
                String[] values = ToolboxHelper.concatArrays(new String[]{String.valueOf(++rowNumber)}, columnValues);
                for (int i = 0; i < values.length; ++i) {
                    if (!NumericFunctions.isDecimal(values[i])) continue;
                    values[i] = NumericFunctions.roundTo4Dec(NumericFunctions.toDouble(values[i]));
                }
                rows.add(values);
            }
            String[] names = ToolboxHelper.concatArrays(new String[]{"row#"}, columnNames);
            JScrollPane jScrollPane = this.displayQueryResults(sorter, names, rows, panelName);
            scanner.close();
            return jScrollPane;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private JScrollPane displayQueryResults(TableRowSorter<TableModel> sorter, String[] columnNames, List<String[]> rows, String panelName) {
        Object[][] data = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])rows.toArray((T[])data), columnNames);
        JTable resultTable = new JTable(defaultTableModel);
        ToolboxHelper.alignResultColumns(resultTable, rows);
        ToolboxHelper.addComparatorsToTableSorter(sorter, defaultTableModel, rows);
        resultTable.setAutoCreateRowSorter(true);
        resultTable.setAutoResizeMode(0);
        resultTable.setRowSorter(sorter);
        resultTable.setSelectionMode(0);
        if (AVAILABLE_TABLES.equals(panelName)) {
            resultTable.getSelectionModel().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    String tableName;
                    int selectedRow = resultTable.getSelectedRow();
                    try {
                        tableName = (String)resultTable.getValueAt(selectedRow, 2);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        return;
                    }
                    if (tableName.equals(this.previousTableName)) {
                        return;
                    }
                    this.previousTableName = tableName;
                    resultTable.setCursor(Cursor.getPredefinedCursor(3));
                    this.removeColumnPanel();
                    String query = "select * from tap_schema.columns where table_name = '" + tableName + "' order by column_name";
                    String encodedQuery = query.replaceAll(" +", "%20");
                    try {
                        String result = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(this.createSynchQueryUrl(encodedQuery)), QUERY_SERVICE);
                        JPanel catalogColumnPanel = new JPanel();
                        this.catalogPanel.add(catalogColumnPanel);
                        catalogColumnPanel.setLayout(new BoxLayout(catalogColumnPanel, 1));
                        this.catalogColumnSorter = new TableRowSorter();
                        catalogColumnPanel.add(this.readQueryResult(this.catalogColumnSorter, result, "Table columns"));
                        JPanel filterPanel = new JPanel(new FlowLayout(0));
                        catalogColumnPanel.add(filterPanel);
                        filterPanel.add(new JLabel("Column filter:"));
                        final JTextField filterField = new JTextField(30);
                        filterPanel.add(filterField);
                        filterField.getDocument().addDocumentListener(new DocumentListener(){

                            @Override
                            public void changedUpdate(DocumentEvent e) {
                            }

                            @Override
                            public void insertUpdate(DocumentEvent e) {
                                AdqlQueryTab.this.catalogColumnSorter.setRowFilter(ToolboxHelper.getCustomRowFilter(filterField.getText()));
                            }

                            @Override
                            public void removeUpdate(DocumentEvent e) {
                                AdqlQueryTab.this.catalogColumnSorter.setRowFilter(ToolboxHelper.getCustomRowFilter(filterField.getText()));
                            }
                        });
                        this.baseFrame.setVisible(true);
                    }
                    catch (IOException ex) {
                        ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                    }
                    finally {
                        resultTable.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }
        ToolboxHelper.resizeColumnWidth(resultTable);
        JScrollPane resultScrollPanel = new JScrollPane(rows.isEmpty() ? new JLabel("Query completed without result.") : resultTable);
        resultScrollPanel.setBorder(ToolboxHelper.createEtchedBorder(panelName));
        return resultScrollPanel;
    }

    private String createSynchQueryUrl(String query) {
        return this.getTapProviderUrl() + "/sync?request=doQuery&lang=ADQL&format=csv&query=" + query;
    }

    private String createAsynchQueryUrl() {
        return this.getTapProviderUrl() + "/async";
    }

    private String createStatusUrl(String jobId) {
        return this.getTapProviderUrl() + "/async/" + jobId + "/phase";
    }

    private String createDeleteUrl(String jobId) {
        return this.getTapProviderUrl() + "/async/" + jobId;
    }

    private String createResultUrl(String jobId) {
        return this.getTapProviderUrl() + "/async/" + jobId + "/results/result";
    }

    private String createErrorUrl(String jobId) {
        return this.getTapProviderUrl() + "/async/" + jobId + "/error";
    }

    private String createValidatorUrl(String query) {
        return "http://cdsportal.u-strasbg.fr/adqltuto/adqlvalidate?query=" + query;
    }

    private String getTapProviderUrl() {
        return this.getTapProvider().val;
    }

    private String getJobIdentifier(String response) throws Exception {
        String id = this.parseXml(response, "jobId");
        if (id.isEmpty()) {
            id = this.parseXml(response, "uws:jobId");
        }
        return id;
    }

    private String getErrorMessage(String response) throws Exception {
        return this.parseXml(response, "message");
    }

    private TapProvider getTapProvider() {
        return (TapProvider)((Object)this.tapProvider.getSelectedItem());
    }

    private void removeResultPanel() {
        this.centerPanel.removeAll();
    }

    private void removeColumnPanel() {
        int count = this.catalogPanel.getComponentCount();
        if (count > 1) {
            this.catalogPanel.remove(1);
        }
    }

    private void initStatus() {
        this.jobStatus = null;
        this.statusField.setText("");
        this.statusField.setBackground(null);
        this.jobId = null;
    }

    private JColor getStatusColor(String jobStatus) {
        JColor color = jobStatus.equals(JobStatus.PENDING.toString()) ? JColor.LIGHT_YELLOW : (jobStatus.equals(JobStatus.QUEUED.toString()) ? JColor.LIGHT_YELLOW : (jobStatus.equals(JobStatus.EXECUTING.toString()) ? JColor.LIGHT_BLUE : (jobStatus.equals(JobStatus.COMPLETED.toString()) ? JColor.LIGHT_GREEN : (jobStatus.equals(JobStatus.ERROR.toString()) ? JColor.LIGHT_RED : (jobStatus.equals(JobStatus.ABORTED.toString()) ? JColor.LIGHT_ORANGE : JColor.LIGHT_YELLOW)))));
        return color;
    }

    private String parseXml(String xml, String tag) throws Exception {
        try {
            InputSource input = new InputSource(new StringReader(xml));
            Document document = this.builder.parse(input);
            Node node = document.getElementsByTagName(tag).item(0);
            return node == null ? "" : node.getTextContent();
        }
        catch (IOException | DOMException | SAXException ex) {
            return "";
        }
    }

    private String doPost(String url, List<NameValuePair> params) throws UnsupportedEncodingException, IOException {
        HttpPost post = new HttpPost(url);
        post.setEntity(new UrlEncodedFormEntity(params));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            block12: {
                CloseableHttpResponse response = httpClient.execute(post);
                try {
                    ToolboxHelper.writeMessageLog(post.getURI().toString());
                    ToolboxHelper.writeMessageLog(params.toString());
                    ToolboxHelper.writeMessageLog(response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
                    string = EntityUtils.toString(response.getEntity());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    private String doGet(String url) throws UnsupportedEncodingException, IOException {
        HttpGet get = new HttpGet(url);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            block12: {
                CloseableHttpResponse response = httpClient.execute(get);
                try {
                    string = EntityUtils.toString(response.getEntity());
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }
}

